/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Accessibility;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.TitleBar;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Tooltip;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGAccessibilityImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGChartImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGEventHandlerImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGInputBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGTooltipImpl;
import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DEvent;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;

public class SVGTitleBarImpl
extends SVGInputBase
implements TitleBar {
    protected static final String BACKGROUND_COLOR_EDEFAULT = null;
    protected static final String LABEL_EDEFAULT = null;
    protected static final boolean SHOW_EDEFAULT = true;
    protected boolean showESet = false;
    protected static final boolean WITH_SEPARATOR_EDEFAULT = true;
    protected boolean withSeparatorESet = false;
    protected Accessibility accessibility = null;
    protected List eventHandler = null;
    protected Tooltip tooltip = null;

    protected SVGTitleBarImpl() {
    }

    public SVGTitleBarImpl(SVGChartImpl chart) {
        this(chart, chart.getDGraphic());
    }

    public SVGTitleBarImpl(Chart chart, DGraphic dgraphic) {
        this._chart = chart;
        this._dgraphic = dgraphic;
    }

    public String getBackgroundColor() {
        DColor color = (DColor)this._dgraphic.getProperties().get("P_TITLE_BACKCOLOR.DGraphic.core.jscrib");
        if (color != null) {
            return color.serializeToString();
        }
        return BACKGROUND_COLOR_EDEFAULT;
    }

    public void setBackgroundColor(String newBackgroundColor) {
        if (newBackgroundColor != null && newBackgroundColor != "" && !newBackgroundColor.substring(0, 1).equals("#")) {
            newBackgroundColor = this.convertToHex(newBackgroundColor);
        }
        if (newBackgroundColor == null || newBackgroundColor == "") {
            this._dgraphic.getProperties().remove("P_BACKCOLOR.DGraphic.core.jscrib");
            return;
        }
        this._dgraphic.getProperties().store("P_TITLE_BACKCOLOR.DGraphic.core.jscrib", ((SVGChartImpl)this._chart).getColor(newBackgroundColor));
    }

    public String getLabel() {
        return this._dgraphic.getTitle();
    }

    public void setLabel(String newLabel) {
        this._dgraphic.setTitle(newLabel);
    }

    public boolean isShow() {
        if (this._dgraphic.getProperties().get("P_SHOW_TITLED.DGraphic.core.jscrib") != null) {
            this.showESet = true;
        }
        return this._dgraphic.getProperties().get("P_SHOW_TITLED.DGraphic.core.jscrib", true);
    }

    public void setShow(boolean newShow) {
        this._dgraphic.getProperties().store("P_SHOW_TITLED.DGraphic.core.jscrib", newShow);
        this.showESet = true;
    }

    public void unsetShow() {
        this.showESet = false;
        this._dgraphic.getProperties().remove("P_SHOW_TITLED.DGraphic.core.jscrib");
    }

    public boolean isSetShow() {
        if (!this.showESet) {
            this.isShow();
        }
        return this.showESet;
    }

    public boolean isWithSeparator() {
        if (this._dgraphic.getProperties().get("P_TITLE_WITH_SEPARATOR.DGraphic.core.jscrib") != null) {
            this.withSeparatorESet = true;
        }
        return this._dgraphic.getProperties().get("P_TITLE_WITH_SEPARATOR.DGraphic.core.jscrib", true);
    }

    public void setWithSeparator(boolean newWithSeparator) {
        this._dgraphic.getProperties().store("P_TITLE_WITH_SEPARATOR.DGraphic.core.jscrib", newWithSeparator);
        this.withSeparatorESet = true;
    }

    public void unsetWithSeparator() {
        this.withSeparatorESet = false;
        this._dgraphic.getProperties().remove("P_TITLE_WITH_SEPARATOR.DGraphic.core.jscrib");
    }

    public boolean isSetWithSeparator() {
        if (!this.withSeparatorESet) {
            this.isWithSeparator();
        }
        return this.withSeparatorESet;
    }

    public Accessibility getAccessibility() {
        if (this.accessibility == null) {
            this.accessibility = new SVGAccessibilityImpl(this._chart, this._dgraphic, (String)this._dgraphic.getProperties().get("P_TITLE_ACC_TITLE.DGraphic.core.jscrib"), (String)this._dgraphic.getProperties().get("P_TITLE_ACC_DESC.DGraphic.core.jscrib"));
        }
        return this.accessibility;
    }

    public void setAccessibility(Accessibility newAccessibility) {
        this.accessibility = newAccessibility;
    }

    public void assignAccessibility(Accessibility source) {
        this.accessibility = new SVGAccessibilityImpl(this._chart, this._dgraphic, SVGAccessibilityImpl.TITLE_EDEFAULT, SVGAccessibilityImpl.DESCRIPTION_EDEFAULT);
        ((SVGAccessibilityImpl)this.accessibility).assign(source);
        this._dgraphic.getProperties().store("P_TITLE_ACC_TITLE.DGraphic.core.jscrib", source.getTitle());
        this._dgraphic.getProperties().store("P_TITLE_ACC_DESC.DGraphic.core.jscrib", source.getDescription());
    }

    public List getEventHandler() {
        if (this.eventHandler == null) {
            this.eventHandler = this.getEventHandler(this._dgraphic.getProperties(), "P_TITLE_EVENT_LIST.DGraphic.core.jscrib");
        }
        return this.eventHandler;
    }

    public void setEventHandler(List newEventHandler) {
        ArrayList<DEvent> eventList = new ArrayList<DEvent>();
        int i = 0;
        while (i < newEventHandler.size()) {
            DEvent event = ((SVGEventHandlerImpl)newEventHandler.get(i)).getDEvent();
            eventList.add(event);
            ++i;
        }
        this._dgraphic.getProperties().store("P_TITLE_EVENT_LIST.DGraphic.core.jscrib", eventList);
    }

    public Tooltip getTooltip() {
        String tooltipStr;
        if (this.tooltip == null && this._dgraphic != null && (tooltipStr = this._dgraphic.getProperties().get("P_TITLE_TOOLTIP.DGraphic.core.jscrib", null)) != null) {
            this.tooltip = new SVGTooltipImpl(this._chart, this._dgraphic, tooltipStr);
        }
        return this.tooltip;
    }

    public void setTooltip(Tooltip newTooltip) {
        this.tooltip = newTooltip;
        this._dgraphic.getProperties().store("P_TITLE_TOOLTIP.DGraphic.core.jscrib", newTooltip.getLabel());
    }

    public void assignTooltip(Tooltip source) {
        this.tooltip = new SVGTooltipImpl(this._chart, this._dgraphic, SVGTooltipImpl.LABEL_EDEFAULT);
        ((SVGTooltipImpl)this.tooltip).assign(source);
        this._dgraphic.getProperties().store("P_TITLE_TOOLTIP.DGraphic.core.jscrib", this.tooltip.getLabel());
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (label: ");
        result.append(this.getLabel());
        result.append(", withSeparator: ");
        if (this.withSeparatorESet) {
            result.append(this.isWithSeparator());
        } else {
            result.append("<unset>");
        }
        if (this.showESet) {
            result.append(this.isShow());
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }
}

