/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.input.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Accessibility;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Tooltip;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.AccessibilityImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.CategoricalDataImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.CoordinatesImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.EventHandlerImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.InputBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.TooltipImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.ElementList;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;
import org.w3c.dom.Element;

public class DataSetImpl
extends InputBase
implements DataSet {
    protected static final String ID_EDEFAULT = null;
    protected String id = ID_EDEFAULT;
    protected static final String LABEL_EDEFAULT = null;
    protected String label = LABEL_EDEFAULT;
    protected List dataPoint = null;
    protected List coordinates = null;
    protected Accessibility accessibility = null;
    protected List eventHandler = null;
    protected Tooltip tooltip = null;

    protected DataSetImpl() {
    }

    public DataSetImpl(Chart chart) {
        this._chart = chart;
        if (this._chart.getElement() != null) {
            this._element = this._chart.getElement().getOwnerDocument().createElement("dataSet");
        }
    }

    public DataSetImpl(Chart chart, Element element) {
        this._chart = chart;
        this._element = element;
    }

    public String getId() {
        if (this.id == ID_EDEFAULT && this._element != null && this._element.hasAttribute("id")) {
            this.id = this._element.getAttribute("id");
        }
        return this.id;
    }

    public void setId(String newId) {
        this.id = newId;
        if (this._element != null) {
            this._element.setAttribute("id", newId);
        }
    }

    public String getLabel() {
        if (this.label == ID_EDEFAULT && this._element != null && this._element.hasAttribute("label")) {
            this.label = this._element.getAttribute("label");
        }
        return this.label;
    }

    public void setLabel(String newLabel) {
        this.label = newLabel;
        if (this._element != null) {
            this._element.setAttribute("label", newLabel);
        }
    }

    public List getDataPoint() {
        if (this.dataPoint == null) {
            if (this._element != null) {
                List elementList = Utilities.getElementList(this._element, "dataPoint");
                this.dataPoint = new ElementList(this, "dataPoint");
                ElementList elemList = (ElementList)this.dataPoint;
                int i = 0;
                while (i < elementList.size()) {
                    elemList.add(new CategoricalDataImpl(this._chart, (Element)elementList.get(i)), false);
                    ++i;
                }
            } else {
                this.dataPoint = new ArrayList();
            }
        }
        return this.dataPoint;
    }

    public List getCoordinates() {
        if (this.coordinates == null) {
            if (this._element != null) {
                List elementList = Utilities.getElementList(this._element, "coordinates");
                this.coordinates = new ElementList(this, "coordinates");
                ElementList elemList = (ElementList)this.coordinates;
                int i = 0;
                while (i < elementList.size()) {
                    elemList.add(new CoordinatesImpl(this._chart, (Element)elementList.get(i)), false);
                    ++i;
                }
            } else {
                this.coordinates = new ArrayList();
            }
        }
        return this.coordinates;
    }

    public Accessibility getAccessibility() {
        Element resultElement;
        if (this.accessibility == null && this._element != null && (resultElement = Utilities.getElement(this._element, "accessibility")) != null) {
            this.accessibility = new AccessibilityImpl(this._chart, resultElement);
        }
        return this.accessibility;
    }

    public void setAccessibility(Accessibility newAccessibility) {
        this.accessibility = newAccessibility;
        if (this._element != null && newAccessibility != null && newAccessibility.getElement() != null) {
            Utilities.appendChild(this, newAccessibility, "accessibility");
        }
    }

    public List getEventHandler() {
        if (this.eventHandler == null) {
            if (this._element != null) {
                List elementList = Utilities.getElementList(this._element, "eventHandler");
                this.eventHandler = new ElementList(this, "eventHandler");
                ElementList elemList = (ElementList)this.eventHandler;
                int i = 0;
                while (i < elementList.size()) {
                    elemList.add(new EventHandlerImpl(this._chart, (Element)elementList.get(i)), false);
                    ++i;
                }
            } else {
                this.eventHandler = new ArrayList();
            }
        }
        return this.eventHandler;
    }

    public Tooltip getTooltip() {
        Element resultElement;
        if (this.tooltip == null && this._element != null && (resultElement = Utilities.getElement(this._element, "tooltip")) != null) {
            this.tooltip = new TooltipImpl(this._chart, resultElement);
        }
        return this.tooltip;
    }

    public void setTooltip(Tooltip newTooltip) {
        this.tooltip = newTooltip;
        if (this._element != null && newTooltip != null && newTooltip.getElement() != null) {
            Utilities.appendChild(this, newTooltip, "tooltip");
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (id: ");
        result.append(this.id);
        result.append(", label: ");
        result.append(this.label);
        result.append(')');
        return result.toString();
    }
}

