/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.input.impl;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.EventHandler;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.InputBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EventHandlerImpl
extends InputBase
implements EventHandler {
    protected static final String VALUE_EDEFAULT = null;
    protected String value = VALUE_EDEFAULT;
    protected static final String TYPE_EDEFAULT = null;
    protected String type = TYPE_EDEFAULT;

    protected EventHandlerImpl() {
    }

    public EventHandlerImpl(Chart chart) {
        this._chart = chart;
        if (this._chart.getElement() != null) {
            this._element = this._chart.getElement().getOwnerDocument().createElement("eventHandler");
        }
    }

    public EventHandlerImpl(Chart chart, Element element) {
        this._chart = chart;
        this._element = element;
    }

    public String getValue() {
        if (this.value == VALUE_EDEFAULT && this._element != null) {
            this.value = Utilities.getText(this._element);
        }
        return this.value;
    }

    public void setValue(String newValue) {
        this.value = newValue;
        if (this._element != null) {
            Text textNode = this._element.getOwnerDocument().createTextNode(newValue);
            this._element.appendChild(textNode);
        }
    }

    public String getType() {
        if (this.type == TYPE_EDEFAULT && this._element != null && this._element.hasAttribute("type")) {
            this.type = this._element.getAttribute("type");
        }
        return this.type;
    }

    public void setType(String newType) {
        this.type = newType;
        if (this._element != null) {
            this._element.setAttribute("type", newType);
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (value: ");
        result.append(this.value);
        result.append(", type: ");
        result.append(this.type);
        result.append(')');
        return result.toString();
    }
}

