/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.input.impl;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Preferences;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Tooltip;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.InputBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.TooltipImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;
import org.w3c.dom.Element;

public class PreferencesImpl
extends InputBase
implements Preferences {
    protected static final String BROWSER_COOKIE_NAME_EDEFAULT = null;
    protected String browserCookieName = BROWSER_COOKIE_NAME_EDEFAULT;
    protected static final boolean SHOW_EDEFAULT = false;
    protected boolean show = false;
    protected boolean showESet = false;
    protected static final String STORED_PREFERENCES_EDEFAULT = null;
    protected String storedPreferences = STORED_PREFERENCES_EDEFAULT;
    protected static final String UPDATED_PREFERENCES_VARIABLE_EDEFAULT = null;
    protected String updatedPreferencesVariable = UPDATED_PREFERENCES_VARIABLE_EDEFAULT;
    protected static final String URL_EDEFAULT = null;
    protected String url = URL_EDEFAULT;
    protected Tooltip tooltip = null;

    protected PreferencesImpl() {
    }

    public PreferencesImpl(Chart chart) {
        this._chart = chart;
        if (this._chart.getElement() != null) {
            this._element = this._chart.getElement().getOwnerDocument().createElement("preferences");
        }
    }

    public PreferencesImpl(Chart chart, Element element) {
        this._chart = chart;
        this._element = element;
    }

    public String getBrowserCookieName() {
        if (this.browserCookieName == BROWSER_COOKIE_NAME_EDEFAULT && this._element != null && this._element.hasAttribute("browserCookieName")) {
            this.browserCookieName = this._element.getAttribute("browserCookieName");
        }
        return this.browserCookieName;
    }

    public void setBrowserCookieName(String newBrowserCookieName) {
        this.browserCookieName = newBrowserCookieName;
        if (this._element != null) {
            this._element.setAttribute("browserCookieName", newBrowserCookieName);
        }
    }

    public boolean isShow() {
        String attr;
        if (!this.show && (attr = this._element.getAttribute("show")).length() != 0) {
            if (attr.equalsIgnoreCase("true")) {
                this.show = true;
            }
            this.showESet = true;
        }
        return this.show;
    }

    public void setShow(boolean newShow) {
        this.show = newShow;
        this.showESet = true;
        if (this._element != null) {
            if (this.show) {
                this._element.setAttribute("show", "true");
            } else {
                this._element.setAttribute("show", "false");
            }
        }
    }

    public void unsetShow() {
        this.showESet = false;
        this.show = false;
        if (this._element != null && this._element.hasAttribute("show")) {
            this._element.removeAttribute("show");
        }
    }

    public boolean isSetShow() {
        if (!this.showESet) {
            this.isShow();
        }
        return this.showESet;
    }

    public String getStoredPreferences() {
        if (this.storedPreferences == STORED_PREFERENCES_EDEFAULT && this._element != null && this._element.hasAttribute("storedPreferences")) {
            this.storedPreferences = this._element.getAttribute("storedPreferences");
        }
        return this.storedPreferences;
    }

    public void setStoredPreferences(String newStoredPreferences) {
        this.storedPreferences = newStoredPreferences;
        if (this._element != null) {
            this._element.setAttribute("storedPreferences", newStoredPreferences);
        }
    }

    public String getUpdatedPreferencesVariable() {
        if (this.updatedPreferencesVariable == UPDATED_PREFERENCES_VARIABLE_EDEFAULT && this._element != null && this._element.hasAttribute("updatedPreferencesVariable")) {
            this.updatedPreferencesVariable = this._element.getAttribute("updatedPreferencesVariable");
        }
        return this.updatedPreferencesVariable;
    }

    public void setUpdatedPreferencesVariable(String newUpdatedPreferencesVariable) {
        this.updatedPreferencesVariable = newUpdatedPreferencesVariable;
        if (this._element != null) {
            this._element.setAttribute("updatedPreferencesVariable", newUpdatedPreferencesVariable);
        }
    }

    public String getUrl() {
        if (this.url == URL_EDEFAULT && this._element != null && this._element.hasAttribute("url")) {
            this.url = this._element.getAttribute("url");
        }
        return this.url;
    }

    public void setUrl(String newUrl) {
        this.url = newUrl;
        if (this._element != null) {
            this._element.setAttribute("url", newUrl);
        }
    }

    public Tooltip getTooltip() {
        Element resultElement;
        if (this.tooltip == null && this._element != null && (resultElement = Utilities.getElement(this._element, "tooltip")) != null) {
            this.tooltip = new TooltipImpl(this._chart, resultElement);
        }
        return this.tooltip;
    }

    public void setTooltip(Tooltip newTooltip) {
        this.tooltip = newTooltip;
        if (this._element != null && newTooltip != null && newTooltip.getElement() != null) {
            Utilities.appendChild(this, newTooltip, "tooltip");
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (browserCookieName: ");
        result.append(this.browserCookieName);
        result.append(", show: ");
        if (this.showESet) {
            result.append(this.show);
        } else {
            result.append("<unset>");
        }
        result.append(", storedPreferences: ");
        result.append(this.storedPreferences);
        result.append(", updatedPreferencesVariable: ");
        result.append(this.updatedPreferencesVariable);
        result.append(", url: ");
        result.append(this.url);
        result.append(')');
        return result.toString();
    }
}

