/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Axes;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Categories;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Category;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Configuration;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.Axis;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.FontHelper;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;

public abstract class AxisCategory
extends Axis {
    protected short labelOrientation;
    protected Data data;
    protected List categoryList = null;
    protected int numOfCategories = 0;
    protected String title = null;
    protected double[] groupBoundaryPositions;
    protected double[] groupDataPositions;

    public AxisCategory(Chart input, NLString nls) {
        this(input, 0, nls, 0.0);
    }

    public AxisCategory(Chart input, short labelOrientation, NLString nls) {
        this(input, labelOrientation, nls, 0.0);
    }

    public AxisCategory(Chart input, short labelOrientation, NLString nls, double labelDegrees) {
        super(input, nls, labelDegrees);
        this.labelOrientation = labelOrientation;
        this.showMajorGridLines = false;
        this.showMinorGridLines = false;
        this.data = input.getData();
        if (this.data != null) {
            this.data.getDataSets();
            Categories categorySet = this.data.getCategories();
            if (categorySet != null) {
                this.categoryList = categorySet.getCategory();
                this.numOfCategories = this.categoryList.size();
            }
        }
        Configuration config = input.getConfiguration();
        Axes axes = null;
        if (config != null && (axes = config.getAxes()) != null) {
            this.axisDef = axes.getIndependentAxis();
            if (this.axisDef != null) {
                if (this.axisDef.isSetLabelRotation()) {
                    this.setLabelDegrees(this.axisDef.getLabelRotation());
                }
                this.title = nls.getString(this.axisDef.getLabel());
                this.majorUnitDef = this.axisDef.getMajorUnit();
                this.minorUnitDef = this.axisDef.getMinorUnit();
                if (this.majorUnitDef != null) {
                    if (this.majorUnitDef.isSetShowTick()) {
                        this.showMajorTicks = this.majorUnitDef.isShowTick();
                    }
                    if (this.majorUnitDef.isSetShowGridLine()) {
                        this.showMajorGridLines = this.majorUnitDef.isShowGridLine();
                    }
                }
                if (this.minorUnitDef != null) {
                    if (this.minorUnitDef.isSetShowTick()) {
                        this.showMinorTicks = this.minorUnitDef.isShowTick();
                    }
                    if (this.minorUnitDef.isSetShowGridLine()) {
                        this.showMinorGridLines = this.minorUnitDef.isShowGridLine();
                    }
                }
            }
        }
    }

    protected abstract SVGBase drawHorizontalLabels();

    protected abstract SVGBase drawVerticalLabels();

    protected String[] wrapLabel(String label) {
        ArrayList<String> wrapStrings = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(label, " ");
        while (st.hasMoreElements()) {
            wrapStrings.add(st.nextElement().toString());
        }
        return wrapStrings.toArray(new String[wrapStrings.size()]);
    }

    protected int getMaxNumOfRowsOfLabels() {
        if (this.categoryList == null) {
            return 0;
        }
        int numOfRows = 0;
        for (Category c : this.categoryList) {
            StringTokenizer tokenizer;
            if (c.getLabel() == null || (tokenizer = new StringTokenizer(c.getLabel())).countTokens() <= numOfRows) continue;
            numOfRows = tokenizer.countTokens();
        }
        return numOfRows;
    }

    protected double getMaxLabelLength() {
        if (this.categoryList == null) {
            return 0.0;
        }
        FontHelper fontHelper = new FontHelper();
        fontHelper.setFontSize(8.0f);
        double maxLength = 0.0;
        for (Category c : this.categoryList) {
            double len;
            if (c.getLabel() == null || !((len = fontHelper.getStringWidth(this.nls.getString(c.getLabel()), this.labelDegrees, true)) > maxLength)) continue;
            maxLength = len;
        }
        return maxLength;
    }

    protected double getMaxLabelHeight() {
        if (this.categoryList == null) {
            return 0.0;
        }
        FontHelper fontHelper = new FontHelper();
        fontHelper.setFontSize(10.0f);
        double maxLength = 0.0;
        for (Category c : this.categoryList) {
            if (c.getLabel() == null) continue;
            if (this.categoryList == null) {
                return 0.0;
            }
            String maxLabel = "";
            double maxStringHeight = 0.0;
            double maxStringWidth = 0.0;
            int maxLine = 1;
            StringTokenizer tokenizer = new StringTokenizer(c.getLabel());
            int lines = tokenizer.countTokens();
            while (tokenizer.hasMoreTokens()) {
                String label = tokenizer.nextToken();
                double len = fontHelper.getStringWidth(label, 0.0);
                if (!(len > maxStringWidth)) continue;
                maxStringWidth = len;
                maxLabel = label;
            }
            if (lines > maxLine) {
                maxLine = lines;
            }
            if (!(maxLength < (maxStringHeight = fontHelper.getHeight(maxLabel, this.labelDegrees, maxLine)))) continue;
            maxLength = maxStringHeight;
        }
        return maxLength;
    }

    private void setGroupBoundaryPositions() {
        this.groupBoundaryPositions = new double[this.numOfCategories + 1];
        if (this.numOfCategories > 0) {
            int i = 0;
            while (i < this.groupBoundaryPositions.length) {
                this.groupBoundaryPositions[i] = this.getAxisLength() * (double)i / (double)this.numOfCategories;
                ++i;
            }
        } else {
            this.groupBoundaryPositions[0] = this.getAxisLength();
        }
    }

    public void setGroupDataPositions() {
        this.groupDataPositions = new double[this.numOfCategories];
        double offset = this.getAxisLength() / (double)(this.numOfCategories * 2);
        int i = 0;
        while (i < this.groupDataPositions.length) {
            this.groupDataPositions[i] = offset + this.getAxisLength() * (double)i / (double)this.numOfCategories;
            ++i;
        }
    }

    public double[] getGroupBoundaryPositions() {
        if (this.groupBoundaryPositions == null) {
            this.setGroupBoundaryPositions();
        }
        return this.groupBoundaryPositions;
    }

    public double[] getGroupDataPositions() {
        if (this.groupDataPositions == null) {
            this.setGroupDataPositions();
        }
        return this.groupDataPositions;
    }

    public void setLabelDegrees(double labelDegrees) {
        if (this.getAxisOrientation() == 1) {
            labelDegrees = -(labelDegrees - 90.0);
        }
        super.setLabelDegrees(labelDegrees);
    }
}

