/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGLine;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolyline;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGUse;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Category;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisCategory;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisLabel;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.EventTools;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;

public class AxisCategoryHorizontal
extends AxisCategory {
    private static final long serialVersionUID = 1L;
    private static final int LINE_HEIGHT = 14;
    private boolean isLTR = true;

    public AxisCategoryHorizontal(Chart input, boolean isLTR, NLString nls) {
        this(input, isLTR, 0, nls);
        this.isLTR = isLTR;
    }

    public AxisCategoryHorizontal(Chart input, boolean isLTR, short labelOrientation, NLString nls) {
        super(input, labelOrientation, nls);
        this.isLTR = isLTR;
        this.axisHeight = this.getAxisHeight();
    }

    public void setAxisLength(double length) {
        this.axisWidth = length;
    }

    public double getAxisLength() {
        return this.axisWidth;
    }

    private int getTitleHeight() {
        if (this.title == null) {
            return 0;
        }
        return 23;
    }

    public double getAxisHeight() {
        return this.getMaxLabelHeight() + 8.0 + (double)this.getTitleHeight();
    }

    protected void constructPart() {
        SVGUse useTick;
        int i;
        double[] tickPositions;
        SVGBase[] ticks;
        SVGGroup tickGroup;
        SVGGroup axisGroup = new SVGGroup();
        SVGBase[] axisParts = new SVGBase[5];
        axisGroup.setChildren(axisParts);
        SVGBase[] child = new SVGBase[]{axisGroup};
        this.setChildren(child);
        SVGLine axis = new SVGLine();
        axis.setX1("0");
        axis.setY1(Integer.toString(5));
        axis.setX2(Double.toString(this.axisWidth));
        axis.setY2(Integer.toString(5));
        axis.setStyleClass("axisLines");
        SVGGroup axisGroup2 = new SVGGroup();
        SVGBase[] axisGroup2Children = new SVGBase[2];
        axisGroup2Children[0] = axis;
        axisGroup2.setChildren(axisGroup2Children);
        if (this.axisDef != null) {
            axisGroup2Children[1] = EventTools.generateUserTooltip(axisGroup2, this.axisDef.getTooltip(), this.nls);
            EventTools.generateUserEvents(axisGroup2, this.axisDef.getEventHandler());
            EventTools.generateAccessibility(axisGroup2, this.axisDef.getAccessibility(), this.nls);
        }
        axisParts[0] = axisGroup2;
        SVGGroup tickDefGroup = new SVGGroup();
        tickDefGroup.setIdentifier("xtickline");
        SVGBase tickDef = this.drawTickMarks();
        tickDef.setStyleClass("axisTicks");
        tickDef.setIdentifier("xtickline");
        SVGBase[] tick = new SVGBase[]{tickDef};
        tickDefGroup.setChildren(tick);
        this.addDefinition(tickDef);
        if (this.showMajorTicks) {
            tickGroup = new SVGGroup();
            ticks = new SVGBase[this.categoryList.size() + 1];
            axisParts[1] = tickGroup;
            tickGroup.setChildren(ticks);
            tickPositions = this.getGroupBoundaryPositions();
            i = 0;
            while (i < tickPositions.length) {
                useTick = new SVGUse();
                useTick.setHref("#xtickline");
                useTick.setXCoordinate(Double.toString(tickPositions[i]));
                useTick.setYCoordinate(Integer.toString(5));
                ticks[i] = useTick;
                ++i;
            }
        }
        if (this.showMinorTicks) {
            tickGroup = new SVGGroup();
            ticks = new SVGBase[this.categoryList.size()];
            axisParts[2] = tickGroup;
            tickGroup.setChildren(ticks);
            tickPositions = this.getGroupDataPositions();
            i = 0;
            while (i < tickPositions.length) {
                useTick = new SVGUse();
                useTick.setHref("#xtickline");
                useTick.setXCoordinate(Double.toString(tickPositions[i]));
                useTick.setYCoordinate(Integer.toString(5));
                ticks[i] = useTick;
                ++i;
            }
        }
        axisParts[3] = this.labelOrientation == 0 ? this.drawHorizontalLabels() : this.drawVerticalLabels();
        if (this.title != null) {
            SVGText svgTitle = new SVGText();
            svgTitle.setText(this.title);
            svgTitle.setXCoordinate(Double.toString(this.getAxisLength() / 2.0));
            svgTitle.setYCoordinate(Double.toString(this.getAxisHeight()));
            svgTitle.setStyleClass("axisTitles anchorAtMiddle");
            svgTitle.setIdentifier("SVGGEN_labelsValues0");
            axisParts[4] = svgTitle;
        }
    }

    protected SVGBase drawHorizontalLabels() {
        SVGGroup labelGroup = new SVGGroup();
        SVGBase[] labels = new SVGBase[this.categoryList.size()];
        labelGroup.setChildren(labels);
        double[] labelPositions = this.getGroupDataPositions();
        int i = 0;
        while (i < labelPositions.length) {
            int currentY = 17;
            int categoryIndex = this.isLTR ? i : labelPositions.length - i - 1;
            Category category = (Category)this.categoryList.get(categoryIndex);
            if (category.getLabel() != null) {
                String[] rows = this.wrapLabel(this.nls.getString(category.getLabel()));
                SVGGroup label = new SVGGroup();
                SVGBase[] rowText = new SVGBase[rows.length + 1];
                label.setChildren(rowText);
                label.setIdentifier(category.getId());
                rowText[rows.length] = EventTools.generateUserTooltip(label, category.getTooltip(), this.nls);
                EventTools.generateUserEvents(label, category.getEventHandler());
                EventTools.generateAccessibility(label, category.getAccessibility(), this.nls);
                double labelDegreesTemp = this.labelDegrees;
                if (rows.length > 1) {
                    labelDegreesTemp = 0.0;
                    label.setTransformation("rotate(" + this.labelDegrees + "," + labelPositions[i] + "," + (currentY + rows.length * 14 / 2) + ")");
                }
                int j = 0;
                while (j < rows.length) {
                    AxisLabel labelLine = new AxisLabel(2, 1);
                    labelLine.setDegrees(labelDegreesTemp);
                    labelLine.setXCoordinate(Double.toString(labelPositions[i]));
                    labelLine.setYCoordinate(Integer.toString(currentY));
                    labelLine.setIdentifier("SVGGEN_axisLabel" + EventTools.getUniqueID());
                    labelLine.setText(rows[j]);
                    currentY += 14;
                    rowText[j] = labelLine;
                    ++j;
                }
                labels[i] = label;
            }
            ++i;
        }
        return labelGroup;
    }

    protected SVGBase drawVerticalLabels() {
        return null;
    }

    public void setCrossPoint(double x, double y) {
        this.setXCoordinate(Double.toString(x));
        this.setYCoordinate(Double.toString(y - 5.0));
    }

    public double getAxisWidth() {
        return 0.0;
    }

    public short getAxisOrientation() {
        return 0;
    }

    protected SVGBase drawTickMarks() {
        SVGPolyline tickDef = new SVGPolyline();
        tickDef.setPoints("0 0 0 -5");
        return tickDef;
    }
}

