/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import java.awt.Font;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGRotateText;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AxisLabel
extends SVGRotateText {
    protected int direction;
    protected int position;
    public static final int NORTH = 0;
    public static final int SOUTH = 1;
    public static final int EAST = 2;
    public static final int WEST = 3;
    public static final int ABOVE = 0;
    public static final int BELOW = 1;
    static final long serialVersionUID = 4073547883552478212L;

    public AxisLabel(int direction, int position) {
        this.direction = direction;
        this.position = position;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public Element doImplementation(Document svgDocument) throws DOMException, NullPointerException {
        this.implementation = super.doImplementation(svgDocument);
        int fontSize = Integer.parseInt(this.getFontSize());
        double midPointY = 0.0;
        double midPointX = 0.0;
        double radDegrees = this.degrees * Math.PI / 180.0;
        if (this.direction == 2 || this.direction == 3) {
            if (this.anchorStyle == 0) {
                midPointX = (double)(-fontSize / 2) * Math.abs(Math.sin(radDegrees));
                midPointY = this.degrees > 90.0 ? -((double)(fontSize / 2) * Math.abs(Math.sin(radDegrees))) : (double)(fontSize / 2) * Math.abs(Math.sin(radDegrees));
            } else if (this.anchorStyle == 2) {
                midPointX = (double)(fontSize / 2) * Math.abs(Math.sin(radDegrees));
                midPointY = this.degrees > 90.0 ? -((double)(fontSize / 2) * Math.abs(Math.cos(radDegrees))) : (double)(fontSize / 2) * Math.abs(Math.cos(radDegrees));
            } else {
                midPointY = fontSize;
                if (this.degrees == 180.0) {
                    midPointY = fontSize / 2;
                }
            }
        } else if (this.anchorStyle == 0) {
            midPointX = this.degrees > 90.0 ? -((double)(fontSize / 2) * Math.abs(Math.sin(radDegrees))) : (double)(fontSize / 2) * Math.abs(Math.cos(radDegrees));
            midPointY = this.degrees < 0.0 ? -((double)(fontSize / 2) * Math.abs(Math.sin(radDegrees))) : (double)(fontSize / 2) * Math.abs(Math.sin(radDegrees));
        } else if (this.anchorStyle == 2) {
            midPointX = this.degrees > 90.0 ? -((double)(fontSize / 2) * Math.abs(Math.cos(radDegrees))) : (double)(fontSize / 2) * Math.abs(Math.cos(radDegrees));
            midPointY = this.degrees < 0.0 ? -((double)(fontSize / 2) * Math.abs(Math.sin(radDegrees))) : (double)(fontSize / 2) * Math.abs(Math.sin(radDegrees));
        } else {
            midPointX = this.position == 0 ? (double)(-fontSize) : (double)fontSize;
            if (this.degrees == 180.0 || this.degrees == 0.0) {
                midPointX = fontSize / 2;
            }
        }
        double translateDegrees = 0.0;
        if (this.direction == 0) {
            translateDegrees = this.degrees - 90.0;
            if (this.position == 0 && this.degrees % 180.0 == 0.0 && this.degrees != 0.0) {
                translateDegrees += 180.0;
            }
        } else if (this.direction == 2) {
            translateDegrees = this.degrees * -1.0;
        } else if (this.direction == 3) {
            translateDegrees = this.degrees - 180.0;
        } else if (this.direction == 1) {
            translateDegrees = -1.0 * (this.degrees - 90.0);
        }
        this.implementation.setAttribute("transform", "translate(" + (Double.parseDouble(this.getXCoordinate()) + midPointX) + "," + (Double.parseDouble(this.getYCoordinate()) + midPointY) + ") rotate(" + translateDegrees + ") translate(" + 0 + "," + 0 + ")");
        if (this.getXCoordinate() != null) {
            this.implementation.removeAttribute("x");
        }
        if (this.getYCoordinate() != null) {
            this.implementation.removeAttribute("y");
        }
        this.boundingBox = SVGRotateText.getBoundingBox(this.getText(), 0.0, new Font("arial", 0, 8));
        Element rect = svgDocument.createElement("rect");
        rect.setAttribute("x", String.valueOf(Double.parseDouble(this.getXCoordinate())));
        rect.setAttribute("y", String.valueOf(Double.parseDouble(this.getYCoordinate())));
        rect.setAttribute("height", "1");
        rect.setAttribute("width", "1");
        rect.setAttribute("fill", "red");
        Element group = svgDocument.createElement("g");
        group.appendChild(rect);
        group.appendChild(this.implementation);
        return this.implementation;
    }

    public void setDegrees(double degrees) {
        degrees %= 360.0;
        switch (this.direction) {
            case 2: 
            case 3: {
                if (degrees == 0.0 || degrees == 180.0) {
                    this.setAnchorStyle(1);
                    break;
                }
                if (degrees < 0.0) {
                    this.setAnchorStyle(0);
                    break;
                }
                if (degrees <= 180.0) {
                    this.setAnchorStyle(2);
                    break;
                }
                this.setAnchorStyle(0);
                break;
            }
            case 0: 
            case 1: {
                if (degrees == 0.0 || degrees == 180.0) {
                    this.setAnchorStyle(1);
                    break;
                }
                if (this.position == 0) {
                    if (degrees < 0.0) {
                        this.setAnchorStyle(0);
                        break;
                    }
                    this.setAnchorStyle(2);
                    break;
                }
                this.setAnchorStyle(0);
            }
        }
        super.setDegrees(degrees);
    }

    public void setAnchorStyle(int anchorStyle) {
        super.setAnchorStyle(anchorStyle);
        switch (anchorStyle) {
            case 2: {
                this.setStyleClass("axisLabels anchorAtEnd");
                break;
            }
            case 1: {
                this.setStyleClass("axisLabels anchorAtMiddle");
                break;
            }
            case 0: {
                this.setStyleClass("axisLabels anchorAtStart");
            }
        }
    }
}

