/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.ULocale;
import java.awt.geom.Dimension2D;
import java.util.Date;
import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.ICustomFormatter;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Axes;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.CategoricalData;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Categories;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Category;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Configuration;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Coordinates;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.CustomFormat;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DateFormat;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Internationalization;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.Axis;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.FontHelper;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;

public abstract class AxisNumber
extends Axis {
    protected double min;
    protected double max;
    protected double majorUnit;
    protected double minorUnit;
    protected double dataMax;
    protected double dataMin;
    protected short labelOrientation = 0;
    protected List datasets = null;
    protected boolean cumulative = false;
    protected static final int TOP_MARGIN = 10;
    protected short axisType;
    protected String title;
    protected String customPattern;
    protected String timezone;
    protected String[] labels;
    protected double[] majorUnitValues;
    protected double[] minorUnitValues;
    protected double maxLabelLength = 0.0;
    protected double maxLabelHeight = 0.0;
    protected boolean isLinear = true;
    private NumberFormat numberFormatter = null;
    private ICustomFormatter customFormatter = null;
    private SimpleDateFormat dateFormatter = null;
    private ULocale locale = null;

    public AxisNumber(Chart input, List datasets, short axisType, boolean cumulative, NLString nls) {
        this(input, datasets, axisType, cumulative, 0, nls, 0.0);
    }

    public AxisNumber(Chart input, List datasets, short axisType, boolean cumulative, NLString nls, double labelDegrees) {
        this(input, datasets, axisType, cumulative, 0, nls, labelDegrees);
    }

    public AxisNumber(Chart input, List datasets, short axisType, boolean cumulative, short labelOrientation, NLString nls) {
        this(input, datasets, axisType, cumulative, labelOrientation, nls, 0.0);
    }

    public AxisNumber(Chart input, List datasets, short axisType, boolean cumulative, short labelOrientation, NLString nls, double labelDegrees) {
        super(input, nls, labelDegrees);
        this.datasets = datasets;
        this.axisType = axisType;
        this.cumulative = cumulative;
        this.labelOrientation = labelOrientation;
        this.dataMax = -1.7976931348623157E308;
        this.dataMin = Double.MAX_VALUE;
        if (axisType == 1) {
            this.showMajorGridLines = true;
            this.showMinorGridLines = true;
        } else if (axisType == 2 || axisType == 0) {
            this.showMajorGridLines = false;
            this.showMinorGridLines = false;
        }
        this.analyzeDataSets();
        this.initDataFormatter();
        this.getTickMarkValuesAndLabels();
    }

    public abstract void setAxisLength(double var1);

    public abstract double getAxisLength();

    public abstract void setCrossPoint(double var1, double var3);

    protected abstract SVGBase drawHorizontalLabels(double[] var1);

    protected abstract SVGBase drawVerticalLabels(double[] var1);

    public abstract short getAxisOrientation();

    private void analyzeDataSets() {
        Configuration config = this.input.getConfiguration();
        Axes axes = null;
        if (config != null) {
            Internationalization i18n;
            axes = config.getAxes();
            this.dataValueDef = config.getDataValue();
            if (axes != null) {
                this.axisDef = this.axisType == 0 ? axes.getIndependentAxis() : (this.axisType == 1 ? axes.getPrimaryDependentAxis() : axes.getSecondaryDependentAxis());
            }
            if ((i18n = config.getInternationalization()) != null) {
                String language = i18n.getLanguage() == null ? "" : i18n.getLanguage();
                String country = i18n.getCountry() == null ? "" : i18n.getCountry();
                String string = this.timezone = i18n.getTimezone() == null ? "" : i18n.getTimezone();
                if (language != "" && country != "") {
                    this.locale = new ULocale(language, country);
                } else if (language != "") {
                    this.locale = new ULocale(language);
                }
            }
        }
        if (this.axisDef != null) {
            if (this.axisDef.isSetLabelRotation()) {
                this.setLabelDegrees(this.axisDef.getLabelRotation());
            }
            this.title = this.nls.getString(this.axisDef.getLabel());
            this.isLinear = this.axisDef.getScale() == null || !this.axisDef.getScale().equals("log");
            boolean findOrderOfMagnitude = false;
            boolean axisMaxKnown = false;
            boolean axisMinKnown = false;
            boolean majorUnitKnown = false;
            double orderOfMagnitude = 1.0;
            if (this.axisDef.isSetMax()) {
                if (this.isLinear) {
                    this.max = this.axisDef.getMax();
                    axisMaxKnown = true;
                } else if (this.axisDef.getMax() > 0.0) {
                    this.max = Math.log(Math.abs(this.axisDef.getMax())) / Math.log(10.0);
                    axisMaxKnown = true;
                }
            }
            if (this.axisDef.isSetMin()) {
                if (this.isLinear) {
                    this.min = this.axisDef.getMin();
                    axisMinKnown = true;
                } else if (this.axisDef.getMin() > 0.0) {
                    this.min = Math.log(Math.abs(this.axisDef.getMin())) / Math.log(10.0);
                    axisMinKnown = true;
                }
            }
            if (axisMaxKnown && axisMinKnown && this.max == this.min) {
                axisMaxKnown = false;
                axisMinKnown = false;
            }
            this.majorUnitDef = this.axisDef.getMajorUnit();
            this.minorUnitDef = this.axisDef.getMinorUnit();
            if (!this.isLinear) {
                this.majorUnit = 1.0;
                majorUnitKnown = true;
            } else if (this.majorUnitDef != null && this.majorUnitDef.isSetValue()) {
                this.majorUnit = Math.abs(this.majorUnitDef.getValue());
                if (this.majorUnit != 0.0) {
                    majorUnitKnown = true;
                }
            } else {
                findOrderOfMagnitude = true;
            }
            if (this.majorUnitDef != null) {
                if (this.majorUnitDef.isSetShowTick()) {
                    this.showMajorTicks = this.majorUnitDef.isShowTick();
                }
                if (this.majorUnitDef.isSetShowGridLine()) {
                    this.showMajorGridLines = this.majorUnitDef.isShowGridLine();
                }
            }
            if (this.minorUnitDef != null) {
                if (this.minorUnitDef.isSetShowTick()) {
                    this.showMinorTicks = this.minorUnitDef.isShowTick();
                }
                if (this.minorUnitDef.isSetShowGridLine()) {
                    this.showMinorGridLines = this.minorUnitDef.isShowGridLine();
                }
            }
            if (!axisMaxKnown || !axisMinKnown || findOrderOfMagnitude) {
                this.getDataMaxMin();
                if (findOrderOfMagnitude) {
                    double magMin = this.dataMin;
                    double magMax = this.dataMax;
                    if (axisMinKnown) {
                        magMin = this.min;
                    }
                    if (axisMaxKnown) {
                        magMax = this.max;
                    }
                    orderOfMagnitude = this.getOrderOfMagnitude(magMax, magMin);
                }
                if (!this.isLinear && (this.dataMax <= 0.0 || this.dataMin <= 0.0)) {
                    this.max = 1.0;
                    this.min = 0.0;
                    axisMaxKnown = true;
                    axisMinKnown = true;
                }
            }
            if (!majorUnitKnown) {
                this.majorUnit = (this.dataMax - this.dataMin) / orderOfMagnitude > 5.0 ? orderOfMagnitude * 2.0 : orderOfMagnitude;
            }
            if (this.isLinear) {
                if (!axisMaxKnown) {
                    this.max = this.dataMax < 0.0 ? 0.0 : Math.floor(this.dataMax / this.majorUnit) * this.majorUnit + this.majorUnit;
                }
                if (!axisMinKnown) {
                    this.min = this.dataMin >= 0.0 ? 0.0 : (Math.floor(Math.abs(this.dataMin) / this.majorUnit) * this.majorUnit + this.majorUnit) * -1.0;
                }
            } else {
                if (!axisMaxKnown) {
                    this.max = this.dataMax > 0.0 ? (double)Math.round(Math.log(this.getOrderOfMagnitude(this.dataMax) * 10.0) / Math.log(10.0)) : 1.0;
                }
                if (!axisMinKnown) {
                    if (this.dataMin > 0.0) {
                        this.min = Math.round(Math.log(this.getOrderOfMagnitude(this.dataMin)) / Math.log(10.0));
                        if ((double)Math.round(Math.log(this.dataMin) / Math.log(10.0)) == this.min) {
                            this.min -= 1.0;
                        }
                    } else {
                        this.min = 0.0;
                    }
                }
            }
            if (this.max < this.min) {
                double tmp = this.max;
                this.max = this.min;
                this.min = tmp;
            }
            if (this.axisDef.getMinorUnit() != null && this.axisDef.getMinorUnit().isSetValue()) {
                this.minorUnit = Math.abs(this.minorUnitDef.getValue());
                if (this.minorUnit == 0.0) {
                    this.minorUnit = this.majorUnit / 2.0;
                }
            } else {
                this.minorUnit = this.majorUnit / 2.0;
            }
        } else {
            this.getDataMaxMin();
            if (this.isLinear) {
                double orderOfMagnitude = this.getOrderOfMagnitude(this.dataMax, this.dataMin);
                this.majorUnit = (this.dataMax - this.dataMin) / orderOfMagnitude > 5.0 ? orderOfMagnitude * 2.0 : orderOfMagnitude;
                this.minorUnit = this.majorUnit / 2.0;
            } else {
                this.majorUnit = 1.0;
            }
            if (this.isLinear) {
                this.max = this.dataMax < 0.0 ? 0.0 : Math.floor(this.dataMax / this.majorUnit) * this.majorUnit + this.majorUnit;
                this.min = this.dataMin >= 0.0 ? 0.0 : (Math.floor(Math.abs(this.dataMin) / this.majorUnit) * this.majorUnit + this.majorUnit) * -1.0;
            } else {
                this.max = Math.round(Math.log(this.getOrderOfMagnitude(this.dataMax) * 10.0) / Math.log(10.0));
                this.min = Math.round(Math.log(this.getOrderOfMagnitude(this.dataMin)) / Math.log(10.0));
            }
        }
    }

    private void getDataMaxMin() {
        if (this.datasets != null) {
            if (!this.cumulative) {
                for (DataSet dataset : this.datasets) {
                    List dataPoints = dataset.getDataPoint();
                    List coordinates = dataset.getCoordinates();
                    if (dataPoints != null && !dataPoints.isEmpty()) {
                        this.findMaxMinFromDataPoints(dataPoints);
                        continue;
                    }
                    if (coordinates == null || coordinates.isEmpty()) continue;
                    boolean useValue1 = false;
                    if (this.axisType == 0) {
                        useValue1 = true;
                    }
                    this.findMaxMinFromCoordinates(coordinates, useValue1);
                }
                if (this.isLinear && this.dataMax < this.dataMin) {
                    this.dataMax = 1.0;
                    this.dataMin = 0.0;
                }
            } else {
                Categories categories;
                Data data = this.input.getData();
                List categoryList = null;
                if (data != null && (categories = data.getCategories()) != null) {
                    categoryList = categories.getCategory();
                }
                if (categoryList != null) {
                    double[] accumulatedHighValues = new double[categoryList.size()];
                    double[] accumulatedLowValues = new double[categoryList.size()];
                    int j = 0;
                    while (j < categoryList.size()) {
                        accumulatedHighValues[j] = 0.0;
                        accumulatedLowValues[j] = 0.0;
                        ++j;
                    }
                    for (DataSet dataset : this.datasets) {
                        List dataPoints = dataset.getDataPoint();
                        if (dataPoints == null || dataPoints.isEmpty()) continue;
                        this.findMaxMinFromDataPoints(dataPoints, categoryList, accumulatedHighValues, accumulatedLowValues);
                    }
                    if (this.isLinear && this.dataMax < this.dataMin) {
                        this.dataMax = 1.0;
                        this.dataMin = 0.0;
                    }
                } else if (this.isLinear) {
                    this.dataMax = 1.0;
                    this.dataMin = 0.0;
                } else {
                    this.dataMax = 9.0;
                    this.dataMin = 1.0;
                }
            }
        } else if (this.isLinear) {
            this.dataMax = 1.0;
            this.dataMin = 0.0;
        } else {
            this.dataMax = 9.0;
            this.dataMin = 1.0;
        }
    }

    private void findMaxMinFromDataPoints(List dataPoints) {
        double currentMax = this.dataMax;
        double currentMin = this.dataMin;
        if (this.isLinear) {
            double factor = Math.pow(10.0, this.findFactor(dataPoints));
            currentMax *= factor;
            currentMin *= factor;
            for (CategoricalData datum : dataPoints) {
                double currentValue = datum.getValue() * factor;
                if (currentValue < currentMin) {
                    currentMin = currentValue;
                }
                if (!(currentValue > currentMax)) continue;
                currentMax = currentValue;
            }
            currentMin /= factor;
            currentMax /= factor;
        } else {
            for (CategoricalData datum : dataPoints) {
                double currentValue = datum.getValue();
                if (currentValue > 0.0 && currentValue < currentMin) {
                    currentMin = currentValue;
                }
                if (!(currentValue > 0.0) || !(currentValue > currentMax)) continue;
                currentMax = currentValue;
            }
        }
        this.dataMax = currentMax;
        this.dataMin = currentMin;
    }

    private int findMaxFactor(int oldFactor, double value) {
        if (Math.abs(value) * Math.pow(10.0, oldFactor) < 1.0 && Math.abs(value) * Math.pow(10.0, oldFactor) > 0.0) {
            return this.findMaxFactor(oldFactor + 1, value);
        }
        if (Math.abs(value) * Math.pow(10.0, oldFactor) >= 10.0) {
            return this.findMaxFactor(oldFactor - 1, value);
        }
        return oldFactor;
    }

    private int findFactor(List values) {
        double[] cfr_ignored_0 = new double[values.size()];
        int factor = 1;
        int maxFactor = Integer.MAX_VALUE;
        for (CategoricalData datum : values) {
            double currentValue = datum.getValue();
            if (Math.abs(currentValue) < 1.0) {
                if ((factor = this.findMaxFactor(factor, currentValue)) >= maxFactor) continue;
                maxFactor = factor;
                continue;
            }
            return 0;
        }
        if (maxFactor == Integer.MAX_VALUE) {
            maxFactor = 0;
        }
        return maxFactor;
    }

    private int findFactor(List values, boolean valueFlag) {
        double[] cfr_ignored_0 = new double[values.size()];
        int factor = 1;
        int maxFactor = Integer.MAX_VALUE;
        for (Coordinates datum : values) {
            double currentValue;
            double d = currentValue = valueFlag ? datum.getValue1() : datum.getValue2();
            if (Math.abs(currentValue) < 1.0) {
                if ((factor = this.findMaxFactor(factor, currentValue)) >= maxFactor) continue;
                maxFactor = factor;
                continue;
            }
            return 0;
        }
        if (maxFactor == Integer.MAX_VALUE) {
            maxFactor = 0;
        }
        return maxFactor;
    }

    private int findFactor(double[] value) {
        double[] cfr_ignored_0 = new double[value.length];
        int factor = 1;
        int maxFactor = Integer.MAX_VALUE;
        int x = 0;
        while (x < value.length) {
            if (Math.abs(value[x] * 10.0) < 1.0) {
                if ((factor = this.findMaxFactor(factor, value[x])) < maxFactor) {
                    maxFactor = factor;
                }
            } else {
                return 0;
            }
            ++x;
        }
        if (maxFactor == Integer.MAX_VALUE) {
            maxFactor = 0;
        }
        return maxFactor;
    }

    private void findMaxMinFromDataPoints(List dataPoints, List categoryList, double[] accumulatedHighValues, double[] accumulatedLowValues) {
        int lowFactor;
        for (CategoricalData datum : dataPoints) {
            double currentValue = datum.getValue();
            Category category = (Category)datum.getCategoryId();
            int categoryIndex = categoryList.indexOf(category);
            if (currentValue >= 0.0) {
                int n = categoryIndex;
                accumulatedHighValues[n] = accumulatedHighValues[n] + currentValue;
                continue;
            }
            int n = categoryIndex;
            accumulatedLowValues[n] = accumulatedLowValues[n] + currentValue;
        }
        int highFactor = this.findFactor(accumulatedHighValues);
        double factor = Math.pow(10.0, highFactor < (lowFactor = this.findFactor(accumulatedLowValues)) ? highFactor : lowFactor);
        double currentMax = this.dataMax;
        double currentMin = this.dataMin;
        int j = 0;
        while (j < categoryList.size()) {
            if (this.isLinear) {
                if (currentMax < accumulatedHighValues[j] * factor) {
                    currentMax = accumulatedHighValues[j] * factor;
                }
                if (currentMin > accumulatedLowValues[j] * factor) {
                    currentMin = accumulatedLowValues[j] * factor;
                }
            } else {
                if (currentMax < accumulatedHighValues[j] && accumulatedHighValues[j] > 0.0) {
                    currentMax = accumulatedHighValues[j];
                }
                if (currentMin > accumulatedHighValues[j] && accumulatedHighValues[j] > 0.0) {
                    currentMin = accumulatedHighValues[j];
                }
            }
            ++j;
        }
        if (this.isLinear) {
            this.dataMax = currentMax / factor;
            this.dataMin = currentMin / factor;
        } else {
            this.dataMax = currentMax;
            this.dataMin = currentMin;
        }
    }

    private void findMaxMinFromCoordinates(List coordinates, boolean value1) {
        double factor = Math.pow(10.0, this.findFactor(coordinates, value1));
        double currentMax = this.dataMax * factor;
        double currentMin = this.dataMin * factor;
        for (Coordinates datum : coordinates) {
            double currentValue = (value1 ? datum.getValue1() : datum.getValue2()) * factor;
            if (currentValue < currentMin) {
                currentMin = currentValue;
            }
            if (!(currentValue > currentMax)) continue;
            currentMax = currentValue;
        }
        this.dataMax = currentMax / factor;
        this.dataMin = currentMin / factor;
    }

    private double getOrderOfMagnitude(double dataMax, double dataMin) {
        if (Math.abs(dataMax) < 1.0 && Math.abs(dataMin) < 1.0) {
            double minFactor = this.findMaxFactor(1, dataMin);
            double maxFactor = this.findMaxFactor(1, dataMax);
            double factor = minFactor;
            factor = dataMax == 0.0 ? Math.pow(10.0, minFactor) : (dataMin == 0.0 ? Math.pow(10.0, maxFactor) : Math.pow(10.0, minFactor < maxFactor ? minFactor : maxFactor));
            return this.getOrderOfMagnitudeLargeNumber(dataMax * factor, dataMin * factor) / factor;
        }
        return this.getOrderOfMagnitudeLargeNumber(dataMax, dataMin);
    }

    private double getOrderOfMagnitudeLargeNumber(double dataMax, double dataMin) {
        double magnitude = 1.0;
        double range = dataMin >= 0.0 ? dataMax : (dataMax <= 0.0 ? Math.abs(dataMin) : dataMax - dataMin);
        while (range > 10.0) {
            range /= 10.0;
            magnitude *= 10.0;
        }
        return magnitude;
    }

    private double getOrderOfMagnitude(double num) {
        double magnitude = 1.0;
        double number = Math.abs(num);
        if (number >= 1.0) {
            while (number >= 10.0) {
                number /= 10.0;
                magnitude *= 10.0;
            }
        } else if (number != 0.0) {
            while (number < 1.0) {
                number *= 10.0;
                magnitude *= 10.0;
            }
            magnitude = 1.0 / magnitude;
        }
        return magnitude;
    }

    protected double getLabelWidth() {
        return this.maxLabelLength + 3.0;
    }

    protected double getLabelHeight() {
        return this.maxLabelHeight;
    }

    protected void getTickMarkValuesAndLabels() {
        block25: {
            double labelValue;
            int numOfMinorDivisions;
            int numOfLabels;
            FontHelper fontHelper;
            block26: {
                double labelValue2;
                block24: {
                    double labelValue3;
                    fontHelper = new FontHelper();
                    fontHelper.setFontSize(8.0f);
                    numOfLabels = (int)((this.max - this.min) / this.majorUnit + 1.0);
                    numOfMinorDivisions = this.isLinear ? (int)((this.max - this.min) / this.minorUnit + 1.0) : (int)(Math.ceil(this.max) - Math.floor(this.min)) * 8;
                    this.labels = new String[numOfLabels];
                    this.majorUnitValues = new double[numOfLabels];
                    this.minorUnitValues = new double[numOfMinorDivisions];
                    if (!(this.min <= 0.0) || !(this.max >= 0.0)) break block24;
                    int numOfNegLabels = (int)Math.floor(Math.abs(this.min) / this.majorUnit);
                    int i = 0;
                    while (i < numOfNegLabels) {
                        String labelText;
                        double labelValue4;
                        this.majorUnitValues[i] = labelValue4 = this.majorUnit * (double)(numOfNegLabels - i) * -1.0;
                        double labelValueForFormat = this.isLinear ? labelValue4 : Math.pow(10.0, labelValue4);
                        this.labels[i] = labelText = this.formatValue(labelValueForFormat);
                        Dimension2D labelLength = fontHelper.getStringBounds(labelText, this.labelDegrees);
                        if (labelLength.getWidth() > this.maxLabelLength) {
                            this.maxLabelLength = labelLength.getWidth();
                        }
                        if (labelLength.getHeight() > this.maxLabelHeight) {
                            this.maxLabelHeight = labelLength.getHeight();
                        }
                        ++i;
                    }
                    int numOfPositiveLabels = (int)(Math.floor(this.max / this.majorUnit) + 1.0);
                    int i2 = 0;
                    while (i2 < numOfPositiveLabels) {
                        String labelText;
                        this.majorUnitValues[numOfNegLabels + i2] = labelValue3 = (double)i2 * this.majorUnit;
                        double labelValueForFormat = this.isLinear ? labelValue3 : Math.pow(10.0, labelValue3);
                        this.labels[numOfNegLabels + i2] = labelText = this.formatValue(labelValueForFormat);
                        Dimension2D labelLength = fontHelper.getStringBounds(labelText, this.labelDegrees);
                        if (labelLength.getWidth() > this.maxLabelLength) {
                            this.maxLabelLength = labelLength.getWidth();
                        }
                        if (labelLength.getHeight() > this.maxLabelHeight) {
                            this.maxLabelHeight = labelLength.getHeight();
                        }
                        ++i2;
                    }
                    if (this.isLinear) {
                        numOfNegLabels = (int)Math.floor(Math.abs(this.min) / this.minorUnit);
                        i2 = 0;
                        while (i2 < numOfNegLabels) {
                            this.minorUnitValues[i2] = labelValue3 = this.minorUnit * (double)(numOfNegLabels - i2) * -1.0;
                            ++i2;
                        }
                        numOfPositiveLabels = (int)(Math.floor(this.max / this.minorUnit) + 1.0);
                        i2 = 0;
                        while (i2 < numOfPositiveLabels) {
                            this.minorUnitValues[numOfNegLabels + i2] = labelValue3 = (double)i2 * this.minorUnit;
                            ++i2;
                        }
                    } else {
                        int minorUnitIndex = 0;
                        double refValue = Math.floor(this.min);
                        int i3 = 0;
                        while (i3 < numOfMinorDivisions / 8) {
                            double refValueLinear = Math.pow(10.0, refValue);
                            double order = this.getOrderOfMagnitude(refValueLinear);
                            int j = 1;
                            while (j <= 8) {
                                this.minorUnitValues[minorUnitIndex++] = Math.log(refValueLinear + order * (double)j) / Math.log(10.0);
                                ++j;
                            }
                            ++i3;
                            refValue += 1.0;
                        }
                    }
                    break block25;
                }
                if (!(this.min >= 0.0)) break block26;
                int i = 0;
                while (i < numOfLabels) {
                    String labelText;
                    labelValue2 = this.isLinear ? this.min + (double)i * this.majorUnit : Math.ceil(this.min) + (double)i * this.majorUnit;
                    this.majorUnitValues[i] = labelValue2;
                    double labelValueForFormat = this.isLinear ? labelValue2 : Math.pow(10.0, labelValue2);
                    this.labels[i] = labelText = this.formatValue(labelValueForFormat);
                    Dimension2D labelLength = fontHelper.getStringBounds(labelText, this.labelDegrees);
                    if (labelLength.getWidth() > this.maxLabelLength) {
                        this.maxLabelLength = labelLength.getWidth();
                    }
                    if (labelLength.getHeight() > this.maxLabelHeight) {
                        this.maxLabelHeight = labelLength.getHeight();
                    }
                    ++i;
                }
                if (this.isLinear) {
                    i = 0;
                    while (i < this.minorUnitValues.length) {
                        this.minorUnitValues[i] = labelValue2 = this.min + (double)i * this.minorUnit;
                        ++i;
                    }
                } else {
                    int minorUnitIndex = 0;
                    double refValue = Math.floor(this.min);
                    int i4 = 0;
                    while (i4 < numOfMinorDivisions / 8) {
                        double refValueLinear = Math.pow(10.0, refValue);
                        double order = this.getOrderOfMagnitude(refValueLinear);
                        int j = 1;
                        while (j <= 8) {
                            this.minorUnitValues[minorUnitIndex++] = Math.log(refValueLinear + order * (double)j) / Math.log(10.0);
                            ++j;
                        }
                        ++i4;
                        refValue += 1.0;
                    }
                }
                break block25;
            }
            if (!(this.max <= 0.0)) break block25;
            int i = 1;
            while (i <= numOfLabels) {
                String labelText;
                this.majorUnitValues[i - 1] = labelValue = this.max - this.majorUnit * (double)(numOfLabels - i);
                double labelValueForFormat = this.isLinear ? labelValue : Math.pow(10.0, labelValue);
                this.labels[i - 1] = labelText = this.formatValue(labelValueForFormat);
                Dimension2D labelLength = fontHelper.getStringBounds(labelText, this.labelDegrees);
                if (labelLength.getWidth() > this.maxLabelLength) {
                    this.maxLabelLength = labelLength.getWidth();
                }
                if (labelLength.getHeight() > this.maxLabelHeight) {
                    this.maxLabelHeight = labelLength.getHeight();
                }
                ++i;
            }
            i = 1;
            while (i <= this.minorUnitValues.length) {
                this.minorUnitValues[i - 1] = labelValue = this.max - this.minorUnit * (double)(numOfMinorDivisions - i);
                ++i;
            }
        }
    }

    private void initDataFormatter() {
        if (this.axisDef != null) {
            CustomFormat customFormat = this.axisDef.getCustomFormat();
            if (customFormat != null) {
                try {
                    this.customPattern = customFormat.getPattern();
                    Class<?> customFormatterClass = Class.forName(customFormat.getFormatClass());
                    customFormatterClass.getConstructor(new Class[0]);
                    this.customFormatter = (ICustomFormatter)customFormatterClass.newInstance();
                }
                catch (SecurityException securityException) {
                    this.customFormatter = null;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.customFormatter = null;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.customFormatter = null;
                }
                catch (InstantiationException instantiationException) {
                    this.customFormatter = null;
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.customFormatter = null;
                }
            } else {
                org.eclipse.tptp.platform.report.chart.svg.internal.input.NumberFormat numFormat = this.axisDef.getNumberFormat();
                if (numFormat == null && this.dataValueDef != null) {
                    numFormat = this.dataValueDef.getNumberFormat();
                }
                if (numFormat != null) {
                    this.numberFormatter = this.locale != null ? NumberFormat.getInstance((ULocale)this.locale) : NumberFormat.getInstance();
                    if (this.numberFormatter instanceof DecimalFormat) {
                        ((DecimalFormat)this.numberFormatter).applyPattern(numFormat.getPattern());
                    }
                } else if (this.axisDef.getDateFormat() != null) {
                    DateFormat dateFormat = this.axisDef.getDateFormat();
                    try {
                        this.dateFormatter = this.locale != null ? new SimpleDateFormat(dateFormat.getPattern(), this.locale) : new SimpleDateFormat(dateFormat.getPattern());
                    }
                    catch (NullPointerException nullPointerException) {
                        this.dateFormatter = null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.dateFormatter = null;
                    }
                }
            }
        }
    }

    public String formatValue(double value) {
        String labelText;
        if (this.customFormatter != null) {
            if (this.locale == null) {
                this.locale = ULocale.ENGLISH;
            }
            labelText = this.customFormatter.format(new Double(value), this.locale, this.timezone, this.customPattern);
        } else {
            labelText = this.numberFormatter != null ? this.numberFormatter.format(value) : (this.dateFormatter != null ? this.dateFormatter.format(new Date((long)value)) : Double.toString(value));
        }
        return labelText;
    }

    public double[] getMajorUnitValues() {
        return this.majorUnitValues;
    }

    public double[] getMinorUnitValues() {
        return this.minorUnitValues;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public boolean isLinear() {
        return this.isLinear;
    }

    public int getMarginForMax() {
        String formattedMax = this.formatValue(this.max);
        FontHelper fontHelper = new FontHelper();
        fontHelper.setFontSize(8.0f);
        this.marginForMax = (int)(fontHelper.getStringWidth(formattedMax, this.labelDegrees) / 2.0 - 5.0);
        return this.marginForMax;
    }

    public void setLabelDegrees(double labelDegrees) {
        if (this.getAxisOrientation() == 1) {
            labelDegrees = -(labelDegrees - 90.0);
        }
        super.setLabelDegrees(labelDegrees);
    }
}

