/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import com.ibm.icu.util.ULocale;
import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGRectangle;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGScript;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGStyle;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Configuration;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSets;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Ecmascript;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Internationalization;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Palettes;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Preferences;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Scripts;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Shapes;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Size;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.TitleBar;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.DefaultResources;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.EventTools;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.GraphArea;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.IGraphicDocumentStyle;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.IGraphicTypeConstants;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.Legend;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.Part;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGColorPalettes;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGShapes;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.Timestamp;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.Title;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.TooltipPlaceholder;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;

public class ChartArea
extends Part
implements IGraphicTypeConstants,
IGraphicDocumentStyle {
    static final long serialVersionUID = 2696039115291774673L;
    private SVGColorPalettes palettes;
    private SVGShapes shapes;
    private boolean useShapes;
    private String bkgroundColor;
    private boolean drawBorder = true;
    private String legendLocation = "TRAILING";
    private boolean isLTR = true;
    private org.eclipse.tptp.platform.report.chart.svg.internal.input.ChartArea chartarea = null;
    private DefaultResources resources;
    private SVGPartInfo titleInfo;
    private SVGPartInfo legendInfo;
    private SVGPartInfo graphAreaInfo;
    private SVGPartInfo timestampInfo;
    private int numOfDataSets = 0;
    private NLString nls;
    private ULocale locale;
    private double east = this.width;
    private double west = 0.0;
    private double north = 0.0;
    private double south = this.height;

    public ChartArea(Chart input, DefaultResources resources) {
        super(input);
        DataSets datasets;
        this.resources = resources;
        Configuration config = input.getConfiguration();
        if (config != null) {
            Internationalization i18n = config.getInternationalization();
            String textDirection = null;
            if (i18n != null && (textDirection = i18n.getTextDirection()) != null) {
                this.isLTR = textDirection.equals("LTR") ? true : !textDirection.equals("RTL");
            }
        }
        this.titleInfo = new SVGPartInfo();
        this.legendInfo = new SVGPartInfo();
        this.graphAreaInfo = new SVGPartInfo();
        this.timestampInfo = new SVGPartInfo();
        this.determinePartDimensions(this.titleInfo, this.legendInfo, this.graphAreaInfo, this.timestampInfo);
        Data data = input.getData();
        if (data != null && (datasets = data.getDataSets()) != null) {
            this.numOfDataSets = datasets.getDataSet().size();
        }
        this.initShapes(input.getType(), config);
        if (config != null) {
            this.chartarea = config.getChartArea();
            if (this.chartarea != null) {
                this.bkgroundColor = this.chartarea.getBackgroundColor();
                if (this.chartarea.isSetBorder()) {
                    this.drawBorder = this.chartarea.isBorder();
                }
            }
        }
        if (config != null) {
            Internationalization i18n = config.getInternationalization();
            if (i18n != null) {
                String country;
                String resourceBundle = i18n.getResourceBundle();
                String language = i18n.getLanguage() == null ? "" : i18n.getLanguage();
                String string = country = i18n.getCountry() == null ? "" : i18n.getCountry();
                this.locale = language != "" && country != "" ? new ULocale(language, country) : (!language.equals("") ? new ULocale(language) : ULocale.getDefault());
                this.nls = resourceBundle != null ? new NLString(resourceBundle, this.locale) : new NLString();
            } else {
                this.locale = ULocale.getDefault();
                this.nls = new NLString();
            }
        } else {
            this.locale = ULocale.getDefault();
            this.nls = new NLString();
        }
        this.initColorPalettes(config, this.locale);
    }

    private void initColorPalettes(Configuration config, ULocale locale) {
        Palettes palettesConfig;
        this.palettes = new SVGColorPalettes(this.resources, locale);
        if (config != null && (palettesConfig = config.getPalettes()) != null) {
            String palettesLocation = palettesConfig.getLocation();
            String paletteId = palettesConfig.getPaletteId();
            String paletteSetId = palettesConfig.getPaletteSetId();
            if (palettesLocation != null || paletteId != null || paletteSetId != null) {
                this.palettes.setCustomPalettes(palettesLocation, paletteId, paletteSetId);
            }
            List colorList = palettesConfig.getDataSetColor();
            this.palettes.setDataSetColors(colorList);
        }
    }

    private void initShapes(String chartType, Configuration config) {
        if (chartType.equals("line") || chartType.equals("area") || chartType.equals("stackedArea") || chartType.equals("scatter")) {
            Shapes shapesConfig;
            this.useShapes = true;
            this.shapes = new SVGShapes(this.resources);
            if (config != null && (shapesConfig = config.getShapes()) != null) {
                String shapesLocation = shapesConfig.getLocation();
                if (shapesLocation != null) {
                    this.shapes.setCustomShapes(shapesLocation);
                }
                List shapeList = shapesConfig.getShape();
                this.shapes.setDataSetShapes(shapeList);
            }
        }
    }

    protected void determinePartDimensions(SVGPartInfo titleInfo, SVGPartInfo legendInfo, SVGPartInfo graphAreaInfo, SVGPartInfo timestampInfo) {
        legendInfo.show = true;
        titleInfo.show = true;
        timestampInfo.show = true;
        graphAreaInfo.show = true;
        this.width = this.input.getType().equals("meter") ? 325.0 : 450.0;
        this.height = 320.0;
        Configuration config = this.input.getConfiguration();
        if (config != null) {
            org.eclipse.tptp.platform.report.chart.svg.internal.input.Legend legend;
            Size size = config.getSize();
            if (size != null) {
                if (size.isSetWidth() && size.getWidth() > 0.0) {
                    this.width = size.getWidth();
                }
                if (size.isSetHeight() && size.getHeight() > 0.0) {
                    this.height = size.getHeight();
                }
            }
            if ((legend = config.getLegend()) != null) {
                if (legend.isSetShow() && !legend.isShow()) {
                    legendInfo.show = false;
                } else if (legend.getLocation() != null) {
                    this.legendLocation = legend.getLocation();
                }
                if (legend.isSetWidth() && legend.getWidth() > 0.0 && legend.getWidth() < this.width) {
                    legend.getWidth();
                }
                if (legend.isSetHeight() && legend.getHeight() > 0.0 && legend.getHeight() < this.height) {
                    legend.getHeight();
                }
            }
            TitleBar titleBar = config.getTitleBar();
            Preferences pref = config.getPreferences();
            boolean showTitle = true;
            boolean showPref = false;
            if (titleBar != null && titleBar.isSetShow() && !titleBar.isShow()) {
                showTitle = false;
            }
            if (pref != null && pref.isSetShow() && pref.isShow()) {
                showPref = true;
            }
            titleInfo.show = showTitle || showPref;
            if (this.input.getData() != null && this.input.getData().getTimestamp() != null) {
                if (config.getTimestamp() != null && config.getTimestamp().isSetShow() && !config.getTimestamp().isShow()) {
                    timestampInfo.show = false;
                }
            } else {
                timestampInfo.show = false;
            }
        }
        if (this.input.getType().equals("meter")) {
            legendInfo.show = false;
        }
        this.north = 0.0;
        this.south = this.height;
        this.east = this.width;
        this.west = 0.0;
        if (titleInfo.show) {
            titleInfo.width = this.width;
            titleInfo.height = 36.0;
            titleInfo.x = 0.0;
            titleInfo.y = 0.0;
            this.north = titleInfo.height;
        }
        if (timestampInfo.show) {
            timestampInfo.width = this.width;
            timestampInfo.height = 20.0;
            timestampInfo.x = 0.0;
            this.south = timestampInfo.y = this.height - timestampInfo.height;
        }
    }

    protected void constructPart() {
        Scripts scripts;
        this.setWidth(Double.toString(this.width));
        this.setHeight(Double.toString(this.height));
        if (this.input.getId() != null) {
            this.setIdentifier(this.input.getId());
        }
        int numUserScripts = 0;
        if (this.input.getConfiguration() != null && (scripts = this.input.getConfiguration().getScripts()) != null) {
            numUserScripts = scripts.getEcmascript().size();
        }
        SVGBase[] parts = new SVGBase[8 + numUserScripts];
        SVGGroup group = new SVGGroup();
        group.setChildren(parts);
        SVGBase[] groupChild = new SVGBase[]{group};
        if (this.chartarea != null) {
            EventTools.generateUserEvents(group, this.chartarea.getEventHandler());
            EventTools.generateAccessibility(group, this.chartarea.getAccessibility(), this.nls);
        }
        this.setChildren(groupChild);
        SVGScript scriptEmitter = new SVGScript();
        EventTools.generateDefaultScripts(this.input, scriptEmitter, this.palettes, this.legendInfo.show, this.locale);
        parts[0] = scriptEmitter;
        if (numUserScripts > 0) {
            List ecmaScriptList = this.input.getConfiguration().getScripts().getEcmascript();
            int i = 0;
            while (i < numUserScripts) {
                String scriptName = ((Ecmascript)ecmaScriptList.get(i)).getHref();
                if (scriptName != null) {
                    SVGScript scriptEmitter2 = new SVGScript();
                    scriptEmitter2.setUserScript(scriptName);
                    parts[i + 1] = scriptEmitter2;
                }
                ++i;
            }
        }
        SVGStyle style = new SVGStyle();
        style.setId("defaultStyleRules");
        StringBuffer styleRules = new StringBuffer(" .graphTitle {font-weight:bold; font-style:normal; font-size:11pt; fill:#000000; stroke-width:0.75pt;} .graphTimeStamp {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000; fill-opacity:0.6} .legendTitle {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000; text-anchor:start; fill-opacity:0.6} .legendData {font-weight:normal; font-style:normal; font-size:8pt; text-anchor:start; fill:#000000;} .tooltip {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000;}.anchorAtEnd {text-anchor: end;} .anchorAtStart {text-anchor: start;} .anchorAtMiddle {text-anchor: middle;}");
        if (this.input.getType().equals("meter")) {
            styleRules.append(" .minmaxRate {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000;} .rateDef {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000;fill-opacity:0.5} .critDiv {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000; fill-opacity:0.5} .graphOutline{fill:none;} .ticks{fill:none;stroke:#999999;stroke-width:0.75;}  .speedometerBg{fill:#FFFFFF;} .innerRim{fill:#999999;} .outerRim{fill:#006666;} .needle{stroke:#000000;stroke-width:3;stroke-linecap:round;} .outerCircle{fill:#000000;stroke:none;} .innerCircle{fill:#FFFFFF;stroke:none;} .center{fill-rule:nonzero;clip-rule:nonzero;stroke:#000000;stroke-miterlimit:4;} .safeRange{fill:#CCCCCC;stroke:#999999;stroke-width:0.75} .semiCritical{fill:#FFFF99;stroke:none;} .critical{fill:#FF0000;stroke:none;} .actualRate{fill:#CCCCCC;stroke:#999999;} ");
        } else if (this.input.getType().equals("pie") || this.input.getType().equals("pie3D")) {
            styleRules.append(" .pievalues{stroke:none; font-weight:normal; font-style:normal; font-size:8pt; fill:#000000; text-anchor: middle;}.axisTicks{stroke-width:1pt;stroke:#000000} .wedgeTick{fill:none;} .wedgeOutline{fill:none;} .wedgeColor{fill:#CCCCCC;stroke:none;}");
        } else {
            styleRules.append(" .grid{stroke-width:0.75pt; stroke:#000000;} .gridline{stroke-width:0.75pt; stroke:#cccccc;} .griddashline{stroke-width:0.75pt; stroke:#cccccc; stroke-dasharray:2, 2; fill:none;} .axisLines{stroke-width:1pt;stroke:#000000} .zero3DAxisLines{stroke-width:0pt;stroke:#808080;fill:#808080} .axis3DLimitLines{stroke-width:1pt;stroke:#cccccc;fill:#cccccc} .axis3DLines{stroke-width:1pt;stroke:#000000;fill:#000000} .axisTicks{stroke-width:1pt;stroke:#000000} .linestyle{stroke-linecap:round; stroke-width:0.75;} .linestyle3D{stroke-linecap:round; stroke-width:0;} .axisTitles{font-weight:normal; font-style:normal; font-size:9pt; fill:#000000;} .axisLabels{font-weight:normal; font-style:normal; font-size:8pt; fill:#000000;} ");
        }
        String[] palette = this.palettes.getPalette();
        int i = 0;
        while (i < this.numOfDataSets) {
            int paletteIndex = i % palette.length;
            if (this.input.getType().equals("pie") || this.input.getType().equals("pie3D")) {
                styleRules.append(" .dataset" + i + "{stroke:black; fill:" + palette[paletteIndex] + ";}");
                styleRules.append(" .shape" + i + "{stroke:none; fill:" + palette[paletteIndex] + ";}");
            }
            if (this.input.getType().equals("verticalBar") || this.input.getType().equals("verticalStackedBar") || this.input.getType().equals("horizontalBar") || this.input.getType().equals("verticalStackedBar3D") || this.input.getType().equals("horizontalBar3D") || this.input.getType().equals("horizontalStackedBar3D") || this.input.getType().equals("verticalBar3D") || this.input.getType().equals("horizontalStackedBar")) {
                styleRules.append(" .dataset" + i + "{stroke-width:0.75pt; stroke:" + palette[paletteIndex] + ";}");
                styleRules.append(" .shape" + i + "{stroke:none; fill:" + palette[paletteIndex] + ";}");
                styleRules.append(" .bars" + i + "{stroke:" + palette[paletteIndex] + "; fill:" + palette[paletteIndex] + ";}");
            }
            styleRules.append(" .strokecolor" + i + "{stroke:" + palette[paletteIndex] + ";}");
            styleRules.append(" .fillcolor" + i + "{fill:" + palette[paletteIndex] + ";}");
            ++i;
        }
        style.setType("text/css");
        style.setCdata(styleRules.toString());
        this.addDefinition(style);
        if (this.useShapes) {
            this.addDefinition(this.shapes.getShapeDefinition(this.numOfDataSets));
        }
        if (this.titleInfo.show) {
            Title titlePart = new Title(this.input, this.isLTR, this.titleInfo.x, this.titleInfo.y, this.titleInfo.width, this.titleInfo.height, this.nls);
            parts[4 + numUserScripts] = titlePart;
        }
        if (this.legendInfo.show) {
            int margin = 10;
            if (this.input.getConfiguration() != null && this.input.getConfiguration().getLegend() != null) {
                margin = this.input.getConfiguration().getLegend().getMargin();
            }
            Legend legendPart = Legend.getInstance(this.legendLocation, this.isLTR, this.input, this.legendInfo.x, this.legendInfo.y, this.legendInfo.width, this.legendInfo.height, this.east - this.west, this.south - this.north, margin, this.palettes, this.shapes, this.nls);
            parts[5 + numUserScripts] = legendPart;
            double legendHeight = legendPart.getLegendHeight();
            if (this.legendLocation.equals("LEADING")) {
                this.legendLocation = this.isLTR ? "W" : "E";
            } else if (this.legendLocation.equals("TRAILING")) {
                String string = this.legendLocation = this.isLTR ? "E" : "W";
            }
            if (this.legendLocation.equals("E")) {
                this.legendInfo.height = this.south - this.north;
                this.legendInfo.x = this.width - legendPart.getLegendWidth();
                this.legendInfo.y = this.north;
                this.east = this.legendInfo.x;
            } else if (this.legendLocation.equals("W")) {
                this.legendInfo.height = this.south - this.north;
                this.legendInfo.x = 0.0;
                this.legendInfo.y = this.north;
                this.west = legendPart.getLegendWidth();
            } else if (this.legendLocation.equals("N")) {
                this.legendInfo.width = this.width;
                this.legendInfo.x = 0.0;
                this.legendInfo.y = this.north;
                this.north += legendHeight;
            } else {
                this.legendInfo.width = this.width;
                this.legendInfo.x = 0.0;
                this.south = this.legendInfo.y = this.south - legendHeight;
            }
            legendPart.setXCoordinate(Double.toString(this.legendInfo.x));
            legendPart.setYCoordinate(Double.toString(this.legendInfo.y));
            if (this.legendLocation.equals("N") || this.legendLocation.equals("S")) {
                legendPart.setWidth(Double.toString(this.legendInfo.width));
            } else {
                legendPart.setHeight(Double.toString(this.legendInfo.height));
            }
        }
        this.graphAreaInfo.width = this.east - this.west;
        this.graphAreaInfo.height = this.south - this.north;
        this.graphAreaInfo.x = this.west;
        this.graphAreaInfo.y = this.north;
        GraphArea graphArea = GraphArea.getInstance(this.input, this.isLTR, this.graphAreaInfo.x, this.graphAreaInfo.y, this.graphAreaInfo.width, this.graphAreaInfo.height, this.palettes, this.shapes);
        graphArea.setNLString(this.nls);
        parts[3 + numUserScripts] = graphArea;
        if (this.timestampInfo.show) {
            Timestamp timestampPart = new Timestamp(this.input, this.isLTR, this.timestampInfo.x, this.timestampInfo.y, this.timestampInfo.width, this.timestampInfo.height, this.nls);
            parts[6 + numUserScripts] = timestampPart;
        }
        if (this.bkgroundColor != null && !this.bkgroundColor.equals("")) {
            SVGRectangle bkground = new SVGRectangle();
            bkground.setXCoordinate("0");
            bkground.setYCoordinate("0");
            bkground.setWidth(this.getWidth());
            bkground.setHeight(this.getHeight());
            bkground.setFill(this.bkgroundColor);
            parts[1 + numUserScripts] = bkground;
        }
        if (this.drawBorder) {
            SVGRectangle border = new SVGRectangle();
            border.setXCoordinate("0");
            border.setYCoordinate("0");
            border.setWidth(Double.toString(this.width - 1.0));
            border.setHeight(Double.toString(this.height - 1.0));
            border.setFill("none");
            border.setStroke("#666666");
            parts[2 + numUserScripts] = border;
        }
        TooltipPlaceholder tooltipSvg = new TooltipPlaceholder(this.input, 0.0, 0.0, this.width, this.height);
        parts[7 + numUserScripts] = tooltipSvg;
    }

    private class SVGPartInfo {
        public boolean show = false;
        public double x = 0.0;
        public double y = 0.0;
        public double width = 0.0;
        public double height = 0.0;

        private SVGPartInfo() {
        }

        public String toString() {
            return "x: " + this.x + " y: " + this.y + " width: " + this.width + " height: " + this.height;
        }
    }
}

