/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGFeComponentTransfer;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGFeFunc;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGFilter;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.CategoricalData;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisCategory;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisNumber;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.DataSetBar;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.EventTools;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.Line3D;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGColorPalettes;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;

public class DataSetBar3D
extends DataSetBar {
    static final long serialVersionUID = -4921885635575271217L;
    protected double y3Doffset;
    protected double x3Doffset;

    public DataSetBar3D(Chart input, boolean isLTR, AxisCategory indepAxis, AxisNumber depAxis, DataSet dataset, int datasetIndex, int colorIndex, double barWidth, double barPosition, double groupInterval, double x3Doffset, double y3Doffset, SVGColorPalettes palettes, NLString nls) {
        super(input, isLTR, indepAxis, depAxis, dataset, datasetIndex, colorIndex, barWidth, barPosition, groupInterval, palettes, nls);
        this.y3Doffset = y3Doffset;
        this.x3Doffset = x3Doffset;
    }

    protected void constructPart() {
        double value;
        Utilities.assertion(this.dataset != null);
        Utilities.assertion(this.dataset.getDataPoint() != null);
        SVGBase[] barpart = new SVGBase[1];
        this.setChildren(barpart);
        SVGGroup barset = new SVGGroup();
        int partNum = this.sortedDatapoints.length + 2;
        SVGBase[] barparts = new SVGBase[partNum];
        SVGGroup dataColourGroup = new SVGGroup();
        SVGBase[] dataColourGroupChild = new SVGBase[]{dataColourGroup};
        dataColourGroup.setChildren(barparts);
        dataColourGroup.setIdentifier("SVGGEN_dataColour" + this.datasetIndex);
        String dataSetColor = this.palettes.getDataSetColor(this.dataset.getId());
        if (dataSetColor != null) {
            dataColourGroup.setFill(dataSetColor);
            dataColourGroup.setStroke(dataSetColor);
        }
        barpart[0] = barset;
        barset.setChildren(dataColourGroupChild);
        barset.setIdentifier(this.dataset.getId());
        barset.setStyleClass("bars" + this.colorIndex);
        SVGFilter filter = new SVGFilter();
        filter.setIdentifier("right-dimension");
        SVGFeComponentTransfer feComponentTransfer = new SVGFeComponentTransfer();
        SVGBase[] feComponentTransferPart = new SVGFeComponentTransfer[]{feComponentTransfer};
        filter.setChildren(feComponentTransferPart);
        SVGBase[] feFuncPart = new SVGFeFunc[3];
        SVGFeFunc feFunc = new SVGFeFunc("R");
        feFunc.setSlope("1");
        feFunc.setIntercept("-0.1");
        feFunc.setType("linear");
        feFuncPart[0] = feFunc;
        feFunc = new SVGFeFunc("G");
        feFunc.setSlope("1");
        feFunc.setIntercept("-0.1");
        feFunc.setType("linear");
        feFuncPart[1] = feFunc;
        feFunc = new SVGFeFunc("B");
        feFunc.setSlope("1");
        feFunc.setIntercept("-0.1");
        feFunc.setType("linear");
        feFuncPart[2] = feFunc;
        feComponentTransfer.setChildren(feFuncPart);
        this.addDefinition(filter);
        filter = new SVGFilter();
        filter.setIdentifier("top-dimension");
        feComponentTransferPart = new SVGFeComponentTransfer[1];
        feComponentTransfer = new SVGFeComponentTransfer();
        feComponentTransferPart[0] = feComponentTransfer;
        filter.setChildren(feComponentTransferPart);
        feFuncPart = new SVGFeFunc[3];
        feFunc = new SVGFeFunc("R");
        feFunc.setSlope("1");
        feFunc.setIntercept("0.1");
        feFunc.setType("linear");
        feFuncPart[0] = feFunc;
        feFunc = new SVGFeFunc("G");
        feFunc.setSlope("1");
        feFunc.setIntercept("0.1");
        feFunc.setType("linear");
        feFuncPart[1] = feFunc;
        feFunc = new SVGFeFunc("B");
        feFunc.setSlope("1");
        feFunc.setIntercept("0.1");
        feFunc.setType("linear");
        feFuncPart[2] = feFunc;
        feComponentTransfer.setChildren(feFuncPart);
        this.addDefinition(filter);
        double min = Math.pow(10.0, this.depAxisMin);
        double d = value = this.linear ? 0.0 : min;
        if (this.indepAxis.getAxisOrientation() == 0) {
            double zero = this.getCoordinate(this.linear, value, 0.0, Double.parseDouble(this.getHeight()) - Math.abs(this.y3Doffset), this.depAxisMax, this.depAxisMin);
            int i = 0;
            while (i < this.categoryList.size()) {
                CategoricalData dp = this.isLTR ? this.sortedDatapoints[i] : this.sortedDatapoints[this.categoryList.size() - i - 1];
                if (!(dp == null || !this.linear && dp.getValue() <= 0.0 || !this.linear && dp.getValue() < min || this.linear && dp.getValue() < this.depAxisMin)) {
                    SVGGroup pointGroup = new SVGGroup();
                    pointGroup.setIdentifier(dp.getId());
                    SVGBase[] point = new SVGBase[3];
                    pointGroup.setChildren(point);
                    SVGGroup pointGroupWrapper = new SVGGroup();
                    SVGBase[] pointWrapper = new SVGBase[2];
                    pointWrapper[1] = pointGroup;
                    pointGroupWrapper.setChildren(pointWrapper);
                    pointGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");
                    point[2] = EventTools.generateValueTooltip(pointGroup, this.depAxis.formatValue(dp.getValue()));
                    point[1] = EventTools.generateUserTooltip(pointGroup, dp.getTooltip(), this.nls);
                    EventTools.generateUserEvents(pointGroup, dp.getEventHandler());
                    EventTools.generateAccessibility(pointGroup, dp.getAccessibility(), this.nls);
                    double curX = this.barPosition + (double)i * this.groupInterval;
                    double curY = this.getCoordinate(this.linear, dp.getValue(), 0.0, Double.parseDouble(this.getHeight()) - Math.abs(this.y3Doffset), this.depAxisMax, this.depAxisMin);
                    barparts[i + 1] = pointGroupWrapper;
                    if (i >= 0) {
                        SVGText barTextSegment = new SVGText();
                        String tooltipID = "SVGGEN_datavalue_" + this.dataset.getId() + "_" + EventTools.getUniqueID();
                        barTextSegment.setText(this.depAxis.formatValue(dp.getValue()));
                        barTextSegment.setStyle("font-size:8pt;stroke:none;fill:black");
                        barTextSegment.setStyleClass("anchorAtMiddle");
                        barTextSegment.setVisibility("hidden");
                        barTextSegment.setXCoordinate(Double.toString(curX));
                        if (dp.getValue() < 0.0) {
                            barTextSegment.setYCoordinate(Double.toString(curY + 8.0 + this.y3Doffset + 2.0));
                        } else {
                            barTextSegment.setYCoordinate(Double.toString(curY - 2.0));
                        }
                        barTextSegment.setIdentifier(tooltipID);
                        SVGGroup barGroup = new SVGGroup();
                        barGroup.setIdentifier("SVGGEN_bar_" + this.dataset.getId());
                        Line3D barSegment = new Line3D();
                        barSegment.setIsNeg(dp.getValue() < 0.0);
                        barSegment.setIsLTR(this.isLTR);
                        barSegment.setPlotHieght(Double.parseDouble(this.getHeight()));
                        barSegment.setPlotWidth(Double.parseDouble(this.getWidth()));
                        barSegment.setIsHorizontal(true);
                        barSegment.setStyleClass("linestyle3D strokecolor" + this.colorIndex);
                        barSegment.setLinear(this.linear);
                        barSegment.setYMax(Double.parseDouble(this.getHeight()));
                        barSegment.setYMin(0.0);
                        barSegment.setZeroYCoord(zero);
                        barSegment.setY3Doffset(this.y3Doffset);
                        barSegment.setX3Doffset(this.x3Doffset);
                        barSegment.setX1(Double.toString(curX));
                        barSegment.setY1(Double.toString(zero));
                        barSegment.setX2(Double.toString(curX));
                        barSegment.setY2(Double.toString(curY));
                        barSegment.setStrokeWidth(Double.toString(this.barWidth));
                        barSegment.setTopDimensionFilter("url(#top-dimension)");
                        barSegment.setRightDimensionFilter("url(#right-dimension)");
                        point[0] = barSegment;
                        pointWrapper[0] = barGroup;
                        SVGBase[] groupChild = new SVGBase[1];
                        barGroup.setChildren(groupChild);
                        groupChild[0] = barTextSegment;
                    }
                }
                ++i;
            }
        } else {
            double zero = this.isLTR ? this.getCoordinate(this.linear, value, Double.parseDouble(this.getWidth()) - Math.abs(this.x3Doffset), 0.0, this.depAxisMax, this.depAxisMin) : this.getCoordinate(this.linear, value, 0.0, Double.parseDouble(this.getWidth()) - Math.abs(this.x3Doffset), this.depAxisMax, this.depAxisMin);
            int i = 0;
            while (i < this.categoryList.size()) {
                CategoricalData dp = this.sortedDatapoints[i];
                if (!(dp == null || !this.linear && dp.getValue() <= 0.0 || !this.linear && dp.getValue() < min || this.linear && dp.getValue() < this.depAxisMin)) {
                    SVGGroup pointGroup = new SVGGroup();
                    pointGroup.setIdentifier(dp.getId());
                    SVGBase[] point = new SVGBase[3];
                    pointGroup.setChildren(point);
                    SVGGroup pointGroupWrapper = new SVGGroup();
                    SVGBase[] pointWrapper = new SVGBase[2];
                    pointWrapper[1] = pointGroup;
                    pointGroupWrapper.setChildren(pointWrapper);
                    pointGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");
                    point[2] = EventTools.generateValueTooltip(pointGroup, this.depAxis.formatValue(dp.getValue()));
                    point[1] = EventTools.generateUserTooltip(pointGroup, dp.getTooltip(), this.nls);
                    EventTools.generateUserEvents(pointGroup, dp.getEventHandler());
                    EventTools.generateAccessibility(pointGroup, dp.getAccessibility(), this.nls);
                    double curY = this.indepAxis.getAxisLength() - (this.barPosition + (double)i * this.groupInterval);
                    double curX = this.isLTR ? this.getCoordinate(this.linear, dp.getValue(), this.depAxis.getAxisLength(), 0.0, this.depAxisMax, this.depAxisMin) : this.getCoordinate(this.linear, dp.getValue(), 0.0, this.depAxis.getAxisLength(), this.depAxisMax, this.depAxisMin);
                    barparts[i + 1] = pointGroupWrapper;
                    if (i >= 0) {
                        SVGText barTextSegment = new SVGText();
                        String tooltipID = "SVGGEN_datavalue_" + this.dataset.getId() + "_" + EventTools.getUniqueID();
                        barTextSegment.setText(this.depAxis.formatValue(dp.getValue()));
                        barTextSegment.setStyle("font-size:8pt;stroke:none;fill:black");
                        barTextSegment.setStyleClass("anchorAtStart");
                        barTextSegment.setVisibility("hidden");
                        if (this.isLTR) {
                            if (dp.getValue() < 0.0) {
                                barTextSegment.setXCoordinate(Double.toString(curX - 2.0));
                                barTextSegment.setStyleClass("anchorAtEnd");
                            } else {
                                barTextSegment.setXCoordinate(Double.toString(curX + 2.0 + this.x3Doffset));
                                barTextSegment.setStyleClass("anchorAtStart");
                            }
                        } else if (dp.getValue() < 0.0) {
                            barTextSegment.setXCoordinate(Double.toString(curX + 2.0 + this.x3Doffset));
                            barTextSegment.setStyleClass("anchorAtStart");
                        } else {
                            barTextSegment.setXCoordinate(Double.toString(curX - 2.0));
                            barTextSegment.setStyleClass("anchorAtEnd");
                        }
                        barTextSegment.setYCoordinate(Double.toString(curY + 4.0 + this.y3Doffset));
                        barTextSegment.setIdentifier(tooltipID);
                        SVGGroup barGroup = new SVGGroup();
                        barGroup.setIdentifier("SVGGEN_bar_" + this.dataset.getId());
                        Line3D barSegment = new Line3D();
                        barSegment.setIsNeg(dp.getValue() < 0.0);
                        barSegment.setPlotHieght(Double.parseDouble(this.getHeight()));
                        barSegment.setPlotWidth(Double.parseDouble(this.getWidth()));
                        barSegment.setStyleClass("linestyle3D strokecolor" + this.colorIndex);
                        barSegment.setIsLTR(this.isLTR);
                        barSegment.setLinear(this.linear);
                        barSegment.setXMax(this.depAxis.getAxisLength());
                        barSegment.setIsHorizontal(false);
                        barSegment.setXMin(0.0);
                        barSegment.setZeroXCoord(zero);
                        barSegment.setY3Doffset(this.y3Doffset);
                        barSegment.setX3Doffset(this.x3Doffset);
                        barSegment.setX1(Double.toString(zero));
                        barSegment.setY1(Double.toString(curY));
                        barSegment.setX2(Double.toString(curX));
                        barSegment.setY2(Double.toString(curY));
                        barSegment.setStrokeWidth(Double.toString(this.barWidth));
                        barSegment.setTopDimensionFilter("url(#top-dimension)");
                        barSegment.setRightDimensionFilter("url(#right-dimension)");
                        point[0] = barSegment;
                        pointWrapper[0] = barGroup;
                        SVGBase[] groupChild = new SVGBase[1];
                        barGroup.setChildren(groupChild);
                        groupChild[0] = barTextSegment;
                    }
                }
                ++i;
            }
        }
    }
}

