/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGFeGaussianBlur;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGFilter;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolygon;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolyline;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGUse;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.CategoricalData;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.Axis;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisNumber;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.DataSetLine;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.EventTools;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGColorPalettes;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;

public class DataSetLineCategory
extends DataSetLine {
    static final long serialVersionUID = -4290054359843253354L;

    public DataSetLineCategory(Chart input, boolean isLTR, Axis indepAxis, AxisNumber depAxis, DataSet dataset, int datasetIndex, int colorIndex, SVGColorPalettes palettes, String shapeId, double shapeWidth, double shapeHeight, NLString nls) {
        super(input, isLTR, indepAxis, depAxis, dataset, datasetIndex, colorIndex, palettes, shapeId, shapeWidth, shapeHeight, nls);
        this.showArea = input.getType().equals("area");
        this.showShapes = true;
        if (input.getConfiguration() != null && input.getConfiguration().getShapes() != null && input.getConfiguration().getShapes().getVisibility() != null) {
            this.showShapes = input.getConfiguration().getShapes().getVisibility().trim().equals("visible");
        }
        if (input.getType().equals("scatter")) {
            this.showLine = false;
            this.generateShadows = true;
        } else {
            this.showLine = true;
            this.generateShadows = false;
        }
    }

    protected void constructPart() {
        Utilities.assertion(this.dataset != null);
        Utilities.assertion(this.dataset.getDataPoint() != null);
        SVGBase[] linepart = new SVGBase[1];
        this.setChildren(linepart);
        SVGGroup line = new SVGGroup();
        int partNum = this.sortedDatapoints.length + 4;
        SVGBase[] lineparts = new SVGBase[partNum];
        SVGGroup dataColourGroup = new SVGGroup();
        SVGBase[] dataColourGroupChild = new SVGBase[]{dataColourGroup};
        dataColourGroup.setChildren(lineparts);
        dataColourGroup.setIdentifier("SVGGEN_dataColour" + this.datasetIndex);
        String dataSetColor = this.palettes.getDataSetColor(this.dataset.getId());
        if (dataSetColor != null) {
            dataColourGroup.setFill(dataSetColor);
            dataColourGroup.setStroke(dataSetColor);
        }
        linepart[0] = line;
        line.setChildren(dataColourGroupChild);
        line.setIdentifier(this.dataset.getId());
        line.setStyleClass("linestyle strokecolor" + this.colorIndex + " fillcolor" + this.colorIndex);
        line.setTransformation("translate(5.0,5.0)");
        SVGGroup lineGroup = new SVGGroup();
        SVGBase[] lineSegments = new SVGBase[this.sortedDatapoints.length - 1];
        if (this.showLine) {
            lineGroup.setChildren(lineSegments);
            lineGroup.setStyle("clip-path: url(#SVGGEN_plotareaBorder)");
            lineparts[1] = lineGroup;
        }
        if (this.generateShadows) {
            SVGFilter filter = new SVGFilter();
            filter.setHeight("200%");
            filter.setWidth("200%");
            filter.setX("-50%");
            filter.setY("-50%");
            filter.setIdentifier("drop-shadow");
            SVGBase[] feGaussianBlurPart = new SVGFeGaussianBlur[1];
            SVGFeGaussianBlur feGaussianBlur = new SVGFeGaussianBlur();
            feGaussianBlur.setStdDeviation("3");
            feGaussianBlur.setIn("SourceAlpha");
            feGaussianBlur.setResult("blur");
            feGaussianBlurPart[0] = feGaussianBlur;
            filter.setChildren(feGaussianBlurPart);
            this.addDefinition(filter);
        }
        lineGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");
        lineparts[partNum - 1] = EventTools.generateUserTooltip(lineGroup, this.dataset.getTooltip(), this.nls);
        EventTools.generateUserEvents(lineGroup, this.dataset.getEventHandler());
        EventTools.generateAccessibility(lineGroup, this.dataset.getAccessibility(), this.nls);
        SVGGroup shadowGroup = new SVGGroup();
        SVGBase[] shadows = new SVGBase[this.sortedDatapoints.length];
        if (this.generateShadows) {
            shadowGroup.setChildren(shadows);
            shadowGroup.setVisibility("hidden");
            shadowGroup.setIdentifier("SVGGEN_shadowGroup" + this.dataset.getId());
            lineparts[2] = shadowGroup;
        }
        boolean firstPointDrawn = false;
        double previousX = 0.0;
        double previousY = 0.0;
        double curX = 0.0;
        double curY = 0.0;
        double zero_y = 0.0;
        StringBuffer pointCoordinates = new StringBuffer();
        int previousPointIndex = 0;
        int i = 0;
        while (i < this.categoryList.size()) {
            CategoricalData dp = this.isLTR ? this.sortedDatapoints[i] : this.sortedDatapoints[this.categoryList.size() - i - 1];
            if (dp != null && (this.depAxislinear || !(dp.getValue() <= 0.0))) {
                SVGGroup pointGroup = new SVGGroup();
                SVGBase[] point = new SVGBase[3];
                pointGroup.setChildren(point);
                SVGGroup pointGroupWrapper = new SVGGroup();
                SVGBase[] pointWrapper = new SVGBase[2];
                pointWrapper[0] = pointGroup;
                pointGroupWrapper.setChildren(pointWrapper);
                pointGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");
                point[2] = EventTools.generateValueTooltip(pointGroup, this.depAxis.formatValue(dp.getValue()));
                point[1] = EventTools.generateUserTooltip(pointGroup, dp.getTooltip(), this.nls);
                EventTools.generateUserEvents(pointGroup, dp.getEventHandler());
                EventTools.generateAccessibility(pointGroup, dp.getAccessibility(), this.nls);
                SVGUse useShape = new SVGUse();
                useShape.setIdentifier(dp.getId());
                curX = this.groupDataPositions[i];
                curY = this.getCoordinate(this.depAxislinear, dp.getValue(), 0.0, this.depAxis.getAxisLength(), this.depAxisMax, this.depAxisMin);
                if (dp.getType().equals("hole")) {
                    useShape.setHref("#SVGGEN_holeshape");
                    useShape.setTransformation("translate(" + (curX - 2.8) + "," + (curY - 2.8) + ")");
                } else {
                    useShape.setHref("#" + this.shapeId);
                    useShape.setTransformation("translate(" + (curX - this.shapeWidth / 2.0) + "," + (curY - this.shapeHeight / 2.0) + ")");
                }
                if (this.showShapes) {
                    useShape.setVisibility("visible");
                } else {
                    useShape.setVisibility("hidden");
                }
                if (dp.getType().equals("hole") || this.shapeId != null && !this.shapeId.trim().equals("")) {
                    point[0] = useShape;
                }
                lineparts[i + 3] = pointGroupWrapper;
                SVGText valueText = new SVGText();
                valueText.setText(this.depAxis.formatValue(dp.getValue()));
                valueText.setStyle("font-size:8pt;stroke:none;fill:black");
                valueText.setXCoordinate(Double.toString(curX + 5.0));
                valueText.setYCoordinate(Double.toString(curY));
                valueText.setVisibility("hidden");
                valueText.setIdentifier("SVGGEN_datavalue" + EventTools.getUniqueID());
                pointWrapper[1] = valueText;
                SVGUse shadowShape = new SVGUse();
                shadowShape.setHref("#" + this.shapeId);
                shadowShape.setTransformation("translate(" + (curX - this.shapeWidth / 2.0) + "," + (curY - this.shapeHeight / 2.0) + ")");
                shadowShape.setFilter("url(#drop-shadow)");
                shadowShape.setIdentifier("SVGGEN_shadowShape" + EventTools.getUniqueID());
                if (this.shapeId != null && !this.shapeId.trim().equals("")) {
                    shadows[i] = shadowShape;
                }
                if (firstPointDrawn) {
                    SVGPolyline lineSegment = new SVGPolyline();
                    String points = String.valueOf(previousX) + " " + previousY + "," + curX + " " + curY;
                    lineSegment.setPoints(points);
                    if (dp.getType().equals("hole") || this.sortedDatapoints[previousPointIndex].getType().equals("hole")) {
                        lineSegment.setStyle("stroke-dasharray: 9, 5; stroke-width: 1.5;");
                    }
                    lineSegments[i - 1] = lineSegment;
                } else {
                    firstPointDrawn = true;
                    if (this.showArea) {
                        double value = this.depAxislinear ? 0.0 : Math.pow(10.0, this.depAxisMin);
                        zero_y = this.getCoordinate(this.depAxislinear, value, 0.0, this.depAxis.getAxisLength(), this.depAxisMax, this.depAxisMin);
                        pointCoordinates.append(String.valueOf(curX) + " " + zero_y);
                    }
                }
                if (this.showArea) {
                    pointCoordinates.append(", " + curX + " " + curY);
                }
                previousX = curX;
                previousY = curY;
                previousPointIndex = i;
            }
            ++i;
        }
        if (this.showArea) {
            SVGGroup areaGroup = new SVGGroup();
            areaGroup.setIdentifier("SVGGEN_area" + this.datasetIndex);
            if (dataSetColor != null) {
                areaGroup.setFill(dataSetColor);
                areaGroup.setStroke(dataSetColor);
            } else {
                areaGroup.setStyleClass("fillcolor" + this.datasetIndex);
            }
            areaGroup.setStyle("clip-path: url(#SVGGEN_plotareaBorder)");
            lineparts[0] = areaGroup;
            pointCoordinates.append(", " + curX + " " + zero_y);
            SVGPolygon area = new SVGPolygon();
            area.setIdentifier("SVGGEN_poly" + this.datasetIndex);
            area.setStyle("fill-opacity: 0.1; stroke: black; stroke-width: 0;");
            area.setPoints(pointCoordinates.toString());
            SVGBase[] groupChild = new SVGBase[1];
            areaGroup.setChildren(groupChild);
            groupChild[0] = area;
            areaGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");
        }
    }
}

