/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPath;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGRectangle;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGUse;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.CategoricalData;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Configuration;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataValue;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.EventTools;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGColorPalettes;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;

public class DataSetPie
extends DataSet {
    static final long serialVersionUID = 853001416600124209L;
    protected CategoricalData[] sortedDatapoints;
    protected org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset;
    protected List categoryList;
    protected double cx;
    protected double cy;
    protected double radius;
    protected int datasetIndex;
    protected int colorIndex;
    protected double pieValue;
    protected double previousDegree;
    protected final int NINETY_DEG = 1;
    protected final int NEGATIVE_NINETY_DEG = 2;
    protected final int ONE_EIGHTY_DEG = 3;
    protected final int ZERO_DEG = 4;
    protected ULocale locale = null;
    protected NumberFormat percentFormatter = null;
    protected DateFormat dateFormatter = null;
    protected DecimalFormat bigNumberFormatter = null;
    private NumberFormat numberFormatter = null;
    protected SVGColorPalettes palettes = null;

    public DataSetPie(Chart input, double cx, double cy, double radius, org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset, int datasetIndex, int colorIndex, CategoricalData[] sortedDatapoints, double pieValue, double previousDegree, ULocale locale, SVGColorPalettes palettes, NLString nls) {
        super(input, nls);
        this.datasetIndex = datasetIndex;
        this.cx = cx;
        this.cy = cy;
        this.radius = radius;
        this.dataset = dataset;
        this.datasetIndex = datasetIndex;
        this.colorIndex = colorIndex;
        this.sortedDatapoints = sortedDatapoints;
        this.pieValue = pieValue;
        this.previousDegree = previousDegree;
        this.palettes = palettes;
        this.locale = locale;
        this.setFormatter();
    }

    public DataSetPie(Chart input, double x, double y, double width, double height, NLString nls) {
        super(input, x, y, width, height, nls);
    }

    protected void constructPart() {
        CategoricalData dp;
        double sliceValue = 0.0;
        double percent = 0.0;
        double degree = 0.0;
        double radian = 0.0;
        double xPosition = 0.0;
        double yPosition = 0.0;
        SVGBase[] piepart = new SVGBase[1];
        this.setChildren(piepart);
        SVGGroup pieset = new SVGGroup();
        int partNum = 5;
        SVGBase[] pieparts = new SVGBase[partNum];
        piepart[0] = pieset;
        pieset.setChildren(pieparts);
        pieset.setIdentifier(this.dataset.getId());
        if (this.sortedDatapoints[0] != null && (dp = this.sortedDatapoints[0]) != null && dp.getValue() > 0.0) {
            sliceValue = dp.getValue();
            percent = this.pieValue > 0.0 ? sliceValue / this.pieValue : 0.0;
            degree = percent * 360.0;
            radian = degree * 0.01745329252;
            xPosition = Math.cos(radian) * this.radius;
            yPosition = Math.sin(radian) * this.radius;
            String translateString = "translate(" + this.cx + "," + this.cy + ")";
            String transformation = this.datasetIndex == 0 ? translateString : String.valueOf(translateString) + " rotate(-" + this.previousDegree + ")";
            String path = "M " + this.radius + " 0 ";
            if (degree == 360.0) {
                path = String.valueOf(path) + " A " + this.radius + " " + this.radius + " 0 0 0 " + -this.radius + " 0 " + " A " + this.radius + " " + this.radius + " 0 0 0 " + this.radius + " 0 ";
            } else if (degree != 0.0) {
                path = String.valueOf(path) + " A " + this.radius + " " + this.radius + " 0 " + (degree < 180.0 ? 0 : 1) + " 0 " + xPosition + " " + -yPosition;
            }
            path = String.valueOf(path) + " L 0 0  Z";
            SVGGroup pointGroup = new SVGGroup();
            pointGroup.setIdentifier("pieColour" + this.datasetIndex);
            pointGroup.setStyleClass("dataset" + this.datasetIndex);
            SVGBase[] point = new SVGBase[5];
            pointGroup.setChildren(point);
            SVGPath pieSegment = new SVGPath();
            pieSegment.setPathData(path);
            pieSegment.setTransform(transformation);
            String dataSetColor = this.palettes.getDataSetColor(this.dataset.getId());
            if (dataSetColor != null) {
                pieSegment.setFill(dataSetColor);
            }
            point[0] = pieSegment;
            pieparts[0] = pointGroup;
            String percentageLabel = this.formatPercentage(percent);
            String sliceValueLabel = this.formatNumber(sliceValue);
            String label = String.valueOf(percentageLabel) + ",  " + sliceValueLabel;
            pointGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavaluePie(evt,'SVGGEN_datasetGroup')");
            String tooltipNum = EventTools.getUniqueID();
            SVGGroup toolTipGroup = new SVGGroup();
            SVGBase[] toolTips = new SVGBase[2];
            toolTipGroup.setChildren(toolTips);
            toolTipGroup.setVisibility("hidden");
            SVGText pieVText = new SVGText();
            pieVText.setIdentifier("SVGGEN_tooltip_exactValue" + tooltipNum + "text");
            pieVText.setText(sliceValueLabel);
            toolTips[0] = pieVText;
            SVGRectangle tooltipRect = new SVGRectangle();
            tooltipRect.setIdentifier("SVGGEN_tooltip_exactValue" + tooltipNum + "rect");
            tooltipRect.setXCoordinate("0");
            tooltipRect.setYCoordinate("0");
            tooltipRect.setWidth("0");
            tooltipRect.setHeight("0");
            toolTips[1] = tooltipRect;
            point[2] = toolTipGroup;
            toolTipGroup = new SVGGroup();
            toolTips = new SVGBase[2];
            toolTipGroup.setChildren(toolTips);
            toolTipGroup.setVisibility("hidden");
            SVGText piePText = new SVGText();
            piePText.setIdentifier("SVGGEN_tooltip_percentValue" + tooltipNum + "text");
            piePText.setText(percentageLabel);
            toolTips[0] = piePText;
            tooltipRect = new SVGRectangle();
            tooltipRect.setIdentifier("SVGGEN_tooltip_percentValue" + tooltipNum + "rect");
            tooltipRect.setXCoordinate("0");
            tooltipRect.setYCoordinate("0");
            tooltipRect.setWidth("0");
            tooltipRect.setHeight("0");
            toolTips[1] = tooltipRect;
            point[3] = toolTipGroup;
            toolTipGroup = new SVGGroup();
            toolTips = new SVGBase[2];
            toolTipGroup.setChildren(toolTips);
            toolTipGroup.setVisibility("hidden");
            SVGText pieBText = new SVGText();
            pieBText.setIdentifier("SVGGEN_tooltip_bothValues" + tooltipNum + "text");
            pieBText.setText(label);
            toolTips[0] = pieBText;
            tooltipRect = new SVGRectangle();
            tooltipRect.setIdentifier("SVGGEN_tooltip_bothValues" + tooltipNum + "rect");
            tooltipRect.setXCoordinate("0");
            tooltipRect.setYCoordinate("0");
            tooltipRect.setWidth("0");
            tooltipRect.setHeight("0");
            toolTips[1] = tooltipRect;
            point[4] = toolTipGroup;
            pointGroup.addEvent("onmouseover", "SVGGEN_showTooltipPie(evt,'" + tooltipNum + "')");
            pointGroup.addEvent("onmouseout", "SVGGEN_hideTooltipPie(evt,'" + tooltipNum + "')");
            point[1] = EventTools.generateUserTooltip(pointGroup, dp.getTooltip(), this.nls);
            EventTools.generateUserEvents(pointGroup, dp.getEventHandler());
            EventTools.generateAccessibility(pointGroup, dp.getAccessibility(), this.nls);
            double rad = (degree / 2.0 + this.previousDegree) * 0.01745329252;
            double xpos = Math.cos(-1.0 * rad) * this.radius;
            double ypos = Math.sin(-1.0 * rad) * this.radius;
            String rotateString = "";
            int rotateFlag = 0;
            if (this.cy + ypos > this.cy && this.cy + ypos >= this.cy + 0.875 * this.radius) {
                rotateString = "rotate(90," + xpos + "," + ypos + ")";
                rotateFlag = 1;
            } else if (this.cy + ypos < this.cy && this.cy + ypos <= this.cy - 0.875 * this.radius) {
                rotateString = "rotate(-90," + xpos + "," + ypos + ")";
                rotateFlag = 2;
            } else if (this.cx + xpos < this.cx) {
                rotateString = "rotate(180," + xpos + "," + ypos + ")";
                rotateFlag = 3;
            } else {
                rotateFlag = 4;
            }
            String stylesheetClass = this.cx + xpos >= this.cx ? "pieValues anchorAtStart" : "pieValues anchorAtEnd";
            Vector labelPosVec = this.calculateLabelPositions(this.cx, xpos, ypos, rotateFlag, label);
            double labelXPos = Double.parseDouble(labelPosVec.firstElement().toString());
            double labelYPos = Double.parseDouble(labelPosVec.lastElement().toString());
            SVGUse tickUse = new SVGUse();
            tickUse.setIdentifier("SVGGEN_datavalue_tick" + EventTools.getUniqueID());
            tickUse.setHref("#tickline");
            tickUse.setXCoordinate(Double.toString(xpos));
            tickUse.setYCoordinate(Double.toString(ypos));
            tickUse.setTransformation(String.valueOf(translateString) + rotateString);
            pieparts[4] = tickUse;
            SVGText pieMCVText = new SVGText();
            pieMCVText.setXCoordinate(Double.toString(labelXPos));
            pieMCVText.setYCoordinate(Double.toString(-1.0 * labelYPos));
            pieMCVText.setIdentifier("SVGGEN_datavalue_exac" + EventTools.getUniqueID());
            pieMCVText.setStyleClass(stylesheetClass);
            pieMCVText.setTransformation(translateString);
            pieMCVText.setVisibility("hidden");
            pieMCVText.setText(sliceValueLabel);
            pieMCVText.setStyle("font-size:8pt;stroke:none;fill:black");
            pieparts[1] = pieMCVText;
            SVGText pieMCPText = new SVGText();
            pieMCPText.setXCoordinate(Double.toString(labelXPos));
            pieMCPText.setYCoordinate(Double.toString(-1.0 * labelYPos));
            pieMCPText.setIdentifier("SVGGEN_datavalue_perc" + EventTools.getUniqueID());
            pieMCPText.setStyleClass(stylesheetClass);
            pieMCPText.setTransformation(translateString);
            pieMCPText.setVisibility("hidden");
            pieMCPText.setText(percentageLabel);
            pieMCPText.setStyle("font-size:8pt;stroke:none;fill:black");
            pieparts[2] = pieMCPText;
            SVGText pieMCBText = new SVGText();
            pieMCBText.setXCoordinate(Double.toString(labelXPos));
            pieMCBText.setYCoordinate(Double.toString(-1.0 * labelYPos));
            pieMCBText.setIdentifier("SVGGEN_datavalue_both" + EventTools.getUniqueID());
            pieMCBText.setStyleClass(stylesheetClass);
            pieMCBText.setTransformation(translateString);
            pieMCBText.setVisibility("visible");
            pieMCBText.setText(label);
            pieMCBText.setStyle("font-size:8pt;stroke:none;fill:black");
            pieparts[3] = pieMCBText;
        }
    }

    protected Vector calculateLabelPositions(double cx, double xpos, double ypos, int rotateFlag, String label) {
        double labelXPos = 0.0;
        double labelYPos = 0.0;
        Vector<Double> labelVec = new Vector<Double>(2);
        if (cx + xpos < cx) {
            if (rotateFlag == 2) {
                labelXPos = xpos + 2.0;
                labelYPos = -ypos + 12.0;
            } else if (rotateFlag == 1) {
                labelXPos = xpos + 2.0;
                labelYPos = -ypos - 20.0;
            } else if (rotateFlag == 3) {
                labelXPos = xpos - 10.0;
                labelYPos = -ypos - 1.0;
            }
        } else if (rotateFlag == 2) {
            labelXPos = xpos - 3.0;
            labelYPos = -ypos + 12.0;
        } else if (rotateFlag == 1) {
            labelXPos = xpos - 3.0;
            labelYPos = -ypos - 20.0;
        } else if (rotateFlag == 4) {
            labelXPos = xpos + 10.0;
            labelYPos = -ypos - 1.0;
        }
        labelVec.add(new Double(labelXPos));
        labelVec.add(new Double(labelYPos));
        return labelVec;
    }

    private void setFormatter() {
        NumberFormat nf;
        org.eclipse.tptp.platform.report.chart.svg.internal.input.NumberFormat numFormat;
        DataValue dataValueDef;
        Configuration config;
        if (this.locale == null) {
            this.locale = ULocale.getDefault();
        }
        if ((config = this.input.getConfiguration()) != null && (dataValueDef = config.getDataValue()) != null && (numFormat = dataValueDef.getNumberFormat()) != null) {
            this.numberFormatter = this.locale != null ? NumberFormat.getInstance((ULocale)this.locale) : NumberFormat.getInstance();
            if (this.numberFormatter instanceof DecimalFormat) {
                ((DecimalFormat)this.numberFormatter).applyPattern(numFormat.getPattern());
            }
        }
        if ((nf = NumberFormat.getInstance((ULocale)this.locale)) instanceof DecimalFormat) {
            this.bigNumberFormatter = (DecimalFormat)nf;
            this.bigNumberFormatter.applyPattern("0.##E0");
        }
        this.percentFormatter = NumberFormat.getPercentInstance((ULocale)this.locale);
        this.percentFormatter.setMinimumFractionDigits(1);
        this.dateFormatter = DateFormat.getDateTimeInstance((int)1, (int)1, (ULocale)this.locale);
    }

    public static String formatValue(ULocale locale, Chart input, double percentage, double sliceValue) {
        NumberFormat nf;
        org.eclipse.tptp.platform.report.chart.svg.internal.input.NumberFormat numFormat;
        DataValue dataValueDef;
        Configuration config;
        NumberFormat numberFormatter = null;
        NumberFormat percentFormatter = null;
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        if ((config = input.getConfiguration()) != null && (dataValueDef = config.getDataValue()) != null && (numFormat = dataValueDef.getNumberFormat()) != null && (numberFormatter = locale != null ? NumberFormat.getInstance((ULocale)locale) : NumberFormat.getInstance()) instanceof DecimalFormat) {
            ((DecimalFormat)numberFormatter).applyPattern(numFormat.getPattern());
        }
        if ((nf = locale != null ? NumberFormat.getInstance((ULocale)locale) : NumberFormat.getInstance()) instanceof DecimalFormat) {
            DecimalFormat bigNumberFormatter = (DecimalFormat)nf;
            bigNumberFormatter.applyPattern("0.##E0");
        }
        percentFormatter = NumberFormat.getPercentInstance((ULocale)locale);
        percentFormatter.setMinimumFractionDigits(1);
        DateFormat.getDateTimeInstance((int)1, (int)1, (ULocale)locale);
        String labelText = numberFormatter != null ? numberFormatter.format(sliceValue) : Double.toString(sliceValue);
        if (input.getConfiguration().getDataValue().getPercentageVisibility().equals("visible") && input.getConfiguration().getDataValue().getValueVisibility().equals("visible")) {
            return String.valueOf(percentFormatter.format(percentage)) + ",  " + labelText;
        }
        if (input.getConfiguration().getDataValue().getValueVisibility().equals("visible")) {
            return labelText;
        }
        if (input.getConfiguration().getDataValue().getPercentageVisibility().equals("visible")) {
            return percentFormatter.format(percentage);
        }
        return String.valueOf(percentFormatter.format(percentage)) + ",  " + labelText;
    }

    public String formatPercentage(double d) {
        return this.percentFormatter.format(d);
    }

    public String formatDate(Date d) {
        return this.dateFormatter.format(d);
    }

    public String formatNumber(double value) {
        String labelText = this.numberFormatter != null ? this.numberFormatter.format(value) : Double.toString(value);
        return labelText;
    }
}

