/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import com.ibm.icu.util.ULocale;
import java.util.Vector;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPath;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGRectangle;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGUse;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.CategoricalData;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.DataSetPie;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.EventTools;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGColorPalettes;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;

public class DataSetPie3D
extends DataSetPie {
    protected double depth = 0.0;
    static final long serialVersionUID = -967686245106472449L;

    public DataSetPie3D(Chart input, double cx, double cy, double radius, DataSet dataset, int datasetIndex, int colorIndex, CategoricalData[] sortedDatapoints, double pieValue, double previousDegree, ULocale locale, SVGColorPalettes palettes, NLString nls) {
        super(input, cx, cy, radius, dataset, datasetIndex, colorIndex, sortedDatapoints, pieValue, previousDegree, locale, palettes, nls);
    }

    public DataSetPie3D(Chart input, double x, double y, double width, double height, NLString nls) {
        super(input, x, y, width, height, nls);
    }

    protected void constructPart() {
        CategoricalData dp;
        double sliceValue = 0.0;
        double percent = 0.0;
        double degree = 0.0;
        double radian = 0.0;
        double xPosition = 0.0;
        double previousX = 0.0;
        double previousY = 0.0;
        double yPosition = 0.0;
        double yDepthPosition = 0.0;
        double xDepthPosition = 0.0;
        double previousDepthX = 0.0;
        double previousDepthY = 0.0;
        SVGBase[] piepart = new SVGBase[1];
        this.setChildren(piepart);
        SVGGroup pieset = new SVGGroup();
        int partNum = 5;
        SVGBase[] pieparts = new SVGBase[partNum];
        piepart[0] = pieset;
        pieset.setChildren(pieparts);
        pieset.setIdentifier(this.dataset.getId());
        if (this.sortedDatapoints[0] != null && (dp = this.sortedDatapoints[0]) != null && dp.getValue() > 0.0) {
            sliceValue = dp.getValue();
            percent = this.pieValue > 0.0 ? sliceValue / this.pieValue : 0.0;
            degree = percent * 360.0;
            radian = (degree + this.previousDegree) * 0.01745329252;
            this.depth = this.radius * 0.3;
            xPosition = Math.cos(radian) * this.radius;
            yPosition = Math.sin(radian) * this.radius * Math.cos(1.0471975511965976);
            String translateString = "translate(" + this.cx + "," + this.cy + ")";
            String transformation = this.datasetIndex == 0 ? translateString : translateString;
            previousX = Math.cos(this.previousDegree * 0.01745329252) * this.radius;
            previousDepthY = previousY = Math.sin(this.previousDegree * 0.01745329252) * this.radius * Math.cos(1.0471975511965976);
            previousDepthX = previousX;
            yDepthPosition = yPosition;
            xDepthPosition = xPosition;
            if (previousY >= 0.0) {
                previousDepthY = 0.0;
                previousDepthX = previousX <= 0.0 ? -this.radius : -this.radius;
            }
            if (yPosition >= 0.0) {
                yDepthPosition = 0.0;
                xDepthPosition = xPosition <= 0.0 ? -this.radius : this.radius;
            }
            if (previousDepthX == xDepthPosition) {
                previousDepthX = -xDepthPosition;
            }
            String depthPath = "M " + previousDepthX + " " + (-previousDepthY + this.depth) + " ";
            String path = "M " + previousX + " " + -previousY + " ";
            if (degree == 360.0) {
                path = String.valueOf(path) + " A " + this.radius + " " + this.radius / 2.0 + " 0 0 0 " + -this.radius + " 0 " + " A " + this.radius + " " + this.radius / 2.0 + " 0 0 0 " + this.radius + " 0 ";
                depthPath = "M " + -this.radius + " " + this.depth + " ";
                depthPath = String.valueOf(depthPath) + " A " + this.radius + " " + this.radius / 2.0 + " 0 " + (degree < 180.0 ? 0 : 1) + " 0 " + this.radius + " " + this.depth;
                depthPath = String.valueOf(depthPath) + " L " + this.radius + " 0" + " A " + this.radius + " " + this.radius / 2.0 + " 0 " + (degree < 180.0 ? 0 : 1) + " 1 " + -this.radius + " " + "0 Z";
            } else if (degree != 0.0) {
                path = String.valueOf(path) + " A " + this.radius + " " + this.radius / 2.0 + " 0 " + (degree < 180.0 ? 0 : 1) + " 0 " + xPosition + " " + -yPosition;
                depthPath = String.valueOf(depthPath) + " A " + this.radius + " " + this.radius / 2.0 + " 0 " + "0 0 " + xDepthPosition + " " + (-yDepthPosition + this.depth);
                depthPath = String.valueOf(depthPath) + " L " + xDepthPosition + " " + -yDepthPosition;
                depthPath = String.valueOf(depthPath) + " A " + this.radius + " " + this.radius / 2.0 + " 0 " + "0 1 " + previousDepthX + " " + -previousDepthY + " Z";
            }
            path = String.valueOf(path) + " L 0 0  Z";
            SVGGroup pointGroup = new SVGGroup();
            pointGroup.setIdentifier("pieColour" + this.datasetIndex);
            pointGroup.setStyleClass("dataset" + this.datasetIndex);
            SVGBase[] point = new SVGBase[5];
            pointGroup.setChildren(point);
            SVGGroup pieGroup = new SVGGroup();
            pieGroup.setIdentifier(this.getIdentifier());
            String dataSetColor = this.palettes.getDataSetColor(this.dataset.getId());
            if (dataSetColor != null) {
                pieGroup.setFill(dataSetColor);
            }
            SVGBase[] pieParts = new SVGBase[2];
            pieGroup.setChildren(pieParts);
            SVGPath pieSegment = new SVGPath();
            pieSegment.setPathData(path);
            pieSegment.setTransform(transformation);
            if ((previousDepthX != this.radius || xDepthPosition != -this.radius) && (previousY < 0.0 || yPosition < 0.0 || degree >= 180.0)) {
                SVGPath shadeSegment = new SVGPath();
                shadeSegment.setPathData(depthPath);
                shadeSegment.setTransform(transformation);
                shadeSegment.setStyle("fill-opacity:0.7");
                pieParts[0] = shadeSegment;
            }
            pieParts[1] = pieSegment;
            point[0] = pieGroup;
            pieparts[0] = pointGroup;
            String percentageLabel = this.formatPercentage(percent);
            String sliceValueLabel = this.formatNumber(sliceValue);
            String label = String.valueOf(percentageLabel) + ",  " + sliceValueLabel;
            pointGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavaluePie(evt,'SVGGEN_datasetGroup')");
            String tooltipNum = EventTools.getUniqueID();
            SVGGroup toolTipGroup = new SVGGroup();
            SVGBase[] toolTips = new SVGBase[2];
            toolTipGroup.setChildren(toolTips);
            toolTipGroup.setVisibility("hidden");
            SVGText pieVText = new SVGText();
            pieVText.setIdentifier("SVGGEN_tooltip_exactValue" + tooltipNum + "text");
            pieVText.setText(sliceValueLabel);
            toolTips[0] = pieVText;
            SVGRectangle tooltipRect = new SVGRectangle();
            tooltipRect.setIdentifier("SVGGEN_tooltip_exactValue" + tooltipNum + "rect");
            tooltipRect.setXCoordinate("0");
            tooltipRect.setYCoordinate("0");
            tooltipRect.setWidth("0");
            tooltipRect.setHeight("0");
            toolTips[1] = tooltipRect;
            point[2] = toolTipGroup;
            toolTipGroup = new SVGGroup();
            toolTips = new SVGBase[2];
            toolTipGroup.setChildren(toolTips);
            toolTipGroup.setVisibility("hidden");
            SVGText piePText = new SVGText();
            piePText.setIdentifier("SVGGEN_tooltip_percentValue" + tooltipNum + "text");
            piePText.setText(percentageLabel);
            toolTips[0] = piePText;
            tooltipRect = new SVGRectangle();
            tooltipRect.setIdentifier("SVGGEN_tooltip_percentValue" + tooltipNum + "rect");
            tooltipRect.setXCoordinate("0");
            tooltipRect.setYCoordinate("0");
            tooltipRect.setWidth("0");
            tooltipRect.setHeight("0");
            toolTips[1] = tooltipRect;
            point[3] = toolTipGroup;
            toolTipGroup = new SVGGroup();
            toolTips = new SVGBase[2];
            toolTipGroup.setChildren(toolTips);
            toolTipGroup.setVisibility("hidden");
            SVGText pieBText = new SVGText();
            pieBText.setIdentifier("SVGGEN_tooltip_bothValues" + tooltipNum + "text");
            pieBText.setText(label);
            toolTips[0] = pieBText;
            tooltipRect = new SVGRectangle();
            tooltipRect.setIdentifier("SVGGEN_tooltip_bothValues" + tooltipNum + "rect");
            tooltipRect.setXCoordinate("0");
            tooltipRect.setYCoordinate("0");
            tooltipRect.setWidth("0");
            tooltipRect.setHeight("0");
            toolTips[1] = tooltipRect;
            point[4] = toolTipGroup;
            pointGroup.addEvent("onmouseover", "SVGGEN_showTooltipPie(evt,'" + tooltipNum + "')");
            pointGroup.addEvent("onmouseout", "SVGGEN_hideTooltipPie(evt,'" + tooltipNum + "')");
            point[1] = EventTools.generateUserTooltip(pointGroup, dp.getTooltip(), this.nls);
            EventTools.generateUserEvents(pointGroup, dp.getEventHandler());
            EventTools.generateAccessibility(pointGroup, dp.getAccessibility(), this.nls);
            double rad = (degree / 2.0 + this.previousDegree) * 0.01745329252;
            double xpos = Math.cos(-1.0 * rad) * this.radius;
            double ypos = Math.sin(-1.0 * rad) * this.radius * Math.cos(1.0471975511965976);
            if (ypos > 0.0) {
                ypos += this.depth;
            }
            String rotateString = "";
            int rotateFlag = 0;
            if (this.cy + ypos > this.cy && this.cy + ypos >= this.cy + 0.875 * this.radius) {
                rotateString = "rotate(90," + xpos + "," + ypos + ")";
                rotateFlag = 1;
            } else if (this.cy + ypos < this.cy && this.cy + ypos <= this.cy - 0.875 * this.radius) {
                rotateString = "rotate(-90," + xpos + "," + ypos + ")";
                rotateFlag = 2;
            } else if (this.cx + xpos < this.cx) {
                rotateString = "rotate(180," + xpos + "," + ypos + ")";
                rotateFlag = 3;
            } else {
                rotateFlag = 4;
            }
            String stylesheetClass = this.cx + xpos >= this.cx ? "pieValues anchorAtStart" : "pieValues anchorAtEnd";
            Vector labelPosVec = this.calculateLabelPositions(this.cx, xpos, ypos, rotateFlag, label);
            double labelXPos = Double.parseDouble(labelPosVec.firstElement().toString());
            double labelYPos = Double.parseDouble(labelPosVec.lastElement().toString());
            SVGUse tickUse = new SVGUse();
            tickUse.setIdentifier("SVGGEN_datavalue_tick" + EventTools.getUniqueID());
            tickUse.setHref("#tickline");
            tickUse.setXCoordinate(Double.toString(xpos));
            tickUse.setYCoordinate(Double.toString(ypos));
            tickUse.setTransformation(String.valueOf(translateString) + rotateString);
            pieparts[4] = tickUse;
            SVGText pieMCVText = new SVGText();
            pieMCVText.setXCoordinate(Double.toString(labelXPos));
            pieMCVText.setYCoordinate(Double.toString(-1.0 * labelYPos));
            pieMCVText.setIdentifier("SVGGEN_datavalue_exac" + EventTools.getUniqueID());
            pieMCVText.setStyleClass(stylesheetClass);
            pieMCVText.setTransformation(translateString);
            pieMCVText.setVisibility("hidden");
            pieMCVText.setText(sliceValueLabel);
            pieMCVText.setStyle("font-size:8pt;stroke:none;fill:black");
            pieparts[1] = pieMCVText;
            SVGText pieMCPText = new SVGText();
            pieMCPText.setXCoordinate(Double.toString(labelXPos));
            pieMCPText.setYCoordinate(Double.toString(-1.0 * labelYPos));
            pieMCPText.setIdentifier("SVGGEN_datavalue_perc" + EventTools.getUniqueID());
            pieMCPText.setStyleClass(stylesheetClass);
            pieMCPText.setTransformation(translateString);
            pieMCPText.setVisibility("hidden");
            pieMCPText.setText(percentageLabel);
            pieMCPText.setStyle("font-size:8pt;stroke:none;fill:black");
            pieparts[2] = pieMCPText;
            SVGText pieMCBText = new SVGText();
            pieMCBText.setXCoordinate(Double.toString(labelXPos));
            pieMCBText.setYCoordinate(Double.toString(-1.0 * labelYPos));
            pieMCBText.setIdentifier("SVGGEN_datavalue_both" + EventTools.getUniqueID());
            pieMCBText.setStyleClass(stylesheetClass);
            pieMCBText.setTransformation(translateString);
            pieMCBText.setVisibility("visible");
            pieMCBText.setText(label);
            pieMCBText.setStyle("font-size:8pt;stroke:none;fill:black");
            pieparts[3] = pieMCBText;
        }
    }

    protected Vector calculateLabelPositions(double cx, double xpos, double ypos, int rotateFlag, String label) {
        double labelXPos = 0.0;
        double labelYPos = 0.0;
        Vector<Double> labelVec = new Vector<Double>(2);
        ypos = ypos > 0.0 ? (ypos += 10.0) : (ypos -= 3.0);
        if (cx + xpos < cx) {
            if (rotateFlag == 2) {
                labelXPos = xpos + 2.0;
                labelYPos = -ypos + 12.0;
            } else if (rotateFlag == 1) {
                labelXPos = xpos + 2.0;
                labelYPos = -ypos - 20.0;
            } else if (rotateFlag == 3) {
                labelXPos = xpos - 10.0;
                labelYPos = -ypos - 1.0;
            }
        } else if (rotateFlag == 2) {
            labelXPos = xpos - 3.0;
            labelYPos = -ypos + 12.0;
        } else if (rotateFlag == 1) {
            labelXPos = xpos - 3.0;
            labelYPos = -ypos - 20.0;
        } else if (rotateFlag == 4) {
            labelXPos = xpos + 10.0;
            labelYPos = -ypos - 1.0;
        }
        labelVec.add(new Double(labelXPos));
        labelVec.add(new Double(labelYPos));
        return labelVec;
    }
}

