/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGLine;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.CategoricalData;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Categories;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisCategory;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisNumber;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.EventTools;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGColorPalettes;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;

public class DataSetStackBar
extends DataSet {
    static final long serialVersionUID = 4550173625267433013L;
    protected AxisCategory indepAxis;
    protected AxisNumber depAxis;
    protected org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset;
    protected CategoricalData[] sortedDatapoints;
    protected int colorIndex;
    protected List categoryList;
    protected double[] groupDataPositions;
    protected double depAxisMax;
    protected double depAxisMin;
    protected double axisLenght;
    protected boolean linear;
    protected double barWidth;
    protected double[] accumulatedHighValues;
    protected double[] accumulatedLowValues;
    protected int datasetIndex;
    protected boolean isLTR = true;
    protected SVGColorPalettes palettes;

    public DataSetStackBar(Chart input, boolean isLTR, AxisCategory indepAxis, AxisNumber depAxis, org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset, int datasetIndex, int colorIndex, double barWidth, double[] accumulatedLowValues, double[] accumulatedHighValues, SVGColorPalettes palettes, NLString nls) {
        super(input, nls);
        this.indepAxis = indepAxis;
        this.depAxis = depAxis;
        this.dataset = dataset;
        this.datasetIndex = datasetIndex;
        this.barWidth = barWidth;
        this.colorIndex = colorIndex;
        this.accumulatedHighValues = accumulatedHighValues;
        this.accumulatedLowValues = accumulatedLowValues;
        this.isLTR = isLTR;
        this.palettes = palettes;
        this.linear = depAxis.isLinear();
        this.sortDataPoints();
        this.groupDataPositions = indepAxis.getGroupDataPositions();
        this.axisLenght = indepAxis.getAxisLength();
        this.depAxisMax = depAxis.getMax();
        this.depAxisMin = depAxis.getMin();
    }

    public DataSetStackBar(Chart input, double x, double y, double width, double height, NLString nls) {
        super(input, x, y, width, height, nls);
    }

    public void setIndepAxis(AxisCategory axis) {
        this.indepAxis = axis;
    }

    public void setDepAxis(AxisNumber axis) {
        this.depAxis = axis;
    }

    public void setDataSet(org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset) {
        this.dataset = dataset;
    }

    protected void constructPart() {
        Utilities.assertion(this.dataset != null);
        Utilities.assertion(this.dataset.getDataPoint() != null);
        SVGBase[] barpart = new SVGBase[2];
        this.setChildren(barpart);
        SVGGroup barGroup1 = new SVGGroup();
        SVGBase[] barGroupChild = new SVGBase[1];
        barpart[0] = barGroup1;
        barGroup1.setChildren(barGroupChild);
        barGroup1.setIdentifier(this.dataset.getId());
        barGroup1.setStyleClass("bars" + this.colorIndex);
        SVGGroup barset = new SVGGroup();
        int partNum = this.sortedDatapoints.length + 1;
        SVGBase[] barparts = new SVGBase[partNum];
        barGroupChild[0] = barset;
        barset.setChildren(barparts);
        String dataSetColor = this.palettes.getDataSetColor(this.dataset.getId());
        if (dataSetColor != null) {
            barset.setFill(dataSetColor);
            barset.setStroke(dataSetColor);
        }
        barset.setIdentifier("SVGGEN_dataColour" + this.datasetIndex);
        double min = Math.pow(10.0, this.depAxisMin);
        double[] groupPosition = this.indepAxis.groupDataPositions;
        if (this.indepAxis.getAxisOrientation() == 0) {
            int i = 0;
            while (i < this.categoryList.size()) {
                CategoricalData dp = this.isLTR ? this.sortedDatapoints[i] : this.sortedDatapoints[this.categoryList.size() - i - 1];
                if (dp != null && (this.linear || !(dp.getValue() <= 0.0))) {
                    SVGGroup pointGroup = new SVGGroup();
                    SVGBase[] point = new SVGBase[4];
                    pointGroup.setChildren(point);
                    pointGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");
                    point[2] = EventTools.generateValueTooltip(pointGroup, this.depAxis.formatValue(dp.getValue()));
                    point[1] = EventTools.generateUserTooltip(pointGroup, dp.getTooltip(), this.nls);
                    EventTools.generateUserEvents(pointGroup, dp.getEventHandler());
                    EventTools.generateAccessibility(pointGroup, dp.getAccessibility(), this.nls);
                    pointGroup.setIdentifier(dp.getId());
                    double yValue = dp.getValue();
                    double lastYValue = 0.0;
                    double curX = groupPosition[i];
                    if (yValue >= 0.0) {
                        yValue = dp.getValue() + this.accumulatedHighValues[i];
                        double value = 0.0;
                        value = !this.linear ? (this.accumulatedHighValues[i] == 0.0 ? min : this.accumulatedHighValues[i]) : this.accumulatedHighValues[i];
                        lastYValue = this.getCoordinate(this.linear, value, 0.0, Double.parseDouble(this.getHeight()), this.depAxisMax, this.depAxisMin);
                        this.accumulatedHighValues[i] = yValue;
                    } else {
                        yValue = dp.getValue() + this.accumulatedLowValues[i];
                        lastYValue = this.getCoordinate(this.linear, this.accumulatedLowValues[i], 0.0, Double.parseDouble(this.getHeight()), this.depAxisMax, this.depAxisMin);
                        this.accumulatedLowValues[i] = yValue;
                    }
                    double curY = this.getCoordinate(this.linear, yValue, 0.0, Double.parseDouble(this.getHeight()), this.depAxisMax, this.depAxisMin);
                    barparts[i + 1] = pointGroup;
                    if (i >= 0) {
                        SVGText barTextSegment = new SVGText();
                        String tooltipID = "SVGGEN_datavalue_" + this.dataset.getId() + "_" + EventTools.getUniqueID();
                        barTextSegment.setText(this.depAxis.formatValue(dp.getValue()));
                        barTextSegment.setStyle("font-size:8pt;stroke:none;fill:black");
                        barTextSegment.setStyleClass("anchorAtMiddle");
                        barTextSegment.setVisibility("hidden");
                        barTextSegment.setXCoordinate(Double.toString(curX));
                        if (dp.getValue() < 0.0) {
                            barTextSegment.setYCoordinate(Double.toString(curY + 8.0));
                        } else {
                            barTextSegment.setYCoordinate(Double.toString(curY - 2.0));
                        }
                        barTextSegment.setIdentifier(tooltipID);
                        SVGGroup barGroup = new SVGGroup();
                        barGroup.setIdentifier("SVGGEN_bar_" + this.dataset.getId());
                        SVGLine barSegment = new SVGLine();
                        barSegment.setX1(Double.toString(curX));
                        barSegment.setY1(Double.toString(lastYValue));
                        barSegment.setX2(Double.toString(curX));
                        barSegment.setY2(Double.toString(curY));
                        barSegment.setStrokeWidth(Double.toString(this.barWidth));
                        point[0] = barSegment;
                        SVGBase[] groupChild = new SVGBase[1];
                        barGroup.setChildren(groupChild);
                        groupChild[0] = barTextSegment;
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.categoryList.size()) {
                CategoricalData dp = this.sortedDatapoints[i];
                if (dp != null && (this.linear || !(dp.getValue() <= 0.0))) {
                    SVGGroup pointGroup = new SVGGroup();
                    SVGBase[] point = new SVGBase[3];
                    pointGroup.setChildren(point);
                    pointGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");
                    point[2] = EventTools.generateValueTooltip(pointGroup, this.depAxis.formatValue(dp.getValue()));
                    point[1] = EventTools.generateUserTooltip(pointGroup, dp.getTooltip(), this.nls);
                    EventTools.generateUserEvents(pointGroup, dp.getEventHandler());
                    EventTools.generateAccessibility(pointGroup, dp.getAccessibility(), this.nls);
                    pointGroup.setIdentifier(dp.getId());
                    double xValue = dp.getValue();
                    double lastXValue = 0.0;
                    double curY = this.indepAxis.getAxisLength() - groupPosition[i];
                    double value = 0.0;
                    value = !this.linear ? (this.accumulatedHighValues[i] == 0.0 ? min : this.accumulatedHighValues[i]) : this.accumulatedHighValues[i];
                    if (xValue >= 0.0) {
                        xValue = dp.getValue() + this.accumulatedHighValues[i];
                        lastXValue = this.isLTR ? this.getCoordinate(this.linear, value, Double.parseDouble(this.getWidth()), 0.0, this.depAxisMax, this.depAxisMin) : this.getCoordinate(this.linear, value, 0.0, Double.parseDouble(this.getWidth()), this.depAxisMax, this.depAxisMin);
                        this.accumulatedHighValues[i] = xValue;
                    } else {
                        xValue = dp.getValue() + this.accumulatedLowValues[i];
                        lastXValue = this.isLTR ? this.getCoordinate(this.linear, this.accumulatedLowValues[i], Double.parseDouble(this.getWidth()), 0.0, this.depAxisMax, this.depAxisMin) : this.getCoordinate(this.linear, this.accumulatedLowValues[i], 0.0, Double.parseDouble(this.getWidth()), this.depAxisMax, this.depAxisMin);
                        this.accumulatedLowValues[i] = xValue;
                    }
                    double curX = this.isLTR ? this.getCoordinate(this.linear, xValue, Double.parseDouble(this.getWidth()), 0.0, this.depAxisMax, this.depAxisMin) : this.getCoordinate(this.linear, xValue, 0.0, Double.parseDouble(this.getWidth()), this.depAxisMax, this.depAxisMin);
                    barparts[i + 1] = pointGroup;
                    if (i >= 0) {
                        SVGText barTextSegment = new SVGText();
                        String tooltipID = "SVGGEN_datavalue_" + this.dataset.getId() + "_" + EventTools.getUniqueID();
                        barTextSegment.setText(this.depAxis.formatValue(dp.getValue()));
                        barTextSegment.setStyle("font-size:8pt;stroke:none;fill:black");
                        barTextSegment.setVisibility("hidden");
                        barTextSegment.setXCoordinate(Double.toString(curX));
                        if (dp.getValue() < 0.0) {
                            barTextSegment.setStyleClass("anchorAtEnd");
                        } else {
                            barTextSegment.setStyleClass("anchorAtStart");
                        }
                        barTextSegment.setIdentifier(tooltipID);
                        SVGGroup barGroup = new SVGGroup();
                        barGroup.setIdentifier("SVGGEN_bar_" + this.dataset.getId());
                        SVGLine barSegment = new SVGLine();
                        barSegment.setX1(Double.toString(lastXValue));
                        barSegment.setY1(Double.toString(curY));
                        barSegment.setX2(Double.toString(curX));
                        barSegment.setY2(Double.toString(curY));
                        barSegment.setStrokeWidth(Double.toString(this.barWidth));
                        point[0] = barSegment;
                        SVGBase[] groupChild = new SVGBase[1];
                        barGroup.setChildren(groupChild);
                        groupChild[0] = barTextSegment;
                    }
                }
                ++i;
            }
        }
    }

    private void sortDataPoints() {
        Categories categories;
        Data data = this.input.getData();
        List datapoints = this.dataset.getDataPoint();
        if (data != null && (categories = data.getCategories()) != null) {
            this.categoryList = categories.getCategory();
            this.sortedDatapoints = new CategoricalData[this.categoryList.size()];
            for (CategoricalData dp : datapoints) {
                int index = this.categoryList.indexOf(dp.getCategoryId());
                this.sortedDatapoints[index] = dp;
            }
            int i = 0;
            while (i < this.categoryList.size()) {
                CategoricalData dp;
                dp = this.sortedDatapoints[i];
                if (dp != null && (this.linear || !(dp.getValue() <= 0.0))) {
                    if (dp.getValue() >= 0.0) {
                        if (!this.isLTR && this.indepAxis.getAxisOrientation() == 0) {
                            if (Double.isNaN(this.accumulatedHighValues[this.categoryList.size() - i - 1])) {
                                this.accumulatedHighValues[this.categoryList.size() - i - 1] = dp.getValue();
                            } else {
                                int n = this.categoryList.size() - i - 1;
                                this.accumulatedHighValues[n] = this.accumulatedHighValues[n] + dp.getValue();
                            }
                        } else if (Double.isNaN(this.accumulatedHighValues[i])) {
                            this.accumulatedHighValues[i] = dp.getValue();
                        } else {
                            int n = i;
                            this.accumulatedHighValues[n] = this.accumulatedHighValues[n] + dp.getValue();
                        }
                    } else if (!this.isLTR && this.indepAxis.getAxisOrientation() == 0) {
                        if (Double.isNaN(this.accumulatedLowValues[this.categoryList.size() - i - 1])) {
                            this.accumulatedLowValues[this.categoryList.size() - i - 1] = dp.getValue();
                        } else {
                            int n = this.categoryList.size() - i - 1;
                            this.accumulatedLowValues[n] = this.accumulatedLowValues[n] + dp.getValue();
                        }
                    } else if (Double.isNaN(this.accumulatedLowValues[i])) {
                        this.accumulatedLowValues[i] = dp.getValue();
                    } else {
                        int n = i;
                        this.accumulatedLowValues[n] = this.accumulatedLowValues[n] + dp.getValue();
                    }
                }
                ++i;
            }
        }
    }
}

