/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGColorPalettes;

public class ECMAScriptGenerator {
    private StringBuffer script;
    private static final String eol = "\n";

    public String generateClientSnifferVariables() {
        this.script = new StringBuffer("var SVGGEN_browserVersion = parseInt(parent.navigator.appVersion); ");
        this.script.append("var SVGGEN_isNN = parent.navigator.appName.indexOf(\"Netscape\")!= -1; ").append(eol);
        this.script.append("var SVGGEN_isIE = parent.navigator.appName.indexOf(\"Microsoft\")!= -1; ").append(eol);
        return this.script.toString();
    }

    public String generateNullClientSnifferVariables() {
        this.script = new StringBuffer("var SVGGEN_browserVersion = null;");
        this.script.append("var SVGGEN_isNN = false;").append(eol);
        this.script.append("var SVGGEN_isIE = false; ").append(eol);
        return this.script.toString();
    }

    public String generateGlobalVariables() {
        this.script = new StringBuffer("var SVGGEN_currentValues = null; ");
        this.script.append("var SVGGEN_palettes = null; ").append(eol);
        this.script.append("var SVGGEN_preferencePage = null;").append(eol);
        return this.script.toString();
    }

    public String generateInitFunction(String userPreferences, SVGColorPalettes palettes, String currentFont, String cookieName, String type, List dataSetList, int numCat, int sets, String updatedUserPrefsVarName, String svgDocumentVariable, String svgWindowVariable, boolean showShapes) {
        HashMap paletteSet = palettes.getGraphicColorPalettes();
        String defaultPaletteName = null;
        this.script = new StringBuffer();
        this.script.append("function SVGGEN_init(e){").append(eol);
        if (svgDocumentVariable != null) {
            this.script.append("  parent.");
            this.script.append(svgDocumentVariable);
            this.script.append(" = e.target.ownerDocument;").append(eol);
        }
        if (svgWindowVariable != null) {
            this.script.append("  parent.");
            this.script.append(svgWindowVariable);
            this.script.append(" = window;").append(eol);
        }
        this.script.append("  SVGGEN_dataValuesVisible = false;").append(eol);
        this.script.append("  SVGGEN_currentValues = null;").append(eol);
        if (showShapes) {
            this.script.append("  SVGGEN_noShapes = false;").append(eol);
        } else {
            this.script.append("  SVGGEN_noShapes = true;").append(eol);
        }
        if ((type.equals("area") || type.equals("stackedArea")) && dataSetList != null) {
            for (DataSet dataset : dataSetList) {
                int datasetIndex = dataSetList.indexOf(dataset);
                this.script.append("  SVGGEN_moveNode('SVGGEN_area" + datasetIndex + "', 'SVGGEN_plotareaBackground');").append(eol);
            }
        }
        if ((type.equals("horizontalBar") || type.equals("horizontalBar3D") || type.equals("verticalBar") || type.equals("verticalBar3D") || type.equals("horizontalStackedBar") || type.equals("horizontalStackedBar3D") || type.equals("verticalStackedBar") || type.equals("verticalStackedBar3D")) && dataSetList != null) {
            for (DataSet dataset : dataSetList) {
                this.script.append("  for (var i = 0; i < " + numCat + "; i++)");
                this.script.append("  SVGGEN_moveNode('SVGGEN_bar_" + dataset.getId() + "', 'SVGGEN_plotareaForeground_" + dataset.getId() + "');").append(eol);
            }
        }
        if (paletteSet == null || paletteSet.isEmpty()) {
            this.script.append("} ").append(eol);
            return this.script.toString();
        }
        this.script.append("SVGGEN_palettes = new Array();").append(eol);
        Iterator keys = paletteSet.keySet().iterator();
        int i = 0;
        while (keys.hasNext()) {
            String id = (String)keys.next();
            String[] codes = (String[])paletteSet.get(id);
            this.script.append("SVGGEN_palettes[");
            this.script.append(i);
            this.script.append("] = [");
            int j = 0;
            while (j < codes.length) {
                this.script.append("\"");
                this.script.append(codes[j]);
                this.script.append("\", ");
                ++j;
            }
            this.script.append("\"");
            this.script.append(palettes.getPaletteDisplayName(id));
            this.script.append("\"");
            this.script.append("];").append(eol);
            ++i;
            if (defaultPaletteName != null) continue;
            defaultPaletteName = palettes.getPaletteDisplayName(id);
        }
        if (cookieName != null) {
            this.script.append("SVGGEN_currentValues = SVGGEN_getPreferences();").append(eol);
        }
        this.script.append("if (SVGGEN_currentValues != null) {").append(eol);
        this.script.append("SVGGEN_updateStyles(SVGGEN_currentValues, true);}").append(eol);
        if (userPreferences != null) {
            int numberOfPreferences = 6;
            int lastCommaIndex = 0;
            int nextCommaIndex = 0;
            String userPreference = null;
            this.script.append("else {SVGGEN_currentValues = [\"");
            nextCommaIndex = userPreferences.indexOf(",", lastCommaIndex);
            userPreference = userPreferences.substring(lastCommaIndex, nextCommaIndex);
            this.script.append(userPreference);
            this.script.append("\",\"");
            int k = 0;
            while (k < numberOfPreferences - 2) {
                lastCommaIndex = nextCommaIndex;
                nextCommaIndex = userPreferences.indexOf(",", lastCommaIndex + 1);
                userPreference = userPreferences.substring(lastCommaIndex + 1, nextCommaIndex);
                this.script.append(userPreference);
                this.script.append("\",\"");
                ++k;
            }
            lastCommaIndex = nextCommaIndex;
            userPreference = userPreferences.substring(lastCommaIndex + 1, userPreferences.length());
            this.script.append(userPreference);
            this.script.append("\"];SVGGEN_updateStyles(SVGGEN_currentValues, true); }").append(eol);
        } else {
            String defaultFont = "font-weight:normal; font-style:normal; font-family:Arial; fill:#000000;";
            String newDefaultFont = String.valueOf(defaultFont.substring(0, defaultFont.indexOf("font-family") + "font-family".length() + 1)) + currentFont + defaultFont.substring(defaultFont.indexOf("; fill"), defaultFont.length());
            this.script.append("else {SVGGEN_currentValues = [\"");
            this.script.append(palettes.getPaletteDisplayName());
            this.script.append("\",\"");
            this.script.append(8);
            this.script.append("\",\"");
            this.script.append(newDefaultFont);
            this.script.append("\",\"");
            this.script.append("1");
            this.script.append("\",\"");
            if (type.equals("pie") || type.equals("pie3D")) {
                this.script.append("1");
            } else {
                this.script.append("0");
            }
            this.script.append("\",\"");
            this.script.append("1");
            this.script.append("\"];SVGGEN_updateStyles(SVGGEN_currentValues, true);}").append(eol);
        }
        if (updatedUserPrefsVarName != null) {
            this.script.append("\tparent.");
            this.script.append(updatedUserPrefsVarName);
            this.script.append(" = SVGGEN_currentValues;").append(eol);
        }
        if (type.equals("stackedArea")) {
            this.script.append("\tSVGGEN_regen();");
        }
        this.script.append("} ").append(eol);
        this.script.append("SVGGEN_defaultPaletteName = \"" + palettes.getPaletteDisplayName() + "\";").append(eol);
        this.script.append("function SVGGEN_getDefaultPaletteName() {").append(eol);
        this.script.append("return SVGGEN_defaultPaletteName;}").append(eol);
        return this.script.toString();
    }

    public String generateOpenPreferencePageFunction(String url, String src, String name, String width, String height) {
        this.script = new StringBuffer("function SVGGEN_openPreferencePage(){");
        this.script.append("if (SVGGEN_isNN) {SVGGEN_useNetscapePreferencePage();}").append(eol);
        this.script.append("else {").append(eol);
        this.script.append("if (SVGGEN_preferencePage) {SVGGEN_preferencePage = null;}").append(eol);
        this.script.append("SVGGEN_preferencePage=open('");
        this.script.append(String.valueOf(url) + src);
        this.script.append("','");
        this.script.append(name);
        this.script.append("', 'width=");
        this.script.append(width);
        this.script.append(",height=");
        this.script.append(height);
        this.script.append(",resizable");
        this.script.append("'); ").append(eol);
        this.script.append("SVGGEN_preferencePage.opener=window;} ").append(eol);
        this.script.append("} ").append(eol);
        this.script.append("function SVGGEN_PreferenceOnOut(evt,prefrectId){").append(eol);
        this.script.append("    var svgDoc = evt.target.ownerDocument;").append(eol);
        this.script.append("    var prefRect = svgDoc.getElementById(prefrectId);").append(eol);
        this.script.append("    prefRect.setAttribute(\"style\", \"stroke-width:1;stroke:#a0a0a4\");").append(eol);
        this.script.append("}").append(eol);
        this.script.append("").append(eol);
        this.script.append("function SVGGEN_PreferenceOnHover(evt,prefrectId){").append(eol);
        this.script.append("    var svgDoc = evt.target.ownerDocument;").append(eol);
        this.script.append("    var prefRect = svgDoc.getElementById(prefrectId);").append(eol);
        this.script.append("    prefRect.setAttribute(\"style\", \"stroke-width:1;stroke:#666666\");").append(eol);
        this.script.append("}").append(eol);
        return this.script.toString();
    }

    public String generateUseNetscapePreferencePage(String url, String src, String name, String pageWidth, String pageHeight) {
        String height = null;
        String ns_src = "indexs.html";
        String width = "360";
        String graphType = name;
        if (name.equals("line")) {
            height = "520";
        } else if (name.equals("area")) {
            height = "520";
        } else if (name.equals("stackedArea")) {
            height = "520";
        } else if (name.equals("scatter")) {
            height = "520";
        } else if (name.equals("verticalBar")) {
            height = "460";
        } else if (name.equals("verticalStackedBar")) {
            height = "460";
        } else if (name.equals("verticalBar3D")) {
            height = "460";
        } else if (name.equals("verticalStackedBar3D")) {
            height = "460";
        } else if (name.equals("pie")) {
            height = "480";
        } else if (name.equals("pie3D")) {
            height = "480";
        } else if (name.equals("meter")) {
            height = "320";
        } else {
            width = pageWidth;
            height = pageHeight;
        }
        if (name.equals("verticalBar3D") || name.equals("horizontalBar3D") || name.equals("verticalBar") || name.equals("horizontalBar")) {
            graphType = "bar";
        }
        if (name.equals("verticalStackedBar3D") || name.equals("horizontalStackedBar3D") || name.equals("verticalStackedBar") || name.equals("horizontalStackedBar")) {
            graphType = "stack";
        }
        if (name.equals("pie") || name.equals("pie3D")) {
            graphType = "pie";
        }
        if (name.equals("stackedArea")) {
            graphType = "area";
        }
        this.script = new StringBuffer("function SVGGEN_useNetscapePreferencePage(){");
        this.script.append("if (SVGGEN_preferencePage) {SVGGEN_preferencePage = null;}").append(eol);
        this.script.append("SVGGEN_preferencePage=open('");
        this.script.append(String.valueOf(url) + ns_src);
        this.script.append("','");
        this.script.append(name);
        this.script.append("','");
        this.script.append("width=");
        this.script.append(width);
        this.script.append(",");
        this.script.append("height=");
        this.script.append(height);
        this.script.append(",top=0,left=0,screenx=0,screeny=0,toolbar=no,scrollbar=no'); ").append(eol);
        this.script.append("SVGGEN_preferencePage.prefType='");
        this.script.append(graphType);
        this.script.append("'; SVGGEN_preferencePage.opener=window;");
        this.script.append("}").append(eol);
        return this.script.toString();
    }

    public String generateGetPalettesFunction() {
        this.script = new StringBuffer("function SVGGEN_getPalettes(){").append(eol);
        this.script.append("return SVGGEN_palettes;").append(eol);
        this.script.append("} ").append(eol);
        return this.script.toString();
    }

    public String generateGetCurrentValuesFunction() {
        this.script = new StringBuffer("var SVGGEN_current = new Array();").append(eol);
        this.script.append("function SVGGEN_getCurrentValues() {").append(eol);
        this.script.append("for (var i = 0; i < 6; i++) {SVGGEN_current[i] = SVGGEN_currentValues[i];}").append(eol);
        this.script.append("for (var i = 0; i < SVGGEN_palettes.length; i++) {").append(eol);
        this.script.append("if (SVGGEN_palettes[i][SVGGEN_palettes[i].length - 1] == SVGGEN_current[0]) {").append(eol);
        this.script.append(" SVGGEN_current[6] = SVGGEN_palettes[i][0];}}").append(eol);
        this.script.append("return SVGGEN_current;").append(eol);
        this.script.append("} ").append(eol);
        return this.script.toString();
    }

    public String generateToggleVisibilityFunction(int sets, String type, boolean showShapes) {
        this.script = new StringBuffer("var SVGGEN_values=1, SVGGEN_percents=1;var SVGGEN_textboxState = new Array();");
        this.script.append("for (var i = 0; i < ").append(sets).append("; i++) {SVGGEN_textboxState[i] = 0;}").append(eol);
        if (!type.equals("pie") && !type.equals("pie3D")) {
            if (type.equals("line") || type.equals("area") || type.equals("scatter") || type.equals("stackedArea")) {
                if (showShapes) {
                    this.script.append("var SVGGEN_noShapes = false;").append(eol);
                } else {
                    this.script.append("var SVGGEN_noShapes = true;").append(eol);
                }
                if (type.equals("scatter")) {
                    this.script.append("function SVGGEN_toggleShadow(id, state) {").append(eol);
                    this.script.append("    var group = document.getElementById(id);").append(eol);
                    this.script.append("    if (group != null) {").append(eol);
                    this.script.append("      var useElementGroup = group.getElementsByTagName('use');").append(eol);
                    this.script.append("      if (useElementGroup != null) {").append(eol);
                    this.script.append("        for (var j = 0; j < useElementGroup.length; j++) {").append(eol);
                    this.script.append("         if(useElementGroup.item(j).getAttribute('xlink:href').substring(1,8) == 'flyover'){").append(eol);
                    this.script.append("\t\t\t\tuseElementGroup.item(j).setAttribute('visibility', state);").append(eol);
                    this.script.append("\t        }else{").append(eol);
                    this.script.append("\t\t        if(useElementGroup.item(j).getAttribute('visibility') == 'hidden'){").append(eol);
                    this.script.append("\t\t        \tstate = 'hidden';").append(eol);
                    this.script.append("        \t\t}").append(eol);
                    this.script.append("    \t\t}").append(eol);
                    this.script.append("        }").append(eol);
                    this.script.append("      }").append(eol);
                    this.script.append("    }").append(eol);
                    this.script.append("}").append(eol);
                }
            } else {
                type.equals("verticalStackedBar");
            }
        }
        this.script.append("function SVGGEN_isVisible(id) {").append(eol);
        this.script.append("  var obj = document.getElementById(id);").append(eol);
        this.script.append("  if (obj.getAttribute('visibility') == 'hidden') return false;").append(eol);
        this.script.append("  obj = obj.parentNode;").append(eol);
        this.script.append("  while (obj != document) {").append(eol);
        this.script.append("    if (obj.getAttribute('visibility') == 'hidden') return false;").append(eol);
        this.script.append("      obj = obj.parentNode;").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("  return true;").append(eol);
        this.script.append("}").append(eol);
        this.script.append("function SVGGEN_setVisibility(id, value) {").append(eol);
        this.script.append(" document.getElementById(id).setAttribute(\"visibility\",value);").append(eol);
        this.script.append("} ").append(eol);
        return this.script.toString();
    }

    public String generateXYChartHelperFunctions() {
        this.script = new StringBuffer("function SVGGEN_resizeAndRepositionTextBox(textBox, newX, newY, newWidth, newHeight) {");
        this.script.append(" textBox.setAttribute('x', newX);").append(eol);
        this.script.append(" textBox.setAttribute('y', newY);").append(eol);
        this.script.append("\ttextBox.setAttribute('width', newWidth);").append(eol);
        this.script.append("\ttextBox.setAttribute('height', newHeight);").append(eol);
        this.script.append("} ").append(eol);
        this.script.append("function resizeTextBox(textBox, newWidth, newHeight) {").append(eol);
        this.script.append("\ttextBox.setAttribute('width', newWidth);").append(eol);
        this.script.append("\ttextBox.setAttribute('height', newHeight);").append(eol);
        this.script.append("} ").append(eol);
        this.script.append("function repositionText(text, newX, newY) {").append(eol);
        this.script.append("\ttext.setAttribute('x', newX);").append(eol);
        this.script.append("\ttext.setAttribute('y', newY);").append(eol);
        this.script.append("} ").append(eol);
        return this.script.toString();
    }

    public String generatePieChartHelperFunctions() {
        this.script = new StringBuffer("");
        this.script.append("function SVGGEN_changeTextColour(bothElement, percentTextElement, exactTextElement, palette) {").append(eol);
        this.script.append("  for (var i = 0, j = palette.length - 1; i < percentTextElement.length; i++, j = palette.length - 1) {").append(eol);
        this.script.append("    if (((i+1) % j) == 0) {j = palette.length - 2;} else {j=((i+1)%j)-1;}").append(eol);
        this.script.append("    bothElement.item(i).setAttribute('style', \"fill:\" + palette[j]);").append(eol);
        this.script.append("\t   percentTextElement.item(i).setAttribute('style', \"fill:\" + palette[j]);").append(eol);
        this.script.append("\t   exactTextElement.item(i).setAttribute('style', \"fill:\" + palette[j]);").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("} ").append(eol);
        return this.script.toString();
    }

    public String generateResetStylesFunction() {
        this.script = new StringBuffer("function SVGGEN_resetStyles(){");
        this.script.append("SVGGEN_updateStyles(SVGGEN_currentValues, true);").append(eol);
        this.script.append("} ").append(eol);
        return this.script.toString();
    }

    public String generateUpdateLegendStylesFunction(int sets, String type) {
        this.script = new StringBuffer();
        this.script.append("function SVGGEN_updateLegendStyles(newStyles, preview) {").append(eol);
        this.script.append("var fontSize=parseInt(newStyles[1]);").append(eol);
        this.script.append("var group = document.getElementById('SVGGEN_legendTitle');").append(eol);
        this.script.append("if (group != null){").append(eol);
        this.script.append(" group.setAttribute(\"style\",\"font-size:\" + (fontSize + 2) + \"pt; \" + newStyles[2]);}").append(eol);
        this.script.append("for (var i = 0; i < " + sets + "; i++){").append(eol);
        this.script.append("var group = document.getElementById('SVGGEN_legendData' + i);").append(eol);
        this.script.append("if (group != null){").append(eol);
        this.script.append(" group.setAttribute(\"style\",\"font-size:\" + fontSize + \"pt; \" + newStyles[2]);}").append(eol);
        this.script.append("}").append(eol);
        this.script.append("var group = document.getElementById(\"legendFlyoverData\");").append(eol);
        this.script.append("if (group != null){").append(eol);
        this.script.append(" group.setAttribute(\"style\",\"font-size:\" + fontSize + \"pt; \" + newStyles[2]);}").append(eol);
        if (type.equals("line") || type.equals("area") || type.equals("scatter") || type.equals("stackedArea")) {
            this.script.append("for (var i = 0; i < " + sets + "; i++){").append(eol);
            this.script.append("  var squareshape = document.getElementById('SVGGEN_legendsquareshapeWithoutLine' + i);").append(eol);
            this.script.append("  var shape = document.getElementById('SVGGEN_legendShape' + i);").append(eol);
            this.script.append("  shape.setAttribute('visibility', (newStyles[3] == '0' ? 'hidden' : 'visible'));").append(eol);
            this.script.append("  squareshape.setAttribute('visibility', (newStyles[3] == '0' ? 'visible' : 'hidden'));").append(eol);
            this.script.append("}").append(eol);
        }
        this.script.append("}").append(eol);
        return this.script.toString();
    }

    public String generateUpdateStylesFunction(int sets, String cookieName, String type, boolean hasLegend, String updatedUserPrefsVarName, int numOfCategories, boolean showUserPref) {
        this.script = new StringBuffer();
        this.script.append("function SVGGEN_getTextElement(myGroup) { return myGroup.getElementsByTagName('text'); }").append(eol);
        this.script.append("function SVGGEN_updateStyles(newStyles, preview) {").append(eol);
        if (showUserPref) {
            this.script.append("if (newStyles == null || newStyles.length < 6) {return;}").append(eol);
            this.script.append("var paletteName=newStyles[0];").append(eol);
            this.script.append("var palette= SVGGEN_palettes[0];").append(eol);
            this.script.append("for (var i = 0; i < SVGGEN_palettes.length; i++) {").append(eol);
            this.script.append("if (SVGGEN_palettes[i][SVGGEN_palettes[i].length-1] == paletteName) {").append(eol);
            this.script.append(" palette = SVGGEN_palettes[i];}}").append(eol);
            this.script.append("for (var i=0, j=palette.length-1; i<" + sets + ";i++, j=palette.length-1) {").append(eol);
            this.script.append("  if (((i+1) % j) == 0) {j = palette.length - 2;} else {j=((i+1)%j)-1;}").append(eol);
            if (type.equals("horizontalStackedBar3D") || type.equals("verticalStackedBar3D")) {
                this.script.append("for (var y=0; y<" + numOfCategories + ";y++) {").append(eol);
                this.script.append("var group = document.getElementById(y+'SVGGEN_dataColour' + i);");
            } else {
                this.script.append("  var group = document.getElementById('SVGGEN_dataColour' + i);").append(eol);
            }
            this.script.append("  if (group != null){").append(eol);
            this.script.append("    group.setAttribute('style', 'stroke:' + palette[j] + '; fill:' + palette[j]);").append(eol);
            this.script.append("    var useElementGroup = group.getElementsByTagName('use');").append(eol);
            this.script.append("    if (useElementGroup != null) {").append(eol);
            this.script.append("      for (var k = 0; k < useElementGroup.length; k++) {").append(eol);
            this.script.append("        useElementGroup.item(k).setAttribute('style', 'stroke:' + palette[j] + '; fill:' + palette[j]);").append(eol);
            this.script.append("      }").append(eol);
            this.script.append("    }").append(eol);
            this.script.append("  }").append(eol);
            if (type.equals("horizontalStackedBar3D") || type.equals("verticalStackedBar3D")) {
                this.script.append("  }").append(eol);
            }
            if (type.equals("area") || type.equals("stackedArea")) {
                this.script.append("  var group = document.getElementById('SVGGEN_area' + i);").append(eol);
                this.script.append("  if (group != null){").append(eol);
                this.script.append("    group.setAttribute(\"style\",\"stroke:\" + palette[j] + \"; fill:\" + palette[j]);}").append(eol);
            }
            this.script.append("  group = document.getElementById('SVGGEN_legendsquareshapeWithoutLine' + i);").append(eol);
            this.script.append("  if (group != null){").append(eol);
            this.script.append("    group.setAttribute(\"style\",\"fill:\" + palette[j]);}").append(eol);
            this.script.append("  group = document.getElementById('SVGGEN_legendShape' + i);").append(eol);
            this.script.append("  if (group != null){").append(eol);
            this.script.append("    group.setAttribute(\"style\",\"fill:\" + palette[j]);}").append(eol);
            this.script.append("  group = document.getElementById(\"pieColour\" + i);").append(eol);
            this.script.append("  if (group != null){").append(eol);
            this.script.append("    group.setAttribute(\"style\", \"stroke:\" + \"black\" + \"; fill: \" + palette[j]);}").append(eol);
            this.script.append("  group = document.getElementById(\"percentValues\" + i);").append(eol);
            this.script.append("  if (group != null){").append(eol);
            this.script.append("    group.setAttribute(\"style\", \"stroke:\" + \"black\" + \"; fill: \" + palette[j]);}").append(eol);
            this.script.append("  group = document.getElementById(\"bothValues\" + i);").append(eol);
            this.script.append("  if (group != null){").append(eol);
            this.script.append("    group.setAttribute(\"style\", \"stroke:\" + palette[j] + \"; fill: \" + palette[j]);}").append(eol);
            this.script.append("  group = document.getElementById(\"line\" + i);").append(eol);
            this.script.append("  if (group != null){").append(eol);
            this.script.append("    group.setAttribute(\"style\", \"fill: \" + palette[j]);}").append(eol);
            this.script.append("}").append(eol);
        }
        this.script.append("var fontSize=parseInt(newStyles[1]);").append(eol);
        this.script.append("var group = document.getElementById('SVGGEN_graphTitle');").append(eol);
        this.script.append("var graphTitleStyle = 'font-weight:bold; ' + newStyles[2].substring(newStyles[2].indexOf('font-style'), newStyles[2].length);").append(eol);
        this.script.append("if (group != null){").append(eol);
        this.script.append(" group.setAttribute(\"style\",\"font-size:\" + (fontSize+3) + \"pt; \" + graphTitleStyle);}").append(eol);
        this.script.append("var group = document.getElementById('SVGGEN_timeStamp');").append(eol);
        this.script.append("if (group != null){").append(eol);
        this.script.append(" group.setAttribute(\"style\",\"font-size:\" + fontSize + \"pt; \");").append(eol);
        this.script.append(" group.setAttribute(\"y\", fontSize + 5);}").append(eol);
        this.script.append("SVGGEN_updateFontStyleAll(document, fontSize, newStyles[2]);").append(eol);
        if (!type.equals("meter")) {
            if (hasLegend) {
                this.script.append("SVGGEN_updateLegendStyles(newStyles, preview);").append(eol);
            }
            if (!type.equals("pie") && !type.equals("pie3D")) {
                this.script.append("var group = document.getElementById(\"dataValues0\");").append(eol);
                this.script.append("if (group != null){").append(eol);
                this.script.append(" group.setAttribute(\"style\",\"font-size:\" + fontSize + \"pt; \" + newStyles[2]);}").append(eol);
                this.script.append("var group = document.getElementById(\"dataValues1\");").append(eol);
                this.script.append("if (group != null){").append(eol);
                this.script.append(" group.setAttribute(\"style\",\"font-size:\" + fontSize + \"pt; \" + newStyles[2]);}").append(eol);
                this.script.append("var datasetGroup = document.getElementById('SVGGEN_datasetGroup');").append(eol);
                this.script.append("if (datasetGroup != null) {").append(eol);
                this.script.append("  if (newStyles[4] == 0) {").append(eol);
                this.script.append("    SVGGEN_toggleVisibilityDatavalue2(datasetGroup, 'hidden');").append(eol);
                this.script.append("  } else {").append(eol);
                this.script.append("    SVGGEN_toggleVisibilityDatavalue2(datasetGroup, 'visible');").append(eol);
                this.script.append("  }").append(eol);
                this.script.append("}").append(eol);
            } else {
                this.script.append("var group = document.getElementById(\"percentValues\");").append(eol);
                this.script.append("if (group != null){").append(eol);
                this.script.append(" group.setAttribute(\"style\",\"font-size:\" + fontSize + \"pt; \");}").append(eol);
                this.script.append("var bothGroup = document.getElementById(\"bothValues\");").append(eol);
                this.script.append("if (bothGroup != null){").append(eol);
                this.script.append(" bothGroup.setAttribute(\"style\",\"font-size:\" + fontSize + \"pt; \");}").append(eol);
            }
            this.script.append("var group = document.getElementById('SVGGEN_labelsValues0');").append(eol);
            this.script.append("if (group != null){").append(eol);
            this.script.append(" group.setAttribute(\"style\",\"text-anchor:middle; font-size:\" + (fontSize+2) + \"pt; \" + newStyles[2]);}").append(eol);
            this.script.append("var group = document.getElementById('SVGGEN_labelsValues1');").append(eol);
            this.script.append("if (group != null){").append(eol);
            this.script.append(" group.setAttribute(\"style\",\"font-size:\" + (fontSize+2) + \"pt; \" + newStyles[2]);}").append(eol);
            this.script.append("var group = document.getElementById('SVGGEN_labelsValues2');").append(eol);
            this.script.append("if (group != null){").append(eol);
            this.script.append(" group.setAttribute(\"style\",\"font-size:\" + (fontSize+2) + \"pt; \" + newStyles[2]);}").append(eol);
            this.script.append("var group = document.getElementById(\"exactValues\");").append(eol);
            this.script.append("if (group != null){").append(eol);
            this.script.append(" group.setAttribute(\"style\",\"font-size:\" + fontSize + \"pt; \");}").append(eol);
        } else {
            this.script.append("var rateDefStyle = newStyles[2].substring(newStyles[2].indexOf('font-style'), newStyles[2].length);").append(eol);
            this.script.append("var group = document.getElementById(\"minmaxRate\");").append(eol);
            this.script.append("if (group != null){").append(eol);
            this.script.append(" group.setAttribute(\"style\",\"font-size:\" + (fontSize) + \"pt; \" + rateDefStyle);}").append(eol);
            this.script.append("var group = document.getElementById(\"rateDefinition\");").append(eol);
            this.script.append("if (group != null){").append(eol);
            this.script.append(" group.setAttribute(\"style\",\"font-size:\" + (fontSize) + \"pt; \" + rateDefStyle);}").append(eol);
            this.script.append("var group = document.getElementById(\"critDiv\");").append(eol);
            this.script.append("if (group != null){").append(eol);
            this.script.append(" group.setAttribute(\"style\",\"font-size:\" + (fontSize) + \"pt; \");}").append(eol);
            this.script.append("var group = document.getElementById(\"meterLabel\");").append(eol);
            this.script.append("if (group != null){ ").append(eol);
            this.script.append("   var tmpText = group.getElementsByTagName('text');").append(eol);
            this.script.append("   for (var i = 0; i < tmpText.length; i++) {").append(eol);
            this.script.append("     tmpText.item(i).setAttribute('style', 'font-size: ' + (fontSize) + 'pt; ');").append(eol);
            this.script.append("   }").append(eol);
            this.script.append("}").append(eol);
        }
        if (type.equals("line") || type.equals("area") || type.equals("scatter") || type.equals("stackedArea")) {
            this.script.append("for (var i = 0; i < " + sets + "; i++){").append(eol);
            this.script.append("  var group = document.getElementById('SVGGEN_dataColour' + i);").append(eol);
            this.script.append("  if (group != null) {").append(eol);
            this.script.append("    var useElementGroup = group.getElementsByTagName('use');").append(eol);
            this.script.append("    if (useElementGroup != null) {").append(eol);
            this.script.append("      for (var j = 0; j < useElementGroup.length; j++) {").append(eol);
            if (type.equals("scatter")) {
                this.script.append("       if(useElementGroup.item(j).getAttribute('id') == null || useElementGroup.item(j).getAttribute('id').substring(0,18) != 'SVGGEN_shadowShape'){").append(eol);
                this.script.append("\t        useElementGroup.item(j).setAttribute('visibility', (newStyles[3] == '1' && SVGGEN_isVisible('SVGGEN_dataColour'+i) ? 'visible' : 'hidden') );").append(eol);
                this.script.append("\t      }").append(eol);
            } else {
                this.script.append("        useElementGroup.item(j).setAttribute('visibility', (newStyles[3] == '1' && SVGGEN_isVisible('SVGGEN_dataColour'+i) ? 'visible' : 'hidden') );").append(eol);
            }
            this.script.append("      }").append(eol);
            this.script.append("    }").append(eol);
            this.script.append("  }").append(eol);
            this.script.append("  SVGGEN_noShapes = newStyles[3] == '0' ? true : false;").append(eol);
            this.script.append("}").append(eol);
        }
        if (type.equals("pie") || type.equals("pie3D")) {
            this.script.append("var bothGroup=document.getElementById('bothValues');var perGroup=document.getElementById('percentValues');var eGroup=document.getElementById('exactValues');").append(eol);
            this.script.append("if (bothGroup != null)").append(eol);
            this.script.append("  SVGGEN_changeTextColour(SVGGEN_getTextElement(bothGroup), SVGGEN_getTextElement(perGroup), SVGGEN_getTextElement(eGroup), palette);").append(eol);
            this.script.append("SVGGEN_toggleVisibilityDatavaluePie2(document, 'hidden');").append(eol);
            this.script.append("SVGGEN_values = (newStyles[4] == '0' ? 0 : 1);").append(eol);
            this.script.append("SVGGEN_percents = (newStyles[5] == '0' ? 0 : 1);").append(eol);
            this.script.append("if (SVGGEN_values == 1 || SVGGEN_percents == 1)").append(eol);
            this.script.append("  SVGGEN_toggleVisibilityDatavaluePie2(document, 'visible');").append(eol);
        } else if (type.equals("line") || type.equals("area") || type.equals("scatter") || type.equals("stackedArea")) {
            this.script.append("for (var i = 0; i < ").append(sets).append("; i++) {").append(eol);
            this.script.append("  if (document.getElementById(\"textbox\" + i) != null) {").append(eol);
            this.script.append("    SVGGEN_textboxState[i] = parseInt(newStyles[4]);").append(eol);
            this.script.append("    if (SVGGEN_isVisible('dataColour'+i)) {").append(eol);
            this.script.append("      SVGGEN_setVisibility(\"textbox\"+i, newStyles[4]=='0' ? 'hidden':'visible');").append(eol);
            this.script.append("      var number = 0; ").append(eol);
            this.script.append("      while ((hoverBoxElement = svgDocument.getElementById(\"textboxRect\" + i + number)) != null) {").append(eol);
            this.script.append("        var hoverBoxText = svgDocument.getElementById('textboxText' + i + number);").append(eol);
            this.script.append("        if (hoverBoxText != null) {").append(eol);
            this.script.append("          hoverBoxText.setAttribute('visibility', (parseInt(newStyles[4]) == 0 ? 'hidden':'visible') );").append(eol);
            this.script.append("          hoverBoxElement.setAttribute('visibility', (parseInt(newStyles[4]) == 0 ? 'hidden':'visible') );").append(eol);
            this.script.append("        }").append(eol);
            this.script.append("        number++;").append(eol);
            this.script.append("      }").append(eol);
            this.script.append("    }").append(eol);
            this.script.append("\t }").append(eol);
            this.script.append("}").append(eol);
        } else if (type.equals("verticalStackedBar")) {
            this.script.append("var showAllState = newStyles[4]=='0' ? 'hidden':'visible';").append(eol);
            this.script.append("var eGroup = document.getElementById('exactValues');").append(eol);
            this.script.append("if (eGroup!=null) {eGroup.setAttribute('visibility',showAllState);}").append(eol);
            this.script.append("for (var i = 0; i < ").append(sets).append("; i++) {").append(eol);
            this.script.append("  if (document.getElementById(\"textbox\" + i) != null) {").append(eol);
            this.script.append("    SVGGEN_setVisibility(\"textbox\"+i, showAllState);").append(eol);
            this.script.append("      var number = 0;").append(eol);
            this.script.append("      while (svgDocument.getElementById('textboxText' + i + number) != null) {").append(eol);
            this.script.append("        SVGGEN_setVisibility('textboxText' + i + number, showAllState);").append(eol);
            this.script.append("        SVGGEN_setVisibility('textboxRect' + i + number, showAllState);").append(eol);
            this.script.append("        number++;").append(eol);
            this.script.append("      }").append(eol);
            this.script.append("  }").append(eol);
            this.script.append("}").append(eol);
        } else if (!type.equals("meter")) {
            this.script.append("var eGroup = document.getElementById(\"exactValues\");").append(eol);
            this.script.append("if (eGroup != null){").append(eol);
            this.script.append("eGroup.setAttribute('visibility', (newStyles[4]=='0'? 'hidden':'visible') );").append(eol);
            this.script.append("}").append(eol);
        }
        this.script.append("if (!preview) {for(var i=0; i<6; i++) {SVGGEN_currentValues[i] = newStyles[i];}").append(eol);
        if (cookieName != null) {
            this.script.append("SVGGEN_storePreferences(SVGGEN_currentValues);").append(eol);
        }
        if (updatedUserPrefsVarName != null) {
            this.script.append("  top.");
            this.script.append(updatedUserPrefsVarName);
            this.script.append(" = SVGGEN_getUserPreferences();").append(eol);
        }
        this.script.append("} }").append(eol);
        this.script.append("function SVGGEN_updateFontStyleAll(obj, fontSize, style) {").append(eol);
        this.script.append("  if (obj.nodeName == 'text') {").append(eol);
        this.script.append("    if (obj.getAttribute('id') != null && obj.getAttribute('id').substring(0,16) == 'SVGGEN_axisLabel'){").append(eol);
        this.script.append("      obj.setAttribute('style','font-size:' + fontSize + 'pt; ' + style);").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("  else {").append(eol);
        this.script.append("    var nodes = obj.childNodes;").append(eol);
        this.script.append("    var node;").append(eol);
        this.script.append("    for (var i=0; i<nodes.length; i++) {").append(eol);
        this.script.append("      node = nodes.item(i);").append(eol);
        this.script.append("      SVGGEN_updateFontStyleAll(node, fontSize, style);").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("}").append(eol);
        return this.script.toString();
    }

    public String generateGetPreferencesFunction(String name) {
        String cookie = name;
        this.script = new StringBuffer("function SVGGEN_getPreferences() {");
        this.script.append("var value = SVGGEN_get_Cookie(\"");
        this.script.append(cookie);
        this.script.append("\");").append(eol);
        this.script.append("if (value != null) {").append(eol);
        this.script.append("return value.split(\"&\");").append(eol);
        this.script.append("} else {").append(eol);
        this.script.append("return null;}").append(eol);
        this.script.append("}").append(eol);
        return this.script.toString();
    }

    public String generateStorePreferencesFunction(String name) {
        String cookie = name;
        this.script = new StringBuffer("function SVGGEN_storePreferences(storevalues) {");
        this.script.append("var value = '';").append(eol);
        this.script.append("for (var i = 0; i < storevalues.length -1; i++) {").append(eol);
        this.script.append("  value += storevalues[i] + \"&\";").append(eol);
        this.script.append("}").append(eol);
        this.script.append("value += storevalues[storevalues.length-1];").append(eol);
        this.script.append("SVGGEN_set_Cookie('");
        this.script.append(cookie);
        this.script.append("', value, SVGGEN_expires_date, '/');").append(eol);
        this.script.append("}").append(eol);
        return this.script.toString();
    }

    public String generateGetUserPreferencesFunction() {
        this.script = new StringBuffer("function SVGGEN_getUserPreferences()");
        this.script.append("{var value = '';").append(eol);
        this.script.append("for (var i = 0; i < SVGGEN_currentValues.length -1; i++) {").append(eol);
        this.script.append("  value += SVGGEN_currentValues[i] + \",\";").append(eol);
        this.script.append("}").append(eol);
        this.script.append("value += SVGGEN_currentValues[SVGGEN_currentValues.length-1];").append(eol);
        this.script.append("return value;").append(eol);
        this.script.append("}").append(eol);
        return this.script.toString();
    }

    public String generateInspectFunction() {
        this.script = new StringBuffer("function SVGGEN_inspect(obj)");
        this.script.append("{var output=\"\";").append(eol);
        this.script.append("if(obj==null){").append(eol);
        this.script.append("return null;} ").append(eol);
        this.script.append("else{").append(eol);
        this.script.append("for(var i in obj){").append(eol);
        this.script.append(" output += i + \" : \" + obj[i] + \"\\n\";}").append(eol);
        this.script.append("return output;}").append(eol);
        this.script.append("} ").append(eol);
        return this.script.toString();
    }

    public String generateCookieFunctions() {
        this.script = new StringBuffer("var SVGGEN_today= new Date();");
        this.script.append("var SVGGEN_expires_date= new Date(SVGGEN_today.getTime() + (365 * 24 * 60 * 60 * 1000));").append(eol);
        this.script.append("function SVGGEN_get_Cookie(name){").append(eol);
        this.script.append("  if ((SVGGEN_isNN && SVGGEN_browserVersion <= 4) && hasSVGCookieSupport) {").append(eol);
        this.script.append("     return get_NNCookie(name);").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("  else if ((SVGGEN_isIE || (SVGGEN_isNN && SVGGEN_browserVersion > 4)) && top.document.cookie != null) {").append(eol);
        this.script.append("    var start = top.document.cookie.indexOf(name+\"=\");").append(eol);
        this.script.append("    var len = start+name.length+1;").append(eol);
        this.script.append("    if ((!start) && (name != top.document.cookie.substring(0,name.length))) return null;").append(eol);
        this.script.append("    if (start == -1) return null;").append(eol);
        this.script.append("    var end = top.document.cookie.indexOf(\";\",len);").append(eol);
        this.script.append("    if (end == -1) end = top.document.cookie.length;").append(eol);
        this.script.append("    return unescape(top.document.cookie.substring(len,end));").append(eol);
        this.script.append("  } ").append(eol);
        this.script.append("  else {").append(eol);
        this.script.append("     return null;").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("} ").append(eol);
        this.script.append("function SVGGEN_set_Cookie(name,value,expires,path,domain,secure){").append(eol);
        this.script.append("  if ((SVGGEN_isNN && SVGGEN_browserVersion <= 4) && hasSVGCookieSupport) {").append(eol);
        this.script.append("    set_NNCookie(name,value,expires,path,domain,secure);").append(eol);
        this.script.append("  } ").append(eol);
        this.script.append("  else if (SVGGEN_isIE || (SVGGEN_isNN && SVGGEN_browserVersion > 4)) { ").append(eol);
        this.script.append("    top.document.cookie = name + \"=\" +escape(value) + ").append(eol);
        this.script.append("    ((expires) ? \";expires=\" + expires.toGMTString() : \"\") +").append(eol);
        this.script.append("    ((path) ? \";path=\" + path : \"\") + ").append(eol);
        this.script.append("    ((domain) ? \";domain=\" + domain : \"\") + ").append(eol);
        this.script.append("    ((secure) ? \";secure\" : \"\");").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("}").append(eol);
        return this.script.toString();
    }

    public String generateChangeOpacity() {
        this.script = new StringBuffer("function SVGGEN_ChangeOpacity(id,NewOpacity){").append(eol);
        this.script.append(" if (document.getElementById(id)){").append(eol);
        this.script.append(" var group = 'fill-opacity:'+ NewOpacity + '; stroke: black; stroke-width: 0;';").append(eol);
        this.script.append(" document.getElementById(id).setAttribute(\"style\", group);").append(eol);
        this.script.append("} ").append(eol);
        this.script.append("} ").append(eol);
        return this.script.toString();
    }

    public String generateFunctionFlyOver() {
        this.script = new StringBuffer("function SVGGEN_FlyOver(id, i, bBoxId){").append(eol);
        this.script.append("\tvar forXPosition = svgDocument.getElementById(\"flyOverText\" + id + bBoxId);").append(eol);
        this.script.append("\tvar forYPosition = svgDocument.getElementById(\"flyOverText\" + id + 0);").append(eol);
        this.script.append("\tvar xbbox;").append(eol);
        this.script.append("\tvar ybbox;").append(eol);
        this.script.append("\tfor (j=0;j<i;j++)").append(eol);
        this.script.append(" \t{").append(eol);
        this.script.append("\t\tvar flyOverText = svgDocument.getElementById(\"flyOverText\" + id + j);").append(eol);
        this.script.append("\t\tflyOverText.setAttribute('visibility', 'visible');").append(eol);
        this.script.append("\t}").append(eol);
        this.script.append("\tif (forXPosition != null)").append(eol);
        this.script.append(" {").append(eol);
        this.script.append("   xbbox = forXPosition.getBBox();").append(eol);
        this.script.append("   ybbox = forYPosition.getBBox();").append(eol);
        this.script.append("\t}").append(eol);
        this.script.append("\tfor (j=0;j<i;j++)").append(eol);
        this.script.append(" \t{").append(eol);
        this.script.append("\t\tvar flyOverText = svgDocument.getElementById(\"flyOverText\" + id + j);").append(eol);
        this.script.append("\t\tif (j != bBoxId)").append(eol);
        this.script.append(" \t{").append(eol);
        this.script.append("\t\t\tflyOverText.setAttribute('x', xbbox.x);").append(eol);
        this.script.append("\t\t}").append(eol);
        this.script.append("\t\t\tflyOverText.setAttribute('y', ybbox.y + (ybbox.height*(j+1)) + 2*(j+1));").append(eol);
        this.script.append("\t}").append(eol);
        this.script.append(" var flyOverBoxElement = svgDocument.getElementById(\"flyOverBox\"  + id);").append(eol);
        this.script.append(" if (flyOverBoxElement != null && xbbox != null)").append(eol);
        this.script.append(" {").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('x', xbbox.x - 3);").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('y', ybbox.y - 3);").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('width', xbbox.width + 6);").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('height', (xbbox.height*(i+1))+(2*i));").append(eol);
        this.script.append(" }").append(eol);
        this.script.append(" var flyOverGroup = svgDocument.getElementById(\"flyOverGroup\" + id);").append(eol);
        this.script.append(" if (flyOverGroup != null)").append(eol);
        this.script.append(" {").append(eol);
        this.script.append("  flyOverGroup.setAttribute('visibility', 'visible');").append(eol);
        this.script.append(" }").append(eol);
        this.script.append(" }").append(eol);
        this.script.append("function SVGGEN_FlyOut(id, i, bBoxId, y){");
        this.script.append("\tvar forXYPosition = svgDocument.getElementById(\"flyOverText\" + id + bBoxId);").append(eol);
        this.script.append("for (j=0;j<i;j++){").append(eol);
        this.script.append("\tvar flyOverText = svgDocument.getElementById(\"flyOverText\" + id + j);").append(eol);
        this.script.append("\tflyOverText.setAttribute('visibility', 'hidden');").append(eol);
        this.script.append("\tflyOverText.setAttribute('y', y+(12*j));").append(eol);
        this.script.append("}").append(eol);
        this.script.append("var bbox;").append(eol);
        this.script.append("\tif (forXYPosition != null)").append(eol);
        this.script.append(" {").append(eol);
        this.script.append("   bbox = forXYPosition.getBBox();").append(eol);
        this.script.append("\t}").append(eol);
        this.script.append(" var flyOverBoxElement = svgDocument.getElementById(\"flyOverBox\"  + id);").append(eol);
        this.script.append(" if (flyOverBoxElement != null && bbox != null)").append(eol);
        this.script.append(" {").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('x', bbox.x - 2);").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('y', bbox.y - 4);").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('width', bbox.width + 8);").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('height', bbox.height + (12*i));").append(eol);
        this.script.append(" }").append(eol);
        this.script.append(" var flyOverGroup = svgDocument.getElementById(\"flyOverGroup\" + id);").append(eol);
        this.script.append(" if (flyOverGroup != null)").append(eol);
        this.script.append(" {").append(eol);
        this.script.append("  flyOverGroup.setAttribute('visibility', 'hidden');").append(eol);
        this.script.append(" }").append(eol);
        this.script.append(" }").append(eol);
        return this.script.toString();
    }

    public String generateFunctionPrefFlyOver() {
        this.script = new StringBuffer("function SVGGEN_PrefFlyOver(){");
        this.script.append("var flyOverText = svgDocument.getElementById(\"hoverBoxText\");").append(eol);
        this.script.append("flyOverText.setAttribute('visibility', 'visible');").append(eol);
        this.script.append("var bbox;").append(eol);
        this.script.append("\tif (flyOverText != null)").append(eol);
        this.script.append(" {").append(eol);
        this.script.append("   bbox = flyOverText.getBBox();").append(eol);
        this.script.append("\t}").append(eol);
        this.script.append(" var flyOverBoxElement = svgDocument.getElementById(\"hoverBox\");").append(eol);
        this.script.append(" if (flyOverBoxElement != null && bbox != null)").append(eol);
        this.script.append(" {").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('x', bbox.x - 3);").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('y', bbox.y - 3);").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('width', bbox.width + 6);").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('height', bbox.height + 6);").append(eol);
        this.script.append(" }").append(eol);
        this.script.append(" var flyOverGroup = svgDocument.getElementById(\"preferencesHoverText\");").append(eol);
        this.script.append(" if (flyOverGroup != null)").append(eol);
        this.script.append(" {").append(eol);
        this.script.append("  flyOverGroup.setAttribute('visibility', 'visible');").append(eol);
        this.script.append(" }").append(eol);
        this.script.append(" }").append(eol);
        this.script.append("function SVGGEN_PrefFlyOut(){");
        this.script.append("var flyOverText = svgDocument.getElementById(\"hoverBoxText\");").append(eol);
        this.script.append("flyOverText.setAttribute('visibility', 'hidden');").append(eol);
        this.script.append("var bbox;").append(eol);
        this.script.append("\tif (flyOverText != null)").append(eol);
        this.script.append(" {").append(eol);
        this.script.append("   bbox = flyOverText.getBBox();").append(eol);
        this.script.append("\t}").append(eol);
        this.script.append(" var flyOverBoxElement = svgDocument.getElementById(\"hoverBox\");").append(eol);
        this.script.append(" if (flyOverBoxElement != null && bbox != null)").append(eol);
        this.script.append(" {").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('x', bbox.x - 3);").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('y', bbox.y - 3);").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('width', bbox.width + 6);").append(eol);
        this.script.append("   flyOverBoxElement.setAttribute('height', bbox.height + 6);").append(eol);
        this.script.append(" }").append(eol);
        this.script.append(" var flyOverGroup = svgDocument.getElementById(\"preferencesHoverText\");").append(eol);
        this.script.append(" if (flyOverGroup != null)").append(eol);
        this.script.append(" {").append(eol);
        this.script.append("  flyOverGroup.setAttribute('visibility', 'hidden');").append(eol);
        this.script.append(" }").append(eol);
        this.script.append(" }").append(eol);
        return this.script.toString();
    }

    public String generateTooltipScripts() {
        this.script = new StringBuffer();
        this.script.append("function SVGGEN_setToolTipSize(tooltip, x, y, w,h) {").append(eol);
        this.script.append("  var nodes = tooltip.childNodes;").append(eol);
        this.script.append("  for (var i=0; i<nodes.length; i++) {").append(eol);
        this.script.append("    node = nodes.item(i);").append(eol);
        this.script.append("    if (node.nodeName == 'rect') {").append(eol);
        this.script.append("      node.setAttribute('x', parseFloat(x) - 3);").append(eol);
        this.script.append("      node.setAttribute('y', parseFloat(y) - 3);").append(eol);
        this.script.append("      node.setAttribute('width', parseFloat(w) + 6);").append(eol);
        this.script.append("      node.setAttribute('height', parseFloat(h) + 6);").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("}").append(eol);
        this.script.append("function SVGGEN_getChildByNodeName(obj, name) {").append(eol);
        this.script.append("  var nodes = obj.childNodes;").append(eol);
        this.script.append("  var node;").append(eol);
        this.script.append("  for (var i=0; i<nodes.length; i++) {").append(eol);
        this.script.append("    node = nodes.item(i);").append(eol);
        this.script.append("    if (node.nodeName == name) break;").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("  return node;").append(eol);
        this.script.append("}").append(eol);
        this.script.append("function SVGGEN_showTooltip(evt, tooltipId) {").append(eol);
        this.script.append("\t\t\t   //Get text value").append(eol);
        this.script.append("\t\t\t   var svgDocument = evt.target.ownerDocument;").append(eol);
        this.script.append("\t\t\t   var contentNode = svgDocument.getElementById(tooltipId+'text');").append(eol);
        this.script.append("\t\t\t   var text = ' ';").append(eol);
        this.script.append("\t\t\t   if (contentNode != null) {").append(eol);
        this.script.append("\t\t\t     text = SVGGEN_getChildByNodeName(contentNode, '#text').nodeValue;").append(eol);
        this.script.append("\t\t\t   }").append(eol);
        this.script.append("\t\t\t   ").append(eol);
        this.script.append("\t\t\t   x = evt.clientX;").append(eol);
        this.script.append("\t\t\t   y = evt.clientY;").append(eol);
        this.script.append("\t\t\t   if (typeof this.group == 'undefined'){").append(eol);
        this.script.append("\t\t\t   this.height = 15;").append(eol);
        this.script.append("\t\t\t   this.root = svgDocument.getElementById(\"SVGGEN_tooltips\");").append(eol);
        this.script.append("\t\t\t   this.xPadding = 5;").append(eol);
        this.script.append("\t\t\t   var off = svgDocument.rootElement.currentTranslate;").append(eol);
        this.script.append("\t\t\t   var scl = svgDocument.rootElement.currentScale;").append(eol);
        this.script.append("\t\t\t   var translateX = (((x+14)-off.x)/scl);").append(eol);
        this.script.append("\t\t\t   var translateY = (((y-20)-off.y)/scl);").append(eol);
        this.script.append("\t\t\t   var group = new BuildHelper(\"g\");").append(eol);
        this.script.append("\t\t\t   group.addToParent(this.root);").append(eol);
        this.script.append("\t\t\t   var rectangle = new BuildHelper(\"rect\", ").append(eol);
        this.script.append("\t\t\t     {id:\"test\",").append(eol);
        this.script.append("\t\t\t      x: 0,").append(eol);
        this.script.append("\t\t\t      y: 0,").append(eol);
        this.script.append("\t\t\t      height: 15,").append(eol);
        this.script.append("\t\t\t      style: \"fill:#FFFFCC;stroke:gray;stroke-width:1;\"").append(eol);
        this.script.append("\t\t\t } );").append(eol);
        this.script.append("\t\t\t   ").append(eol);
        this.script.append("\t\t\t   rectangle.addToParent(group.element);").append(eol);
        this.script.append("\t\t\t   this.text = new BuildHelper(\"text\", ").append(eol);
        this.script.append("\t\t\t     {id:\"tooltip\",").append(eol);
        this.script.append("\t\t\t      x: this.xPadding,").append(eol);
        this.script.append("\t\t\t      y: (15/2+4),").append(eol);
        this.script.append("\t\t\t      classType: \"tooltip\"").append(eol);
        this.script.append("\t\t\t },text);").append(eol);
        this.script.append("\t\t\t   this.text.addToParent(group.element);").append(eol);
        this.script.append("\t\t\t   var itemlength =this.text.element.getComputedTextLength();").append(eol);
        this.script.append("\t\t\t   rectangle.element.setAttributeNS(null, \"width\", (itemlength+2*this.xPadding));").append(eol);
        this.script.append("\t\t\t   var tooltipHeight = 15;").append(eol);
        this.script.append("\t\t\t   var xdiff = 0;").append(eol);
        this.script.append("\t\t\t   var chartWidth = SVGGEN_getChartWidth();").append(eol);
        this.script.append("\t\t\t   if ((x + itemlength) <= chartWidth) {").append(eol);
        this.script.append("\t\t\t        xdiff = translateX;").append(eol);
        this.script.append("\t\t\t   }").append(eol);
        this.script.append("\t\t\t   else").append(eol);
        this.script.append("\t\t\t        xdiff = chartWidth - parseFloat(itemlength+2*this.xPadding);").append(eol);
        this.script.append("\t\t\t   var ydiff = translateY;").append(eol);
        this.script.append("\t\t\t   if ((y - tooltipHeight ) < 0) {").append(eol);
        this.script.append("\t\t\t        ydiff = y + tooltipHeight;").append(eol);
        this.script.append("\t\t\t   }").append(eol);
        this.script.append("\t\t\t   group.element.setAttributeNS(null, \"transform\", \"translate(\" + xdiff + \",\" + ydiff + \")\");").append(eol);
        this.script.append("\t\t\t  }").append(eol);
        this.script.append("\t\t\t  this.group = group;").append(eol);
        this.script.append("}").append(eol);
        this.script.append("function SVGGEN_hideTooltip(evt, tooltipId) {").append(eol);
        this.script.append("\t\t   if (typeof this.group != 'undefined'){").append(eol);
        this.script.append("\t\t\t  this.group.removeNode();").append(eol);
        this.script.append("\t\t   \t  this.group = undefined;").append(eol);
        this.script.append("\t\t } ").append(eol);
        this.script.append("}").append(eol);
        this.script.append("function SVGGEN_toggleVisibility(obj, visibility) {").append(eol);
        this.script.append("  obj.setAttribute('visibility', visibility);").append(eol);
        this.script.append("  var nodes = obj.childNodes;").append(eol);
        this.script.append("  for (var i=0; i<nodes.length; i++) {").append(eol);
        this.script.append("    var node = nodes.item(i);").append(eol);
        this.script.append("    if (node.nodeName == 'rect' || node.nodeName == 'text') {").append(eol);
        this.script.append("      node.setAttribute('visibility', visibility);").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("}").append(eol);
        this.script.append("function SVGGEN_getChartWidth() {").append(eol);
        this.script.append("  var boundary = document.getElementById('SVGGEN_boundary');").append(eol);
        this.script.append("  return boundary.getAttribute('width');").append(eol);
        this.script.append("}").append(eol);
        return this.script.toString();
    }

    public String generateToggleVisibilityDataset() {
        this.script = new StringBuffer();
        this.script.append("var SVGGEN_dataValuesVisible = false;").append(eol);
        this.script.append("function SVGGEN_toggleVisibilityDataset(evt, id) {").append(eol);
        this.script.append("  var svgDoc = evt.target.ownerDocument;").append(eol);
        this.script.append("  if (svgDoc != null) {").append(eol);
        this.script.append("    var obj = svgDoc.getElementById(id);").append(eol);
        this.script.append("    var foreobj = svgDoc.getElementById('SVGGEN_plotareaForeground_'+id);");
        this.script.append("    if (obj != null) {").append(eol);
        this.script.append("      var v1 = obj.getAttribute('visibility');").append(eol);
        this.script.append("      var v2;").append(eol);
        this.script.append("      if (v1 == 'hidden') {").append(eol);
        this.script.append("         v2 = 'visible';").append(eol);
        this.script.append("         SVGGEN_showDatasetValues(obj);").append(eol);
        this.script.append("      } else {").append(eol);
        this.script.append("         v2 = 'hidden';").append(eol);
        this.script.append("         SVGGEN_hideDatasetValues(obj);").append(eol);
        this.script.append("      }").append(eol);
        this.script.append("      if (foreobj != null)");
        this.script.append("         foreobj.setAttribute('visibility', v2);");
        this.script.append("      obj.setAttribute('visibility', v2);").append(eol);
        this.script.append("      var useElementGroup = obj.getElementsByTagName('use');").append(eol);
        this.script.append("      if (useElementGroup != null) {").append(eol);
        this.script.append("        var v3 = (v2 == 'visible' && SVGGEN_noShapes == false) ? 'visible' : 'hidden';").append(eol);
        this.script.append("        for (var j = 0; j < useElementGroup.length; j++) {").append(eol);
        this.script.append("          useElementGroup.item(j).setAttribute('visibility', v3);").append(eol);
        this.script.append("        }").append(eol);
        this.script.append("      }").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("}").append(eol);
        this.script.append("function SVGGEN_hideDatasetValues(obj) {").append(eol);
        this.script.append("  if (obj.nodeName == 'text') {").append(eol);
        this.script.append("    if (obj.getAttribute('id').substring(0,16) == 'SVGGEN_datavalue') {").append(eol);
        this.script.append("      obj.setAttribute('visibility', 'hidden');").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("  else {").append(eol);
        this.script.append("    var nodes = obj.childNodes;").append(eol);
        this.script.append("    var node;").append(eol);
        this.script.append("    for (var i=0; i<nodes.length; i++) {").append(eol);
        this.script.append("      node = nodes.item(i);").append(eol);
        this.script.append("      SVGGEN_hideDatasetValues(node);").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("}").append(eol);
        this.script.append("function SVGGEN_showDatasetValues(obj) {").append(eol);
        this.script.append("  if (SVGGEN_dataValuesVisible == false) return;").append(eol);
        this.script.append("  if (obj.nodeName == 'text') {").append(eol);
        this.script.append("    if (obj.getAttribute('id').substring(0,16) == 'SVGGEN_datavalue') {").append(eol);
        this.script.append("      obj.setAttribute('visibility', 'visible');").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("  else {").append(eol);
        this.script.append("    var nodes = obj.childNodes;").append(eol);
        this.script.append("    var node;").append(eol);
        this.script.append("    for (var i=0; i<nodes.length; i++) {").append(eol);
        this.script.append("      node = nodes.item(i);").append(eol);
        this.script.append("      SVGGEN_showDatasetValues(node);").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("}").append(eol);
        return this.script.toString();
    }

    public String generateToggleVisibilityDatasetScatter() {
        this.script = new StringBuffer();
        this.script.append("var SVGGEN_dataValuesVisible = false;").append(eol);
        this.script.append("function SVGGEN_toggleVisibilityDataset(evt, id, shadowID) {").append(eol);
        this.script.append("  var svgDoc = evt.target.ownerDocument;").append(eol);
        this.script.append("  if (svgDoc != null) {").append(eol);
        this.script.append("    var obj = svgDoc.getElementById(id);").append(eol);
        this.script.append("    if (obj != null) {").append(eol);
        this.script.append("      var v1 = obj.getAttribute('visibility');").append(eol);
        this.script.append("      var v2;").append(eol);
        this.script.append("      if (v1 == 'hidden') {").append(eol);
        this.script.append("         v2 = 'visible';").append(eol);
        this.script.append("         SVGGEN_showDatasetValues(obj);").append(eol);
        this.script.append("      } else {").append(eol);
        this.script.append("         v2 = 'hidden';").append(eol);
        this.script.append("         SVGGEN_hideDatasetValues(obj);").append(eol);
        this.script.append("      }").append(eol);
        this.script.append("      obj.setAttribute('visibility', v2);").append(eol);
        this.script.append("      var useElementGroup = obj.getElementsByTagName('use');").append(eol);
        this.script.append("      if (useElementGroup != null) {").append(eol);
        this.script.append("        if (!SVGGEN_noShapes) {").append(eol);
        this.script.append("        for (var j = 0; j < useElementGroup.length; j++) {").append(eol);
        this.script.append("          if(useElementGroup.item(j).getAttribute('id') == null || useElementGroup.item(j).getAttribute('id').substring(0,18) != 'SVGGEN_shadowShape'){").append(eol);
        this.script.append("            useElementGroup.item(j).setAttribute('visibility', v2);").append(eol);
        this.script.append("          }").append(eol);
        this.script.append("        }").append(eol);
        this.script.append("        }").append(eol);
        this.script.append("      }").append(eol);
        this.script.append("      SVGGEN_toggleVisibilityShadow(evt, shadowID, v2);").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("}").append(eol);
        this.script.append("function SVGGEN_hideDatasetValues(obj) {").append(eol);
        this.script.append("  if (obj.nodeName == 'text') {").append(eol);
        this.script.append("    if (obj.getAttribute('id').substring(0,16) == 'SVGGEN_datavalue') {").append(eol);
        this.script.append("      obj.setAttribute('visibility', 'hidden');").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("  else {").append(eol);
        this.script.append("    var nodes = obj.childNodes;").append(eol);
        this.script.append("    var node;").append(eol);
        this.script.append("    for (var i=0; i<nodes.length; i++) {").append(eol);
        this.script.append("      node = nodes.item(i);").append(eol);
        this.script.append("      SVGGEN_hideDatasetValues(node);").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("}").append(eol);
        this.script.append("function SVGGEN_showDatasetValues(obj) {").append(eol);
        this.script.append("  if (SVGGEN_dataValuesVisible == false) return;").append(eol);
        this.script.append("  if (obj.nodeName == 'text') {").append(eol);
        this.script.append("    if (obj.getAttribute('id').substring(0,16) == 'SVGGEN_datavalue') {").append(eol);
        this.script.append("      obj.setAttribute('visibility', 'visible');").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("  else {").append(eol);
        this.script.append("    var nodes = obj.childNodes;").append(eol);
        this.script.append("    var node;").append(eol);
        this.script.append("    for (var i=0; i<nodes.length; i++) {").append(eol);
        this.script.append("      node = nodes.item(i);").append(eol);
        this.script.append("      SVGGEN_showDatasetValues(node);").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("}").append(eol);
        return this.script.toString();
    }

    public String generateToggleVisibilityDatasetBar() {
        this.script = new StringBuffer();
        this.script.append("var SVGGEN_dataValuesVisible = false;").append(eol);
        this.script.append("function SVGGEN_toggleVisibilityDataset(evt, id) {").append(eol);
        this.script.append("  var svgDoc = evt.target.ownerDocument;").append(eol);
        this.script.append("  if (svgDoc != null) {").append(eol);
        this.script.append("    var obj = svgDoc.getElementById(id);").append(eol);
        this.script.append("    var foreobj = svgDoc.getElementById('SVGGEN_plotareaForeground_'+id);").append(eol);
        this.script.append("    if (obj != null) {").append(eol);
        this.script.append("      var v1 = obj.getAttribute('visibility');").append(eol);
        this.script.append("      var v2;").append(eol);
        this.script.append("      if (v1 == 'hidden') {").append(eol);
        this.script.append("         v2 = 'visible';").append(eol);
        this.script.append("         SVGGEN_showDatasetValues(svgDoc, id);").append(eol);
        this.script.append("      } else {").append(eol);
        this.script.append("         v2 = 'hidden';").append(eol);
        this.script.append("         SVGGEN_hideDatasetValues(svgDoc, id);").append(eol);
        this.script.append("      }").append(eol);
        this.script.append("      if (foreobj != null)").append(eol);
        this.script.append("         foreobj.setAttribute('visibility', v2);").append(eol);
        this.script.append("      obj.setAttribute('visibility', v2);").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("}").append(eol);
        this.script.append("function SVGGEN_hideDatasetValues(obj, datasetID) {").append(eol);
        this.script.append("  if (obj.nodeName == 'text') {").append(eol);
        this.script.append("    var datavalueID = 'SVGGEN_datavalue_' + datasetID + '_';").append(eol);
        this.script.append("    var len = datavalueID.length;").append(eol);
        this.script.append("    if (obj.getAttribute('id').substring(0,len) == datavalueID) {").append(eol);
        this.script.append("      obj.setAttribute('visibility', 'hidden');").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("  else {").append(eol);
        this.script.append("    var nodes = obj.childNodes;").append(eol);
        this.script.append("    var node;").append(eol);
        this.script.append("    for (var i=0; i<nodes.length; i++) {").append(eol);
        this.script.append("      node = nodes.item(i);").append(eol);
        this.script.append("      SVGGEN_hideDatasetValues(node, datasetID);").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("}").append(eol);
        this.script.append("function SVGGEN_showDatasetValues(obj, datasetID) {").append(eol);
        this.script.append("  if (SVGGEN_dataValuesVisible == false) return;").append(eol);
        this.script.append("  if (obj.nodeName == 'text') {").append(eol);
        this.script.append("    var datavalueID = 'SVGGEN_datavalue_' + datasetID + '_';").append(eol);
        this.script.append("    var len = datavalueID.length;").append(eol);
        this.script.append("    if (obj.getAttribute('id').substring(0,len) == datavalueID) {").append(eol);
        this.script.append("      obj.setAttribute('visibility', 'visible');").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("  else {").append(eol);
        this.script.append("    var nodes = obj.childNodes;").append(eol);
        this.script.append("    var node;").append(eol);
        this.script.append("    for (var i=0; i<nodes.length; i++) {").append(eol);
        this.script.append("      node = nodes.item(i);").append(eol);
        this.script.append("      SVGGEN_showDatasetValues(node, datasetID);").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("}").append(eol);
        return this.script.toString();
    }

    public String generateToggleVisibilityShadow(boolean showShapes) {
        this.script = new StringBuffer();
        this.script.append("function SVGGEN_toggleVisibilityShadow(evt, id, visibility) {").append(eol);
        if (!showShapes) {
            this.script.append("if (SVGGEN_noShapes) return;").append(eol);
        }
        this.script.append("  var svgDoc = evt.target.ownerDocument;").append(eol);
        this.script.append("  if (svgDoc != null) {").append(eol);
        this.script.append("    var obj = svgDoc.getElementById(id);").append(eol);
        this.script.append("    if (obj != null) {").append(eol);
        this.script.append("      if (visibility == 'visible') {").append(eol);
        this.script.append("        var obj1 = obj.parentNode;").append(eol);
        this.script.append("        while (obj1 != svgDoc) {").append(eol);
        this.script.append("          if (obj1.getAttribute('visibility') == 'hidden') return;").append(eol);
        this.script.append("          obj1 = obj1.parentNode;").append(eol);
        this.script.append("        }").append(eol);
        this.script.append("      }").append(eol);
        this.script.append("      obj.setAttribute('visibility', visibility);").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("}").append(eol);
        return this.script.toString();
    }

    public String generateBuildHelper() {
        this.script = new StringBuffer();
        this.script.append("\t\tfunction BuildHelper(tag, attrList, text) {").append(eol);
        this.script.append("\t\t\tthis.tag = tag;").append(eol);
        this.script.append("\t\t\tthis.attrList = attrList;").append(eol);
        this.script.append("\t\t\tthis.text       = text;").append(eol);
        this.script.append("\t\t\tthis.element  = null;").append(eol);
        this.script.append("\t\t\tthis.textNode = null;").append(eol);
        this.script.append("\t\t}").append(eol);
        this.script.append("\t").append(eol);
        this.script.append("\t\tBuildHelper.prototype.addToParent= function(parent) {").append(eol);
        this.script.append("\t\t       if (!parent) return;").append(eol);
        this.script.append("\t\t\tvar svgDocument = parent.ownerDocument;").append(eol);
        this.script.append("\t\t\tthis.element = svgDocument.createElementNS(\"http://www.w3.org/2000/svg\",this.tag);").append(eol);
        this.script.append("\t\t\t").append(eol);
        this.script.append("\t\t\tfor (var attribute in this.attrList){").append(eol);
        this.script.append("\t\t          if (attribute == 'classType')").append(eol);
        this.script.append("\t\t   \t\t     this.element.setAttributeNS(null, 'class', this.attrList[attribute]);").append(eol);
        this.script.append("\t\t          else").append(eol);
        this.script.append("\t\t\t\t     this.element.setAttributeNS(null, attribute, this.attrList[attribute]);").append(eol);
        this.script.append("\t\t        }").append(eol);
        this.script.append("\t\t\t").append(eol);
        this.script.append("\t\t\tif (this.text) {").append(eol);
        this.script.append("\t\t\t\tthis.textNode = svgDocument.createTextNode(this.text);").append(eol);
        this.script.append("\t\t\t\tthis.element.appendChild(this.textNode);").append(eol);
        this.script.append("\t\t\t}").append(eol);
        this.script.append("\t\t\t").append(eol);
        this.script.append("\t\t\tparent.appendChild(this.element);").append(eol);
        this.script.append("\t\t};").append(eol);
        this.script.append("\t\t").append(eol);
        this.script.append("\t\tBuildHelper.prototype.insertBefore = function(parent, before) {").append(eol);
        this.script.append("\t\t        if (typeof parent != 'undefined') return;").append(eol);
        this.script.append("\t\t\tvar svgDocument = parent.ownerDocument;").append(eol);
        this.script.append("\t\t\tthis.element = svgDocument.createElementNS(\"http://www.w3.org/2000/svg\",this.tag);").append(eol);
        this.script.append("\t\t\t").append(eol);
        this.script.append("\t\t\tfor (var attribute in this.attrList){").append(eol);
        this.script.append("\t\t          if (attribute == 'classType')").append(eol);
        this.script.append("\t\t  \t\t     this.element.setAttributeNS(null, 'class', this.attrList[attribute]);").append(eol);
        this.script.append("\t\t          else").append(eol);
        this.script.append("\t\t\t\t     this.element.setAttributeNS(null, attribute, this.attrList[attribute]);").append(eol);
        this.script.append("\t\t        }").append(eol);
        this.script.append("\t\t\t").append(eol);
        this.script.append("\t\t\tif (this.text) {").append(eol);
        this.script.append("\t\t\t\tthis.textNode = svgDocument.createTextNode(this.text);").append(eol);
        this.script.append("\t\t\t\tthis.element.appendChild(textNode);").append(eol);
        this.script.append("\t\t\t}").append(eol);
        this.script.append("\t\t\t").append(eol);
        this.script.append("\t\t\tparent.insertBefore(this.element, before);").append(eol);
        this.script.append("\t\t};").append(eol);
        this.script.append("\t\t").append(eol);
        this.script.append("\t\tBuildHelper.prototype.removeNode = function() {").append(eol);
        this.script.append("\t\t\tif (this.element) this.element.parentNode.removeChild(this.element);").append(eol);
        this.script.append("\t\t\tthis.tag = \"\";").append(eol);
        this.script.append("\t\t\tthis.attrList = null;").append(eol);
        this.script.append("\t\t\tthis.text = null;").append(eol);
        this.script.append("\t\t\tthis.element = null;").append(eol);
        this.script.append("\t\t\tthis.textNode = null;").append(eol);
        this.script.append("\t\t};").append(eol);
        return this.script.toString();
    }

    public String generateToggleVisibilityDatavalue() {
        this.script = new StringBuffer();
        this.script.append("function SVGGEN_toggleVisibilityDatavalue(evt, id) {").append(eol);
        this.script.append("  var svgDoc = evt.target.ownerDocument;").append(eol);
        this.script.append("  if (svgDoc != null) {").append(eol);
        this.script.append("    var obj = svgDoc.getElementById(id);").append(eol);
        this.script.append("    if (obj != null) {").append(eol);
        this.script.append("      SVGGEN_toggleVisibilityDatavalue2(obj);").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("}").append(eol);
        this.script.append("function SVGGEN_toggleVisibilityDatavalue2(obj, state) {").append(eol);
        this.script.append("  if (obj.nodeName == 'text' || obj.nodeName == 'use') {").append(eol);
        this.script.append("  if((obj.getAttribute('id') != null) && (obj.getAttribute('id').substring(0,16) == 'SVGGEN_datavalue')) {").append(eol);
        this.script.append("      var v1 = obj.getAttribute('visibility');").append(eol);
        this.script.append("      var v2 = (v1 == 'hidden') ? 'visible' : 'hidden';").append(eol);
        this.script.append("      if (state != null) v2 = state;").append(eol);
        this.script.append("      if (v2 == 'visible') {").append(eol);
        this.script.append("        var obj1 = obj.parentNode;").append(eol);
        this.script.append("        while (obj1 != document) {").append(eol);
        this.script.append("          if (obj1.getAttribute('visibility') == 'hidden') return;").append(eol);
        this.script.append("          obj1 = obj1.parentNode;").append(eol);
        this.script.append("        }").append(eol);
        this.script.append("        SVGGEN_dataValuesVisible = true;").append(eol);
        this.script.append("      } else {").append(eol);
        this.script.append("        SVGGEN_dataValuesVisible = false;").append(eol);
        this.script.append("      }").append(eol);
        this.script.append("      obj.setAttribute('visibility', v2);").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("  else {").append(eol);
        this.script.append("    var nodes = obj.childNodes;").append(eol);
        this.script.append("    var node;").append(eol);
        this.script.append("    for (var i=0; i<nodes.length; i++) {").append(eol);
        this.script.append("      node = nodes.item(i);").append(eol);
        this.script.append("      SVGGEN_toggleVisibilityDatavalue2(node, state);").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("}").append(eol);
        return this.script.toString();
    }

    public String generateMoveNode() {
        this.script = new StringBuffer();
        this.script.append("function SVGGEN_moveNode(source, destination) {").append(eol);
        this.script.append("  var node = document.getElementById(source);").append(eol);
        this.script.append("  if (node != null) {").append(eol);
        this.script.append("    var originalParent = node.parentNode;").append(eol);
        this.script.append("    var destNode = document.getElementById(destination);").append(eol);
        this.script.append("    destNode.appendChild(originalParent.removeChild(node));").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("}").append(eol);
        return this.script.toString();
    }

    public String generateKeyPressHandler() {
        this.script = new StringBuffer();
        this.script.append("var SVGGEN_g_svgdoc = null;").append(eol);
        this.script.append("var SVGGEN_g_svgnode = null;").append(eol);
        this.script.append("var SVGGEN_g_nextElement = 0;").append(eol);
        this.script.append("var SVGGEN_g_curNode = null;").append(eol);
        this.script.append("function SVGGEN_displayMessage (msg)").append(eol);
        this.script.append("{").append(eol);
        this.script.append("  alert(msg);").append(eol);
        this.script.append("}").append(eol);
        this.script.append("function SVGGEN_playTitle (node)").append(eol);
        this.script.append("{").append(eol);
        this.script.append("  if (!node)").append(eol);
        this.script.append("    SVGGEN_displayMessage ('> No caption found for title!');").append(eol);
        this.script.append("  else {").append(eol);
        this.script.append("    var titleText = node.getFirstChild().getNodeValue();").append(eol);
        this.script.append("    if (SVGGEN_findDesc(SVGGEN_g_curNode))").append(eol);
        this.script.append("      SVGGEN_displayMessage (titleText + '\\n> Press \"D\" for description.');").append(eol);
        this.script.append("    else").append(eol);
        this.script.append("      SVGGEN_displayMessage (titleText);").append(eol);
        this.script.append("   }").append(eol);
        this.script.append("}").append(eol);
        this.script.append("function SVGGEN_playDesc ()").append(eol);
        this.script.append("{").append(eol);
        this.script.append("  var descnode = null;").append(eol);
        this.script.append("  if (SVGGEN_g_curNode)").append(eol);
        this.script.append("    descnode = SVGGEN_findDesc (SVGGEN_g_curNode);").append(eol);
        this.script.append("  if (!descnode)").append(eol);
        this.script.append("    SVGGEN_displayMessage ('> No caption found for description!');").append(eol);
        this.script.append("  else {").append(eol);
        this.script.append("    var titleText = descnode.getFirstChild().getNodeValue();").append(eol);
        this.script.append("    SVGGEN_displayMessage (titleText);").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("}").append(eol);
        this.script.append("function SVGGEN_playNext (startOfSearch)").append(eol);
        this.script.append("{").append(eol);
        this.script.append("  if (SVGGEN_g_nextElement == 0) {").append(eol);
        this.script.append("    var titlenode = SVGGEN_findTitle (SVGGEN_g_svgnode);").append(eol);
        this.script.append("    if (!titlenode) {").append(eol);
        this.script.append("      SVGGEN_g_nextElement++;").append(eol);
        this.script.append("      return SVGGEN_playNext(true);").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("  } else {").append(eol);
        this.script.append("    var titlenode;").append(eol);
        this.script.append("    if (SVGGEN_g_nextElement == 1)").append(eol);
        this.script.append("      titlenode = SVGGEN_findNextTitle (SVGGEN_youngestChild(SVGGEN_g_svgnode));").append(eol);
        this.script.append("    else").append(eol);
        this.script.append("      titlenode = SVGGEN_findNextTitle (SVGGEN_nextNode(SVGGEN_g_curNode));").append(eol);
        this.script.append("    if (!titlenode) {").append(eol);
        this.script.append("      if (startOfSearch) {").append(eol);
        this.script.append("        SVGGEN_displayMessage ('> No captions found in document!');").append(eol);
        this.script.append("        SVGGEN_g_curNode = null;").append(eol);
        this.script.append("        return false;").append(eol);
        this.script.append("      } else {").append(eol);
        this.script.append("        SVGGEN_g_nextElement = 0;").append(eol);
        this.script.append("        return SVGGEN_playNext(startOfSearch);").append(eol);
        this.script.append("      }").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("    if (titlenode.getParentNode() == SVGGEN_g_svgnode) {").append(eol);
        this.script.append("      SVGGEN_displayMessage ('> No more captions in document.');").append(eol);
        this.script.append("      SVGGEN_g_curNode = null;").append(eol);
        this.script.append("      SVGGEN_g_nextElement = 0;").append(eol);
        this.script.append("      return false;").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("  SVGGEN_g_curNode = titlenode.getParentNode();").append(eol);
        this.script.append("  SVGGEN_playTitle (titlenode);").append(eol);
        this.script.append("  SVGGEN_g_nextElement++;").append(eol);
        this.script.append("  return true;").append(eol);
        this.script.append("}").append(eol);
        this.script.append("function SVGGEN_findDesc (node)").append(eol);
        this.script.append("{").append(eol);
        this.script.append("  var kids = node.childNodes;").append(eol);
        this.script.append("  for (var i = 0;  i < kids.length;  i++) {").append(eol);
        this.script.append("    var kid = kids.item(i);").append(eol);
        this.script.append("    if (kid.getNodeType() == 1  &&  kid.getTagName()+'' == 'desc')").append(eol);
        this.script.append("      return kid;").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("  return null;").append(eol);
        this.script.append("}").append(eol);
        this.script.append("function SVGGEN_findTitle (node)").append(eol);
        this.script.append("{").append(eol);
        this.script.append("  var kids = node.childNodes;").append(eol);
        this.script.append("  for (var i = 0;  i < kids.length;  i++) {").append(eol);
        this.script.append("    var kid = kids.item(i);").append(eol);
        this.script.append("    if (kid.getNodeType() == 1  &&  kid.getTagName()+'' == 'title')").append(eol);
        this.script.append("      return kid;").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("  return null;").append(eol);
        this.script.append("}").append(eol);
        this.script.append("function SVGGEN_youngestChild (node)").append(eol);
        this.script.append("{").append(eol);
        this.script.append("  var kids = node.childNodes;").append(eol);
        this.script.append("  for (var i = 0;  i < kids.length;  i++) {").append(eol);
        this.script.append("    var kid = kids.item(i);").append(eol);
        this.script.append("    if (kid.getNodeType() == 1)").append(eol);
        this.script.append("      return SVGGEN_youngestChild (kid);").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("  return node;").append(eol);
        this.script.append("}").append(eol);
        this.script.append("function SVGGEN_nextNode (startNode)").append(eol);
        this.script.append("{").append(eol);
        this.script.append("  var node = startNode.getNextSibling();").append(eol);
        this.script.append("  while (node) {").append(eol);
        this.script.append("    if (node.getNodeType() == 1) {").append(eol);
        this.script.append("      return SVGGEN_youngestChild(node);").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("    node = node.getNextSibling();").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("  if (startNode.getParentNode())").append(eol);
        this.script.append("    return startNode.getParentNode();").append(eol);
        this.script.append("  return null;").append(eol);
        this.script.append("}").append(eol);
        this.script.append("function SVGGEN_findNextTitle (startNode)").append(eol);
        this.script.append("{").append(eol);
        this.script.append("  var node = SVGGEN_findTitle (startNode);").append(eol);
        this.script.append("  if (node)").append(eol);
        this.script.append("    return node;").append(eol);
        this.script.append("  node = SVGGEN_nextNode (startNode);").append(eol);
        this.script.append("  if (!node)").append(eol);
        this.script.append("    return null;").append(eol);
        this.script.append("  else").append(eol);
        this.script.append("    return SVGGEN_findNextTitle (node);").append(eol);
        this.script.append("}").append(eol);
        this.script.append("function SVGGEN_handle_keypress (event)").append(eol);
        this.script.append("{").append(eol);
        this.script.append("  SVGGEN_g_svgnode = event.target.ownerDocument;").append(eol);
        this.script.append("  var key = event.getCharCode();").append(eol);
        this.script.append("  var keychar = String.fromCharCode(key);").append(eol);
        this.script.append("  switch (keychar) {").append(eol);
        this.script.append("    case 't':").append(eol);
        this.script.append("    case 'T':").append(eol);
        this.script.append("      SVGGEN_playNext (false);").append(eol);
        this.script.append("      break;").append(eol);
        this.script.append("    case 'd':").append(eol);
        this.script.append("    case 'D':").append(eol);
        this.script.append("      SVGGEN_playDesc();").append(eol);
        this.script.append("      break;").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("}").append(eol);
        return this.script.toString();
    }

    public String generatePieScripts() {
        this.script = new StringBuffer();
        this.script.append("function SVGGEN_showTooltipPie(evt, tooltipNum) {").append(eol);
        this.script.append("  if (SVGGEN_values && !SVGGEN_percents) {").append(eol);
        this.script.append("    SVGGEN_showTooltip(evt, 'SVGGEN_tooltip_exactValue' + tooltipNum);").append(eol);
        this.script.append("  } else if (!SVGGEN_values && SVGGEN_percents) {").append(eol);
        this.script.append("    SVGGEN_showTooltip(evt, 'SVGGEN_tooltip_percentValue' + tooltipNum);").append(eol);
        this.script.append("  } else {").append(eol);
        this.script.append("    SVGGEN_showTooltip(evt, 'SVGGEN_tooltip_bothValues' + tooltipNum);").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("}").append(eol);
        this.script.append("function SVGGEN_hideTooltipPie(evt, tooltipNum) {").append(eol);
        this.script.append("  if (SVGGEN_values && !SVGGEN_percents) {").append(eol);
        this.script.append("    SVGGEN_hideTooltip(evt, 'SVGGEN_tooltip_exactValue' + tooltipNum);").append(eol);
        this.script.append("  } else if (!SVGGEN_values && SVGGEN_percents) {").append(eol);
        this.script.append("    SVGGEN_hideTooltip(evt, 'SVGGEN_tooltip_percentValue' + tooltipNum);").append(eol);
        this.script.append("  } else {").append(eol);
        this.script.append("    SVGGEN_hideTooltip(evt, 'SVGGEN_tooltip_bothValues' + tooltipNum);").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("}").append(eol);
        this.script.append("function SVGGEN_toggleVisibilityDatavaluePie(evt, id) {").append(eol);
        this.script.append("  var svgDoc = evt.target.ownerDocument;").append(eol);
        this.script.append("  if (svgDoc != null) {").append(eol);
        this.script.append("    var obj = svgDoc.getElementById(id);").append(eol);
        this.script.append("    if (obj != null) {").append(eol);
        this.script.append("      SVGGEN_toggleVisibilityDatavaluePie2(obj);").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("}").append(eol);
        this.script.append("function SVGGEN_toggleVisibilityDatavaluePie2(obj, state) {").append(eol);
        this.script.append("  if (obj.nodeName == 'text' || obj.nodeName == 'use') {").append(eol);
        this.script.append("    var dataValueName;").append(eol);
        this.script.append("    if (SVGGEN_values && !SVGGEN_percents) {").append(eol);
        this.script.append("      dataValueName = 'SVGGEN_datavalue_exac';").append(eol);
        this.script.append("    } else if (!SVGGEN_values && SVGGEN_percents) {").append(eol);
        this.script.append("      dataValueName = 'SVGGEN_datavalue_perc';").append(eol);
        this.script.append("    } else {").append(eol);
        this.script.append("      dataValueName = 'SVGGEN_datavalue_both';").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("    if (obj.getAttribute('id').substring(0,21) == dataValueName || ").append(eol);
        this.script.append("        obj.getAttribute('id').substring(0,21) == 'SVGGEN_datavalue_tick') {").append(eol);
        this.script.append("      var v1 = obj.getAttribute('visibility');").append(eol);
        this.script.append("      var v2 = (v1 == 'hidden') ? 'visible' : 'hidden';").append(eol);
        this.script.append("      if (state != null) { v2 = state; }").append(eol);
        this.script.append("      if (v2 == 'visible') {").append(eol);
        this.script.append("        var obj1 = obj.parentNode;").append(eol);
        this.script.append("        while (obj1 != document) {").append(eol);
        this.script.append("          if (obj1.getAttribute('visibility') == 'hidden') return;").append(eol);
        this.script.append("          obj1 = obj1.parentNode;").append(eol);
        this.script.append("        }").append(eol);
        this.script.append("        SVGGEN_dataValuesVisible = true;").append(eol);
        this.script.append("      } else {").append(eol);
        this.script.append("        SVGGEN_dataValuesVisible = false;").append(eol);
        this.script.append("      }").append(eol);
        this.script.append("      obj.setAttribute('visibility', v2);").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("  else {").append(eol);
        this.script.append("    var nodes = obj.childNodes;").append(eol);
        this.script.append("    var node;").append(eol);
        this.script.append("    for (var i=0; i<nodes.length; i++) {").append(eol);
        this.script.append("      node = nodes.item(i);").append(eol);
        this.script.append("      SVGGEN_toggleVisibilityDatavaluePie2(node, state);").append(eol);
        this.script.append("    }").append(eol);
        this.script.append("  }").append(eol);
        this.script.append("}").append(eol);
        return this.script.toString();
    }

    public String generateRegenInit() {
        this.script = new StringBuffer();
        this.script.append("\t\tSVGGEN_regen();").append(eol);
        this.script.append("\t\talert(xpts);").append(eol);
        return this.script.toString();
    }

    public String generateRegen() {
        this.script = new StringBuffer();
        this.script.append("var incl = null;").append(eol);
        this.script.append("function SVGGEN_regen()").append(eol);
        this.script.append("{").append(eol);
        this.script.append("\tif ((incl == null) || (incl.length <= 0)) {").append(eol);
        this.script.append("\t\treturn;").append(eol);
        this.script.append("\t}").append(eol);
        this.script.append("\tif ((xpts == null) || (xpts.length <= 0)) {").append(eol);
        this.script.append("\t\treturn;").append(eol);
        this.script.append("\t}").append(eol);
        this.script.append("\tvar lstl = new Array(xpts.length);").append(eol);
        this.script.append("\tvar thsl = new Array(xpts.length);").append(eol);
        this.script.append("\tvar yTotal = new Array(xpts.length);").append(eol);
        this.script.append("\tfor( i=0;i<xpts.length;i++ ) {").append(eol);
        this.script.append("\t\tlstl[i] = yBasePoint;").append(eol);
        this.script.append("    \tthsl[i] = yBasePoint;").append(eol);
        this.script.append("    \tyTotal[i] = 0.0;").append(eol);
        this.script.append("\t}").append(eol);
        this.script.append("\tfor( i=1;i<=incl.length;i++ ) {").append(eol);
        this.script.append("\t\tj = i - 1;").append(eol);
        this.script.append("\t\tvar arE = document.getElementById('SVGGEN_poly' + j);").append(eol);
        this.script.append("\t\tvar lnE = document.getElementById('SVGGEN_lineGroup' + j);").append(eol);
        this.script.append("\t\tvar nodes = lnE.childNodes;").append(eol);
        this.script.append("\t\tvar dSetE = document.getElementById('SVGGEN_dataColour' + (j));").append(eol);
        this.script.append("\t\tvar dSetNodes = dSetE.childNodes;").append(eol);
        this.script.append("\t").append(eol);
        this.script.append("\t\tif (arE == null)").append(eol);
        this.script.append("\t\tcontinue;").append(eol);
        this.script.append("\t").append(eol);
        this.script.append("\t\tif( incl[i-1] ) {").append(eol);
        this.script.append("\t\t\tvar ypts = eval('ypts' + i );").append(eol);
        this.script.append("\t\t\tvar width = eval('width' + i );").append(eol);
        this.script.append("\t\t\tvar height = eval('height' + i );").append(eol);
        this.script.append("\t\t\tvar nlst = '';").append(eol);
        this.script.append("\t\t\tfor(j=0;j<ypts.length;j++) {").append(eol);
        this.script.append("\t\t\t\tif(i==1){").append(eol);
        this.script.append("\t\t\t\t\tif(linear){").append(eol);
        this.script.append("\t\t\t\t\t\tthsl[j] = ypts[j];").append(eol);
        this.script.append("\t\t\t\t\t}else{").append(eol);
        this.script.append("\t\t\t\t\t\tyTotal[j] = ypts[j];").append(eol);
        this.script.append("\t\t\t\t\t\tif(ypts[j] == 0.0){").append(eol);
        this.script.append("\t\t\t\t\t\t\tthsl[j] = SVGGEN_getCoordinate(linear, minBase, max_coor, min_coor, max, min);").append(eol);
        this.script.append("\t\t\t\t\t\t}else{").append(eol);
        this.script.append("\t\t\t\t\t\t\tthsl[j] = SVGGEN_getCoordinate(linear, ypts[j], max_coor, min_coor, max, min);").append(eol);
        this.script.append("\t\t\t\t\t\t}").append(eol);
        this.script.append("\t\t\t\t\t}").append(eol);
        this.script.append("\t\t\t\t}else{").append(eol);
        this.script.append("\t\t\t\t\tif(linear){").append(eol);
        this.script.append("\t\t\t\t\t\tthsl[j] = lstl[j] - ypts[j] ; ").append(eol);
        this.script.append("\t\t\t\t\t}else{").append(eol);
        this.script.append("\t\t\t\t\t\tyTotal[j] += ypts[j];").append(eol);
        this.script.append("\t\t\t\t\t\tif(ypts[j] == 0.0){").append(eol);
        this.script.append("\t\t\t\t\t\t\tthsl[j] = SVGGEN_getCoordinate(linear, minBase, max_coor, min_coor, max, min);").append(eol);
        this.script.append("\t\t\t\t\t\t}else{").append(eol);
        this.script.append("\t\t\t\t\t\t\tthsl[j] = SVGGEN_getCoordinate(linear, yTotal[j], max_coor, min_coor, max, min);").append(eol);
        this.script.append("\t\t\t\t\t\t}").append(eol);
        this.script.append("\t\t\t\t\t}").append(eol);
        this.script.append("\t\t\t\t}").append(eol);
        this.script.append("\t\t\t\tnlst += xpts[j] + ',' + thsl[j] + ' ';").append(eol);
        this.script.append("\t\t\t\tif(j < ypts.length && j > 1){").append(eol);
        this.script.append("\t\t\t\t\tfor (var n=0; n<nodes.length; n++) {").append(eol);
        this.script.append("\t\t\t\t\t\tvar node = nodes.item(n);").append(eol);
        this.script.append("\t\t\t\t\t\tif (node.nodeName == 'polyline'){").append(eol);
        this.script.append("\t\t\t\t\t\t\tif (node.getAttribute('id') == 'SVGGEN_Line' + (j-1)) {").append(eol);
        this.script.append("\t\t\t\t\t\t\t\tnode.setAttribute('points',xpts[j-1] + ' ' + thsl[j-1] + ', ' + xpts[j] + ' ' + thsl[j]);").append(eol);
        this.script.append("\t\t\t\t\t\t\t}").append(eol);
        this.script.append("\t\t\t\t\t\t}").append(eol);
        this.script.append("\t\t\t\t\t}").append(eol);
        this.script.append("\t\t\t\t\tfor (var n=0; n<dSetNodes.length; n++) {").append(eol);
        this.script.append("\t\t\t\t\t\tvar node = dSetNodes.item(n);").append(eol);
        this.script.append("\t\t\t\t\t\tif (node.nodeName == 'g'){").append(eol);
        this.script.append("\t\t\t\t\t\t\tif (node.getAttribute('id') == 'SVGGEN_pointGroupWrapper' + (j-1)) {").append(eol);
        this.script.append("\t\t\t\t\t\t\t\tvar cNode = node.childNodes;").append(eol);
        this.script.append("\t\t\t\t\t\t\t\t//alert(node.getAttribute('id'));").append(eol);
        this.script.append("\t\t\t\t\t\t\t\tfor (var m=0; m<cNode.length; m++) {").append(eol);
        this.script.append("\t\t\t\t\t\t\t\t\tvar nodeC = cNode.item(m);").append(eol);
        this.script.append("\t\t\t\t\t\t\t\t\tif (nodeC.nodeName == 'text'){").append(eol);
        this.script.append("\t\t\t\t\t\t\t\t\t\tnodeC.setAttribute('x',(xpts[j-1] + 5));").append(eol);
        this.script.append("\t\t\t\t\t\t\t\t\t\tnodeC.setAttribute('y',thsl[j-1]);").append(eol);
        this.script.append("\t\t\t\t\t\t\t\t\t}").append(eol);
        this.script.append("\t\t\t\t\t\t\t\t\tif (nodeC.nodeName == 'g'){").append(eol);
        this.script.append("\t\t\t\t\t\t\t\t\t\tvar ccNode = nodeC.childNodes;").append(eol);
        this.script.append("\t\t\t\t\t\t\t\t\t\tfor (var l=0; l<ccNode.length; l++) {").append(eol);
        this.script.append("\t\t\t\t\t\t\t\t\t\t\tvar nodeCC = ccNode.item(l);").append(eol);
        this.script.append("\t\t\t\t\t\t\t\t\t\t\tif (nodeCC.nodeName == 'use'){").append(eol);
        this.script.append("\t\t\t\t\t\t\t\t\t\t\t\tif(nodeCC.getAttribute('xlink:href') == '#SVGGEN_holeshape'){").append(eol);
        this.script.append("\t\t\t\t\t\t\t\t\t\t\t\t\tnodeCC.setAttribute('transform', 'translate(' + (xpts[j-1]-2.8 ) + ',' + (thsl[j-1]-2.8) + ')');").append(eol);
        this.script.append("\t\t\t\t\t\t\t\t\t\t\t\t}else{").append(eol);
        this.script.append("\t\t\t\t\t\t\t\t\t\t\t\t\tnodeCC.setAttribute('transform', 'translate(' + (xpts[j-1]- width[j-2]) + ',' + (thsl[j-1] - height[j-2]) + ')');").append(eol);
        this.script.append("\t\t\t\t\t\t\t\t\t\t\t\t}").append(eol);
        this.script.append("\t\t\t\t\t\t\t\t\t\t\t}").append(eol);
        this.script.append("\t\t\t\t\t\t\t\t\t\t}").append(eol);
        this.script.append("\t\t\t\t\t\t\t\t\t}").append(eol);
        this.script.append("\t\t\t\t\t\t\t\t}").append(eol);
        this.script.append("\t\t\t\t\t\t\t}").append(eol);
        this.script.append("\t\t\t\t\t\t}").append(eol);
        this.script.append("\t\t\t\t\t}").append(eol);
        this.script.append("\t\t\t\t}").append(eol);
        this.script.append("\t\t\t}").append(eol);
        this.script.append("\t\t\tfor(j=ypts.length-1;j>=0;j--) {").append(eol);
        this.script.append("\t\t\t\tif(i==1){").append(eol);
        this.script.append("\t\t\t\t\tnlst += xpts[j] + ',' + lstl[j] + ' ';").append(eol);
        this.script.append("\t\t\t\t}else{").append(eol);
        this.script.append("\t\t\t\t\tnlst += xpts[j] + ',' + lstl[j] + ' ';").append(eol);
        this.script.append("\t\t\t\t}").append(eol);
        this.script.append("\t\t\t}").append(eol);
        this.script.append("\t\t\tarE.setAttribute('points',nlst);").append(eol);
        this.script.append("\t\t\tfor(j=0;j<thsl.length;j++) {").append(eol);
        this.script.append("\t\t\t\tlstl[j] = thsl[j];").append(eol);
        this.script.append("\t\t\t}").append(eol);
        this.script.append("\t\t}").append(eol);
        this.script.append("\t}").append(eol);
        this.script.append("} ").append(eol);
        return this.script.toString();
    }

    public String generateTakeOut() {
        this.script = new StringBuffer();
        this.script.append("\t\tfunction SVGGEN_takeOut(item) {").append(eol);
        this.script.append("\t\t\tincl[item-1] = false;").append(eol);
        this.script.append("\t\t\tSVGGEN_regen();").append(eol);
        this.script.append("\t\t}").append(eol);
        return this.script.toString();
    }

    public String generatePutIn() {
        this.script = new StringBuffer();
        this.script.append("\t\tfunction SVGGEN_putIn(item) {").append(eol);
        this.script.append("\t\t\tincl[item-1] = true;").append(eol);
        this.script.append("\t\t\tSVGGEN_regen();").append(eol);
        this.script.append("\t\t}").append(eol);
        return this.script.toString();
    }

    public String generateToggle() {
        this.script = new StringBuffer();
        this.script.append("\t\tfunction SVGGEN_toggle(item) {").append(eol);
        this.script.append("\t\t\tif( incl[item-1] ) {").append(eol);
        this.script.append("\t\t\t\tSVGGEN_takeOut(item);").append(eol);
        this.script.append("\t\t\t}").append(eol);
        this.script.append("\t\t\t\telse {").append(eol);
        this.script.append("\t\t\t\tSVGGEN_putIn(item);").append(eol);
        this.script.append("\t\t\t}").append(eol);
        this.script.append("\t\t}").append(eol);
        return this.script.toString();
    }

    public String generateGetCoordinateFunction() {
        this.script = new StringBuffer();
        this.script.append("\tfunction SVGGEN_getCoordinate(linear, value, max_coor, min_coor, max, min) {").append(eol);
        this.script.append("\t\tvar plotvalue;").append(eol);
        this.script.append("\t\tvar coord;").append(eol);
        this.script.append("\t\tif (linear == 'true') {").append(eol);
        this.script.append("\t\t\tplotvalue = value;").append(eol);
        this.script.append("\t\t} else {").append(eol);
        this.script.append("\t\t\tplotvalue = Math.log(value) / Math.log(10);").append(eol);
        this.script.append("\t\t}").append(eol);
        this.script.append("\t\tcoord = (plotvalue - max) / (min - max) * (min_coor - max_coor) + max_coor;").append(eol);
        this.script.append("\t\treturn coord;").append(eol);
        this.script.append("\t}").append(eol);
        return this.script.toString();
    }
}

