/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.GraphAreaBar;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.GraphAreaBar3D;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.GraphAreaLine;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.GraphAreaMeter;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.GraphAreaPie;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.GraphAreaPie3D;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.GraphAreaStackArea;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.GraphAreaStackBar;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.GraphAreaStackBar3D;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.IGraphicTypeConstants;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.Part;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGColorPalettes;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGShapes;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;

public abstract class GraphArea
extends Part
implements IGraphicTypeConstants {
    protected SVGShapes shapes = null;
    protected SVGColorPalettes palettes = null;
    protected NLString nls;

    public GraphArea(Chart input, double x, double y, double width, double height) {
        super(input, x, y, width, height);
        this.input = input;
        this.setXCoordinate(Double.toString(x));
        this.setYCoordinate(Double.toString(y));
        this.setWidth(Double.toString(width));
        this.setHeight(Double.toString(height));
    }

    public void setNLString(NLString nls) {
        this.nls = nls;
    }

    public static GraphArea getInstance(Chart input, boolean isLTR, double x, double y, double width, double height, SVGColorPalettes palettes, SVGShapes shapes) {
        if (input.getType().equals("line") || input.getType().equals("area") || input.getType().equals("scatter")) {
            return new GraphAreaLine(input, isLTR, x, y, width, height, palettes, shapes);
        }
        if (input.getType().equals("stackedArea")) {
            return new GraphAreaStackArea(input, isLTR, x, y, width, height, palettes, shapes);
        }
        if (input.getType().equals("verticalBar3D")) {
            return new GraphAreaBar3D(input, isLTR, x, y, width, height, palettes, "S");
        }
        if (input.getType().equals("horizontalBar3D")) {
            return new GraphAreaBar3D(input, isLTR, x, y, width, height, palettes, "W");
        }
        if (input.getType().equals("verticalStackedBar3D")) {
            return new GraphAreaStackBar3D(input, isLTR, x, y, width, height, palettes, "S");
        }
        if (input.getType().equals("horizontalStackedBar3D")) {
            return new GraphAreaStackBar3D(input, isLTR, x, y, width, height, palettes, "W");
        }
        if (input.getType().equals("verticalBar")) {
            return new GraphAreaBar(input, isLTR, x, y, width, height, palettes, "S");
        }
        if (input.getType().equals("horizontalBar")) {
            return new GraphAreaBar(input, isLTR, x, y, width, height, palettes, "W");
        }
        if (input.getType().equals("verticalStackedBar")) {
            return new GraphAreaStackBar(input, isLTR, x, y, width, height, palettes, "S");
        }
        if (input.getType().equals("horizontalStackedBar")) {
            return new GraphAreaStackBar(input, isLTR, x, y, width, height, palettes, "W");
        }
        if (input.getType().equals("pie")) {
            return new GraphAreaPie(input, x, y, width, height, palettes);
        }
        if (input.getType().equals("pie3D")) {
            return new GraphAreaPie3D(input, x, y, width, height, palettes);
        }
        if (input.getType().equals("meter")) {
            return new GraphAreaMeter(input, x, y, width, height);
        }
        return null;
    }
}

