/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisCategoryHorizontal3D;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisCategoryVertical3D;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisNumber;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisNumberHorizontal3D;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisNumberVertical3D;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.GraphAreaXY;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.Grid3D;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.MarkerLines;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.PlotArea;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;

public abstract class GraphAreaXY3D
extends GraphAreaXY {
    protected double x3Doffset;
    protected double y3Doffset;

    public GraphAreaXY3D(Chart input, boolean isLTR, double x, double y, double width, double height, double x3Doffset, double y3Doffset) {
        super(input, isLTR, x, y, width, height);
        this.y3Doffset = y3Doffset;
        this.x3Doffset = x3Doffset;
    }

    protected void constructPart() {
        SVGBase[] parts = new SVGBase[7];
        this.setChildren(parts);
        if (this.indepAxisPosition.equals("S")) {
            double rightVertAxisWidth;
            double leftVertAxisWidth;
            this.indepAxis = this.useCategories ? new AxisCategoryHorizontal3D(this.input, this.isLTR, this.x3Doffset, this.y3Doffset, this.nls) : new AxisNumberHorizontal3D(this.input, this.isLTR, this.datasetList, 0, this.cumulative, this.x3Doffset, this.y3Doffset, this.nls);
            this.primaryDepAxis = new AxisNumberVertical3D(this.input, this.isLTR, this.primaryDataSets, 1, this.cumulative, this.x3Doffset, this.y3Doffset, this.nls);
            double marginHeight = this.primaryDepAxis.getMarginForMax();
            if (this.useSecondaryAxis) {
                this.secondaryDepAxis = new AxisNumberVertical3D(this.input, this.isLTR, this.secondaryDataSets, 2, this.cumulative, this.x3Doffset, this.y3Doffset, this.nls);
                if (marginHeight < (double)this.secondaryDepAxis.getMarginForMax()) {
                    marginHeight = this.secondaryDepAxis.getMarginForMax();
                }
            }
            boolean primaryDepAxisOnLeft = this.isLTR;
            double graphAreaWidth = new Double(this.getWidth());
            double graphAreaHeight = new Double(this.getHeight());
            int margin = 0;
            if (this.indepAxis instanceof AxisNumber) {
                margin = ((AxisNumber)this.indepAxis).getMarginForMax();
            }
            if (primaryDepAxisOnLeft) {
                leftVertAxisWidth = this.primaryDepAxis == null ? 0.0 : this.primaryDepAxis.getAxisWidth();
                rightVertAxisWidth = this.secondaryDepAxis == null ? (double)margin : this.secondaryDepAxis.getAxisWidth();
            } else {
                leftVertAxisWidth = this.secondaryDepAxis == null ? (double)margin : this.secondaryDepAxis.getAxisWidth();
                rightVertAxisWidth = this.primaryDepAxis == null ? 0.0 : this.primaryDepAxis.getAxisWidth();
            }
            double horAxisHeight = this.indepAxis.getAxisHeight();
            double indepAxisLength = graphAreaWidth - leftVertAxisWidth - rightVertAxisWidth - 20.0;
            double depAxisLength = graphAreaHeight - horAxisHeight - 20.0 - 10.0 - marginHeight;
            this.indepAxis.setAxisLength(indepAxisLength);
            this.indepAxis.setCrossPoint(leftVertAxisWidth + 10.0, 20.0 + depAxisLength + this.y3Doffset + marginHeight);
            parts[1] = this.indepAxis;
            this.primaryDepAxis.setAxisLength(depAxisLength);
            if (primaryDepAxisOnLeft) {
                this.primaryDepAxis.setCrossPoint(leftVertAxisWidth + 10.0, 20.0 + depAxisLength + this.y3Doffset + marginHeight);
            } else {
                this.primaryDepAxis.setCrossPoint(graphAreaWidth - rightVertAxisWidth - 10.0, 20.0 + depAxisLength + this.y3Doffset + marginHeight);
            }
            parts[2] = this.primaryDepAxis;
            if (this.secondaryDepAxis != null) {
                this.secondaryDepAxis.setAxisLength(depAxisLength);
                if (primaryDepAxisOnLeft) {
                    this.secondaryDepAxis.setCrossPoint(graphAreaWidth - rightVertAxisWidth - 10.0, 20.0 + depAxisLength + this.y3Doffset + marginHeight);
                } else {
                    this.secondaryDepAxis.setCrossPoint(leftVertAxisWidth + 10.0, 20.0 + depAxisLength + this.y3Doffset + marginHeight);
                }
                parts[3] = this.secondaryDepAxis;
            }
            Grid3D grid = new Grid3D(this.input, this.isLTR, leftVertAxisWidth + 10.0, 20.0 + marginHeight, indepAxisLength + Math.abs(this.x3Doffset), depAxisLength + Math.abs(this.y3Doffset), this.x3Doffset, this.y3Doffset);
            grid.setPrimaryDepAxis(this.primaryDepAxis);
            grid.setSecondaryDepAxis(this.secondaryDepAxis);
            grid.setIndepAxis(this.indepAxis);
            parts[0] = grid;
            PlotArea plotarea = this.getPlotArea(leftVertAxisWidth + 10.0, 20.0 + this.y3Doffset + marginHeight, indepAxisLength, depAxisLength);
            parts[4] = plotarea;
            MarkerLines markerLines = new MarkerLines(this.input, this.isLTR, leftVertAxisWidth + 10.0, 20.0 + this.y3Doffset + marginHeight, indepAxisLength, depAxisLength, this.indepAxisPosition, this.nls);
            markerLines.setIndepAxis(this.indepAxis);
            markerLines.setIndepAxisDef(this.indepAxisDef);
            markerLines.setPrimaryDepAxis(this.primaryDepAxis);
            markerLines.setPrimaryDepAxisDef(this.primaryDepAxisDef);
            markerLines.setSecondaryDepAxis(this.secondaryDepAxis);
            markerLines.setSecondaryDepAxisDef(this.secondaryDepAxisDef);
            parts[6] = markerLines;
        } else if (this.indepAxisPosition.equals("W")) {
            double rightVertAxisWidth;
            double leftVertAxisWidth;
            this.indepAxis = new AxisCategoryVertical3D(this.input, this.isLTR, this.x3Doffset, this.y3Doffset, this.nls);
            double marginHeight = this.indepAxis.getMarginForMax();
            this.primaryDepAxis = new AxisNumberHorizontal3D(this.input, this.isLTR, this.primaryDataSets, 1, this.cumulative, this.x3Doffset, this.y3Doffset, this.nls);
            if (this.useSecondaryAxis) {
                this.secondaryDepAxis = new AxisNumberHorizontal3D(this.input, this.isLTR, this.secondaryDataSets, 2, this.cumulative, this.x3Doffset, this.y3Doffset, this.nls);
            }
            boolean indepAxisOnLeft = this.isLTR;
            double graphAreaWidth = new Double(this.getWidth());
            double graphAreaHeight = new Double(this.getHeight());
            double bottomAxisHeight = this.primaryDepAxis == null ? 0.0 : this.primaryDepAxis.getAxisHeight();
            double topAxisHeight = this.secondaryDepAxis == null ? 0.0 : this.secondaryDepAxis.getAxisHeight();
            int margin = 0;
            if (this.primaryDepAxis instanceof AxisNumber) {
                margin = this.primaryDepAxis.getMarginForMax();
            }
            if (indepAxisOnLeft) {
                leftVertAxisWidth = this.indepAxis.getAxisWidth();
                rightVertAxisWidth = margin;
            } else {
                leftVertAxisWidth = margin;
                rightVertAxisWidth = this.indepAxis.getAxisWidth();
            }
            double indepAxisLength = graphAreaHeight - bottomAxisHeight - topAxisHeight - 20.0 - marginHeight;
            double depAxisLength = graphAreaWidth - leftVertAxisWidth - rightVertAxisWidth - 20.0;
            this.indepAxis.setAxisLength(indepAxisLength);
            if (indepAxisOnLeft) {
                this.indepAxis.setCrossPoint(leftVertAxisWidth + 10.0, 10.0 + indepAxisLength + marginHeight + topAxisHeight + this.y3Doffset);
            } else {
                this.indepAxis.setCrossPoint(graphAreaWidth - rightVertAxisWidth - 10.0, 10.0 + indepAxisLength + marginHeight + topAxisHeight + this.y3Doffset);
            }
            parts[2] = this.indepAxis;
            this.primaryDepAxis.setAxisLength(depAxisLength);
            this.primaryDepAxis.setCrossPoint(leftVertAxisWidth + 10.0, 10.0 + indepAxisLength + marginHeight + topAxisHeight + this.y3Doffset);
            parts[3] = this.primaryDepAxis;
            if (this.secondaryDepAxis != null) {
                this.secondaryDepAxis.setAxisLength(depAxisLength);
                this.secondaryDepAxis.setCrossPoint(leftVertAxisWidth + 10.0, 10.0 + topAxisHeight + marginHeight);
                parts[4] = this.secondaryDepAxis;
            }
            Grid3D grid = new Grid3D(this.input, this.isLTR, leftVertAxisWidth + 10.0, 10.0 + marginHeight + topAxisHeight, depAxisLength + Math.abs(this.x3Doffset), indepAxisLength + Math.abs(this.y3Doffset), this.x3Doffset, this.y3Doffset);
            grid.setPrimaryDepAxis(this.primaryDepAxis);
            grid.setSecondaryDepAxis(this.secondaryDepAxis);
            grid.setIndepAxis(this.indepAxis);
            parts[0] = grid;
            PlotArea plotarea = this.getPlotArea(leftVertAxisWidth + 10.0, 10.0 + topAxisHeight + marginHeight + this.y3Doffset, depAxisLength, indepAxisLength);
            parts[5] = plotarea;
            MarkerLines markerLines = new MarkerLines(this.input, this.isLTR, leftVertAxisWidth + 10.0, 10.0 + topAxisHeight + marginHeight + this.y3Doffset, depAxisLength, indepAxisLength, this.indepAxisPosition, this.nls);
            markerLines.setIndepAxis(this.indepAxis);
            markerLines.setIndepAxisDef(this.indepAxisDef);
            markerLines.setPrimaryDepAxis(this.primaryDepAxis);
            markerLines.setPrimaryDepAxisDef(this.primaryDepAxisDef);
            markerLines.setSecondaryDepAxis(this.secondaryDepAxis);
            markerLines.setSecondaryDepAxisDef(this.secondaryDepAxisDef);
            parts[6] = markerLines;
        } else {
            Utilities.assertion(false);
        }
    }
}

