/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import java.util.Vector;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolyline;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGRectangle;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGUse;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Configuration;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.PlotArea;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.Axis;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisCategory;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisNumber;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.Part;

public class Grid
extends Part {
    static final long serialVersionUID = 1674478110608378637L;
    protected Axis indepAxis = null;
    protected AxisNumber primaryDepAxis = null;
    protected AxisNumber secondaryDepAxis = null;
    protected boolean drawBorder = true;
    protected String bkgroundColor;
    protected boolean isLTR = true;

    public Grid(Chart input, boolean isLTR) {
        super(input);
        this.isLTR = isLTR;
    }

    public Grid(Chart input, boolean isLTR, double x, double y, double width, double height) {
        super(input, x, y, width, height);
        PlotArea plotarea;
        this.isLTR = isLTR;
        Configuration config = input.getConfiguration();
        if (config != null && (plotarea = config.getPlotArea()) != null) {
            this.bkgroundColor = plotarea.getBackgroundColor();
            if (plotarea.isSetBorder()) {
                this.drawBorder = plotarea.isBorder();
            }
        }
    }

    protected void constructPart() {
        double gridWidth = this.width - 1.0;
        SVGPolyline horizontalSolidLineDef = new SVGPolyline();
        horizontalSolidLineDef.setPoints("0 0 " + gridWidth + " 0");
        horizontalSolidLineDef.setStyleClass("gridline");
        horizontalSolidLineDef.setIdentifier("horizontalSolidLine");
        SVGPolyline verticalSolidLineDef = new SVGPolyline();
        verticalSolidLineDef.setPoints("0 0 0 " + this.getHeight());
        verticalSolidLineDef.setStyleClass("gridline");
        verticalSolidLineDef.setIdentifier("verticalSolidLine");
        SVGPolyline horizontalDashLineDef = new SVGPolyline();
        horizontalDashLineDef.setPoints("0 0 " + gridWidth + " 0");
        horizontalDashLineDef.setStyleClass("griddashline");
        horizontalDashLineDef.setIdentifier("horizontalDashLine");
        SVGPolyline verticalDashLineDef = new SVGPolyline();
        verticalDashLineDef.setPoints("0 0 0 " + this.getHeight());
        verticalDashLineDef.setStyleClass("griddashline");
        verticalDashLineDef.setIdentifier("verticalDashLine");
        SVGPolyline horizontalZeroLineDef = new SVGPolyline();
        horizontalZeroLineDef.setPoints("0 0 " + gridWidth + " 0");
        horizontalZeroLineDef.setStyleClass("axisLines");
        horizontalZeroLineDef.setIdentifier("horizontalZeroLine");
        SVGPolyline verticalZeroLineDef = new SVGPolyline();
        verticalZeroLineDef.setPoints("0 0 0 " + this.getHeight());
        verticalZeroLineDef.setStyleClass("axisLines");
        verticalZeroLineDef.setIdentifier("verticalZeroLine");
        this.addDefinition(horizontalSolidLineDef);
        this.addDefinition(verticalSolidLineDef);
        this.addDefinition(horizontalDashLineDef);
        this.addDefinition(verticalDashLineDef);
        this.addDefinition(horizontalZeroLineDef);
        this.addDefinition(verticalZeroLineDef);
        Vector<SVGBase> gridLines = new Vector<SVGBase>();
        if (this.primaryDepAxis != null) {
            if (this.primaryDepAxis.isShowMajorGridLines()) {
                if (this.primaryDepAxis.getAxisOrientation() == 1) {
                    gridLines.addAll(this.drawHorizontalGridLines(this.primaryDepAxis, true));
                } else {
                    gridLines.addAll(this.drawVerticalGridLines(this.primaryDepAxis, true));
                }
            }
            if (this.primaryDepAxis.isShowMinorGridLines()) {
                if (this.primaryDepAxis.getAxisOrientation() == 1) {
                    gridLines.addAll(this.drawHorizontalGridLines(this.primaryDepAxis, false));
                } else {
                    gridLines.addAll(this.drawVerticalGridLines(this.primaryDepAxis, false));
                }
            }
            if (this.primaryDepAxis.isLinear && this.primaryDepAxis.getMin() <= 0.0 && this.primaryDepAxis.getMax() >= 0.0) {
                if (this.primaryDepAxis.getAxisOrientation() == 1) {
                    gridLines.add(this.drawHorizontalZeroLine(this.primaryDepAxis));
                } else {
                    gridLines.add(this.drawVerticalZeroLine(this.primaryDepAxis));
                }
            }
        }
        if (this.secondaryDepAxis != null) {
            if (this.secondaryDepAxis.isShowMajorGridLines()) {
                if (this.secondaryDepAxis.getAxisOrientation() == 1) {
                    gridLines.addAll(this.drawHorizontalGridLines(this.secondaryDepAxis, true));
                } else {
                    gridLines.addAll(this.drawVerticalGridLines(this.secondaryDepAxis, true));
                }
            }
            if (this.secondaryDepAxis.isShowMinorGridLines()) {
                if (this.secondaryDepAxis.getAxisOrientation() == 1) {
                    gridLines.addAll(this.drawHorizontalGridLines(this.secondaryDepAxis, false));
                } else {
                    gridLines.addAll(this.drawVerticalGridLines(this.secondaryDepAxis, false));
                }
            }
            if (this.secondaryDepAxis.isLinear && this.secondaryDepAxis.getMin() <= 0.0 && this.secondaryDepAxis.getMax() >= 0.0) {
                if (this.secondaryDepAxis.getAxisOrientation() == 1) {
                    gridLines.add(this.drawHorizontalZeroLine(this.secondaryDepAxis));
                } else {
                    gridLines.add(this.drawVerticalZeroLine(this.secondaryDepAxis));
                }
            }
        }
        if (this.indepAxis != null) {
            if (this.indepAxis.isShowMajorGridLines()) {
                if (this.indepAxis.getAxisOrientation() == 1) {
                    if (this.indepAxis instanceof AxisNumber) {
                        gridLines.addAll(this.drawHorizontalGridLines((AxisNumber)this.indepAxis, true));
                    } else {
                        gridLines.addAll(this.drawHorizontalGridLines((AxisCategory)this.indepAxis, true));
                    }
                } else if (this.indepAxis instanceof AxisNumber) {
                    gridLines.addAll(this.drawVerticalGridLines((AxisNumber)this.indepAxis, true));
                } else {
                    gridLines.addAll(this.drawVerticalGridLines((AxisCategory)this.indepAxis, true));
                }
            }
            if (this.indepAxis.isShowMinorGridLines()) {
                if (this.indepAxis.getAxisOrientation() == 1) {
                    if (this.indepAxis instanceof AxisNumber) {
                        gridLines.addAll(this.drawHorizontalGridLines((AxisNumber)this.indepAxis, false));
                    } else {
                        gridLines.addAll(this.drawHorizontalGridLines((AxisCategory)this.indepAxis, false));
                    }
                } else if (this.indepAxis instanceof AxisNumber) {
                    gridLines.addAll(this.drawVerticalGridLines((AxisNumber)this.indepAxis, false));
                } else {
                    gridLines.addAll(this.drawVerticalGridLines((AxisCategory)this.indepAxis, false));
                }
            }
            if (this.indepAxis instanceof AxisNumber) {
                AxisNumber numAxis = (AxisNumber)this.indepAxis;
                if (numAxis.isLinear && numAxis.getMin() <= 0.0 && numAxis.getMax() >= 0.0) {
                    if (this.indepAxis.getAxisOrientation() == 1) {
                        gridLines.add(this.drawHorizontalZeroLine(numAxis));
                    } else {
                        gridLines.add(this.drawVerticalZeroLine(numAxis));
                    }
                }
            }
        }
        SVGBase[] children = new SVGBase[gridLines.size() + 2];
        if (this.bkgroundColor != null && !this.bkgroundColor.equals("")) {
            SVGRectangle bkground = new SVGRectangle();
            bkground.setXCoordinate("0");
            bkground.setYCoordinate("0");
            bkground.setWidth(Double.toString(gridWidth));
            bkground.setHeight(this.getHeight());
            bkground.setFill(this.bkgroundColor);
            children[0] = bkground;
        }
        if (this.drawBorder) {
            SVGRectangle border = new SVGRectangle();
            border.setXCoordinate("0");
            border.setYCoordinate("0");
            border.setWidth(Double.toString(gridWidth));
            border.setHeight(this.getHeight());
            border.setFill("none");
            border.setStroke("#cccccc");
            children[1] = border;
        }
        int i = 0;
        while (i < gridLines.size()) {
            children[i + 2] = (SVGBase)gridLines.elementAt(i);
            ++i;
        }
        this.setChildren(children);
    }

    public void setIndepAxis(Axis axis) {
        this.indepAxis = axis;
    }

    public void setPrimaryDepAxis(AxisNumber axis) {
        this.primaryDepAxis = axis;
    }

    public void setSecondaryDepAxis(AxisNumber axis) {
        this.secondaryDepAxis = axis;
    }

    protected Vector drawHorizontalGridLines(AxisNumber axis, boolean major) {
        double[] values = major ? axis.getMajorUnitValues() : axis.getMinorUnitValues();
        double max_y = 0.0;
        double min_y = Double.parseDouble(this.getHeight());
        double max = axis.getMax();
        double min = axis.getMin();
        Vector<SVGUse> lines = new Vector<SVGUse>(values.length);
        int i = 0;
        while (i < values.length) {
            double line_y = this.getCoordinate(values[i], max_y, min_y, max, min);
            SVGUse useLine = new SVGUse();
            if (major) {
                useLine.setHref("#horizontalSolidLine");
            } else {
                useLine.setHref("#horizontalDashLine");
            }
            useLine.setXCoordinate("0");
            useLine.setYCoordinate(Double.toString(line_y));
            lines.add(useLine);
            ++i;
        }
        return lines;
    }

    protected SVGBase drawHorizontalZeroLine(AxisNumber axis) {
        double max_y = 0.0;
        double min_y = Double.parseDouble(this.getHeight());
        double max = axis.getMax();
        double min = axis.getMin();
        double line_y = this.getCoordinate(0.0, max_y, min_y, max, min);
        SVGUse useLine = new SVGUse();
        useLine.setHref("#horizontalZeroLine");
        useLine.setXCoordinate("0");
        useLine.setYCoordinate(Double.toString(line_y));
        return useLine;
    }

    protected Vector drawVerticalGridLines(AxisNumber axis, boolean major) {
        double[] values = major ? axis.getMajorUnitValues() : axis.getMinorUnitValues();
        double max_x = Double.parseDouble(this.getWidth());
        double min_x = 0.0;
        double max = axis.getMax();
        double min = axis.getMin();
        Vector<SVGUse> lines = new Vector<SVGUse>(values.length);
        int i = 0;
        while (i < values.length) {
            double line_x = this.isLTR ? this.getCoordinate(values[i], max_x, min_x, max, min) : this.getCoordinate(values[i], min_x, max_x, max, min);
            SVGUse useLine = new SVGUse();
            if (major) {
                useLine.setHref("#verticalSolidLine");
            } else {
                useLine.setHref("#verticalDashLine");
            }
            useLine.setXCoordinate(Double.toString(line_x));
            useLine.setYCoordinate("0");
            lines.add(useLine);
            ++i;
        }
        return lines;
    }

    protected Vector drawVerticalGridLines(AxisCategory axis, boolean major) {
        double[] values = major ? axis.getGroupBoundaryPositions() : axis.getGroupDataPositions();
        Vector<SVGUse> lines = new Vector<SVGUse>(values.length);
        int i = 0;
        while (i < values.length) {
            SVGUse useLine = new SVGUse();
            if (major) {
                useLine.setHref("#verticalSolidLine");
            } else {
                useLine.setHref("#verticalDashLine");
            }
            useLine.setXCoordinate(Double.toString(values[i]));
            useLine.setYCoordinate("0");
            lines.add(useLine);
            ++i;
        }
        return lines;
    }

    protected Vector drawHorizontalGridLines(AxisCategory axis, boolean major) {
        double[] values = major ? axis.getGroupBoundaryPositions() : axis.getGroupDataPositions();
        Vector<SVGUse> lines = new Vector<SVGUse>(values.length);
        int i = 0;
        while (i < values.length) {
            SVGUse useLine = new SVGUse();
            if (major) {
                useLine.setHref("#horizontalSolidLine");
            } else {
                useLine.setHref("#horizontalDashLine");
            }
            useLine.setXCoordinate("0");
            useLine.setYCoordinate(Double.toString(values[i]));
            lines.add(useLine);
            ++i;
        }
        return lines;
    }

    protected SVGBase drawVerticalZeroLine(AxisNumber axis) {
        double max_x = Double.parseDouble(this.getWidth());
        double min_x = 0.0;
        double max = axis.getMax();
        double min = axis.getMin();
        double line_x = this.isLTR ? this.getCoordinate(0.0, max_x, min_x, max, min) : this.getCoordinate(0.0, min_x, max_x, max, min);
        SVGUse useLine = new SVGUse();
        useLine.setHref("#verticalZeroLine");
        useLine.setXCoordinate(Double.toString(line_x));
        useLine.setYCoordinate("0");
        return useLine;
    }

    protected double getCoordinate(double value, double max_coor, double min_coor, double max, double min) {
        return (value - max) / (min - max) * (min_coor - max_coor) + max_coor;
    }
}

