/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import java.util.Vector;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGFeComponentTransfer;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGFeFunc;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGFilter;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolygon;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolyline;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGRectangle;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGUse;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisCategory;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisNumber;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.Grid;

public class Grid3D
extends Grid {
    protected double x3Doffset;
    protected double y3Doffset;
    static final long serialVersionUID = 8771697403582307286L;

    public Grid3D(Chart input, boolean isLTR) {
        super(input, isLTR);
    }

    public Grid3D(Chart input, boolean isLTR, double x, double y, double width, double height, double x3Doffset, double y3Doffset) {
        super(input, isLTR, x, y, width, height);
        this.x3Doffset = x3Doffset;
        this.y3Doffset = -y3Doffset;
    }

    protected void constructPart() {
        double gridWidth = this.width - 1.0;
        SVGPolyline horizontalSolidLineDef = new SVGPolyline();
        horizontalSolidLineDef.setFill("none");
        if (this.isLTR) {
            horizontalSolidLineDef.setPoints("0 0 " + this.x3Doffset + " " + this.y3Doffset + " " + gridWidth + " " + this.y3Doffset);
        } else {
            horizontalSolidLineDef.setPoints(String.valueOf(this.x3Doffset) + " " + this.y3Doffset + " " + gridWidth + " " + this.y3Doffset);
        }
        horizontalSolidLineDef.setStyleClass("gridline");
        horizontalSolidLineDef.setIdentifier("horizontalSolidLine");
        SVGPolyline verticalSolidLineDef = new SVGPolyline();
        verticalSolidLineDef.setFill("none");
        verticalSolidLineDef.setPoints(String.valueOf(this.x3Doffset) + " 0 " + this.x3Doffset + " " + (this.height + this.y3Doffset) + " 0 " + this.height);
        verticalSolidLineDef.setStyleClass("gridline");
        verticalSolidLineDef.setIdentifier("verticalSolidLine");
        SVGPolyline horizontalDashLineDef = new SVGPolyline();
        horizontalDashLineDef.setFill("none");
        if (this.isLTR) {
            horizontalDashLineDef.setPoints("0 0 " + this.x3Doffset + " " + this.y3Doffset + " " + gridWidth + " " + this.y3Doffset);
        } else {
            horizontalDashLineDef.setPoints(String.valueOf(this.x3Doffset) + " " + this.y3Doffset + " " + gridWidth + " " + this.y3Doffset);
        }
        horizontalDashLineDef.setStyleClass("griddashline");
        horizontalDashLineDef.setIdentifier("horizontalDashLine");
        SVGPolyline verticalDashLineDef = new SVGPolyline();
        verticalDashLineDef.setFill("none");
        verticalDashLineDef.setPoints(String.valueOf(this.x3Doffset) + " 0 " + this.x3Doffset + " " + (this.height + this.y3Doffset) + " 0 " + this.height);
        verticalDashLineDef.setStyleClass("griddashline");
        verticalDashLineDef.setIdentifier("verticalDashLine");
        SVGPolygon horizontalZeroLineDef = new SVGPolygon();
        horizontalZeroLineDef.setPoints("0,0 " + (gridWidth - this.x3Doffset) + ",0 " + gridWidth + ", " + this.y3Doffset + " " + this.x3Doffset + "," + this.y3Doffset);
        horizontalZeroLineDef.setStyleClass("zero3DAxisLines");
        horizontalZeroLineDef.setIdentifier("horizontalZeroLine");
        SVGPolygon verticalZeroLineDef = new SVGPolygon();
        verticalZeroLineDef.setPoints("0," + -this.y3Doffset + " " + this.x3Doffset + ",0 " + this.x3Doffset + "," + (this.height + this.y3Doffset) + " 0," + this.height);
        verticalZeroLineDef.setStyleClass("zero3DAxisLines");
        verticalZeroLineDef.setIdentifier("verticalZeroLine");
        SVGPolygon horizontalLineDef = new SVGPolygon();
        horizontalLineDef.setPoints("0,0 " + (gridWidth - this.x3Doffset) + ",0 " + gridWidth + ", " + this.y3Doffset + " " + this.x3Doffset + "," + this.y3Doffset);
        horizontalLineDef.setStyleClass("axis3DLimitLines");
        horizontalLineDef.setIdentifier("horizontalLimitLine");
        horizontalLineDef.setFilter("url(#top-dimension)");
        SVGPolygon verticalLineDef = new SVGPolygon();
        verticalLineDef.setPoints("0," + -this.y3Doffset + " " + this.x3Doffset + ",0 " + this.x3Doffset + "," + (this.height + this.y3Doffset) + " 0," + this.height);
        verticalLineDef.setStyleClass("axis3DLimitLines");
        verticalLineDef.setIdentifier("verticalLimitLine");
        verticalLineDef.setFilter("url(#right-dimension)");
        SVGFilter filter = new SVGFilter();
        filter.setIdentifier("right-dimension");
        SVGFeComponentTransfer feComponentTransfer = new SVGFeComponentTransfer();
        SVGBase[] feComponentTransferPart = new SVGFeComponentTransfer[]{feComponentTransfer};
        filter.setChildren(feComponentTransferPart);
        SVGBase[] feFuncPart = new SVGFeFunc[3];
        SVGFeFunc feFunc = new SVGFeFunc("R");
        feFunc.setSlope("1");
        feFunc.setIntercept("-0.1");
        feFunc.setType("linear");
        feFuncPart[0] = feFunc;
        feFunc = new SVGFeFunc("G");
        feFunc.setSlope("1");
        feFunc.setIntercept("-0.1");
        feFunc.setType("linear");
        feFuncPart[1] = feFunc;
        feFunc = new SVGFeFunc("B");
        feFunc.setSlope("1");
        feFunc.setIntercept("-0.1");
        feFunc.setType("linear");
        feFuncPart[2] = feFunc;
        feComponentTransfer.setChildren(feFuncPart);
        this.addDefinition(filter);
        filter = new SVGFilter();
        filter.setIdentifier("top-dimension");
        feComponentTransferPart = new SVGFeComponentTransfer[1];
        feComponentTransfer = new SVGFeComponentTransfer();
        feComponentTransferPart[0] = feComponentTransfer;
        filter.setChildren(feComponentTransferPart);
        feFuncPart = new SVGFeFunc[3];
        feFunc = new SVGFeFunc("R");
        feFunc.setSlope("1");
        feFunc.setIntercept("0.1");
        feFunc.setType("linear");
        feFuncPart[0] = feFunc;
        feFunc = new SVGFeFunc("G");
        feFunc.setSlope("1");
        feFunc.setIntercept("0.1");
        feFunc.setType("linear");
        feFuncPart[1] = feFunc;
        feFunc = new SVGFeFunc("B");
        feFunc.setSlope("1");
        feFunc.setIntercept("0.1");
        feFunc.setType("linear");
        feFuncPart[2] = feFunc;
        feComponentTransfer.setChildren(feFuncPart);
        this.addDefinition(filter);
        this.addDefinition(horizontalSolidLineDef);
        this.addDefinition(verticalSolidLineDef);
        this.addDefinition(horizontalDashLineDef);
        this.addDefinition(verticalDashLineDef);
        this.addDefinition(horizontalZeroLineDef);
        this.addDefinition(verticalZeroLineDef);
        this.addDefinition(horizontalLineDef);
        this.addDefinition(verticalLineDef);
        Vector<SVGBase> gridLines = new Vector<SVGBase>();
        if (this.primaryDepAxis != null) {
            if (this.primaryDepAxis.isShowMajorGridLines()) {
                if (this.primaryDepAxis.getAxisOrientation() == 1) {
                    gridLines.addAll(this.drawHorizontalGridLines(this.primaryDepAxis, true));
                } else {
                    gridLines.addAll(this.drawVerticalGridLines(this.primaryDepAxis, true));
                }
            }
            if (this.primaryDepAxis.isShowMinorGridLines()) {
                if (this.primaryDepAxis.getAxisOrientation() == 1) {
                    gridLines.addAll(this.drawHorizontalGridLines(this.primaryDepAxis, false));
                } else {
                    gridLines.addAll(this.drawVerticalGridLines(this.primaryDepAxis, false));
                }
            }
        }
        if (this.secondaryDepAxis != null) {
            if (this.secondaryDepAxis.isShowMajorGridLines()) {
                if (this.secondaryDepAxis.getAxisOrientation() == 1) {
                    gridLines.addAll(this.drawHorizontalGridLines(this.secondaryDepAxis, true));
                } else {
                    gridLines.addAll(this.drawVerticalGridLines(this.secondaryDepAxis, true));
                }
            }
            if (this.secondaryDepAxis.isShowMinorGridLines()) {
                if (this.secondaryDepAxis.getAxisOrientation() == 1) {
                    gridLines.addAll(this.drawHorizontalGridLines(this.secondaryDepAxis, false));
                } else {
                    gridLines.addAll(this.drawVerticalGridLines(this.secondaryDepAxis, false));
                }
            }
        }
        if (this.indepAxis != null) {
            if (this.indepAxis.isShowMajorGridLines()) {
                if (this.indepAxis.getAxisOrientation() == 1) {
                    if (this.indepAxis instanceof AxisNumber) {
                        gridLines.addAll(this.drawHorizontalGridLines((AxisNumber)this.indepAxis, true));
                    } else {
                        gridLines.addAll(this.drawHorizontalGridLines((AxisCategory)this.indepAxis, true));
                    }
                } else if (this.indepAxis instanceof AxisNumber) {
                    gridLines.addAll(this.drawVerticalGridLines((AxisNumber)this.indepAxis, true));
                } else {
                    gridLines.addAll(this.drawVerticalGridLines((AxisCategory)this.indepAxis, true));
                }
            }
            if (this.indepAxis.isShowMinorGridLines()) {
                if (this.indepAxis.getAxisOrientation() == 1) {
                    if (this.indepAxis instanceof AxisNumber) {
                        gridLines.addAll(this.drawHorizontalGridLines((AxisNumber)this.indepAxis, false));
                    } else {
                        gridLines.addAll(this.drawHorizontalGridLines((AxisCategory)this.indepAxis, false));
                    }
                } else if (this.indepAxis instanceof AxisNumber) {
                    gridLines.addAll(this.drawVerticalGridLines((AxisNumber)this.indepAxis, false));
                } else {
                    gridLines.addAll(this.drawVerticalGridLines((AxisCategory)this.indepAxis, false));
                }
            }
        }
        if (this.primaryDepAxis != null && this.primaryDepAxis.isLinear && this.primaryDepAxis.getMin() <= 0.0 && this.primaryDepAxis.getMax() >= 0.0) {
            if (this.primaryDepAxis.getAxisOrientation() == 1) {
                gridLines.add(this.drawHorizontalZeroLine(this.primaryDepAxis));
            } else if (this.isLTR || !this.input.getType().equals("horizontalStackedBar3D")) {
                gridLines.add(this.drawVerticalZeroLine(this.primaryDepAxis));
            }
        }
        if (this.secondaryDepAxis != null && this.secondaryDepAxis.isLinear && this.secondaryDepAxis.getMin() <= 0.0 && this.secondaryDepAxis.getMax() >= 0.0) {
            if (this.secondaryDepAxis.getAxisOrientation() == 1) {
                gridLines.add(this.drawHorizontalZeroLine(this.secondaryDepAxis));
            } else {
                gridLines.add(this.drawVerticalZeroLine(this.secondaryDepAxis));
            }
        }
        if (this.indepAxis != null && this.indepAxis instanceof AxisNumber) {
            AxisNumber numAxis = (AxisNumber)this.indepAxis;
            if (numAxis.isLinear && numAxis.getMin() <= 0.0 && numAxis.getMax() >= 0.0) {
                if (this.indepAxis.getAxisOrientation() == 1) {
                    gridLines.add(this.drawHorizontalZeroLine(numAxis));
                } else {
                    gridLines.add(this.drawVerticalZeroLine(numAxis));
                }
            }
        }
        SVGBase[] children = new SVGBase[gridLines.size() + 4];
        if (this.isLTR) {
            children[0] = this.drawXAxisLimitLines();
            children[1] = this.drawYAxisLimitLines();
        } else {
            children[1] = this.drawXAxisLimitLines();
            children[0] = this.drawYAxisLimitLines();
        }
        if (this.bkgroundColor != null && !this.bkgroundColor.equals("")) {
            SVGRectangle bkground = new SVGRectangle();
            bkground.setXCoordinate("0");
            bkground.setYCoordinate("0");
            bkground.setWidth(Double.toString(gridWidth));
            bkground.setHeight(this.getHeight());
            bkground.setFill(this.bkgroundColor);
            children[2] = bkground;
        }
        if (this.drawBorder) {
            SVGPolygon border = new SVGPolygon();
            border.setPoints(String.valueOf(this.x3Doffset) + ",0 " + gridWidth + ",0 " + gridWidth + "," + (this.height - Math.abs(this.y3Doffset)) + " " + this.x3Doffset + "," + (this.height - Math.abs(this.y3Doffset)));
            border.setFill("none");
            border.setStroke("#cccccc");
            children[3] = border;
        }
        int i = 0;
        while (i < gridLines.size()) {
            children[i + 4] = (SVGBase)gridLines.elementAt(i);
            ++i;
        }
        this.setChildren(children);
    }

    protected Vector drawHorizontalGridLines(AxisNumber axis, boolean major) {
        double[] values = major ? axis.getMajorUnitValues() : axis.getMinorUnitValues();
        double max_y = Math.abs(this.y3Doffset);
        double min_y = Double.parseDouble(this.getHeight());
        double max = axis.getMax();
        double min = axis.getMin();
        Vector<SVGUse> lines = new Vector<SVGUse>(values.length);
        int i = 0;
        while (i < values.length) {
            double line_y = this.getCoordinate(values[i], max_y, min_y, max, min);
            SVGUse useLine = new SVGUse();
            if (major) {
                useLine.setHref("#horizontalSolidLine");
            } else {
                useLine.setHref("#horizontalDashLine");
            }
            useLine.setXCoordinate("0");
            useLine.setYCoordinate(Double.toString(line_y));
            lines.add(useLine);
            ++i;
        }
        SVGUse verticalLine = new SVGUse();
        verticalLine.setHref("#verticalSolidLine");
        verticalLine.setXCoordinate("0");
        verticalLine.setYCoordinate("0");
        lines.add(verticalLine);
        return lines;
    }

    protected SVGBase drawHorizontalZeroLine(AxisNumber axis) {
        double max_y = Math.abs(this.y3Doffset);
        double min_y = Double.parseDouble(this.getHeight());
        double max = axis.getMax();
        double min = axis.getMin();
        double line_y = this.getCoordinate(0.0, max_y, min_y, max, min);
        SVGUse useLine = new SVGUse();
        useLine.setHref("#horizontalZeroLine");
        useLine.setXCoordinate("0");
        useLine.setYCoordinate(Double.toString(line_y));
        return useLine;
    }

    protected Vector drawVerticalGridLines(AxisNumber axis, boolean major) {
        double[] values = major ? axis.getMajorUnitValues() : axis.getMinorUnitValues();
        double max_x = Double.parseDouble(this.getWidth()) - Math.abs(this.x3Doffset);
        double min_x = 0.0;
        double max = axis.getMax();
        double min = axis.getMin();
        Vector<SVGUse> lines = new Vector<SVGUse>(values.length);
        int i = 0;
        while (i < values.length) {
            double line_x = this.isLTR ? this.getCoordinate(values[i], max_x, min_x, max, min) : this.getCoordinate(values[i], min_x, max_x, max, min);
            SVGUse useLine = new SVGUse();
            if (major) {
                useLine.setHref("#verticalSolidLine");
            } else {
                useLine.setHref("#verticalDashLine");
            }
            useLine.setXCoordinate(Double.toString(line_x));
            useLine.setYCoordinate("0");
            lines.add(useLine);
            ++i;
        }
        SVGUse horizontalLine = new SVGUse();
        horizontalLine.setHref("#horizontalSolidLine");
        horizontalLine.setXCoordinate("0");
        horizontalLine.setYCoordinate(this.getHeight());
        lines.add(horizontalLine);
        return lines;
    }

    protected Vector drawVerticalGridLines(AxisCategory axis, boolean major) {
        double[] values = major ? axis.getGroupBoundaryPositions() : axis.getGroupDataPositions();
        Vector<SVGUse> lines = new Vector<SVGUse>(values.length);
        int i = 0;
        while (i < values.length) {
            SVGUse useLine = new SVGUse();
            if (major) {
                useLine.setHref("#verticalSolidLine");
            } else {
                useLine.setHref("#verticalDashLine");
            }
            useLine.setXCoordinate(Double.toString(values[i]));
            useLine.setYCoordinate("0");
            lines.add(useLine);
            ++i;
        }
        return lines;
    }

    protected Vector drawHorizontalGridLines(AxisCategory axis, boolean major) {
        double[] values = major ? axis.getGroupBoundaryPositions() : axis.getGroupDataPositions();
        Vector<SVGUse> lines = new Vector<SVGUse>(values.length);
        int i = 0;
        while (i < values.length) {
            SVGUse useLine = new SVGUse();
            if (major) {
                useLine.setHref("#horizontalSolidLine");
            } else {
                useLine.setHref("#horizontalDashLine");
            }
            useLine.setXCoordinate("0");
            useLine.setYCoordinate(Double.toString(values[i] - this.y3Doffset));
            lines.add(useLine);
            ++i;
        }
        return lines;
    }

    protected SVGBase drawVerticalZeroLine(AxisNumber axis) {
        double max_x = Double.parseDouble(this.getWidth()) - Math.abs(this.x3Doffset);
        double min_x = 0.0;
        double max = axis.getMax();
        double min = axis.getMin();
        double line_x = this.isLTR ? this.getCoordinate(0.0, max_x, min_x, max, min) : this.getCoordinate(0.0, min_x, max_x, max, min);
        SVGUse useLine = new SVGUse();
        useLine.setHref("#verticalZeroLine");
        useLine.setXCoordinate(Double.toString(line_x));
        useLine.setYCoordinate("0");
        return useLine;
    }

    protected SVGBase drawXAxisLimitLines() {
        double yAxisX = 0.0;
        if (!this.isLTR) {
            yAxisX = Double.parseDouble(this.getWidth()) - this.x3Doffset;
        }
        SVGUse useLine = new SVGUse();
        useLine.setHref("#verticalLimitLine");
        useLine.setXCoordinate(Double.toString(yAxisX));
        useLine.setYCoordinate("0");
        return useLine;
    }

    protected SVGBase drawYAxisLimitLines() {
        double xAxisY = Double.parseDouble(this.getHeight());
        SVGUse useLine = new SVGUse();
        useLine.setHref("#horizontalLimitLine");
        useLine.setXCoordinate("0");
        useLine.setYCoordinate(Double.toString(xAxisY));
        return useLine;
    }
}

