/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGRectangle;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.Legend;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGColorPalettes;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGShapes;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.SVGShapeIterator;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;

public class LegendHorizontalRTL
extends Legend {
    static final long serialVersionUID = 7379307583915137487L;
    protected double verticalScalingFactor = 1.0;
    protected double horizontalScalingFactor = 1.0;
    protected Coordinates[] legendItemCoordinates;

    public LegendHorizontalRTL(Chart input, double x, double y, double width, double height, double chartWidth, double chartHeight, int margin, SVGColorPalettes palettes, SVGShapes shapes, NLString nls) {
        super(input, x, y, width, height, chartWidth, chartHeight, margin, palettes, shapes, nls);
        this.isLTR = false;
        this.legendItemCoordinates = this.legendLabels != null ? new Coordinates[this.legendLabels.length] : new Coordinates[0];
        this.analyzeData();
    }

    protected void analyzeData() {
        int i;
        double currentX = this.chartWidth;
        double currentY = 10.0;
        double minX = this.chartWidth;
        double titleWidth = 0.0;
        boolean newLine = true;
        double lineHeight = 18.0;
        if (this.legendTitle != null) {
            this.fontHelper.setFontSize(10.0f);
            titleWidth = this.fontHelper.getStringWidth(this.nls.getString(this.legendTitle)) + 15.0;
            currentX -= titleWidth;
        }
        this.fontHelper.setFontSize(8.0f);
        if (this.useShapes && this.legendLabels != null) {
            Utilities.assertion(this.shapes != null);
            i = 0;
            while (i < this.legendLabels.length) {
                double itemWidth = 21.0 + this.fontHelper.getStringWidth(this.nls.getString(this.legendLabels[i])) + 10.0;
                if (currentX - itemWidth < 60.0 && i != 0) {
                    newLine = true;
                }
                if (newLine && i != 0) {
                    currentY += lineHeight;
                    if (currentX < minX) {
                        minX = currentX;
                    }
                    currentX = this.chartWidth - titleWidth;
                }
                this.legendItemCoordinates[i] = new Coordinates(currentX, currentY);
                currentX -= itemWidth;
                newLine = false;
                ++i;
            }
        } else if (!this.useShapes && this.legendLabels != null) {
            i = 0;
            while (i < this.legendLabels.length) {
                double itemWidth = 13.0 + this.fontHelper.getStringWidth(this.nls.getString(this.legendLabels[i])) + 10.0;
                if (currentX - itemWidth < 60.0 && i != 0) {
                    newLine = true;
                }
                if (newLine && i != 0) {
                    currentY += lineHeight;
                    if (currentX < minX) {
                        minX = currentX;
                    }
                    currentX = this.chartWidth - titleWidth;
                }
                this.legendItemCoordinates[i] = new Coordinates(currentX, currentY);
                currentX -= itemWidth;
                newLine = false;
                ++i;
            }
        }
        if (currentX < minX) {
            minX = currentX;
        }
        double naturalLengendHeight = currentY + 8.0 + 10.0;
        double naturalLegendWidth = this.chartWidth - minX;
        if (!this.isSetCustomHeight) {
            if (naturalLengendHeight < this.chartHeight * 0.5) {
                this.height = naturalLengendHeight;
            } else {
                this.height = this.chartHeight * 0.5;
                this.verticalScalingFactor = this.height / naturalLengendHeight;
            }
        } else {
            this.height = this.customHeight;
            this.verticalScalingFactor = this.height / naturalLengendHeight;
        }
        if (naturalLegendWidth > this.chartWidth - 60.0) {
            this.horizontalScalingFactor = (this.chartWidth - 60.0) / naturalLegendWidth;
        }
    }

    protected void constructPart() {
        SVGBase[] subElements = new SVGBase[2];
        this.setChildren(subElements);
        this.setIdentifier(this.legendId);
        SVGGroup legendGroup = new SVGGroup();
        SVGBase[] legendMembers = new SVGBase[this.numOfDataSets + 1];
        legendGroup.setChildren(legendMembers);
        SVGGroup translateGroup = new SVGGroup();
        SVGBase[] translateGroupMember = new SVGBase[1];
        translateGroup.setChildren(translateGroupMember);
        translateGroupMember[0] = legendGroup;
        subElements[1] = translateGroup;
        if (this.legendTitle != null) {
            legendMembers[0] = this.drawTitle(this.chartWidth, 18.0);
        }
        if (this.useShapes && this.legendLabels != null) {
            Utilities.assertion(this.shapes != null);
            SVGShapeIterator shapeIterator = this.shapes.getShapeIterator();
            int i = 0;
            while (i < this.legendLabels.length) {
                legendMembers[i + 1] = this.drawLegendItem(shapeIterator.getNextShapeId(this.datasetArray[i].getId()), shapeIterator.getShapeWidth(), shapeIterator.getShapeHeight(), this.legendItemCoordinates[i].x, this.legendItemCoordinates[i].y, i);
                ++i;
            }
        } else if (!this.useShapes && this.legendLabels != null) {
            int i = 0;
            while (i < this.legendLabels.length) {
                legendMembers[i + 1] = this.drawLegendItem(this.legendItemCoordinates[i].x, this.legendItemCoordinates[i].y, i);
                ++i;
            }
        }
        double xOffset = 0.0;
        double scalingFactor = 1.0;
        double d = scalingFactor = this.horizontalScalingFactor < this.verticalScalingFactor ? this.horizontalScalingFactor : this.verticalScalingFactor;
        if (scalingFactor < 1.0) {
            legendGroup.setTransformation("scale(" + scalingFactor + ")");
            xOffset = this.chartWidth * (1.0 - scalingFactor);
        }
        translateGroup.setTransformation("translate(" + (xOffset - 30.0) + ",0)");
        this.setHeight(Double.toString(this.height));
        if (this.backgroundColor != null && !this.backgroundColor.equals("")) {
            SVGRectangle bkground = new SVGRectangle();
            bkground.setXCoordinate("0");
            bkground.setYCoordinate("0");
            bkground.setWidth(this.getWidth());
            bkground.setHeight(this.getHeight());
            bkground.setFill(this.backgroundColor);
            subElements[0] = bkground;
        }
    }

    class Coordinates {
        public double x;
        public double y;

        public Coordinates(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }
}

