/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGLine;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolygon;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Line3D
extends SVGLine {
    static final long serialVersionUID = -4712262470499704315L;
    private double x3Doffset = 0.0;
    private double y3Doffset = 0.0;
    private String topDimensionFilter;
    private String rightDimensionFilter;
    private double xMax = 0.0;
    private double xMin = 0.0;
    private double yMax = 0.0;
    private double zeroYCoord = 0.0;
    private double zeroXCoord = 0.0;
    private boolean linear = false;
    private double yMin = 0.0;
    private boolean isLTR = false;
    private boolean isHorizontal = false;
    private double plotWidth;
    private double plotHieght;
    private boolean isNeg = false;
    private boolean stacked = false;

    public Element doImplementation(Document svgDocument) throws DOMException {
        SVGGroup lineGroup = new SVGGroup();
        lineGroup.setIdentifier(this.getIdentifier());
        SVGBase[] lineParts = new SVGBase[3];
        lineGroup.setChildren(lineParts);
        double width = Double.parseDouble(this.getStrokeWidth());
        double d_x1 = Double.parseDouble(this.getX1());
        double d_x2 = Double.parseDouble(this.getX2());
        double d_y1 = Double.parseDouble(this.getY1()) + this.y3Doffset;
        double d_y2 = Double.parseDouble(this.getY2()) + this.y3Doffset;
        double br_x = 0.0;
        double br_y = 0.0;
        double tr_x = 0.0;
        double tr_y = 0.0;
        double bl_x = 0.0;
        double bl_y = 0.0;
        double tl_x = 0.0;
        double tl_y = 0.0;
        if (this.isHorizontal) {
            bl_x = tl_x = d_x1 - width / 2.0;
            tr_x = br_x = d_x1 + width / 2.0;
            if (d_y1 < d_y2) {
                if (d_y1 < this.yMin + this.y3Doffset) {
                    d_y1 = this.yMin + this.y3Doffset;
                }
                if (d_y2 > this.yMax) {
                    d_y2 = this.yMax;
                }
                tr_y = tl_y = d_y1;
                br_y = bl_y = d_y2;
            } else if (d_y1 >= d_y2) {
                if (d_y2 < this.yMin + this.y3Doffset) {
                    d_y2 = this.yMin + this.y3Doffset;
                }
                if (d_y2 < this.yMax && d_y1 > this.yMax) {
                    d_y1 = this.yMax;
                }
                tr_y = tl_y = d_y2;
                br_y = bl_y = d_y1;
            }
        } else {
            tr_y = tl_y = d_y1 - width / 2.0;
            bl_y = br_y = d_y1 + width / 2.0;
            if (d_x1 <= d_x2) {
                if (!(d_x2 < this.xMin) && d_x1 < this.xMin) {
                    d_x1 = this.xMin;
                }
                if (!(d_x1 > this.xMax) && d_x2 > this.xMax) {
                    d_x2 = this.xMax;
                }
                br_x = tr_x = d_x2;
                tl_x = bl_x = d_x1;
            } else if (d_x1 > d_x2) {
                if (!(d_x1 < this.xMin) && d_x2 < this.xMin) {
                    d_x2 = this.xMin;
                }
                if (!(d_x2 > this.xMax) && d_x1 > this.xMax) {
                    d_x1 = this.xMax;
                }
                br_x = tr_x = d_x1;
                tl_x = bl_x = d_x2;
            }
        }
        if (!this.linear) {
            this.isNeg = false;
        }
        SVGPolygon mainPoly = new SVGPolygon();
        mainPoly.setStyleClass(this.getStyleClass());
        mainPoly.setStroke("none");
        String mainPolyStr = "";
        if (this.getFill() != null) {
            mainPoly.setFill(this.getFill());
        }
        lineParts[0] = mainPoly;
        if (tr_x - tl_x >= 1.0 && (this.isHorizontal && (!this.isNeg || this.zeroYCoord < this.yMin) || !this.isHorizontal)) {
            SVGPolygon topPoly = new SVGPolygon();
            topPoly.setStroke("none");
            topPoly.setStyleClass(this.getStyleClass());
            topPoly.setFill(this.getFill());
            if ((this.isLTR || !this.stacked) && !this.isHorizontal && tr_y - this.y3Doffset + 3.0 > this.yMin + this.y3Doffset && !this.isHorizontal && (!this.isLTR && tr_x + this.x3Doffset >= this.zeroXCoord && !this.isNeg || !this.isLTR && tr_x + this.x3Doffset >= this.plotWidth - this.x3Doffset && !this.isNeg || this.isLTR && tr_x + this.x3Doffset >= this.zeroXCoord && this.isNeg)) {
                topPoly.setPoints(String.valueOf(tr_x) + "," + tr_y + " " + tl_x + "," + tl_y + " " + (tl_x + this.x3Doffset) + "," + (tl_y - this.y3Doffset) + " " + tr_x + "," + (tr_y - this.y3Doffset) + " ");
                mainPolyStr = String.valueOf(mainPolyStr) + tl_x + "," + tl_y + " " + (tl_x + this.x3Doffset) + "," + (tl_y - this.y3Doffset) + " " + tr_x + "," + (tr_y - this.y3Doffset) + " ";
            } else {
                topPoly.setPoints(String.valueOf(tr_x) + "," + tr_y + " " + tl_x + "," + tl_y + " " + (tl_x + this.x3Doffset) + "," + (tl_y - this.y3Doffset) + " " + (tr_x + this.x3Doffset) + "," + (tr_y - this.y3Doffset) + " ");
                mainPolyStr = String.valueOf(mainPolyStr) + tl_x + "," + tl_y + " " + (tl_x + this.x3Doffset) + "," + (tl_y - this.y3Doffset) + " " + (tr_x + this.x3Doffset) + "," + (tr_y - this.y3Doffset) + " ";
            }
            topPoly.setFilter(this.topDimensionFilter);
            lineParts[1] = topPoly;
        }
        if ((!this.isHorizontal && !this.isNeg || !this.isHorizontal && this.isNeg && !this.isLTR || this.isHorizontal || !this.isHorizontal && this.isNeg && this.isLTR && br_x == this.xMax && this.zeroXCoord > this.xMax) && (this.isLTR || this.isNeg || this.isHorizontal || !this.isHorizontal && this.isNeg && this.isLTR && br_x == this.xMax && this.zeroXCoord > this.xMax)) {
            SVGPolygon rightPoly = new SVGPolygon();
            rightPoly.setStroke("none");
            rightPoly.setStyleClass(this.getStyleClass());
            if (this.getFill() != null) {
                rightPoly.setFill(this.getFill());
            }
            if (this.isHorizontal && this.isNeg && tr_y - this.y3Doffset <= this.zeroYCoord) {
                rightPoly.setPoints(String.valueOf(br_x) + "," + br_y + " " + tr_x + "," + tr_y + " " + (tr_x + this.x3Doffset) + "," + tr_y + " " + (br_x + this.x3Doffset) + "," + (br_y - this.y3Doffset) + " ");
                mainPolyStr = String.valueOf(mainPolyStr) + (tr_x + this.x3Doffset) + "," + tr_y + " " + (br_x + this.x3Doffset) + "," + (br_y - this.y3Doffset) + " ";
            } else {
                rightPoly.setPoints(String.valueOf(br_x) + "," + br_y + " " + tr_x + "," + tr_y + " " + (tr_x + this.x3Doffset) + "," + (tr_y - this.y3Doffset) + " " + (br_x + this.x3Doffset) + "," + (br_y - this.y3Doffset) + " ");
                mainPolyStr = String.valueOf(mainPolyStr) + (br_x + this.x3Doffset) + "," + (br_y - this.y3Doffset) + " ";
            }
            rightPoly.setFilter(this.rightDimensionFilter);
            lineParts[2] = rightPoly;
        }
        if (lineParts[2] == null) {
            mainPolyStr = String.valueOf(mainPolyStr) + tr_x + "," + tr_y + " ";
        }
        mainPolyStr = String.valueOf(mainPolyStr) + br_x + "," + br_y + " " + bl_x + "," + bl_y + " ";
        if (lineParts[1] == null) {
            mainPolyStr = String.valueOf(mainPolyStr) + tl_x + "," + tl_y + " " + tr_x + "," + tr_y + " ";
        }
        mainPoly.setPoints(mainPolyStr);
        return lineGroup.doImplementation(svgDocument);
    }

    public String getRightDimensionFilter() {
        return this.rightDimensionFilter;
    }

    public String getTopDimensionFilter() {
        return this.topDimensionFilter;
    }

    public void setRightDimensionFilter(String rightDimensionFilter) {
        this.rightDimensionFilter = rightDimensionFilter;
    }

    public void setTopDimensionFilter(String topDimensionFilter) {
        this.topDimensionFilter = topDimensionFilter;
    }

    public double getXMax() {
        return this.xMax;
    }

    public double getXMin() {
        return this.xMin;
    }

    public double getYMax() {
        return this.yMax;
    }

    public double getYMin() {
        return this.yMin;
    }

    public void setXMax(double xMax) {
        this.xMax = xMax;
    }

    public void setXMin(double xMin) {
        this.xMin = xMin;
    }

    public void setYMax(double yMax) {
        this.yMax = yMax;
    }

    public void setYMin(double yMin) {
        this.yMin = yMin;
    }

    public double getX3Doffset() {
        return this.x3Doffset;
    }

    public double getY3Doffset() {
        return this.y3Doffset;
    }

    public void setX3Doffset(double x3Doffset) {
        this.x3Doffset = x3Doffset;
    }

    public void setY3Doffset(double y3Doffset) {
        this.y3Doffset = y3Doffset;
    }

    public double getZeroYCoord() {
        return this.zeroYCoord;
    }

    public void setZeroYCoord(double zeroYCoord) {
        this.zeroYCoord = zeroYCoord;
    }

    public double getZeroXCoord() {
        return this.zeroXCoord;
    }

    public void setZeroXCoord(double zeroXCoord) {
        this.zeroXCoord = zeroXCoord;
    }

    public boolean isLinear() {
        return this.linear;
    }

    public void setLinear(boolean linear) {
        this.linear = linear;
    }

    public boolean isLTR() {
        return this.isLTR;
    }

    public void setIsLTR(boolean isLTR) {
        this.isLTR = isLTR;
    }

    public boolean isHorizontal() {
        return this.isHorizontal;
    }

    public void setIsHorizontal(boolean isHorizontal) {
        this.isHorizontal = isHorizontal;
    }

    public void setPlotHieght(double plotHieght) {
        this.plotHieght = plotHieght;
    }

    public void setPlotWidth(double plotWidth) {
        this.plotWidth = plotWidth;
    }

    public boolean isNeg() {
        return this.isNeg;
    }

    public void setIsNeg(boolean isNeg) {
        this.isNeg = isNeg;
    }

    public boolean isStacked() {
        return this.stacked;
    }

    public void setStacked(boolean stacked) {
        this.stacked = stacked;
    }
}

