/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import java.util.List;
import java.util.Vector;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGLine;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.AxisDefinition;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.MarkerLine;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.Axis;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisNumber;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.EventTools;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.Part;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;

public class MarkerLines
extends Part {
    static final long serialVersionUID = 7569584230566675280L;
    private Axis indepAxis = null;
    private AxisNumber primaryDepAxis = null;
    private AxisNumber secondaryDepAxis = null;
    private AxisDefinition indepAxisDef = null;
    private AxisDefinition primaryDepAxisDef = null;
    private AxisDefinition secondaryDepAxisDef = null;
    private String indepAxisPosition = null;
    private boolean isLTR = true;
    protected NLString nls;

    public MarkerLines(Chart input, boolean isLTR, double x, double y, double width, double height, String indepAxisPosition, NLString nls) {
        super(input, x, y, width, height);
        this.indepAxisPosition = indepAxisPosition;
        this.isLTR = isLTR;
        this.nls = nls;
    }

    public void setIndepAxis(Axis axis) {
        this.indepAxis = axis;
    }

    public void setPrimaryDepAxis(AxisNumber axis) {
        this.primaryDepAxis = axis;
    }

    public void setSecondaryDepAxis(AxisNumber axis) {
        this.secondaryDepAxis = axis;
    }

    public void setIndepAxisDef(AxisDefinition axisDef) {
        this.indepAxisDef = axisDef;
    }

    public void setPrimaryDepAxisDef(AxisDefinition axisDef) {
        this.primaryDepAxisDef = axisDef;
    }

    public void setSecondaryDepAxisDef(AxisDefinition axisDef) {
        this.secondaryDepAxisDef = axisDef;
    }

    protected void constructPart() {
        List markerLines;
        Vector<SVGBase> lineVector = new Vector<SVGBase>();
        if (this.primaryDepAxisDef != null) {
            markerLines = this.primaryDepAxisDef.getMarkerLine();
            for (MarkerLine markerLine : markerLines) {
                if (this.indepAxisPosition.equals("S") || this.indepAxisPosition.equals("N")) {
                    lineVector.add(this.drawHorizontalMarkerLine(this.primaryDepAxis, markerLine));
                    continue;
                }
                lineVector.add(this.drawVerticalMarkerLine(this.primaryDepAxis, markerLine));
            }
        }
        if (this.secondaryDepAxisDef != null) {
            markerLines = this.secondaryDepAxisDef.getMarkerLine();
            for (MarkerLine markerLine : markerLines) {
                if (this.indepAxisPosition.equals("S") || this.indepAxisPosition.equals("N")) {
                    lineVector.add(this.drawHorizontalMarkerLine(this.secondaryDepAxis, markerLine));
                    continue;
                }
                lineVector.add(this.drawVerticalMarkerLine(this.secondaryDepAxis, markerLine));
            }
        }
        if (this.indepAxisDef != null && this.indepAxis instanceof AxisNumber) {
            markerLines = this.indepAxisDef.getMarkerLine();
            for (MarkerLine markerLine : markerLines) {
                if (this.indepAxisPosition.equals("S") || this.indepAxisPosition.equals("N")) {
                    lineVector.add(this.drawVerticalMarkerLine((AxisNumber)this.indepAxis, markerLine));
                    continue;
                }
                lineVector.add(this.drawHorizontalMarkerLine((AxisNumber)this.indepAxis, markerLine));
            }
        }
        SVGBase[] children = new SVGBase[lineVector.size()];
        int i = 0;
        while (i < lineVector.size()) {
            children[i] = (SVGBase)lineVector.elementAt(i);
            ++i;
        }
        this.setChildren(children);
    }

    private SVGBase drawHorizontalMarkerLine(AxisNumber axis, MarkerLine markerLine) {
        double value;
        SVGGroup lineGroup = new SVGGroup();
        SVGBase[] groupMembers = new SVGBase[2];
        lineGroup.setChildren(groupMembers);
        SVGLine horizontalMarkerLine = new SVGLine();
        groupMembers[0] = horizontalMarkerLine;
        double max_y = 0.0;
        double min_y = Double.parseDouble(this.getHeight());
        double max = axis.getMax();
        double min = axis.getMin();
        if (axis.isLinear) {
            value = markerLine.getValue();
        } else if (markerLine.getValue() > 0.0) {
            value = Math.log(markerLine.getValue()) / Math.log(10.0);
        } else {
            return lineGroup;
        }
        double y_coor = this.getCoordinate(value, max_y, min_y, max, min);
        horizontalMarkerLine.setX1("0");
        horizontalMarkerLine.setY1(Double.toString(y_coor));
        horizontalMarkerLine.setX2(this.getWidth());
        horizontalMarkerLine.setY2(Double.toString(y_coor));
        if (markerLine.isSetThickness()) {
            horizontalMarkerLine.setStrokeWidth(Double.toString(markerLine.getThickness()));
        } else {
            horizontalMarkerLine.setStrokeWidth("1.5");
        }
        if (markerLine.getColor() != null) {
            horizontalMarkerLine.setStroke(markerLine.getColor());
        } else {
            horizontalMarkerLine.setStroke("red");
        }
        String label = this.nls.getString(markerLine.getLabel());
        if (label != null && label.length() != 0) {
            groupMembers[1] = EventTools.generateValueTooltip(lineGroup, label);
        }
        return lineGroup;
    }

    private SVGBase drawVerticalMarkerLine(AxisNumber axis, MarkerLine markerLine) {
        double value;
        SVGGroup lineGroup = new SVGGroup();
        SVGBase[] groupMembers = new SVGBase[2];
        lineGroup.setChildren(groupMembers);
        SVGLine verticalMarkerLine = new SVGLine();
        groupMembers[0] = verticalMarkerLine;
        double max_x = Double.parseDouble(this.getWidth());
        double min_x = 0.0;
        double max = axis.getMax();
        double min = axis.getMin();
        if (axis.isLinear) {
            value = markerLine.getValue();
        } else if (markerLine.getValue() > 0.0) {
            value = Math.log(markerLine.getValue()) / Math.log(10.0);
        } else {
            return lineGroup;
        }
        double x_coor = this.isLTR ? this.getCoordinate(value, max_x, min_x, max, min) : this.getCoordinate(value, min_x, max_x, max, min);
        verticalMarkerLine.setX1(Double.toString(x_coor));
        verticalMarkerLine.setY1("0");
        verticalMarkerLine.setX2(Double.toString(x_coor));
        verticalMarkerLine.setY2(this.getHeight());
        if (markerLine.isSetThickness()) {
            verticalMarkerLine.setStrokeWidth(Double.toString(markerLine.getThickness()));
        } else {
            verticalMarkerLine.setStrokeWidth("1.5");
        }
        if (markerLine.getColor() != null) {
            verticalMarkerLine.setStroke(markerLine.getColor());
        } else {
            verticalMarkerLine.setStroke("red");
        }
        String label = this.nls.getString(markerLine.getLabel());
        if (label != null) {
            groupMembers[1] = EventTools.generateValueTooltip(lineGroup, label);
        }
        return lineGroup;
    }

    private double getCoordinate(double value, double max_coor, double min_coor, double max, double min) {
        return (value - max) / (min - max) * (min_coor - max_coor) + max_coor;
    }
}

