/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisCategory;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisNumber;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.DataSetBar;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.PlotAreaXY;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGColorPalettes;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;

public class PlotAreaBar
extends PlotAreaXY {
    static final long serialVersionUID = -698368106011605017L;
    protected double barMaxWidth;
    protected double barPosition;
    protected double barWidth;
    protected double groupInterval;
    protected double barInterval;
    protected String indepAxisPosition;
    protected boolean useCategories;
    protected boolean isLTR;

    public PlotAreaBar(Chart input, boolean isLTR, double x, double y, double width, double height, SVGColorPalettes palettes, String indepAxisPosition, boolean useCategories, NLString nls) {
        super(input, x, y, width, height, nls);
        this.barWidth = this.barMaxWidth = 40.0;
        this.isLTR = true;
        this.palettes = palettes;
        this.indepAxisPosition = indepAxisPosition;
        this.isLTR = isLTR;
        this.useCategories = useCategories;
    }

    protected DataSet getDataSet(org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset, int datasetIndex, AxisNumber depAxis) {
        String[] colors = this.palettes.getPalette();
        int colorIndex = datasetIndex % colors.length;
        this.barPosition = this.numOfSets % 2 == 1 ? this.groupInterval / 2.0 - (double)(this.numOfSets / 2) * this.barInterval + (double)datasetIndex * this.barInterval : this.groupInterval / 2.0 - (double)(this.numOfSets / 2) * this.barInterval + 0.5 * this.barInterval + (double)datasetIndex * this.barInterval;
        DataSetBar datasetPart = new DataSetBar(this.input, this.isLTR, (AxisCategory)this.indepAxis, this.primaryDepAxis, dataset, datasetIndex, colorIndex, this.barWidth, this.barPosition, this.groupInterval, this.palettes, this.nls);
        datasetPart.setHeight(this.getHeight());
        datasetPart.setWidth(this.getWidth());
        return datasetPart;
    }

    public void initPlotArea() {
        if (this.useCategories) {
            this.groupInterval = this.indepAxis.getAxisLength() / (double)((AxisCategory)this.indepAxis).categoryList.size();
            this.barInterval = this.groupInterval / ((double)this.numOfSets + 1.5);
            if (this.barMaxWidth < this.barInterval) {
                this.barInterval = this.barMaxWidth;
                this.barWidth = this.barInterval - 2.0;
            } else {
                this.barWidth = this.barInterval < 5.0 ? this.barInterval - 0.1 : this.barInterval - 1.0;
            }
        }
    }
}

