/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGCircle;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGClipPath;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGRectangle;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGScript;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Categories;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSets;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.Axis;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisNumber;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.EventTools;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.PlotArea;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;

public abstract class PlotAreaXY
extends PlotArea {
    protected AxisNumber primaryDepAxis = null;
    protected AxisNumber secondaryDepAxis = null;
    protected Axis indepAxis = null;
    protected int numOfSets = 0;
    double[] accumulatedHighValues;
    double[] accumulatedLowValues;

    public PlotAreaXY(Chart input, double x, double y, double width, double height, NLString nls) {
        super(input, x, y, width, height, nls);
    }

    protected abstract DataSet getDataSet(org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet var1, int var2, AxisNumber var3);

    protected void constructPart() {
        DataSet datasetPart;
        SVGGroup foreground;
        if (this.primaryDataSets != null) {
            this.numOfSets += this.primaryDataSets.size();
        }
        if (this.secondaryDataSets != null) {
            this.numOfSets += this.secondaryDataSets.size();
        }
        Data data = this.input.getData();
        List dataSetList = null;
        SVGBase[] parts = new SVGBase[this.numOfSets * 2 + 3];
        if (data != null) {
            DataSets datasets = data.getDataSets();
            if (datasets != null) {
                dataSetList = datasets.getDataSet();
            }
            if (this.input.getType().equals("stackedArea")) {
                double min = Math.pow(10.0, this.primaryDepAxis.getMin());
                double value = this.primaryDepAxis.isLinear() ? 0.0 : min;
                double zero_y = this.getCoordinate(this.primaryDepAxis.isLinear(), value, 0.0, this.primaryDepAxis.getAxisLength(), this.primaryDepAxis.getMax(), this.primaryDepAxis.getMin());
                StringBuffer yBasePoint = new StringBuffer("var minBase = " + value + "; var yBasePoint = " + zero_y + ";");
                SVGScript scriptEmitter = new SVGScript();
                StringBuffer setDatasetArray = new StringBuffer("var xpts; var incl = new Array(true");
                int i = 1;
                while (i < this.numOfSets) {
                    setDatasetArray.append(",true");
                    ++i;
                }
                setDatasetArray.append(");");
                EventTools.generateStackAreaJSFunction(scriptEmitter, setDatasetArray.toString());
                Categories categories = data.getCategories();
                if (categories != null) {
                    List categoryList = categories.getCategory();
                    this.accumulatedHighValues = new double[categoryList.size()];
                    this.accumulatedLowValues = new double[categoryList.size()];
                }
                EventTools.generateStackAreaJSFunction(scriptEmitter, String.valueOf(setDatasetArray.toString()) + yBasePoint.toString());
                parts[this.numOfSets * 2 + 2] = scriptEmitter;
            }
        }
        SVGGroup group = new SVGGroup();
        group.setIdentifier("SVGGEN_datasetGroup");
        group.setChildren(parts);
        SVGCircle circle = new SVGCircle();
        circle.setRadius(Double.toString(2.8));
        circle.setCx(Double.toString(2.8));
        circle.setCy(Double.toString(2.8));
        circle.setStyle("stroke-width:0.75;fill:none;");
        circle.setIdentifier("SVGGEN_holeshape");
        this.addDefinition(circle);
        SVGBase[] groupChildren = new SVGBase[]{group};
        this.setChildren(groupChildren);
        if (this.input.getType().equals("line") || this.input.getType().equals("area") || this.input.getType().equals("stackedArea") || this.input.getType().equals("scatter")) {
            SVGClipPath clipPath = new SVGClipPath();
            clipPath.setIdentifier("SVGGEN_plotareaBorder");
            SVGBase[] clipPathChildren = new SVGBase[1];
            clipPath.setChildren(clipPathChildren);
            SVGRectangle border = new SVGRectangle();
            border.setXCoordinate("0");
            border.setYCoordinate("0");
            border.setWidth(Double.toString(this.width - 10.0));
            border.setHeight(Double.toString(this.height - 10.0));
            clipPathChildren[0] = border;
            this.addDefinition(clipPath);
        }
        SVGGroup bkground = new SVGGroup();
        if (this.input.getType().equals("line") || this.input.getType().equals("area") || this.input.getType().equals("stackedArea") || this.input.getType().equals("scatter")) {
            bkground.setStyle("clip-path: url(#SVGGEN_plotareaBorder)");
        }
        bkground.setIdentifier("SVGGEN_plotareaBackground");
        if (this.input.getType().equals("area") || this.input.getType().equals("stackedArea")) {
            bkground.setTransformation("translate(5.0,5.0)");
        }
        parts[0] = bkground;
        int curSetNum = 1;
        this.initPlotArea();
        if (this.primaryDataSets != null) {
            for (org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset : this.primaryDataSets) {
                int datasetIndex = dataSetList.indexOf(dataset);
                foreground = new SVGGroup();
                foreground.setIdentifier("SVGGEN_plotareaForeground_" + dataset.getId());
                parts[this.numOfSets + curSetNum] = foreground;
                datasetPart = this.getDataSet(dataset, datasetIndex, this.primaryDepAxis);
                parts[curSetNum++] = datasetPart;
            }
        }
        if (this.secondaryDataSets != null) {
            for (org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset : this.secondaryDataSets) {
                int datasetIndex = dataSetList.indexOf(dataset);
                foreground = new SVGGroup();
                foreground.setIdentifier("SVGGEN_plotareaForeground_" + dataset.getId());
                parts[this.numOfSets + curSetNum] = foreground;
                datasetPart = this.getDataSet(dataset, datasetIndex, this.secondaryDepAxis);
                parts[curSetNum++] = datasetPart;
            }
        }
    }

    public void setPrimaryDepAxis(AxisNumber axis) {
        this.primaryDepAxis = axis;
    }

    public void setSecondaryDepAxis(AxisNumber axis) {
        this.secondaryDepAxis = axis;
    }

    public void setIndepAxis(Axis axis) {
        this.indepAxis = axis;
    }

    protected void initPlotArea() {
    }
}

