/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import com.ibm.icu.util.StringTokenizer;
import com.ibm.icu.util.ULocale;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSetColor;
import org.eclipse.tptp.platform.report.chart.svg.internal.palettes.ColorPaletteSets;
import org.eclipse.tptp.platform.report.chart.svg.internal.palettes.PaletteSetType;
import org.eclipse.tptp.platform.report.chart.svg.internal.palettes.PaletteType;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.DefaultResources;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.PalettesDOMDocument;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.XMLLoader;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class SVGColorPalettes {
    private boolean useDefault = true;
    private String customPalettesId;
    private HashMap customGraphicColorPalettes = null;
    private HashMap customDisplayNameMap = null;
    private String[] customColorPalettes = null;
    private Object customPaletteSetId = null;
    private List customColorPaletteSet = null;
    private DefaultResources defaultResources = null;
    private String customPaletteDisplayName = null;
    private NLString nls = null;
    private ULocale locale = null;
    private HashMap dataSetColors = null;

    public SVGColorPalettes(DefaultResources defaultResources, ULocale locale) {
        this.defaultResources = defaultResources;
        this.locale = locale;
        this.dataSetColors = new HashMap();
        if (!defaultResources.isDefaultPalettesInitialized()) {
            this.initColorPalettes();
        }
        this.initNLString();
    }

    public HashMap getGraphicColorPalettes() {
        if (this.useDefault) {
            return this.defaultResources.getDefaultGraphicColorPalettes();
        }
        return this.customGraphicColorPalettes;
    }

    public String[] getPalette() {
        if (this.useDefault) {
            return this.defaultResources.getDefaultColorPalettes();
        }
        return this.customColorPalettes;
    }

    public String getPaletteColor(int colorIndex) {
        if (this.useDefault) {
            String[] colors = this.defaultResources.getDefaultColorPalettes();
            int numColors = colors.length;
            return colors[colorIndex % numColors];
        }
        int numColors = this.customColorPalettes.length;
        return this.customColorPalettes[colorIndex % numColors];
    }

    public String getPaletteId() {
        if (this.useDefault) {
            return this.defaultResources.getDefaultPalettesId();
        }
        return this.customPalettesId;
    }

    public String getPaletteDisplayName() {
        if (this.useDefault) {
            String displayNameKey = this.defaultResources.getDefaultColorPaletteDisplayName();
            if (displayNameKey != null && this.nls.getString(displayNameKey) != null) {
                return this.nls.getString(displayNameKey);
            }
            return this.getPaletteId();
        }
        if (this.customPaletteDisplayName != null && this.nls.getString(this.customPaletteDisplayName) != null) {
            return this.nls.getString(this.customPaletteDisplayName);
        }
        return this.getPaletteId();
    }

    public String getPaletteDisplayName(String paletteId) {
        HashMap displayNameMap = this.getDisplayNameMap();
        if (this.useDefault) {
            String displayNameKey = (String)displayNameMap.get(paletteId);
            if (displayNameKey != null && this.nls.getString(displayNameKey) != null) {
                return this.nls.getString(displayNameKey);
            }
            return this.getPaletteId();
        }
        if (this.customPaletteDisplayName != null && this.nls.getString(this.customPaletteDisplayName) != null) {
            return this.nls.getString(this.customPaletteDisplayName);
        }
        return this.getPaletteId();
    }

    public void setDataSetColors(List colorList) {
        for (DataSetColor dataSetColor : colorList) {
            try {
                DataSet dataSet = (DataSet)dataSetColor.getDataSetId();
                String dataSetId = dataSet.getId();
                String color = dataSetColor.getColor();
                this.dataSetColors.put(dataSetId, color);
            }
            catch (ClassCastException classCastException) {}
        }
    }

    public String getDataSetColor(String dataSetId) {
        String color = (String)this.dataSetColors.get(dataSetId);
        return color;
    }

    private HashMap getDisplayNameMap() {
        if (this.useDefault) {
            return this.defaultResources.getDefaultPaletteDisplayNames();
        }
        return this.customDisplayNameMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initColorPalettes() {
        DefaultResources defaultResources = this.defaultResources;
        synchronized (defaultResources) {
            String paletteXMLFile;
            if (this.defaultResources.isDefaultPalettesInitialized()) {
                return;
            }
            PalettesDOMDocument palettesDOM = null;
            boolean initialized = false;
            if (this.defaultResources.getResourceDir() != null && (palettesDOM = this.getPalettesFromInputFile(paletteXMLFile = String.valueOf(this.defaultResources.getResourceDir()) + "/palettes.xml")) != null) {
                initialized = this.parsePaletteDOM(palettesDOM);
            }
            if (!initialized && (palettesDOM = this.getPalettesFromDefaultLocation()) != null) {
                initialized = this.parsePaletteDOM(palettesDOM);
            }
            if (initialized) {
                this.defaultResources.setDefaultPalettesDOM(palettesDOM);
                this.defaultResources.setDefaultPalettesInitialized(true);
            } else {
                Utilities.assertion(this.defaultResources.isDefaultPalettesInitialized());
            }
        }
    }

    private void initNLString() {
        String resourceBundle = this.defaultResources.getPaletteResourceBundle();
        this.nls = resourceBundle != null && this.locale != null ? new NLString(resourceBundle, this.locale) : new NLString();
    }

    private PalettesDOMDocument getPalettesFromInputFile(String paletteXMLFile) {
        Document doc = null;
        XMLLoader xmlLoader = new XMLLoader();
        InputSource inputSource = new InputSource(paletteXMLFile);
        if (!xmlLoader.load(inputSource)) {
            return null;
        }
        doc = xmlLoader.getDOM();
        PalettesDOMDocument palettesDom = new PalettesDOMDocument(doc);
        return palettesDom;
    }

    private PalettesDOMDocument getPalettesFromDefaultLocation() {
        Document doc = null;
        XMLLoader xmlLoader = new XMLLoader();
        InputStream defaultShapes = Utilities.getResourceAsStream("org/eclipse/tptp/platform/report/chart/svg/internal/resources/palettes.xml");
        InputSource inputSource = new InputSource(defaultShapes);
        if (!xmlLoader.load(inputSource)) {
            return null;
        }
        doc = xmlLoader.getDOM();
        PalettesDOMDocument palettesDom = new PalettesDOMDocument(doc);
        return palettesDom;
    }

    private boolean parsePaletteDOM(PalettesDOMDocument palettesDom) {
        if (palettesDom != null) {
            this.getDefaultHashColorPaletteset(palettesDom);
            ColorPaletteSets defaultColorPaletteSets = palettesDom.getPalettes();
            if (defaultColorPaletteSets != null) {
                Object defaultPaletteSetId = defaultColorPaletteSets.getDefaultSetId();
                this.defaultResources.setDefaultPaletteSetId(defaultPaletteSetId);
                List defaultColorPaletteSet = defaultColorPaletteSets.getColorPaletteSet();
                this.defaultResources.setDefaultColorPaletteSet(defaultColorPaletteSet);
                String[] defaultColorPalettes = this.getDefaultPalette();
                this.defaultResources.setDefaultColorPalettes(defaultColorPalettes);
                PaletteSetType defaultPaletteSet = (PaletteSetType)defaultColorPaletteSets.getDefaultSetId();
                PaletteType dp = (PaletteType)defaultPaletteSet.getDefaultPaletteId();
                String defaultPalettesId = dp.getId();
                this.defaultResources.setDefaultPalettesId(defaultPalettesId);
                String defaultDisplayName = dp.getDisplayName();
                if (defaultDisplayName == null || defaultDisplayName.equals("")) {
                    defaultDisplayName = defaultPalettesId;
                }
                this.defaultResources.setDefaultColorPaletteDisplayName(defaultDisplayName);
                this.defaultResources.setDefaultPaletteDisplayNames(this.getDisplayNameMap(defaultPaletteSet));
                String resourceBundle = defaultColorPaletteSets.getResourceBundle();
                this.defaultResources.setPaletteResourceBundle(resourceBundle);
                return true;
            }
        }
        return false;
    }

    private String[] getDefaultPalette() {
        PaletteSetType dps = (PaletteSetType)this.defaultResources.getDefaultPaletteSetId();
        PaletteType dp = (PaletteType)dps.getDefaultPaletteId();
        dp.getId();
        String colorList = dp.getColorList();
        return this.getColors(colorList);
    }

    private void getDefaultHashColorPaletteset(PalettesDOMDocument palettesDom) {
        ColorPaletteSets colorPaletteSets = palettesDom.getPalettes();
        List paletteSetList = colorPaletteSets.getColorPaletteSet();
        if (paletteSetList != null) {
            PaletteSetType paletteSet = (PaletteSetType)colorPaletteSets.getDefaultSetId();
            List paletteList = paletteSet.getPalette();
            HashMap<String, String[]> defaultGraphicColorPalettes = new HashMap<String, String[]>();
            int j = 0;
            while (j < paletteList.size()) {
                PaletteType dp = (PaletteType)paletteList.get(j);
                String colorList = dp.getColorList();
                String id = dp.getId();
                defaultGraphicColorPalettes.put(id, this.getColors(colorList));
                ++j;
            }
            this.defaultResources.setDefaultGraphicColorPalettes(defaultGraphicColorPalettes);
        }
    }

    private PaletteSetType getCustomHashColorPaletteset(PalettesDOMDocument palettesDom, String paletteSetId) {
        ColorPaletteSets colorPaletteSets = palettesDom.getPalettes();
        List paletteSetList = colorPaletteSets.getColorPaletteSet();
        PaletteSetType paletteSet = null;
        if (paletteSetList != null) {
            if (paletteSetId != null && paletteSetId != "") {
                int i = 0;
                while (i < paletteSetList.size()) {
                    paletteSet = (PaletteSetType)paletteSetList.get(i);
                    if (!paletteSetId.equals(paletteSet.getId())) {
                        paletteSet = (PaletteSetType)colorPaletteSets.getDefaultSetId();
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                paletteSet = (PaletteSetType)colorPaletteSets.getDefaultSetId();
            }
            this.customGraphicColorPalettes = new HashMap();
            if (paletteSet != null) {
                List paletteList = paletteSet.getPalette();
                int j = 0;
                while (j < paletteList.size()) {
                    PaletteType dp = (PaletteType)paletteList.get(j);
                    String colorList = dp.getColorList();
                    String id = dp.getId();
                    this.customGraphicColorPalettes.put(id, this.getColors(colorList));
                    ++j;
                }
            }
        }
        return paletteSet;
    }

    public void setCustomPalettes(String palettesLocation, String paletteId, String paletteSetId) {
        PalettesDOMDocument palettesDom;
        if (palettesLocation == null) {
            if (!this.defaultResources.isDefaultPalettesInitialized()) {
                this.initColorPalettes();
            }
            palettesDom = this.defaultResources.getDefaultPalettesDOM();
        } else {
            palettesDom = this.getPalettesFromInputFile(palettesLocation);
            if (palettesDom == null) {
                if (!this.defaultResources.isDefaultPalettesInitialized()) {
                    this.initColorPalettes();
                }
                palettesDom = this.defaultResources.getDefaultPalettesDOM();
            }
        }
        Utilities.assertion(palettesDom != null);
        PaletteSetType paletteSet = null;
        paletteSet = this.getCustomHashColorPaletteset(palettesDom, paletteSetId);
        this.customDisplayNameMap = this.getDisplayNameMap(paletteSet);
        Object[] keys = this.customGraphicColorPalettes.keySet().toArray();
        if (paletteSetId != null && paletteSetId != "") {
            if (keys != null && keys.length != 0) {
                paletteId = this.getCorrectPaletteId(paletteSet, paletteId);
                this.customColorPalettes = (String[])this.customGraphicColorPalettes.get(paletteId);
                if (this.customColorPalettes != null) {
                    this.customPalettesId = paletteId;
                    this.customPaletteDisplayName = this.getPaletteDisplayName(paletteSet, paletteId);
                    this.useDefault = false;
                }
            }
        } else {
            ColorPaletteSets customColorPaletteSets = palettesDom.getPalettes();
            if (customColorPaletteSets != null && (paletteSet = (PaletteSetType)customColorPaletteSets.getDefaultSetId()) != null) {
                paletteId = this.getCorrectPaletteId(paletteSet, paletteId);
                this.customColorPalettes = (String[])this.customGraphicColorPalettes.get(paletteId);
                if (this.customColorPalettes != null) {
                    this.customPalettesId = paletteId;
                    this.customPaletteDisplayName = this.getPaletteDisplayName(paletteSet, paletteId);
                    this.useDefault = false;
                }
            }
        }
    }

    private String getCorrectPaletteId(PaletteSetType paletteSet, String paletteId) {
        PaletteType ddp = (PaletteType)paletteSet.getDefaultPaletteId();
        String DefaultPaletteId = ddp.getId();
        if (paletteId != null) {
            List plist = paletteSet.getPalette();
            int j = 0;
            while (j < plist.size()) {
                PaletteType dp = (PaletteType)plist.get(j);
                if (paletteId.equals(dp.getId())) {
                    return paletteId;
                }
                ++j;
            }
        }
        return DefaultPaletteId;
    }

    private String getPaletteDisplayName(PaletteSetType paletteSet, String paletteId) {
        if (paletteId != null) {
            List paletteList = paletteSet.getPalette();
            for (PaletteType palette : paletteList) {
                if (!palette.getId().equals(paletteId)) continue;
                return palette.getDisplayName();
            }
        }
        return paletteId;
    }

    private HashMap getDisplayNameMap(PaletteSetType paletteSet) {
        HashMap<String, String> displayNameMap = new HashMap<String, String>();
        List paletteList = paletteSet.getPalette();
        for (PaletteType palette : paletteList) {
            if (palette.getDisplayName() != null) {
                displayNameMap.put(palette.getId(), palette.getDisplayName());
                continue;
            }
            displayNameMap.put(palette.getId(), palette.getId());
        }
        return displayNameMap;
    }

    private String[] getColors(String label) {
        ArrayList<String> wrapStrings = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(label);
        while (st.hasMoreElements()) {
            wrapStrings.add(st.nextElement().toString());
        }
        return wrapStrings.toArray(new String[wrapStrings.size()]);
    }
}

