/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.ULocale;
import java.util.Date;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Configuration;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DateFormat;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Internationalization;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.Part;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;

public class Timestamp
extends Part {
    static final long serialVersionUID = 6366274088283355495L;
    private String timestamp;
    private boolean isLTR;
    private NLString nls;

    public Timestamp(Chart input, boolean isLTR, double x, double y, double width, double height, NLString nls) {
        super(input, x, y, width, height);
        Data data;
        this.isLTR = isLTR;
        this.nls = nls;
        String prefix = null;
        String pattern = null;
        ULocale locale = null;
        SimpleDateFormat dateFormatter = null;
        Configuration config = input.getConfiguration();
        if (config != null) {
            Internationalization i18n;
            if (config.getTimestamp() != null) {
                DateFormat dateFormat;
                if (config.getTimestamp().getPrefix() != null) {
                    prefix = nls.getString(config.getTimestamp().getPrefix());
                }
                if (config.getTimestamp().getDateFormat() != null && (dateFormat = config.getTimestamp().getDateFormat()) != null && dateFormat.getPattern() != null) {
                    pattern = dateFormat.getPattern();
                }
            }
            if ((i18n = config.getInternationalization()) != null) {
                String country;
                String language = i18n.getLanguage() == null ? "" : i18n.getLanguage();
                String string = country = i18n.getCountry() == null ? "" : i18n.getCountry();
                if (language != "" || country != "") {
                    locale = new ULocale(language, country);
                } else if (language != "") {
                    locale = new ULocale(language);
                }
            }
        }
        if ((data = input.getData()) != null) {
            block18: {
                if (pattern != null && pattern != "") {
                    try {
                        if (locale != null) {
                            dateFormatter = new SimpleDateFormat(pattern, locale);
                            break block18;
                        }
                        dateFormatter = new SimpleDateFormat(pattern);
                    }
                    catch (NullPointerException nullPointerException) {
                        dateFormatter = null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        dateFormatter = null;
                    }
                } else {
                    try {
                        dateFormatter = new SimpleDateFormat();
                    }
                    catch (NullPointerException nullPointerException) {
                        dateFormatter = null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        dateFormatter = null;
                    }
                }
            }
            String timeStampText = dateFormatter != null ? dateFormatter.format(Timestamp.parseISO8601Date(data.getTimestamp())) : data.getTimestamp();
            this.timestamp = prefix != null ? (!prefix.equals("") ? (isLTR ? String.valueOf(prefix) + "  " + timeStampText : String.valueOf(timeStampText) + "  " + prefix) : timeStampText) : timeStampText;
        }
    }

    protected void constructPart() {
        if (this.timestamp != null) {
            SVGText graphTimeStamp = new SVGText();
            graphTimeStamp.setText(this.timestamp);
            if (this.isLTR) {
                graphTimeStamp.setXCoordinate(Double.toString(this.width - 10.0));
                graphTimeStamp.setYCoordinate(Double.toString(this.height - 10.0));
                graphTimeStamp.setStyleClass("graphTimeStamp anchorAtEnd");
                graphTimeStamp.setIdentifier("SVGGEN_timeStamp");
            } else {
                graphTimeStamp.setXCoordinate(Double.toString(10.0));
                graphTimeStamp.setYCoordinate(Double.toString(this.height - 10.0));
                graphTimeStamp.setStyleClass("graphTimeStamp anchorAtStart");
                graphTimeStamp.setIdentifier("SVGGEN_timeStamp");
            }
            SVGBase[] children = new SVGBase[2];
            children[1] = graphTimeStamp;
            this.setChildren(children);
        }
    }

    public static Date parseISO8601Date(String s) {
        if (s == null) {
            return null;
        }
        int year = 0;
        int month = 0;
        int day = 0;
        int hrs = 0;
        int min = 0;
        int sec = 0;
        try {
            int len = s.length();
            if (len >= 4) {
                year = Integer.parseInt(s.substring(0, 4));
            }
            if (len >= 7) {
                month = Integer.parseInt(s.substring(5, 7)) - 1;
            }
            if (len >= 10) {
                day = Integer.parseInt(s.substring(8, 10));
            }
            if (len >= 13) {
                hrs = Integer.parseInt(s.substring(11, 13));
            }
            if (len >= 16) {
                min = Integer.parseInt(s.substring(14, 16));
            }
            if (len >= 19) {
                sec = Integer.parseInt(s.substring(17, 19));
            }
            return new GregorianCalendar(year, month, day, hrs, min, sec).getTime();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

