/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGLine;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolyline;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGRectangle;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGUse;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Configuration;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Preferences;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.TitleBar;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.EventTools;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.Part;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.PreferenceIcon;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;

public class Title
extends Part {
    static final long serialVersionUID = 7371525869612526897L;
    private String title;
    private boolean prefIconShow = false;
    private TitleBar titleBar;
    private boolean isLTR;
    private NLString nls;

    public Title(Chart input, boolean isLTR, double x, double y, double width, double height, NLString nls) {
        super(input, x, y, width, height);
        this.isLTR = isLTR;
        this.nls = nls;
        Configuration config = input.getConfiguration();
        if (config != null) {
            Preferences pref = config.getPreferences();
            this.titleBar = config.getTitleBar();
            if (this.titleBar != null) {
                this.title = this.titleBar.getLabel();
            }
            if (pref != null && pref.isSetShow() && pref.isShow()) {
                this.prefIconShow = true;
            }
        }
    }

    protected void constructPart() {
        int noOfParts = 5;
        SVGBase[] children = new SVGBase[noOfParts];
        SVGGroup group = new SVGGroup();
        group.setChildren(children);
        SVGBase[] groupChild = new SVGBase[2];
        groupChild[0] = group;
        if (this.prefIconShow) {
            PreferenceIcon prefIcon = new PreferenceIcon(this.input, this.x + 300.0, this.y, this.width, this.height);
            children[4] = prefIcon;
            SVGGroup outlineGroup = new SVGGroup();
            outlineGroup.setIdentifier("preferencesOutlineIconHoverBox");
            outlineGroup.setStyle("stroke-width:1;stroke:#a0a0a4");
            SVGBase[] outlineGroupChild = new SVGBase[4];
            outlineGroup.setChildren(outlineGroupChild);
            SVGGroup iconGroup = new SVGGroup();
            SVGBase[] iconGroupChild = new SVGBase[3];
            iconGroup.setChildren(iconGroupChild);
            iconGroupChild[0] = outlineGroup;
            SVGUse iconUse = new SVGUse();
            iconUse.setHref("#preferences");
            iconUse.setIdentifier("preferencesIconHoverBox");
            double xCoord = 0.0;
            double yCoord = 0.0;
            if (this.isLTR) {
                xCoord = this.width - 10.0 - 30.0;
                yCoord = this.height / 2.0 - 12.0;
                iconUse.setXCoordinate(Double.toString(this.width - 10.0 - 30.0));
                iconUse.setYCoordinate(Double.toString(this.height / 2.0 - 12.0));
            } else {
                xCoord = 10.0;
                yCoord = this.height / 2.0 - 12.0;
                iconUse.setXCoordinate(Double.toString(10.0));
                iconUse.setYCoordinate(Double.toString(this.height / 2.0 - 12.0));
            }
            SVGLine line = new SVGLine();
            line.setX1(String.valueOf(xCoord - 2.0));
            line.setX2(String.valueOf(xCoord + 32.0));
            line.setY1(String.valueOf(yCoord - 2.5));
            line.setY2(String.valueOf(yCoord - 2.5));
            outlineGroupChild[0] = line;
            line = new SVGLine();
            line.setX1(String.valueOf(xCoord - 2.5));
            line.setX2(String.valueOf(xCoord - 2.5));
            line.setY1(String.valueOf(yCoord - 2.0));
            line.setY2(String.valueOf(yCoord + 25.0));
            outlineGroupChild[1] = line;
            line = new SVGLine();
            line.setX1(String.valueOf(xCoord + 32.5));
            line.setX2(String.valueOf(xCoord + 32.5));
            line.setY1(String.valueOf(yCoord - 2.0));
            line.setY2(String.valueOf(yCoord + 25.0));
            outlineGroupChild[2] = line;
            line = new SVGLine();
            line.setX1(String.valueOf(xCoord - 2.0));
            line.setX2(String.valueOf(xCoord + 32.0));
            line.setY1(String.valueOf(yCoord + 25.5));
            line.setY2(String.valueOf(yCoord + 25.5));
            outlineGroupChild[3] = line;
            iconGroupChild[1] = iconUse;
            groupChild[1] = iconGroup;
            iconGroup.addEvent("onclick", "SVGGEN_openPreferencePage()");
            String tooltipID = "SVGGEN_tooltip" + EventTools.getUniqueID();
            String tooltipString = "User Preferences";
            if (this.input.getConfiguration() != null && this.input.getConfiguration().getPreferences() != null && this.input.getConfiguration().getPreferences().getTooltip() != null) {
                tooltipString = this.input.getConfiguration().getPreferences().getTooltip().getLabel();
                SVGGroup toolTipGroup = new SVGGroup();
                SVGBase[] toolTips = new SVGBase[2];
                toolTipGroup.setChildren(toolTips);
                toolTipGroup.setVisibility("hidden");
                SVGText tooltipText = new SVGText();
                tooltipText.setText(this.nls.getString(tooltipString));
                tooltipText.setIdentifier(String.valueOf(tooltipID) + "text");
                toolTips[0] = tooltipText;
                SVGRectangle tooltipRect = new SVGRectangle();
                tooltipRect.setIdentifier(String.valueOf(tooltipID) + "rect");
                tooltipRect.setXCoordinate("0");
                tooltipRect.setYCoordinate("0");
                tooltipRect.setWidth("0");
                tooltipRect.setHeight("0");
                toolTips[1] = tooltipRect;
                iconGroupChild[2] = toolTipGroup;
                iconGroup.addEvent("onmouseover", "SVGGEN_showTooltip(evt,'" + tooltipID + "');SVGGEN_PreferenceOnOut(evt,'preferencesOutlineIconHoverBox')");
                iconGroup.addEvent("onmouseout", "SVGGEN_hideTooltip(evt,'" + tooltipID + "');SVGGEN_PreferenceOnHover(evt,'preferencesOutlineIconHoverBox')");
            } else {
                iconGroup.addEvent("onmouseout", "SVGGEN_PreferenceOnOut(evt,'preferencesOutlineIconHoverBox')");
                iconGroup.addEvent("onmouseover", "SVGGEN_PreferenceOnHover(evt,'preferencesOutlineIconHoverBox')");
            }
        }
        this.setChildren(groupChild);
        if (this.titleBar == null || !this.titleBar.isSetWithSeparator() || this.titleBar.isWithSeparator()) {
            SVGPolyline titleUnderLine = new SVGPolyline();
            titleUnderLine.setStroke("#666666");
            String points = "0 " + (this.height - 1.0) + " " + this.getWidth() + " " + (this.height - 1.0);
            titleUnderLine.setPoints(points.toString());
            children[1] = titleUnderLine;
        }
        if (this.titleBar != null) {
            if (this.titleBar.getBackgroundColor() != null && !this.titleBar.getBackgroundColor().equals("")) {
                SVGRectangle bkground = new SVGRectangle();
                bkground.setXCoordinate("0");
                bkground.setYCoordinate("0");
                bkground.setWidth(this.getWidth());
                bkground.setHeight(this.getHeight());
                bkground.setFill(this.titleBar.getBackgroundColor());
                children[0] = bkground;
            }
            if (this.title != null && this.title != "") {
                SVGText graphTitle = new SVGText();
                graphTitle.setText(this.nls.getString(this.title));
                if (this.isLTR) {
                    graphTitle.setXCoordinate(Double.toString(10.0));
                    graphTitle.setYCoordinate(Double.toString(this.height / 2.0 + 5.0));
                    graphTitle.setStyleClass("graphTitle");
                    graphTitle.setIdentifier("SVGGEN_graphTitle");
                } else {
                    graphTitle.setXCoordinate(Double.toString(this.width - 10.0));
                    graphTitle.setYCoordinate(Double.toString(this.height / 2.0 + 5.0));
                    graphTitle.setStyleClass("graphTitle anchorAtEnd");
                    graphTitle.setIdentifier("SVGGEN_graphTitle");
                }
                children[3] = graphTitle;
                children[2] = EventTools.generateUserTooltip(group, this.titleBar.getTooltip(), this.nls);
                EventTools.generateUserEvents(group, this.titleBar.getEventHandler());
                EventTools.generateAccessibility(group, this.titleBar.getAccessibility(), this.nls);
            }
        }
    }
}

