/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.util;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;

public class FontHelper {
    private Graphics2D g;
    private FontMetrics metrics;

    public FontHelper() {
        this.g = new BufferedImage(1, 1, 1).createGraphics();
        this.metrics = this.g.getFontMetrics();
    }

    public FontHelper(String fontName, int style, int size) {
        Font f = new Font(fontName, style, size);
        this.g.setFont(f);
        this.metrics = this.g.getFontMetrics();
    }

    public void setFont(Font font) {
        this.g.setFont(font);
        this.metrics = this.g.getFontMetrics();
    }

    public void setFontSize(float size) {
        Font font = this.g.getFont().deriveFont(size);
        this.g.setFont(font);
        this.metrics = this.g.getFontMetrics();
    }

    public double getStringWidth(String str) {
        return this.getStringWidth(str, 0.0, false);
    }

    public double getStringWidth(String str, double degrees) {
        return this.getStringWidth(str, degrees, false);
    }

    public Dimension2D getStringBounds(String str, double degrees) {
        this.g.getFont().getStringBounds(str, this.g.getFontRenderContext());
        double radDegrees = degrees * Math.PI / 180.0;
        double width = (double)this.metrics.stringWidth(str) * 1.5;
        new Dimension((int)(width * Math.abs(Math.cos(radDegrees)) + (double)this.metrics.getHeight() * Math.abs(Math.sin(radDegrees))), (int)(width * Math.abs(Math.sin(radDegrees)) + (double)this.metrics.getHeight() * Math.abs(Math.cos(radDegrees))));
        return new Dimension((int)(width * Math.abs(Math.cos(radDegrees)) + (double)this.metrics.getHeight() * Math.abs(Math.sin(radDegrees))), (int)(width * Math.abs(Math.sin(radDegrees)) + (double)this.metrics.getHeight() * Math.abs(Math.cos(radDegrees))));
    }

    public double getStringWidth(String str, double degrees, boolean vertical) {
        this.g.getFont().getStringBounds(str, this.g.getFontRenderContext());
        double radDegrees = degrees * Math.PI / 180.0;
        if (vertical) {
            radDegrees += 1.5707963267948966;
        }
        double width = (double)this.metrics.stringWidth(str) * 1.5;
        return width * Math.abs(Math.cos(radDegrees)) + (double)this.metrics.getHeight() * Math.abs(Math.sin(radDegrees));
    }

    public double getHeight() {
        return this.getHeight("", 0.0);
    }

    public double getHeight(String str, double degrees) {
        double radDegrees = degrees * Math.PI / 180.0;
        double width = (double)this.metrics.stringWidth(str) * 1.5;
        return width * Math.abs(Math.sin(radDegrees)) + (double)this.metrics.getHeight() * Math.abs(Math.cos(radDegrees));
    }

    public double getHeight(String str, double degrees, int numOfLines) {
        double radDegrees = degrees * Math.PI / 180.0;
        double width = (double)this.metrics.stringWidth(str) * 1.5;
        return width * Math.abs(Math.sin(radDegrees)) + (double)(this.metrics.getHeight() * numOfLines) * Math.abs(Math.cos(radDegrees));
    }
}

