/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.util;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.InputBase;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Utilities {
    public static void unimplementedFunction() {
        System.err.println("Unimplemented Function.");
        Exception e = new Exception();
        e.printStackTrace();
    }

    public static Element getElement(Element element, String name) {
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName() == name) {
                return (Element)child;
            }
            ++i;
        }
        return null;
    }

    public static List getElementList(Element element, String name) {
        NodeList children = element.getChildNodes();
        ArrayList<Node> resultList = new ArrayList<Node>();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName() == name) {
                resultList.add(child);
            }
            ++i;
        }
        return resultList;
    }

    public static String getText(Element element) {
        Node child = element.getFirstChild();
        String result = null;
        if (child != null && child.getNodeType() == 3) {
            result = child.getNodeValue();
        }
        return result;
    }

    public static void copyAttributes(Element from, Element to) {
        NamedNodeMap attrMap = from.getAttributes();
        int i = 0;
        while (i < attrMap.getLength()) {
            Node attr = attrMap.item(i);
            String name = attr.getNodeName();
            String value = attr.getNodeValue();
            to.setAttribute(name, value);
            ++i;
        }
    }

    public static void copyChildren(Element from, Element to) {
        while (from.getFirstChild() != null) {
            Node childToMove = from.removeChild(from.getFirstChild());
            to.appendChild(childToMove);
        }
    }

    public static Element appendChild(InputBase parentObj, Object childObj, String tagName) {
        Utilities.assertion(childObj instanceof InputBase);
        try {
            Element parent = parentObj.getElement();
            Element child = ((InputBase)childObj).getElement();
            String childTag = child.getTagName();
            if (!childTag.equals(tagName)) {
                Element newElement = parent.getOwnerDocument().createElement(tagName);
                Utilities.copyAttributes(child, newElement);
                Utilities.copyChildren(child, newElement);
                parent.appendChild(newElement);
                ((InputBase)childObj).setElement(newElement);
                return newElement;
            }
            parent.appendChild(child);
            return child;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public static void setInputObjectElement(Object obj, Element element) {
        try {
            InputBase inputObj = (InputBase)obj;
            inputObj.setElement(element);
        }
        catch (ClassCastException classCastException) {}
    }

    public static String getCDATA(Element element) {
        String result = null;
        NodeList nodeList = element.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node child = nodeList.item(i);
            if (child.getNodeType() == 4) {
                result = ((CDATASection)child).getData();
                break;
            }
            ++i;
        }
        return result;
    }

    public static void assertion(boolean assertion) {
        if (!assertion) {
            System.err.println("Assertion Failed.");
            Exception e = new Exception();
            e.printStackTrace();
        }
    }

    public static InputStream getResourceAsStream(String name) {
        ClassLoader clsLoader = null;
        InputStream is = null;
        Iterator iter = Utilities.getClassLoaders();
        while (iter.hasNext()) {
            clsLoader = (ClassLoader)iter.next();
            is = clsLoader.getResourceAsStream(name);
            if (is == null) continue;
            return is;
        }
        return null;
    }

    public static URL getResourceAsUrl(String name) {
        ClassLoader clsLoader = null;
        URL url = null;
        Iterator iter = Utilities.getClassLoaders();
        while (iter.hasNext()) {
            clsLoader = (ClassLoader)iter.next();
            url = clsLoader.getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    protected static Iterator getClassLoaders() {
        Thread t;
        ArrayList<ClassLoader> clsLoaders = new ArrayList<ClassLoader>();
        ClassLoader clsLoader = null;
        try {
            clsLoader = Utilities.class.getClassLoader();
            if (clsLoader != null) {
                clsLoaders.add(clsLoader);
            }
        }
        catch (SecurityException securityException) {}
        if ((t = Thread.currentThread()) != null) {
            try {
                clsLoader = t.getContextClassLoader();
                if (clsLoader != null) {
                    clsLoaders.add(clsLoader);
                }
            }
            catch (SecurityException securityException) {}
        }
        try {
            clsLoader = ClassLoader.getSystemClassLoader();
            if (clsLoader != null) {
                clsLoaders.add(clsLoader);
            }
        }
        catch (SecurityException securityException) {}
        return clsLoaders.iterator();
    }
}

