/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.core.internal;

import org.eclipse.tptp.platform.report.core.internal.DItemContainer;
import org.eclipse.tptp.platform.report.core.internal.IDColor;
import org.eclipse.tptp.platform.report.core.internal.IDParagraphItem;

public class DBorder
extends DItemContainer
implements IDParagraphItem {
    public static final int S_NONE = 0;
    public static final int S_SOLID = 1;
    public static final int S_GRADIENT = 2;
    public static final int S_HALO = 3;
    public static final int L_NONE = 0;
    public static final int L_SIMPLE = 1;
    public static final int L_BOLD = 3;
    public static final int L_HEAVY = 7;
    public static final int L_DOUBLE = 5;
    public static final int L_TRIPLE = 21;
    public static final int L_BOLD_SIMPLE = 11;
    public static final int L_SIMPLE_BOLD = 13;
    protected int shadow_type_;
    protected int shadow_depth_;
    protected IDColor shadow_color_;
    protected int line_type_;
    protected int margin_;

    public DBorder() {
        this.shadow_type_ = 1;
        this.shadow_depth_ = 8;
        this.line_type_ = 1;
        this.margin_ = 3;
    }

    public DBorder(int line_type) {
        this.shadow_type_ = 0;
        this.line_type_ = line_type;
        this.shadow_depth_ = 8;
        this.margin_ = 3;
    }

    public DBorder(int shadow_type, int shadow_depth) {
        this.shadow_type_ = shadow_type;
        this.shadow_depth_ = Math.max(0, shadow_depth);
        this.line_type_ = 1;
        this.margin_ = 3;
    }

    public DBorder(int shadow_type, int shadow_depth, int line_type) {
        this.shadow_type_ = shadow_type;
        this.shadow_depth_ = Math.max(0, shadow_depth);
        this.line_type_ = line_type;
        this.margin_ = 3;
    }

    public DBorder(DBorder model) {
        this.setBorder(model);
    }

    public int getShadowType() {
        return this.shadow_type_;
    }

    public int getShadowDepth() {
        return this.shadow_depth_;
    }

    public IDColor getShadowColor() {
        return this.shadow_color_;
    }

    public int getLineType() {
        return this.line_type_;
    }

    public int getMargin() {
        return this.margin_;
    }

    public boolean isShadowType(int _type) {
        return this.shadow_type_ == _type;
    }

    public void setShadowType(int _type) {
        this.shadow_type_ = _type;
    }

    public void setShadowDepth(int _depth) {
        this.shadow_depth_ = Math.max(0, _depth);
    }

    public void setShadowColor(IDColor c) {
        this.shadow_color_ = c;
    }

    public void setLineType(int _type) {
        this.line_type_ = _type;
    }

    public void setMargin(int margin) {
        this.margin_ = Math.max(0, margin);
    }

    public void setBorder(DBorder model) {
        this.shadow_type_ = model.shadow_type_;
        this.shadow_depth_ = model.shadow_depth_;
        this.shadow_color_ = model.shadow_color_;
        this.line_type_ = model.line_type_;
        this.margin_ = model.margin_;
    }

    public static String StrShadowType(int st) {
        switch (st) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "SOLID";
            }
            case 2: {
                return "GRADIENT";
            }
            case 3: {
                return "HALO";
            }
        }
        return "UNKNOWN";
    }

    public static int ToShadowType(String str) {
        if (str == null) {
            return 0;
        }
        if (str.equals("NONE")) {
            return 0;
        }
        if (str.equals("SOLID")) {
            return 1;
        }
        if (str.equals("GRADIENT")) {
            return 2;
        }
        if (str.equals("HALO")) {
            return 3;
        }
        return 0;
    }

    public static String StrLineType(int lt) {
        switch (lt) {
            default: {
                return "NONE";
            }
            case 1: {
                return "SIMPLE";
            }
            case 3: {
                return "BOLD";
            }
            case 7: {
                return "HEAVY";
            }
            case 5: {
                return "DOUBLE";
            }
            case 21: {
                return "TRIPLE";
            }
            case 11: {
                return "BOLD_SIMPLE";
            }
            case 13: 
        }
        return "SIMPLE_BOLD";
    }

    public static int ToLineType(String str) {
        if (str == null) {
            return 0;
        }
        if (str.equals("NONE")) {
            return 0;
        }
        if (str.equals("SIMPLE")) {
            return 1;
        }
        if (str.equals("BOLD")) {
            return 3;
        }
        if (str.equals("HEAVY")) {
            return 7;
        }
        if (str.equals("DOUBLE")) {
            return 5;
        }
        if (str.equals("TRIPLE")) {
            return 21;
        }
        if (str.equals("BOLD_SIMPLE")) {
            return 11;
        }
        if (str.equals("SIMPLE_BOLD")) {
            return 13;
        }
        return 0;
    }
}

