/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.core.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.tptp.platform.report.core.internal.DAccessibilityDesc;
import org.eclipse.tptp.platform.report.core.internal.DAccessibilityTitle;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DBorder;
import org.eclipse.tptp.platform.report.core.internal.DCategory;
import org.eclipse.tptp.platform.report.core.internal.DCell;
import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DDocument;
import org.eclipse.tptp.platform.report.core.internal.DEvent;
import org.eclipse.tptp.platform.report.core.internal.DFolder;
import org.eclipse.tptp.platform.report.core.internal.DFooter;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DHeader;
import org.eclipse.tptp.platform.report.core.internal.DI18N;
import org.eclipse.tptp.platform.report.core.internal.DInclude;
import org.eclipse.tptp.platform.report.core.internal.DIndexEntry;
import org.eclipse.tptp.platform.report.core.internal.DLink;
import org.eclipse.tptp.platform.report.core.internal.DList;
import org.eclipse.tptp.platform.report.core.internal.DMarkerLine;
import org.eclipse.tptp.platform.report.core.internal.DMarkerRegion;
import org.eclipse.tptp.platform.report.core.internal.DPalettes;
import org.eclipse.tptp.platform.report.core.internal.DParagraph;
import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.DPopup;
import org.eclipse.tptp.platform.report.core.internal.DPreferences;
import org.eclipse.tptp.platform.report.core.internal.DRow;
import org.eclipse.tptp.platform.report.core.internal.DSection;
import org.eclipse.tptp.platform.report.core.internal.DShapes;
import org.eclipse.tptp.platform.report.core.internal.DTable;
import org.eclipse.tptp.platform.report.core.internal.DText;
import org.eclipse.tptp.platform.report.core.internal.DTimeStamp;
import org.eclipse.tptp.platform.report.core.internal.DTitle;
import org.eclipse.tptp.platform.report.core.internal.IDBasicItem;
import org.eclipse.tptp.platform.report.core.internal.IDCoord;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDParagraphItem;

public class DChildrenController {
    protected static HashMap rules = new HashMap();

    static {
        DChildrenController.installChildRule(DParagraph.class, IDParagraphItem.class);
        DChildrenController.installChildRule(DLink.class, IDBasicItem.class);
        DChildrenController.installChildRule(DTable.class, DRow.class);
        DChildrenController.installChildRule(DRow.class, DCell.class);
        DChildrenController.installChildRule(DCell.class, IDParagraphItem.class);
        DChildrenController.installChildrenRule(DGraphic.class, new Class[]{DGraphic.class, DCurve.class, DAxis.class, DEvent.class, DAccessibilityTitle.class, DAccessibilityDesc.class, DI18N.class, DPreferences.class, DTimeStamp.class, DInclude.class, DPalettes.class, DShapes.class});
        DChildrenController.installChildrenRule(DPoint.class, new Class[]{IDCoord.class, DText.class, DEvent.class, DAccessibilityTitle.class, DAccessibilityDesc.class});
        DChildrenController.installChildrenRule(DCurve.class, new Class[]{DPoint.class, DEvent.class, DAccessibilityTitle.class, DAccessibilityDesc.class});
        DChildrenController.installChildrenRule(DAxis.class, new Class[]{DCategory.class, DEvent.class, DAccessibilityTitle.class, DAccessibilityDesc.class, DMarkerLine.class, DMarkerRegion.class});
        DChildrenController.installChildrenRule(DCategory.class, new Class[]{DEvent.class, DAccessibilityTitle.class, DAccessibilityDesc.class});
        DChildrenController.installChildRule(DSection.class, IDParagraphItem.class);
        DChildrenController.installChildrenRule(DDocument.class, new Class[]{IDParagraphItem.class, DSection.class});
        DChildrenController.installChildRule(DFooter.class, IDParagraphItem.class);
        DChildrenController.installChildRule(DHeader.class, IDParagraphItem.class);
        DChildrenController.installChildRule(DIndexEntry.class, IDParagraphItem.class);
        DChildrenController.installChildrenRule(DList.class, new Class[]{DParagraph.class, DLink.class, IDBasicItem.class});
        DChildrenController.installChildrenRule(DPopup.class, new Class[]{IDParagraphItem.class, IDBasicItem.class});
        DChildrenController.installChildRule(DTitle.class, IDBasicItem.class);
        DChildrenController.installChildRule(IDParagraphItem.class, DFolder.class);
        DChildrenController.installChildRule(DDocument.class, DFolder.class);
        DChildrenController.installChildRule(DSection.class, DFolder.class);
        DChildrenController.installChildRule(DCell.class, DFolder.class);
        DChildrenController.installChildRule(DParagraph.class, DFolder.class);
        DChildrenController.installChildRule(DFolder.class, IDParagraphItem.class);
        DChildrenController.installChildRule(DFolder.class, DFolder.class);
        DChildrenController.installChildRule(IDParagraphItem.class, DBorder.class);
        DChildrenController.installChildRule(DParagraph.class, DBorder.class);
        DChildrenController.installChildRule(DCell.class, DBorder.class);
        DChildrenController.installChildRule(DBorder.class, IDParagraphItem.class);
        DChildrenController.installChildRule(DBorder.class, DBorder.class);
    }

    public static void installChildrenRule(Class _parent, Class[] _children) {
        ArrayList<Class> rule = (ArrayList<Class>)rules.get(_parent);
        if (rule == null) {
            rule = new ArrayList<Class>(_children.length);
            rules.put(_parent, rule);
        }
        int i = 0;
        while (i < _children.length) {
            rule.add(_children[i]);
            ++i;
        }
    }

    public static void installChildRule(Class _parent, Class _child) {
        ArrayList<Class> rule = (ArrayList<Class>)rules.get(_parent);
        if (rule == null) {
            rule = new ArrayList<Class>();
            rule.add(_child);
            rules.put(_parent, rule);
        } else {
            rule.add(_child);
        }
    }

    public static boolean removeChildClass(Class _parent, Class _child) {
        List rule = (List)rules.get(_parent);
        if (rule != null) {
            rule.remove(_child);
            if (rule.size() == 0) {
                rules.remove(_parent);
            }
            return true;
        }
        return false;
    }

    public static boolean acceptChild(IDItem _parent, IDItem _child) {
        return DChildrenController.acceptChild(_parent.getClass(), _child);
    }

    public static boolean acceptChild(Class _parent, IDItem _child) {
        if (_child == null) {
            return false;
        }
        Class parent = _parent;
        while (parent != null) {
            List rule = (List)rules.get(parent);
            if (rule != null) {
                for (Object o : rule) {
                    if (!((Class)o).isInstance(_child)) continue;
                    return true;
                }
            }
            parent = parent.getSuperclass();
        }
        System.err.println("DChildrenController: [FAILED] acceptChild( " + _parent.getName() + ", " + _child.getClass().getName() + ")");
        return false;
    }
}

