/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.core.internal;

import org.eclipse.tptp.platform.report.core.internal.IDColor;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;

public class DColor
implements IDColor {
    private int red;
    private int blue;
    private int green;
    private int alpha = 255;

    public DColor() {
    }

    public DColor(int r, int g, int b) {
        this.setRGB(r, g, b);
    }

    public DColor(IDColor clr) {
        if (clr == null) {
            this.setRGB(0, 0, 0);
        } else {
            this.setRGB(clr.getRed(), clr.getGreen(), clr.getBlue());
        }
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public void setRed(int r) {
        if (r > 255) {
            r = 255;
        }
        this.red = r;
    }

    public void setGreen(int g) {
        if (g > 255) {
            g = 255;
        }
        this.green = g;
    }

    public void setBlue(int b) {
        if (b > 255) {
            b = 255;
        }
        this.blue = b;
    }

    public boolean equals(Object c) {
        if (c == this) {
            return true;
        }
        if (!(c instanceof IDColor)) {
            return false;
        }
        IDColor cl = (IDColor)c;
        return cl.getRed() == this.getRed() && cl.getGreen() == this.getGreen() && cl.getBlue() == this.getBlue();
    }

    public void setRGB(int r, int g, int b) {
        this.setRed(r);
        this.setGreen(g);
        this.setBlue(b);
    }

    public void setRGBA(int r, int g, int b, int a) {
        this.setRed(r);
        this.setGreen(g);
        this.setBlue(b);
        this.setAlpha(a);
    }

    public String toString() {
        String s = super.toString();
        s = String.valueOf(s) + "{" + this.red + "," + this.green + "," + this.blue + "}";
        return s;
    }

    public int getRGBA() {
        return RGBA.Get(this.red, this.green, this.blue);
    }

    public static int RGBA(IDColor c) {
        return RGBA.Get(c.getRed(), c.getGreen(), c.getBlue());
    }

    public static int RGBA(IDColor c, int rgb_default) {
        if (c == null) {
            return rgb_default;
        }
        return RGBA.Get(c.getRed(), c.getGreen(), c.getBlue());
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        if (alpha > 255) {
            alpha = 255;
        }
        this.alpha = alpha;
    }

    public String serializeToString() {
        String r = Integer.toHexString(this.getRed());
        if (this.getRed() <= 15) {
            r = "0" + r;
        }
        String g = Integer.toHexString(this.getGreen());
        if (this.getGreen() <= 15) {
            g = "0" + g;
        }
        String b = Integer.toHexString(this.getBlue());
        if (this.getBlue() <= 15) {
            b = "0" + b;
        }
        String ret = "#" + r + g + b;
        if (this.getAlpha() < 255) {
            String a = Integer.toHexString(this.getAlpha());
            if (this.getAlpha() <= 15) {
                a = "0" + a;
            }
            ret = String.valueOf(ret) + a;
        }
        return ret;
    }

    public void serializeFromString(String s) {
        if (s.length() < 7 || s.charAt(0) != '#') {
            return;
        }
        this.setRed(Integer.decode("0x" + s.substring(1, 3)));
        this.setGreen(Integer.decode("0x" + s.substring(3, 5)));
        this.setBlue(Integer.decode("0x" + s.substring(5, 7)));
        if (s.length() == 9) {
            this.setAlpha(Integer.decode("0x" + s.substring(7, 9)));
        }
    }

    public String getID() {
        return Integer.toString(this.hashCode(), 16);
    }
}

