/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.core.internal;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.tptp.platform.report.core.internal.DChildrenController;
import org.eclipse.tptp.platform.report.core.internal.DItem;
import org.eclipse.tptp.platform.report.core.internal.IDItem;

public abstract class DItemContainer
extends DItem {
    private IDItem child = null;

    public IDItem getLastChild() {
        IDItem c = null;
        c = this.getFirstChild();
        while (c != null) {
            if (c.getNext() == null) {
                return c;
            }
            c = c.getNext();
        }
        return c;
    }

    public boolean removeChild(IDItem item) {
        if (item == null || this.child == null) {
            return false;
        }
        if (item == this.child) {
            this.child = this.child.getNext();
        } else {
            IDItem c = null;
            c = this.child;
            while (c != null) {
                if (c.getNext() == item) {
                    c.setNext(item.getNext());
                    break;
                }
                c = c.getNext();
            }
        }
        item.setParent(null);
        item.setNext(null);
        return true;
    }

    public boolean insertChild(IDItem _child, IDItem after) {
        if (!DChildrenController.acceptChild(this, _child)) {
            return false;
        }
        _child.setParent(this);
        if (after != null) {
            IDItem aux = after.getNext();
            after.setNext(_child);
            _child.setNext(aux);
        } else {
            _child.setNext(this.child);
            this.child = _child;
        }
        return true;
    }

    public IDItem getFirstChild() {
        return this.child;
    }

    public void clear() {
        IDItem c = null;
        c = this.getFirstChild();
        while (c != null) {
            IDItem n = c.getNext();
            c.clear();
            c = n;
        }
        this.child = null;
        super.clear();
    }

    public int getChildCount() {
        IDItem c = null;
        int cpt = 0;
        c = this.getFirstChild();
        while (c != null) {
            ++cpt;
            c = c.getNext();
        }
        return cpt;
    }

    public int getChildPosition(IDItem i) {
        IDItem c = null;
        int cpt = 0;
        c = this.getFirstChild();
        while (c != null) {
            ++cpt;
            if (c == i) {
                return cpt;
            }
            c = c.getNext();
        }
        return -1;
    }

    public List getChildrenOfClass(Class clazz) {
        LinkedList<IDItem> list = new LinkedList<IDItem>();
        IDItem c = this.getFirstChild();
        while (c != null) {
            if (c.getClass().isAssignableFrom(clazz)) {
                list.add(c);
            }
            c = c.getNext();
        }
        return list;
    }

    public IDItem getChildOfClass(Class clazz) {
        IDItem c = this.getFirstChild();
        while (c != null) {
            if (c.getClass().isAssignableFrom(clazz)) {
                return c;
            }
            c = c.getNext();
        }
        return null;
    }

    public boolean isContainer() {
        return true;
    }
}

