/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.core.internal;

import java.util.ArrayList;
import org.eclipse.tptp.platform.report.core.internal.IDLink;

public class DLinkUtil {
    public static final String DEFAULT_LINK = "jscrib-link";
    public static final String DETACH = "jscrib-detach";
    public static final String POINTER = "jscrib-popup";
    public static final String TOOLTIP = "jscrib-tooltip";

    public static final boolean isInternalLink(IDLink a_link) {
        return DLinkUtil.isInternalLink(a_link.getTarget());
    }

    public static boolean isInternalLink(String a_target) {
        String method = DLinkUtil.getMethod(a_target);
        if (DEFAULT_LINK.equals(method)) {
            return true;
        }
        if (DETACH.equals(method)) {
            return true;
        }
        if (POINTER.equals(method)) {
            return true;
        }
        return TOOLTIP.equals(method);
    }

    public static boolean isPopupLink(IDLink a_link) {
        String method = DLinkUtil.getMethod(a_link);
        if (DETACH.equals(method)) {
            return true;
        }
        if (POINTER.equals(method)) {
            return true;
        }
        return TOOLTIP.equals(method);
    }

    public static String getMethod(String a_target) {
        if (a_target == null) {
            return null;
        }
        String method = DEFAULT_LINK;
        int idx = a_target.indexOf(":");
        int idx2 = a_target.indexOf("/");
        if (idx > -1 && (idx2 < 0 || idx2 > idx)) {
            method = a_target.substring(0, idx);
        }
        return method;
    }

    public static final String getMethod(IDLink a_link) {
        return DLinkUtil.getMethod(a_link.getTarget());
    }

    public static String getPath(String a_target) {
        String path = a_target;
        int idx = a_target.indexOf(":");
        int idx2 = a_target.indexOf("/");
        if (idx > -1 && idx2 > idx) {
            path = a_target.substring(idx + 1);
        } else if (idx2 == -1 && idx > -1) {
            path = a_target.substring(idx + 1);
        }
        return path;
    }

    public static final String getPath(IDLink a_link) {
        return DLinkUtil.getPath(a_link.getTarget());
    }

    public static String[] getPathItems(IDLink a_link) {
        String t = DLinkUtil.getPath(a_link);
        int idx = t.indexOf("/");
        ArrayList<String> items = new ArrayList<String>();
        while (idx > -1) {
            String w = t.substring(0, idx);
            items.add(w);
            t = t.substring(idx + 1);
            idx = t.indexOf("/");
        }
        items.add(t);
        String[] retval = new String[items.size()];
        int i = 0;
        while (i < items.size()) {
            retval[i] = (String)items.get(i);
            ++i;
        }
        return retval;
    }

    public static String buildTarget(String a_method, String a_target) {
        String m = a_method;
        if (a_method == null) {
            m = DEFAULT_LINK;
        }
        return String.valueOf(m) + ":" + a_target;
    }
}

