/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.core.provisional;

import java.io.OutputStream;
import org.eclipse.tptp.platform.report.chart.svg.internal.SVGGenerator;
import org.eclipse.tptp.platform.report.chart.svg.internal.SVGGeneratorException;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGChartImpl;
import org.eclipse.tptp.platform.report.core.internal.DDocument;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.provisional.IChart;
import org.eclipse.tptp.platform.report.core.provisional.IRenderer;
import org.eclipse.tptp.platform.report.core.provisional.RendererException;
import org.w3c.dom.Document;

public class SVGRenderer
implements IRenderer {
    protected SVGGenerator generator = new SVGGenerator();
    protected OutputStream outputStream;

    public void setProperty(String key, Object value) throws RendererException {
        if (!key.equals("tptp.output.stream")) {
            throw new RendererException("Property key: " + key + " not supported by this renderer.");
        }
        this.outputStream = (OutputStream)value;
    }

    public void render(IChart chart) throws RendererException {
        if (chart instanceof DDocument) {
            chart = (IChart)((Object)((DDocument)chart).getChildOfClass(DGraphic.class));
        }
        if (chart instanceof DGraphic) {
            SVGChartImpl input = new SVGChartImpl((DGraphic)chart);
            try {
                Document svgoutput = this.generator.generateGraphicDocument(input);
                this.generator.writeDocumentToOutputStream(svgoutput, this.outputStream);
            }
            catch (SVGGeneratorException e) {
                e.printStackTrace();
                throw new RendererException(e.getMessage(), e);
            }
        }
    }
}

