/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.core.provisional;

import java.io.OutputStream;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tptp.platform.report.core.internal.DDocument;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.provisional.IChart;
import org.eclipse.tptp.platform.report.core.provisional.RendererException;
import org.eclipse.tptp.platform.report.core.provisional.StaticImageRenderer;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.render.internal.RenderableSnapShot;
import org.eclipse.tptp.platform.report.tools.internal.DChartTranslator;
import org.eclipse.tptp.platform.report.tools.internal.SWTIImageProvider;

public class SWTStaticImageRenderer
extends StaticImageRenderer {
    public SWTStaticImageRenderer() {
        this.transcode_type = "Transcode.JPEG";
    }

    public void setProperty(String key, Object value) throws RendererException {
        if (!key.equals("tptp.output.stream")) {
            throw new RendererException("Property key: " + key + " not supported by this renderer.");
        }
        this.outputStream = (OutputStream)value;
    }

    public void render(IChart chart) throws RendererException {
        int w;
        if (chart instanceof DDocument) {
            chart = (IChart)((Object)((DDocument)chart).getChildOfClass(DGraphic.class));
        }
        DGraphic graphic = null;
        if (chart instanceof DGraphic) {
            DChartTranslator tc = new DChartTranslator();
            graphic = tc.translate((DGraphic)chart);
        }
        Display dev = Display.getDefault();
        int h = w = 500;
        w = (int)((float)w * graphic.getWidthScale());
        h = (int)((float)h * graphic.getHeightScale());
        Rect r = new Rect(0, 0, w, h);
        SWTIImageProvider iimage_provider = new SWTIImageProvider((Device)dev);
        Image img = RenderableSnapShot.Process((Device)dev, r, graphic, 1.0f, iimage_provider);
        ImageLoader loader = new ImageLoader();
        if (loader.data == null) {
            loader.data = new ImageData[1];
        }
        loader.data[0] = img.getImageData();
        try {
            loader.save(this.outputStream, 4);
        }
        catch (SWTException _e) {
            System.err.println("Error saving image to output stream:" + (Object)((Object)_e));
        }
        catch (SWTError _r) {
            System.err.println("Error saving image to output stream:" + (Object)((Object)_r));
        }
        img.dispose();
    }
}

