/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.core.provisional;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;
import org.eclipse.tptp.platform.report.core.internal.IDObject;
import org.eclipse.tptp.platform.report.core.provisional.IChart;
import org.eclipse.tptp.platform.report.core.provisional.ISerializer;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlDocumentReader;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlDocumentWriter;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlError;
import org.eclipse.tptp.platform.report.drivers.xml.internal.XSDValidate;
import org.eclipse.tptp.platform.report.drivers.xml.internal.XSDXmlParserAdapter;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class SerializerImpl
implements ISerializer {
    private static ISerializer sz = null;

    private SerializerImpl() {
    }

    public static final synchronized ISerializer instance() {
        if (sz == null) {
            sz = new SerializerImpl();
        }
        return sz;
    }

    public void write(IChart cModel, OutputStream os) throws IOException {
        DXmlDocumentWriter dxcw = new DXmlDocumentWriter();
        try {
            dxcw.write(os, (IDObject)((Object)cModel));
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public Document toDOM(InputStream is) throws IOException {
        DXmlDocumentReader dxcr = new DXmlDocumentReader(new XSDXmlParserAdapter(new XSDValidate()));
        try {
            return dxcr.readDOM(is);
        }
        catch (DXmlError e) {
            throw new IOException(e.getMessage());
        }
    }

    public IChart read(InputStream is) throws IOException {
        DXmlDocumentReader dxcr = new DXmlDocumentReader(new XSDXmlParserAdapter(new XSDValidate()));
        try {
            IDObject[] objects = dxcr.read(is);
            return (IChart)((Object)objects[0]);
        }
        catch (DXmlError e) {
            throw new IOException(e.getMessage());
        }
    }

    public IChart read(Document dom) throws IOException {
        DXmlDocumentReader dxcr = new DXmlDocumentReader(new XSDXmlParserAdapter(new XSDValidate()));
        String strDOM = this.serializeGeneratedDocumentToString(dom);
        try {
            IDObject[] objects = dxcr.read(new InputSource(new StringReader(strDOM)));
            return (IChart)((Object)objects[0]);
        }
        catch (DXmlError e) {
            throw new IOException(e.getMessage());
        }
    }

    private String serializeGeneratedDocumentToString(Document generatedDocument) {
        if (generatedDocument == null) {
            return null;
        }
        OutputStreamWriter writer = null;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            writer = new OutputStreamWriter((OutputStream)stream, "UTF-8");
            DOMSource source = new DOMSource(generatedDocument);
            StreamResult result = new StreamResult(writer);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.transform(source, result);
        }
        catch (Exception exception) {
            Utilities.assertion(false);
        }
        return stream.toString();
    }
}

