/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.core.provisional;

import java.io.OutputStream;
import org.eclipse.tptp.platform.report.chart.svg.internal.SVGGenerator;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGChartImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.SVGTranscode;
import org.eclipse.tptp.platform.report.core.internal.DDocument;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.provisional.IChart;
import org.eclipse.tptp.platform.report.core.provisional.IRenderer;
import org.eclipse.tptp.platform.report.core.provisional.RendererException;
import org.w3c.dom.Document;

public class StaticImageRenderer
implements IRenderer {
    protected SVGGenerator generator = new SVGGenerator();
    protected OutputStream outputStream;
    public static final String JPEG = "Transcode.JPEG";
    public static final String PNG = "Transcode.PNG";
    public static final String PDF = "Transcode.PDF";
    public static final String STATIC_IMAGE_TYPE = "tptp.transcode.type";
    protected String transcode_type;

    public void setProperty(String key, Object value) throws RendererException {
        if (key.equals("tptp.output.stream")) {
            this.outputStream = (OutputStream)value;
        } else if (key.equals(STATIC_IMAGE_TYPE)) {
            this.transcode_type = (String)value;
        } else {
            throw new RendererException("Property key: " + key + " not supported by this renderer.");
        }
    }

    public void render(IChart chart) throws RendererException {
        if (chart instanceof DDocument) {
            chart = (IChart)((Object)((DDocument)chart).getChildOfClass(DGraphic.class));
        }
        if (chart instanceof DGraphic) {
            SVGChartImpl input = new SVGChartImpl((DGraphic)chart);
            try {
                Document svgoutput = this.generator.generateGraphicDocument(input);
                String SVGGraphic = this.generator.serializeGeneratedDocumentToString(svgoutput);
                if (PDF.equals(this.transcode_type)) {
                    SVGTranscode.transcode2PDF(SVGGraphic, this.outputStream);
                } else if (PNG.equals(this.transcode_type)) {
                    SVGTranscode.transcode2PNG(SVGGraphic, this.outputStream);
                } else if (JPEG.equals(this.transcode_type)) {
                    SVGTranscode.transcode2JPEG(SVGGraphic, this.outputStream);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

