/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drawutil.internal;

import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class CursorUtil {
    private static PaletteData pal_;

    public static Cursor CursorFromString(String[] _str, int _hsx, int _hsy) {
        if (pal_ == null) {
            RGB[] rgb = new RGB[]{new RGB(0, 0, 0), new RGB(255, 0, 0)};
            pal_ = new PaletteData(rgb);
        }
        int w = _str[0].length();
        int h = _str.length;
        byte[] src = new byte[w * h];
        byte[] msk = new byte[w * h];
        int cb = 0;
        int mask = 128;
        int y = 0;
        while (y < _str.length) {
            int cw = _str[y].length();
            if (cw != w) {
                System.err.println("Width mismatch in CursorFromString");
                return null;
            }
            int x = 0;
            while (x < _str[y].length()) {
                char chr = _str[y].charAt(x);
                switch (chr) {
                    case '.': {
                        int n = cb;
                        msk[n] = (byte)(msk[n] | mask);
                        break;
                    }
                    case 'n': {
                        break;
                    }
                    case ' ': {
                        int n = cb;
                        src[n] = (byte)(src[n] | mask);
                        break;
                    }
                    default: {
                        int n = cb;
                        msk[n] = (byte)(msk[n] | mask);
                        int n2 = cb;
                        src[n2] = (byte)(src[n2] | mask);
                    }
                }
                if ((mask >>= 1) == 0) {
                    mask = 128;
                    ++cb;
                }
                ++x;
            }
            ++y;
        }
        ImageData i_src = new ImageData(w, h, 1, pal_, 1, src);
        ImageData i_msk = new ImageData(w, h, 1, pal_, 1, msk);
        Cursor crs = new Cursor(null, i_src, i_msk, _hsx, _hsy);
        return crs;
    }
}

