/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drawutil.internal;

import org.eclipse.tptp.platform.report.core.internal.DWallpaper;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IImage;
import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.internal.IShape;
import org.eclipse.tptp.platform.report.igc.internal.ISize;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.igc.util.internal.Size;

public class DrawUtilIGC {
    public static final int MASK = 448;
    private static final int DistMax = 4;

    public static boolean isEmpty(String _s) {
        if (_s == null) {
            return true;
        }
        return _s.length() == 0;
    }

    public static String truncateText(IGC _gc, String _text, int _available_width, int _available_height, int _alignment) {
        if (DrawUtilIGC.HaveAlignment(_alignment, 64)) {
            return DrawUtilIGC.truncateTextV(_gc, _text, _available_height);
        }
        if (DrawUtilIGC.HaveAlignment(_alignment, 128) || DrawUtilIGC.HaveAlignment(_alignment, 256)) {
            return DrawUtilIGC.truncateTextH(_gc, _text, _available_height);
        }
        return DrawUtilIGC.truncateTextH(_gc, _text, _available_width);
    }

    public static String truncateTextH(IGC _gc, String _text, int _available_width) {
        String txt = _text;
        if (_text == null) {
            return null;
        }
        if (_available_width <= 0) {
            return null;
        }
        ISize size = _gc.textExtent(_text);
        if (size.getW() > _available_width) {
            while (size.getW() > _available_width) {
                if (txt.length() == 0) {
                    return null;
                }
                txt = txt.substring(0, txt.length() - 1);
                size = _gc.textExtent(String.valueOf(txt) + "...");
            }
            txt = String.valueOf(txt) + "...";
        }
        return txt;
    }

    public static String truncateTextV(IGC _gc, String _text, int _available_height) {
        if (DrawUtilIGC.isEmpty(_text)) {
            return null;
        }
        if (_available_height <= 0) {
            return null;
        }
        String txt = _text;
        ISize size = DrawUtilIGC.verticalTextExtent(_gc, _text);
        if (size.getH() > _available_height) {
            while (size.getH() > _available_height) {
                if (txt.length() == 0) {
                    return null;
                }
                txt = txt.substring(0, txt.length() - 1);
                size = DrawUtilIGC.verticalTextExtent(_gc, txt);
            }
        }
        return txt;
    }

    public static ISize verticalTextExtent(IGC _gc, String _s) {
        if (DrawUtilIGC.isEmpty(_s)) {
            return new Size(0, 0);
        }
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < _s.length()) {
            ISize size = _gc.textExtent(_s.substring(i, i + 1));
            int w = size.getW();
            if (w > width) {
                width = w;
            }
            height += size.getH();
            ++i;
        }
        return new Size(width, height);
    }

    public static ISize textExtent(IGC _gc, String _s, int _style) {
        if (_s == null) {
            return new Size(0, 0);
        }
        if (DrawUtilIGC.HaveAlignment(_style, 64)) {
            return DrawUtilIGC.verticalTextExtent(_gc, _s);
        }
        if (DrawUtilIGC.HaveAlignment(_style, 256)) {
            return DrawUtilIGC.rotCW90TextExtent(_gc, _s);
        }
        if (DrawUtilIGC.HaveAlignment(_style, 128)) {
            return DrawUtilIGC.rotCCW90TextExtent(_gc, _s);
        }
        return _gc.textExtent(_s);
    }

    public static ISize rotCW90TextExtent(IGC _gc, String _s) {
        ISize ext = _gc.textExtent(_s, 4.71238898038469);
        return ext;
    }

    public static ISize rotCCW90TextExtent(IGC _gc, String _s) {
        return _gc.textExtent(_s, 1.5707963267948966);
    }

    public static final void drawText(IGC _gc, IRect _r, int _align, String _txt) {
        DrawUtilIGC.drawText(_gc, _r.getX(), _r.getY(), _r.getW(), _r.getH(), _align, _txt);
    }

    public static boolean HaveAlignment(int _alignment, int _mask) {
        return (_alignment & _mask) == _mask;
    }

    public static void drawText(IGC _gc, int _x, int _y, int _w, int _h, int _align, String _txt) {
        if (_txt == null) {
            return;
        }
        ISize size = DrawUtilIGC.textExtent(_gc, _txt, _align);
        if (size == null) {
            _gc.drawText(_txt, _x, _y);
            return;
        }
        int x = _x;
        int y = _y;
        x = DrawUtilIGC.HaveAlignment(_align, 1) ? _x : (DrawUtilIGC.HaveAlignment(_align, 2) ? _x + _w - size.getW() : _x + (_w - size.getW()) / 2);
        y = DrawUtilIGC.HaveAlignment(_align, 8) ? _y : (DrawUtilIGC.HaveAlignment(_align, 16) ? _y + _h - size.getH() : _y + (_h - size.getH()) / 2);
        if (DrawUtilIGC.HaveAlignment(_align, 64)) {
            int H = size.getW();
            int xctr = _x + _w / 2;
            int i = 0;
            while (i < _txt.length()) {
                String c = _txt.substring(i, i + 1);
                ISize sz = _gc.textExtent(c);
                int wc = sz.getW();
                int cx = x;
                cx = DrawUtilIGC.HaveAlignment(_align, 1) ? x : (DrawUtilIGC.HaveAlignment(_align, 2) ? x + size.getW() - wc : xctr - (wc >> 1));
                _gc.drawText(c, cx, y);
                y += H;
                ++i;
            }
        } else if (DrawUtilIGC.HaveAlignment(_align, 128)) {
            _gc.drawText(_txt, x, y + size.getH(), 1.5707963267948966);
        } else if (DrawUtilIGC.HaveAlignment(_align, 256)) {
            _gc.drawText(_txt, x + size.getW(), y, 4.71238898038469);
        } else {
            _gc.drawText(_txt, x, y);
        }
    }

    public static final Rect boundingRect(IGC _gc, IRect _r, int _align, String _txt) {
        return DrawUtilIGC.boundingRect(_gc, _r.getX(), _r.getY(), _r.getW(), _r.getH(), _align, _txt);
    }

    public static Rect boundingRect(IGC _gc, int _x, int _y, int _w, int _h, int _align, String _txt) {
        ISize size = DrawUtilIGC.textExtent(_gc, _txt, _align);
        int x = _x;
        int y = _y;
        x = DrawUtilIGC.HaveAlignment(_align, 1) ? _x : (DrawUtilIGC.HaveAlignment(_align, 2) ? _x + _w - size.getW() : _x + (_w - size.getW()) / 2);
        y = DrawUtilIGC.HaveAlignment(_align, 8) ? _y : (DrawUtilIGC.HaveAlignment(_align, 16) ? _y + _h - size.getH() : _y + (_h - size.getH()) / 2);
        return new Rect(x, y, size.getW(), size.getH());
    }

    public static boolean segmentContains(int _ax, int _ay, int _bx, int _by, int _px, int _py) {
        int ymax;
        int ymin;
        int xmax;
        int xmin;
        if (_ax == _bx) {
            return DrawUtilIGC.near_segment_uv(_ay, _by, _ax, _py, _px, 4);
        }
        if (_ay == _by) {
            return DrawUtilIGC.near_segment_uv(_ax, _bx, _ay, _px, _py, 4);
        }
        if (_ax < _bx) {
            xmin = _ax;
            xmax = _bx;
        } else {
            xmin = _bx;
            xmax = _ax;
        }
        if (_ay < _by) {
            ymin = _ay;
            ymax = _by;
        } else {
            ymin = _by;
            ymax = _ay;
        }
        if (_px < xmin - 4) {
            return false;
        }
        if (_px > xmax + 4) {
            return false;
        }
        if (_py < ymin - 4) {
            return false;
        }
        if (_py > ymax + 4) {
            return false;
        }
        int _bax = _bx - _ax;
        int _bay = _by - _ay;
        float n_ab = (float)Math.sqrt(_bax * _bax + _bay * _bay);
        float _1_n_ab = 1.0f / n_ab;
        float u_ab_x = (float)_bax * _1_n_ab;
        float u_ab_y = (float)_bay * _1_n_ab;
        float v_ab_x = -u_ab_y;
        float v_ab_y = u_ab_x;
        float kx = _bax;
        float lx = v_ab_x;
        float cx = _ax - _px;
        float ky = _bay;
        float ly = v_ab_y;
        float cy = _ay - _py;
        float a = ly * kx + ky * lx;
        float b = cx * ly + cy * lx;
        float k = -b / a;
        float x = k * (float)_bax + (float)_ax;
        float y = k * (float)_bay + (float)_ay;
        if (k < 0.0f) {
            return false;
        }
        if (k > 1.0f) {
            return false;
        }
        float v1 = (float)_px - x;
        float v2 = (float)_py - y;
        float dist = (float)Math.sqrt(v1 * v1 + v2 * v2);
        return dist <= 4.0f && k >= 0.0f && k <= 1.0f;
    }

    protected static boolean near_segment_uv(int _su1, int _su2, int _sv, int _pu, int _pv, int _DistMax) {
        int umax;
        int umin;
        if (_su1 < _su2) {
            umin = _su1;
            umax = _su2;
        } else {
            umin = _su2;
            umax = _su1;
        }
        if (_pu < umin) {
            if (_pu < umin - _DistMax) {
                return false;
            }
            if (_pv < _sv - _DistMax) {
                return false;
            }
            if (_pv > _sv + _DistMax) {
                return false;
            }
            int v1 = _pu - umin;
            int v2 = _pv - _sv;
            float dist = (float)Math.sqrt(v1 * v1 + v2 * v2);
            return dist <= (float)_DistMax;
        }
        if (_pu > umax) {
            if (_pu > umax + _DistMax) {
                return false;
            }
            if (_pv < _sv - _DistMax) {
                return false;
            }
            if (_pv > _sv + _DistMax) {
                return false;
            }
            int v1 = _pu - umax;
            int v2 = _pv - _sv;
            float dist = (float)Math.sqrt(v1 * v1 + v2 * v2);
            return dist <= (float)_DistMax;
        }
        int dist = _pv - _sv;
        if (dist < 0) {
            dist = -dist;
        }
        return dist <= _DistMax;
    }

    public static boolean polygonContains(int[] poly, int px, int py) {
        if (poly == null) {
            return false;
        }
        if (poly.length < 6) {
            return false;
        }
        int length = poly.length;
        if ((length & 1) != 0) {
            --length;
        }
        int last_ip = length - 2;
        int lx = poly[last_ip];
        int ly = poly[last_ip + 1];
        int segment_count = 0;
        int i = 0;
        while (i < length) {
            int yxx;
            int xx;
            int yxn;
            int xn;
            int x = poly[i++];
            int y = poly[i++];
            if (lx < x) {
                xn = lx;
                yxn = ly;
                xx = x;
                yxx = y;
            } else {
                xn = x;
                yxn = y;
                xx = lx;
                yxx = ly;
            }
            if (px >= xn && px <= xx && py >= (y < ly ? y : ly)) {
                if (xn == xx) {
                    return py <= (y < ly ? ly : y);
                }
                float sy = yxn + (px - xn) * (yxx - yxn) / (xx - xn);
                if (sy == (float)py) {
                    return true;
                }
                if (sy < (float)py) {
                    ++segment_count;
                }
            }
            lx = x;
            ly = y;
        }
        return segment_count & true;
    }

    public static boolean ovalContains(int _x, int _y, int _w, int _h, int px, int py) {
        float ya;
        int ry;
        if (!Rect.Contains(_x, _y, _w, _h, px, py)) {
            return false;
        }
        int cx = _x + _w / 2;
        int cy = _y + _h / 2;
        int dx = px - cx;
        int dy = py - cy;
        float rp = (float)Math.sqrt(dx * dx + dy * dy);
        int rx = Math.abs(_w / 2);
        if (rx == (ry = Math.abs(_h / 2))) {
            return rp <= (float)rx;
        }
        if (dy == 0) {
            return Math.abs(dx) <= rx;
        }
        if (dx == 0) {
            return Math.abs(dy) <= ry;
        }
        float a = (float)Math.atan2(dy, dx);
        float xa = (float)((double)rx * Math.cos(a));
        float ra = (float)Math.sqrt(xa * xa + (ya = (float)((double)ry * Math.sin(a))) * ya);
        return rp <= ra;
    }

    public static boolean ovalUnder(int _x, int _y, int _w, int _h, int px, int py) {
        float ya;
        int ry;
        if (!Rect.Contains(_x, _y, _w, _h, px, py)) {
            return false;
        }
        int cx = _x + _w / 2;
        int cy = _y + _h / 2;
        int dx = px - cx;
        int dy = py - cy;
        float rp = (float)Math.sqrt(dx * dx + dy * dy);
        int rx = Math.abs(_w / 2);
        if (rx == (ry = Math.abs(_h / 2))) {
            boolean r = (float)(rx - 2) <= rp && rp <= (float)(rx + 2);
            return r;
        }
        if (dy == 0) {
            return Math.abs(dx) <= rx;
        }
        if (dx == 0) {
            return Math.abs(dy) <= ry;
        }
        float a = (float)Math.atan2(dy, dx);
        float xa = (float)((double)rx * Math.cos(a));
        float ra = (float)Math.sqrt(xa * xa + (ya = (float)((double)ry * Math.sin(a))) * ya);
        return ra - 2.0f <= rp && rp <= ra + 2.0f;
    }

    public static final void drawImage(IGC gc, IImage image, Rect rect, float _scale, int effect) {
        DrawUtilIGC.drawImage(gc, image, rect.x(), rect.y(), rect.w(), rect.h(), _scale, effect);
    }

    public static void drawImage(IGC _gc, IImage _image, int _x, int _y, int _w, int _h, float _scale, int _effect) {
        int iy;
        int div;
        int ix;
        int add;
        if (_effect == 0 || _w <= 0 || _h <= 0) {
            return;
        }
        _image.getWidth();
        _image.getHeight();
        int devimgw = (int)((float)_image.getWidth() * _scale);
        int devimgh = (int)((float)_image.getHeight() * _scale);
        if (devimgw == 0 || devimgh == 0) {
            return;
        }
        int iw = devimgw;
        int ih = devimgh;
        int icx = 1;
        int icy = 1;
        if (DWallpaper.HaveEffect(_effect, DWallpaper.BORDER)) {
            int ix2 = _x;
            icx = _w / devimgw;
            ix2 = _x;
            iw = _w / (icx == 0 ? 1 : icx);
            int iy2 = _y;
            icy = _h / devimgh;
            iy2 = _y;
            ih = _h / (icy == 0 ? 1 : icy);
            if (icx == 0 || icy == 0) {
                return;
            }
            IShape save = _gc.getClipping();
            _gc.setClipping(new Rect(_x, _y, _w, _h));
            try {
                int iix = ix2;
                int ry = 0;
                while (ry < icy) {
                    ix2 = iix;
                    int rx = 0;
                    while (rx < icx) {
                        boolean border;
                        boolean bl = ry != 0 && !(rx == 0 | ry == icy - 1) && rx != icx - 1 ? false : (border = true);
                        if (border) {
                            _gc.drawImage(_image, ix2, iy2, iw, ih);
                        }
                        ix2 += iw;
                        ++rx;
                    }
                    iy2 += ih;
                    ++ry;
                }
            }
            finally {
                _gc.setClipping(save);
            }
            return;
        }
        if (DWallpaper.HaveEffect(_effect, DWallpaper.HREPEAT)) {
            add = _w % devimgw == 0 ? 0 : 1;
            icx = _w / devimgw + add;
            int tw = icx * devimgw;
            if (DWallpaper.HaveEffect(_effect, DWallpaper.LEFT)) {
                ix = _x;
            } else if (DWallpaper.HaveEffect(_effect, DWallpaper.RIGHT)) {
                ix = _x + _w - tw;
            } else if (DWallpaper.HaveEffect(_effect, DWallpaper.HSCALE)) {
                ix = _x;
                div = icx - add;
                iw = _w / (div == 0 ? 1 : div);
                icx -= add;
            } else {
                ix = _x + (_w - tw) / 2;
            }
        } else if (DWallpaper.HaveEffect(_effect, DWallpaper.HSCALE)) {
            ix = _x;
            iw = _w;
        } else {
            ix = DWallpaper.HaveEffect(_effect, DWallpaper.LEFT) ? _x : (DWallpaper.HaveEffect(_effect, DWallpaper.RIGHT) ? _x + _w - devimgw : _x + (_w - devimgw) / 2);
        }
        if (DWallpaper.HaveEffect(_effect, DWallpaper.VREPEAT)) {
            add = _h % devimgh == 0 ? 0 : 1;
            icy = _h / devimgh + add;
            int th = icy * devimgh;
            if (DWallpaper.HaveEffect(_effect, DWallpaper.TOP)) {
                iy = _y;
            } else if (DWallpaper.HaveEffect(_effect, DWallpaper.BOTTOM)) {
                iy = _y + _h - th;
            } else if (DWallpaper.HaveEffect(_effect, DWallpaper.VSCALE)) {
                iy = _y;
                div = icy - add;
                ih = _h / (div == 0 ? 1 : div);
                icy -= add;
            } else {
                iy = _y + (_h - th) / 2;
            }
        } else if (DWallpaper.HaveEffect(_effect, DWallpaper.VSCALE)) {
            iy = _y;
            ih = _h;
        } else {
            iy = DWallpaper.HaveEffect(_effect, DWallpaper.TOP) ? _y : (DWallpaper.HaveEffect(_effect, DWallpaper.BOTTOM) ? _y + _h - devimgh : _y + (_h - devimgh) / 2);
        }
        if (iw < 0 || ih < 0) {
            return;
        }
        IShape save = _gc.getClipping();
        _gc.setClipping(new Rect(_x, _y, _w, _h));
        try {
            int iix = ix;
            int ry = 0;
            while (ry < icy) {
                ix = iix;
                int rx = 0;
                while (rx < icx) {
                    _gc.drawImage(_image, ix, iy, iw, ih);
                    ix += iw;
                    ++rx;
                }
                iy += ih;
                ++ry;
            }
        }
        finally {
            _gc.setClipping(save);
        }
    }
}

