/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drawutil.internal;

import org.eclipse.tptp.platform.report.drawutil.internal.DrawUtilIGC;
import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IPen;
import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.util.internal.LineStylePen;
import org.eclipse.tptp.platform.report.igc.util.internal.Polygon;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.igc.util.internal.SolidBrush;

public interface ISymbol {
    public void draw(IGC var1, IRect var2);

    public boolean contains(IGC var1, IRect var2, int var3, int var4);

    public String getId();

    public static class Cross
    extends GeneratedPolygonSymbol {
        private static double[] gen_;

        protected double[] getGenerator() {
            if (gen_ != null) {
                return gen_;
            }
            gen_ = new double[20];
            double l = 0.25;
            Cross.gen_[0] = 0.5;
            Cross.gen_[1] = 0.5;
            Cross.gen_[2] = 0.0;
            Cross.gen_[3] = 0.5 + l;
            Cross.gen_[4] = 0.0;
            Cross.gen_[5] = 0.5 - l;
            Cross.gen_[6] = 1.0;
            Cross.gen_[7] = 0.5 + l;
            Cross.gen_[8] = 1.0;
            Cross.gen_[9] = 0.5 - l;
            Cross.gen_[10] = 0.5;
            Cross.gen_[11] = 0.5;
            Cross.gen_[12] = 0.5 - l;
            Cross.gen_[13] = 0.0;
            Cross.gen_[14] = 0.5 + l;
            Cross.gen_[15] = 0.0;
            Cross.gen_[16] = 0.5 - l;
            Cross.gen_[17] = 1.0;
            Cross.gen_[18] = 0.5 + l;
            Cross.gen_[19] = 1.0;
            return gen_;
        }
    }

    public static class Cross2
    extends GeneratedPolygonSymbol {
        private static double[] gen_;

        protected double[] getGenerator() {
            if (gen_ != null) {
                return gen_;
            }
            gen_ = new double[20];
            double l = 0.25;
            Cross2.gen_[0] = 0.5;
            Cross2.gen_[1] = 0.5;
            Cross2.gen_[2] = 0.0;
            Cross2.gen_[3] = 0.5 - l;
            Cross2.gen_[4] = 0.5 - l;
            Cross2.gen_[5] = 0.0;
            Cross2.gen_[6] = 0.5 + l;
            Cross2.gen_[7] = 1.0;
            Cross2.gen_[8] = 1.0;
            Cross2.gen_[9] = 0.5 + l;
            Cross2.gen_[10] = 0.5;
            Cross2.gen_[11] = 0.5;
            Cross2.gen_[12] = 0.5 - l;
            Cross2.gen_[13] = 1.0;
            Cross2.gen_[14] = 0.0;
            Cross2.gen_[15] = 0.5 + l;
            Cross2.gen_[16] = 1.0;
            Cross2.gen_[17] = 0.5 - l;
            Cross2.gen_[18] = 0.5 + l;
            Cross2.gen_[19] = 0.0;
            return gen_;
        }
    }

    public static class Diamond
    extends PolygonSymbol {
        protected Polygon getPolygon(IRect r) {
            int[] points;
            int xc = Rect.CenterX(r);
            int yc = Rect.CenterY(r);
            int dx = r.getW() / 2;
            int dy = r.getH() / 2;
            points = new int[]{xc, yc - dy, xc + dx, yc, xc, yc + dy, xc - dx, yc, points[0], points[1]};
            return new Polygon(points);
        }
    }

    public static class Down
    extends PolygonSymbol {
        protected Polygon getPolygon(IRect r) {
            int yt = Rect.Top(r);
            Polygon p = new Polygon(4);
            p.setPoint(0, Rect.Right(r), yt);
            p.setPoint(1, Rect.CenterX(r), Rect.Bottom(r));
            p.setPoint(2, Rect.Left(r), yt);
            p.setPoint(3, Rect.Right(r), yt);
            return p;
        }
    }

    public static abstract class GeneratedPolygonSymbol
    extends PolygonSymbol {
        protected abstract double[] getGenerator();

        protected static void FitGenerator(double[] _gen) {
            double xn = 0.0;
            double yn = 0.0;
            double xx = 0.0;
            double yx = 0.0;
            int i = 0;
            while (i < _gen.length) {
                if (i == 0) {
                    xn = xx = _gen[i];
                } else if (_gen[i] < xn) {
                    xn = _gen[i];
                } else if (_gen[i] > xx) {
                    xx = _gen[i];
                }
                if (++i == 1) {
                    yn = yx = _gen[i];
                } else if (_gen[i] < yn) {
                    yn = _gen[i];
                } else if (_gen[i] > yx) {
                    yx = _gen[i];
                }
                ++i;
            }
            double kx = 1.0 / (xx - xn);
            double ky = 1.0 / (yx - yn);
            int i2 = 0;
            while (i2 < _gen.length) {
                _gen[i2] = kx * (_gen[i2] - xn);
                _gen[++i2] = ky * (_gen[i2] - yn);
                ++i2;
            }
        }

        protected Polygon getPolygon(IRect r) {
            double[] gen = this.getGenerator();
            double sx = r.getW();
            double sy = r.getH();
            int x0 = r.getX();
            int y0 = r.getY();
            int[] points = new int[gen.length + 2];
            int i = 0;
            while (i < gen.length) {
                points[i] = x0 + (int)Math.round(sx * gen[i]);
                points[++i] = y0 + (int)Math.round(sy * gen[i]);
                ++i;
            }
            points[gen.length] = points[0];
            points[gen.length + 1] = points[1];
            return new Polygon(points);
        }
    }

    public static class HTri2
    extends PolygonSymbol {
        protected Polygon getPolygon(IRect r) {
            int[] points;
            points = new int[]{r.getX(), r.getY(), r.getX() + r.getW(), r.getY() + r.getH(), points[2], points[1], points[0], points[3], points[0], points[1]};
            return new Polygon(points);
        }
    }

    public static class Hexagon
    extends GeneratedPolygonSymbol {
        private static double[] gen_;

        protected double[] getGenerator() {
            if (gen_ != null) {
                return gen_;
            }
            gen_ = new double[12];
            double c = 0.5 * Math.cos(1.0471975511965976);
            double s = 0.5 * Math.sin(1.0471975511965976);
            Hexagon.gen_[0] = 1.0;
            Hexagon.gen_[1] = 0.5;
            Hexagon.gen_[2] = 0.5 + c;
            Hexagon.gen_[3] = 0.5 - s;
            Hexagon.gen_[4] = 0.5 - c;
            Hexagon.gen_[5] = gen_[3];
            Hexagon.gen_[6] = 0.0;
            Hexagon.gen_[7] = 0.5;
            Hexagon.gen_[8] = gen_[4];
            Hexagon.gen_[9] = 0.5 + s;
            Hexagon.gen_[10] = gen_[2];
            Hexagon.gen_[11] = gen_[9];
            Hexagon.FitGenerator(gen_);
            return gen_;
        }
    }

    public static class HexagonCross
    extends GeneratedPolygonSymbol {
        private static double[] gen_;

        protected double[] getGenerator() {
            if (gen_ != null) {
                return gen_;
            }
            gen_ = new double[12];
            double c = 0.5 * Math.cos(1.0471975511965976);
            double s = 0.5 * Math.sin(1.0471975511965976);
            HexagonCross.gen_[0] = 1.0;
            HexagonCross.gen_[1] = 0.5;
            HexagonCross.gen_[2] = 0.0;
            HexagonCross.gen_[3] = 0.5;
            HexagonCross.gen_[4] = 0.5 - c;
            HexagonCross.gen_[5] = 0.5 + s;
            HexagonCross.gen_[6] = 0.5 + c;
            HexagonCross.gen_[7] = 0.5 - s;
            HexagonCross.gen_[8] = 0.5 - c;
            HexagonCross.gen_[9] = 0.5 - s;
            HexagonCross.gen_[10] = 0.5 + c;
            HexagonCross.gen_[11] = 0.5 + s;
            HexagonCross.FitGenerator(gen_);
            return gen_;
        }
    }

    public static class HexagonCross2
    extends GeneratedPolygonSymbol {
        private static double[] gen_;

        protected double[] getGenerator() {
            if (gen_ != null) {
                return gen_;
            }
            gen_ = new double[12];
            double c = 0.5 * Math.cos(1.0471975511965976);
            double s = 0.5 * Math.sin(1.0471975511965976);
            HexagonCross2.gen_[0] = 1.0;
            HexagonCross2.gen_[1] = 0.5;
            HexagonCross2.gen_[2] = 0.0;
            HexagonCross2.gen_[3] = 0.5;
            HexagonCross2.gen_[4] = 0.5 - c;
            HexagonCross2.gen_[5] = 0.5 - s;
            HexagonCross2.gen_[6] = 0.5 + c;
            HexagonCross2.gen_[7] = 0.5 + s;
            HexagonCross2.gen_[8] = 0.5 - c;
            HexagonCross2.gen_[9] = 0.5 + s;
            HexagonCross2.gen_[10] = 0.5 + c;
            HexagonCross2.gen_[11] = 0.5 - s;
            HexagonCross2.FitGenerator(gen_);
            return gen_;
        }
    }

    public static class Left
    extends PolygonSymbol {
        protected Polygon getPolygon(IRect r) {
            int[] points;
            int xr = Rect.Right(r);
            points = new int[]{xr, Rect.Top(r), xr, Rect.Bottom(r), Rect.Left(r), Rect.CenterY(r), points[0], points[1]};
            return new Polygon(points);
        }
    }

    public static class Minus
    implements ISymbol {
        public void draw(IGC gc, IRect rect) {
            int h = rect.getH() / 3;
            gc.fillRect(rect.getX(), rect.getY() + h, rect.getW(), h);
            gc.drawRect(rect.getX(), rect.getY() + h, rect.getW(), h);
        }

        public boolean contains(IGC gc, IRect rect, int px, int py) {
            int h = rect.getH() / 3;
            return Rect.Contains(rect.getX(), rect.getY() + h, rect.getW(), h, px, py);
        }

        public String getId() {
            return this.getClass().getName();
        }
    }

    public static class MoonDown
    implements ISymbol {
        public void draw(IGC gc, IRect rect) {
            rect.getY();
            int cfr_ignored_0 = rect.getH() / 4;
            int cx = Rect.CenterX(rect);
            int cy = Rect.CenterY(rect);
            int w = rect.getW();
            int rx = w / 2;
            int ry = rect.getH() / 2;
            gc.fillArc(cx, cy, 0.0, rx, ry, Math.PI, Math.PI);
            gc.drawArc(cx, cy, 0.0, rx, ry, Math.PI, Math.PI);
            int cfr_ignored_1 = rect.getY() + rect.getH() / 4;
            gc.drawLine(Rect.Left(rect), cy, Rect.Right(rect), cy);
        }

        public boolean contains(IGC gc, IRect r, int px, int py) {
            int x = r.getX();
            int y = r.getY();
            int w = r.getW();
            int h = r.getH();
            return !Rect.Contains(x, y - h / 4, w, h / 2, px, py) && DrawUtilIGC.ovalContains(x, y - h / 4, w, h, px, py);
        }

        public String getId() {
            return this.getClass().getName();
        }
    }

    public static class MoonLeft
    implements ISymbol {
        public void draw(IGC gc, IRect rect) {
            rect.getX();
            int cfr_ignored_0 = rect.getW() / 4;
            int cx = Rect.CenterX(rect);
            int cy = Rect.CenterY(rect);
            int rx = rect.getW() / 2;
            int ry = rect.getH() / 2;
            gc.fillArc(cx, cy, 0.0, rx, ry, 1.5707963267948966, Math.PI);
            gc.drawArc(cx, cy, 0.0, rx, ry, 1.5707963267948966, Math.PI);
            int cfr_ignored_1 = rect.getX() + 3 * rect.getW() / 4;
            gc.drawLine(cx, Rect.Top(rect), cx, Rect.Bottom(rect));
        }

        public boolean contains(IGC gc, IRect r, int px, int py) {
            int h;
            int x = r.getX();
            int y = r.getY();
            int w = r.getW();
            return !Rect.Contains(x + w / 4, y, w / 2, h = r.getH(), px, py) && DrawUtilIGC.ovalContains(x + w / 4, y, w / 2, h, px, py);
        }

        public String getId() {
            return this.getClass().getName();
        }
    }

    public static class MoonRight
    implements ISymbol {
        public void draw(IGC gc, IRect rect) {
            rect.getX();
            int cfr_ignored_0 = rect.getW() / 4;
            int cx = Rect.CenterX(rect);
            int cy = Rect.CenterY(rect);
            int rx = rect.getW() / 2;
            int ry = rect.getH() / 2;
            gc.fillArc(cx, cy, 0.0, rx, ry, 4.71238898038469, Math.PI);
            gc.drawArc(cx, cy, 0.0, rx, ry, 4.71238898038469, Math.PI);
            int cfr_ignored_1 = rect.getX() + rect.getW() / 4;
            gc.drawLine(cx, Rect.Top(rect), cx, Rect.Bottom(rect));
        }

        public boolean contains(IGC gc, IRect r, int px, int py) {
            int h;
            int x = r.getX();
            int y = r.getY();
            int w = r.getW();
            return !Rect.Contains(x + w / 4, y, w / 2, h = r.getH(), px, py) && DrawUtilIGC.ovalContains(x + w / 4, y, w / 2, h, px, py);
        }

        public String getId() {
            return this.getClass().getName();
        }
    }

    public static class MoonUp
    implements ISymbol {
        public void draw(IGC gc, IRect rect) {
            rect.getY();
            int cfr_ignored_0 = rect.getH() / 4;
            int cx = Rect.CenterX(rect);
            int cy = Rect.CenterY(rect);
            int rx = rect.getW() / 2;
            int ry = rect.getH() / 2;
            gc.fillArc(cx, cy, 0.0, rx, ry, 0.0, Math.PI);
            gc.drawArc(cx, cy, 0.0, rx, ry, 0.0, Math.PI);
            int cfr_ignored_1 = rect.getY() + 3 * rect.getH() / 4;
            gc.drawLine(Rect.Left(rect), cy, Rect.Right(rect), cy);
        }

        public boolean contains(IGC gc, IRect r, int px, int py) {
            int x = r.getX();
            int y = r.getY();
            int w = r.getW();
            int h = r.getH();
            return !Rect.Contains(x, y + h / 4, w, h / 2, px, py) && DrawUtilIGC.ovalContains(x, y + h / 4, w, h / 2, px, py);
        }

        public String getId() {
            return this.getClass().getName();
        }
    }

    public static class Oval
    implements ISymbol {
        public void draw(IGC gc, IRect rect) {
            gc.fillOval(rect.getX(), rect.getY(), rect.getW(), rect.getH());
            gc.drawOval(rect.getX(), rect.getY(), rect.getW(), rect.getH());
        }

        public boolean contains(IGC gc, IRect r, int px, int py) {
            return DrawUtilIGC.ovalContains(r.getX(), r.getY(), r.getW(), r.getH(), px, py);
        }

        public String getId() {
            return this.getClass().getName();
        }
    }

    public static class OvalDot
    implements ISymbol {
        public void draw(IGC gc, IRect rect) {
            gc.fillOval(rect.getX(), rect.getY(), rect.getW(), rect.getH());
            gc.drawOval(rect.getX(), rect.getY(), rect.getW(), rect.getH());
            IPen pen = gc.getPen();
            IBrush old = gc.getBrush();
            if (pen instanceof LineStylePen) {
                gc.setBrush(new SolidBrush(((LineStylePen)pen).getRGBA()));
            }
            int x2 = rect.getX() + rect.getW() / 4;
            int w2 = rect.getW() / 2;
            int y2 = rect.getY() + rect.getH() / 4;
            int h2 = rect.getH() / 2;
            gc.fillOval(x2, y2, w2 + 1, h2 + 1);
            gc.drawOval(x2, y2, w2, h2);
            gc.setBrush(old);
        }

        public boolean contains(IGC gc, IRect r, int px, int py) {
            return DrawUtilIGC.ovalContains(r.getX(), r.getY(), r.getW(), r.getH(), px, py);
        }

        public String getId() {
            return this.getClass().getName();
        }
    }

    public static class Pentagon
    extends GeneratedPolygonSymbol {
        private static double[] gen_;

        protected double[] getGenerator() {
            if (gen_ != null) {
                return gen_;
            }
            gen_ = new double[10];
            double rx = 0.5;
            double ry = 0.5;
            double cx = 0.5;
            double cy = 0.5;
            double a = 1.5707963267948966;
            double da = 1.2566370614359172;
            int i = 0;
            int j = 0;
            while (j < 5) {
                Pentagon.gen_[i++] = cx + rx * Math.cos(a);
                Pentagon.gen_[i++] = cy - ry * Math.sin(a);
                ++j;
                a += da;
            }
            Pentagon.FitGenerator(gen_);
            return gen_;
        }
    }

    public static class Plus
    extends PolygonSymbol {
        protected Polygon getPolygon(IRect r) {
            int[] points;
            int dx = r.getW() / 3;
            int dy = r.getH() / 3;
            int x0 = Rect.Left(r);
            int y0 = Rect.Top(r);
            int x1 = x0 + dx;
            int y1 = y0 + dy;
            int x2 = x1 + dx;
            int y2 = y1 + dy;
            int x3 = x2 + dx;
            int y3 = y2 + dy;
            points = new int[]{x2, y0, x2, y1, x3, y1, x3, y2, x2, y2, x2, y3, x1, y3, x1, y2, x0, y2, x0, y1, x1, y1, x1, y0, points[0], points[1]};
            return new Polygon(points);
        }
    }

    public static abstract class PolygonSymbol
    implements ISymbol {
        protected abstract Polygon getPolygon(IRect var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void draw(IGC gc, IRect rect) {
            Polygon poly;
            Polygon polygon = poly = this.getPolygon(rect);
            synchronized (polygon) {
                gc.fillPoly(poly);
                gc.drawPoly(poly);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(IGC gc, IRect rect, int px, int py) {
            Polygon poly;
            if (!rect.contains(px, py)) {
                return false;
            }
            Polygon polygon = poly = this.getPolygon(rect);
            synchronized (polygon) {
                return poly.contains(px, py);
            }
        }

        public String getId() {
            return this.getClass().getName();
        }
    }

    public static class Right
    extends PolygonSymbol {
        protected Polygon getPolygon(IRect r) {
            int[] points;
            int y2 = Rect.CenterY(r);
            int xl = Rect.Left(r);
            points = new int[]{xl, Rect.Top(r), Rect.Right(r), y2, xl, Rect.Bottom(r), points[0], points[1]};
            return new Polygon(points);
        }
    }

    public static class Square
    implements ISymbol {
        public void draw(IGC gc, IRect rect) {
            gc.fillRect(rect.getX(), rect.getY(), rect.getW(), rect.getH());
            gc.drawRect(rect.getX(), rect.getY(), rect.getW(), rect.getH());
        }

        public boolean contains(IGC gc, IRect rect, int px, int py) {
            return rect.contains(px, py);
        }

        public String getId() {
            return this.getClass().getName();
        }
    }

    public static class Square2
    implements ISymbol {
        public void draw(IGC gc, IRect rect) {
            int x = rect.getX();
            int y = rect.getY();
            int w = rect.getW();
            int h = rect.getH();
            gc.fillRect(x, y, w, h);
            gc.drawRect(x, y, w, h);
            IPen pen = gc.getPen();
            IBrush old_brush = gc.getBrush();
            if (pen instanceof LineStylePen) {
                gc.setBrush(new SolidBrush(((LineStylePen)pen).getRGBA()));
            }
            int x2 = rect.getX() + rect.getW() / 4;
            int w2 = rect.getW() / 2;
            int y2 = rect.getY() + rect.getH() / 4;
            int h2 = rect.getH() / 2;
            gc.fillRect(x2, y2, w2 + 1, h2 + 1);
            gc.drawRect(x2, y2, w2, h2);
            gc.setBrush(old_brush);
        }

        public boolean contains(IGC gc, IRect rect, int px, int py) {
            return rect.contains(px, py);
        }

        public String getId() {
            return this.getClass().getName();
        }
    }

    public static class Star
    extends GeneratedPolygonSymbol {
        private static double[] gen_;

        protected double[] getGenerator() {
            if (gen_ != null) {
                return gen_;
            }
            gen_ = new double[20];
            double rx = 0.5;
            double ry = 0.5;
            double rix = rx / 2.65;
            double riy = ry / 2.65;
            double cx = 0.5;
            double cy = 0.5;
            double a = 1.5707963267948966;
            double da = 0.6283185307179586;
            int i = 0;
            int j = 0;
            while (j < 10) {
                Star.gen_[i++] = cx + ((j & 1) == 0 ? rx : rix) * Math.cos(a);
                Star.gen_[i++] = cy - ((j & 1) == 0 ? ry : riy) * Math.sin(a);
                ++j;
                a += da;
            }
            Star.FitGenerator(gen_);
            return gen_;
        }
    }

    public static class Up
    extends PolygonSymbol {
        protected Polygon getPolygon(IRect r) {
            int yb = Rect.Bottom(r);
            Polygon p = new Polygon(4);
            p.setPoint(0, Rect.CenterX(r), Rect.Top(r));
            p.setPoint(1, Rect.Right(r), yb);
            p.setPoint(2, Rect.Left(r), yb);
            p.setPoint(3, Rect.CenterX(r), Rect.Top(r));
            return p;
        }
    }

    public static class VTri2
    extends PolygonSymbol {
        protected Polygon getPolygon(IRect r) {
            int[] points;
            points = new int[]{r.getX(), r.getY(), r.getX() + r.getW(), r.getY() + r.getH(), points[0], points[3], points[2], points[1], points[0], points[1]};
            return new Polygon(points);
        }
    }
}

