/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drawutil.internal;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class Rect {
    protected int x_;
    protected int y_;
    protected int w_;
    protected int h_;

    public Rect() {
        this.h_ = 0;
        this.w_ = 0;
        this.y_ = 0;
        this.x_ = 0;
    }

    public Rect(int _x, int _y, int _w, int _h) {
        this.x_ = _x;
        this.y_ = _y;
        this.w_ = _w;
        this.h_ = _h;
    }

    public Rect(Rect _r) {
        this.setRect(_r);
    }

    public Rect(Rectangle _r) {
        this.setRect(_r);
    }

    public int x() {
        return this.x_;
    }

    public int y() {
        return this.y_;
    }

    public int w() {
        return this.w_;
    }

    public int h() {
        return this.h_;
    }

    public int left() {
        if (this.w_ >= 0) {
            return this.x_;
        }
        return this.x_ + this.w_;
    }

    public int right() {
        if (this.w_ >= 0) {
            return this.x_ + this.w_;
        }
        return this.x_;
    }

    public int top() {
        if (this.h_ >= 0) {
            return this.y_;
        }
        return this.y_ + this.h_;
    }

    public int bottom() {
        if (this.h_ >= 0) {
            return this.y_ + this.h_;
        }
        return this.y_;
    }

    public Point center() {
        return new Point(this.centerX(), this.centerY());
    }

    public int centerX() {
        return this.x_ + (this.w_ >> 1);
    }

    public int centerY() {
        return this.y_ + (this.h_ >> 1);
    }

    public void setX(int _x) {
        this.x_ = _x;
    }

    public void setY(int _y) {
        this.y_ = _y;
    }

    public void setWidth(int _w) {
        this.w_ = _w;
    }

    public void setHeight(int _h) {
        this.h_ = _h;
    }

    public void setSize(int _w, int _h) {
        this.w_ = _w;
        this.h_ = _h;
    }

    public final void setSize(Point _size) {
        this.setSize(_size.x, _size.y);
    }

    public void setLocation(int _x, int _y) {
        this.x_ = _x;
        this.y_ = _y;
    }

    public final void setLocation(Point _p) {
        this.setLocation(_p.x, _p.y);
    }

    public void setLeft(int _l) {
        int r = this.right();
        this.x_ = _l;
        this.w_ = r - _l;
    }

    public void setRight(int _r) {
        int l;
        this.x_ = l = this.left();
        this.w_ = _r - l;
    }

    public void setTop(int _t) {
        int b = this.bottom();
        this.y_ = _t;
        this.h_ = b - _t;
    }

    public void setBottom(int _b) {
        int t;
        this.y_ = t = this.top();
        this.h_ = _b - t;
    }

    public void grow(int _amount) {
        this.x_ -= _amount;
        this.w_ += 2 * _amount;
        this.y_ -= _amount;
        this.h_ += 2 * _amount;
    }

    public void shrink(int _amount) {
        this.x_ += _amount;
        this.w_ -= 2 * _amount;
        this.y_ += _amount;
        this.h_ -= 2 * _amount;
    }

    public static boolean Contains(int _lx, int _ty, int _w, int _h, int _px, int _py) {
        if (_px < _lx) {
            return false;
        }
        if (_px > _lx + _w) {
            return false;
        }
        if (_py < _ty) {
            return false;
        }
        return _py <= _ty + _h;
    }

    public static boolean ContainsBorder(int _lx, int _ty, int _w, int _h, int _px, int _py) {
        if (_px <= _lx) {
            return false;
        }
        if (_px >= _lx + _w) {
            return false;
        }
        if (_py <= _ty) {
            return false;
        }
        return _py < _ty + _h;
    }

    public boolean contains(int _px, int _py) {
        if (_px < this.left()) {
            return false;
        }
        if (_px > this.right()) {
            return false;
        }
        if (_py < this.top()) {
            return false;
        }
        return _py <= this.bottom();
    }

    public boolean containsBorder(int _px, int _py) {
        if (_px <= this.left()) {
            return false;
        }
        if (_px >= this.right()) {
            return false;
        }
        if (_py <= this.top()) {
            return false;
        }
        return _py < this.bottom();
    }

    public final boolean contains(Point _p) {
        if (_p == null) {
            return false;
        }
        return this.contains(_p.x, _p.y);
    }

    public final boolean containsBorder(Point _p) {
        if (_p == null) {
            return false;
        }
        return this.contains(_p.x, _p.y);
    }

    public void setRect(int _x, int _y, int _w, int _h) {
        this.x_ = _x;
        this.y_ = _y;
        this.w_ = _w;
        this.h_ = _h;
    }

    public void setRect(Rect _r) {
        if (_r == null) {
            this.h_ = 0;
            this.w_ = 0;
            this.y_ = 0;
            this.x_ = 0;
        } else {
            this.x_ = _r.x_;
            this.y_ = _r.y_;
            this.w_ = _r.w_;
            this.h_ = _r.h_;
        }
    }

    public void setRect(Rectangle _r) {
        if (_r == null) {
            this.h_ = 0;
            this.w_ = 0;
            this.y_ = 0;
            this.x_ = 0;
        } else {
            this.x_ = _r.x;
            this.y_ = _r.y;
            this.w_ = _r.width;
            this.h_ = _r.height;
        }
    }

    public Rectangle toRectangle() {
        return new Rectangle(this.x_, this.y_, this.w_, this.h_);
    }

    public Rectangle toRectangle(Rectangle _r) {
        if (_r == null) {
            return new Rectangle(this.x_, this.y_, this.w_, this.h_);
        }
        _r.x = this.x_;
        _r.y = this.y_;
        _r.width = this.w_;
        _r.height = this.h_;
        return _r;
    }

    public Rect normalize() {
        if (this.w_ < 0) {
            this.x_ += this.w_;
            this.w_ = -this.w_;
        }
        if (this.h_ < 0) {
            this.y_ += this.h_;
            this.h_ = -this.h_;
        }
        return this;
    }

    public void moveTo(int _x, int _y) {
        this.x_ = _x;
        this.y_ = _y;
    }

    public void moveBy(int _dx, int _dy) {
        this.x_ += _dx;
        this.y_ += _dy;
    }

    public void moveCenter(int _cx, int _cy) {
        this.x_ = _cx - (this.w_ >> 1);
        this.y_ = _cy - (this.h_ >> 1);
    }

    public final void moveCenter(Point _p) {
        this.moveCenter(_p.x, _p.y);
    }

    public Rect intersection(Rect _r) {
        int left = Math.max(this.left(), _r.left());
        int top = Math.max(this.top(), _r.top());
        int right = Math.min(this.right(), _r.right());
        int bottom = Math.min(this.bottom(), _r.bottom());
        this.x_ = left;
        this.y_ = top;
        this.w_ = Math.max(0, right - left);
        this.h_ = Math.max(0, bottom - top);
        return this;
    }

    public Rect union(Rect _r) {
        int left = Math.min(this.left(), _r.left());
        int top = Math.min(this.top(), _r.top());
        int right = Math.max(this.right(), _r.right());
        int bottom = Math.max(this.bottom(), _r.bottom());
        this.x_ = left;
        this.y_ = top;
        this.w_ = Math.max(0, right - left);
        this.h_ = Math.max(0, bottom - top);
        return this;
    }

    public static Rect Intersection(Rect _r1, Rect _r2) {
        Rect r = new Rect(_r1);
        return r.intersection(_r2);
    }

    public static Rect Intersection(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        int b2;
        int t2;
        int r2;
        int l2;
        int b1;
        int t1;
        int r1;
        int l1;
        if (w1 >= 0) {
            l1 = x1;
            r1 = x1 + w1;
        } else {
            l1 = x1 + w1;
            r1 = x1;
        }
        if (h1 >= 0) {
            t1 = y1;
            b1 = y1 + h1;
        } else {
            t1 = y1 + h1;
            b1 = y1;
        }
        if (w2 >= 0) {
            l2 = x2;
            r2 = x2 + w2;
        } else {
            l2 = x2 + w2;
            r2 = x2;
        }
        if (h2 >= 0) {
            t2 = y2;
            b2 = y2 + h2;
        } else {
            t2 = y2 + h2;
            b2 = y2;
        }
        int left = Math.max(l1, l2);
        int right = Math.min(r1, r2);
        int w = right - left;
        if (w < 0) {
            return null;
        }
        int top = Math.max(t1, t2);
        int bottom = Math.min(b1, b2);
        int h = bottom - top;
        if (h < 0) {
            return null;
        }
        return new Rect(left, top, w, h);
    }

    public static Rectangle IntersectionR(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        int b2;
        int t2;
        int r2;
        int l2;
        int b1;
        int t1;
        int r1;
        int l1;
        if (w1 >= 0) {
            l1 = x1;
            r1 = x1 + w1;
        } else {
            l1 = x1 + w1;
            r1 = x1;
        }
        if (h1 >= 0) {
            t1 = y1;
            b1 = y1 + h1;
        } else {
            t1 = y1 + h1;
            b1 = y1;
        }
        if (w2 >= 0) {
            l2 = x2;
            r2 = x2 + w2;
        } else {
            l2 = x2 + w2;
            r2 = x2;
        }
        if (h2 >= 0) {
            t2 = y2;
            b2 = y2 + h2;
        } else {
            t2 = y2 + h2;
            b2 = y2;
        }
        int left = Math.max(l1, l2);
        int right = Math.min(r1, r2);
        int w = right - left;
        if (w < 0) {
            return null;
        }
        int top = Math.max(t1, t2);
        int bottom = Math.min(b1, b2);
        int h = bottom - top;
        if (h < 0) {
            return null;
        }
        return new Rectangle(left, top, w, h);
    }

    public static Rect Union(Rect _r1, Rect _r2) {
        Rect r = new Rect(_r1);
        return r.union(_r2);
    }

    public String toString() {
        String s = String.valueOf(this.x_) + "," + this.y_ + "," + this.w_ + "x" + this.h_;
        return s;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Rect) {
            Rect or = (Rect)o;
            return or.x_ == this.x_ && or.y_ == this.y_ && or.h_ == this.h_ && or.w_ == this.w_;
        }
        if (o instanceof Rectangle) {
            Rectangle or = (Rectangle)o;
            return or.x == this.x_ && or.y == this.y_ && or.height == this.h_ && or.width == this.w_;
        }
        return false;
    }
}

