/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drawutil.internal;

import com.ibm.icu.util.ULocale;
import java.util.HashMap;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.tptp.platform.report.core.internal.IDColor;
import org.eclipse.tptp.platform.report.core.internal.IDFont;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDStyle;
import org.eclipse.tptp.platform.report.drawutil.internal.DrawUtil;
import org.eclipse.tptp.platform.report.tools.internal.IDisposable;

public class SWTDStyle
implements IDisposable {
    protected Font font_;
    protected Color fore_;
    protected Color back_;
    protected boolean dispose_font_;
    protected boolean dispose_back_;
    protected boolean dispose_fore_;
    protected int font_style_;
    private static SColor a_scolor = new SColor();
    private static SFont a_sfont = new SFont();

    public SWTDStyle(Device _dev) {
        this.styleOf(_dev, null, 1.0f);
    }

    public SWTDStyle(Device _dev, float font_scale) {
        this.styleOf(_dev, null, font_scale);
    }

    public SWTDStyle(Device dev, IDItem _item) {
        this.styleOf(dev, _item, 1.0f);
    }

    public SWTDStyle(Device dev, IDItem _item, float font_scale) {
        this.styleOf(dev, _item, font_scale);
    }

    public void dispose() {
        if (this.font_ != null && this.dispose_font_) {
            this.font_.dispose();
        }
        if (this.fore_ != null && this.dispose_fore_) {
            this.fore_.dispose();
        }
        if (this.back_ != null && this.dispose_back_) {
            this.back_.dispose();
        }
        this.font_ = null;
        this.dispose_font_ = false;
        this.fore_ = null;
        this.dispose_fore_ = false;
        this.back_ = null;
        this.dispose_back_ = false;
    }

    public Font getFont() {
        return this.font_;
    }

    public Color getFore() {
        return this.fore_;
    }

    public Color getBack() {
        return this.back_;
    }

    public int getFontStyle() {
        return this.font_style_;
    }

    public static Color getDefaultFore(Device dev_) {
        return dev_.getSystemColor(2);
    }

    public static Color getDefaultBack(Device dev_) {
        return dev_.getSystemColor(1);
    }

    public static Font getDefaultFont(Device dev_, float font_scale) {
        Float fh = new Float(font_scale);
        Font f = (Font)SFont._defaultFont.get(fh);
        if (f == null) {
            f = new Font(dev_, "", (int)(8.0f * font_scale), 0);
            SFont._defaultFont.put(fh, f);
        }
        return f;
    }

    public void styleOf(Device _swt_device, IDItem _item, float font_scale) {
        this.dispose();
        IDStyle jscrib_style = null;
        IDFont jscrib_font = null;
        IDColor jscrib_color = null;
        int all = 0;
        IDItem item = _item;
        while (item != null) {
            jscrib_style = item.getStyle();
            if (jscrib_style != null) {
                if (this.font_ == null && (jscrib_font = jscrib_style.getFont()) != null) {
                    a_sfont = SWTDStyle.getFont(_swt_device, jscrib_font, font_scale, a_sfont);
                    this.dispose_font_ = a_sfont.isDisposable();
                    this.font_ = a_sfont.getFont();
                    this.font_style_ = jscrib_font.getStyle();
                    ++all;
                }
                if (this.fore_ == null && (jscrib_color = jscrib_style.getForeColor()) != null) {
                    a_scolor = SWTDStyle.getColor(_swt_device, jscrib_color, a_scolor);
                    this.dispose_fore_ = a_scolor.isDisposable();
                    this.fore_ = a_scolor.getColor();
                    ++all;
                }
                if (this.back_ == null && (jscrib_color = jscrib_style.getBackColor()) != null) {
                    a_scolor = SWTDStyle.getColor(_swt_device, jscrib_color, a_scolor);
                    this.dispose_back_ = a_scolor.isDisposable();
                    this.back_ = a_scolor.getColor();
                    ++all;
                }
                if (all == 3) {
                    return;
                }
            }
            item = item.getParent();
        }
        if (this.font_ == null) {
            this.font_ = SWTDStyle.getDefaultFont(_swt_device, font_scale);
            this.font_style_ = 0;
        }
        if (this.fore_ == null) {
            this.fore_ = SWTDStyle.getDefaultFore(_swt_device);
        }
        if (this.back_ == null) {
            this.back_ = SWTDStyle.getDefaultBack(_swt_device);
        }
    }

    public void styleOf(Device _swt_device, IDItem _item) {
        this.styleOf(_swt_device, _item, 1.0f);
    }

    public static SFont getFont(Device _swt_device, IDFont _jscrib_font, float _font_scale, SFont _sfont) {
        if (_sfont == null) {
            _sfont = new SFont();
        }
        if (_jscrib_font == null) {
            _sfont.setFont(SWTDStyle.getDefaultFont(_swt_device, _font_scale), false);
            return _sfont;
        }
        int swt_style = 0;
        if (_jscrib_font.haveStyle(1)) {
            swt_style |= 1;
        }
        if (_jscrib_font.haveStyle(2)) {
            swt_style |= 2;
        }
        String ffamily = _jscrib_font.getFamily();
        String fscript = _jscrib_font.getScript();
        int fsize = _jscrib_font.getSize();
        if (DrawUtil.isEmpty(ffamily)) {
            ffamily = "arial";
        }
        if (DrawUtil.isEmpty(fscript)) {
            fscript = ULocale.getDefault().toString();
        }
        if (_font_scale != 1.0f) {
            fsize = (int)((float)fsize * _font_scale);
        }
        if (fsize <= 5) {
            fsize = 6;
        }
        FontData font_data = new FontData(ffamily, fsize, swt_style);
        font_data.setLocale(fscript);
        Font font = new Font(_swt_device, font_data);
        _sfont.setFont(font, true);
        return _sfont;
    }

    public static SFont getFont(Device _swt_device, IDFont _jscrib_font, SFont _sfont) {
        return SWTDStyle.getFont(_swt_device, _jscrib_font, 1.0f, _sfont);
    }

    public static final SFont getFont(Device _swt_device, IDFont _jscrib_font) {
        return SWTDStyle.getFont(_swt_device, _jscrib_font, null);
    }

    public static int getColorComponent(int jscrib_color_component) {
        if (jscrib_color_component > 255) {
            return 255;
        }
        if (jscrib_color_component < 0) {
            return 0;
        }
        return jscrib_color_component;
    }

    public static SColor getColor(Device _swt_device, IDColor _jscrib_color, SColor _scolor) {
        if (_scolor == null) {
            _scolor = new SColor();
        }
        if (_jscrib_color == null) {
            _scolor.setColor(SWTDStyle.getDefaultFore(_swt_device), false);
            return _scolor;
        }
        int red = SWTDStyle.getColorComponent(_jscrib_color.getRed());
        int green = SWTDStyle.getColorComponent(_jscrib_color.getGreen());
        int blue = SWTDStyle.getColorComponent(_jscrib_color.getBlue());
        _scolor.setColor(new Color(_swt_device, red, green, blue), true);
        return _scolor;
    }

    public static SColor getColor(Device _swt_device, IDColor _jscrib_color) {
        return SWTDStyle.getColor(_swt_device, _jscrib_color, null);
    }

    public static SColor getForeColor(Device _swt_device, IDItem _item) {
        IDStyle jscrib_style = null;
        IDColor jscrib_color = null;
        IDItem item = _item;
        while (item != null) {
            jscrib_style = item.getStyle();
            if (jscrib_style != null && (jscrib_color = jscrib_style.getForeColor()) != null) {
                return SWTDStyle.getColor(_swt_device, jscrib_color, null);
            }
            item = item.getParent();
        }
        return new SColor(SWTDStyle.getDefaultFore(_swt_device), false);
    }

    public static SColor getBackColor(Device _swt_device, IDItem _item) {
        IDStyle jscrib_style = null;
        IDColor jscrib_color = null;
        IDItem item = _item;
        while (item != null) {
            jscrib_style = item.getStyle();
            if (jscrib_style != null && (jscrib_color = jscrib_style.getBackColor()) != null) {
                return SWTDStyle.getColor(_swt_device, jscrib_color, null);
            }
            item = item.getParent();
        }
        return new SColor(SWTDStyle.getDefaultBack(_swt_device), false);
    }

    public static SFont getFont(Device _swt_device, IDItem _item, float font_scale) {
        IDFont f = SWTDStyle.getFont(_item);
        if (f != null) {
            return SWTDStyle.getFont(_swt_device, f, font_scale, null);
        }
        return new SFont(SWTDStyle.getDefaultFont(_swt_device, font_scale), false);
    }

    public static SFont getFont(Device _swt_device, IDItem _item) {
        return SWTDStyle.getFont(_swt_device, _item, 1.0f);
    }

    public static IDFont getFont(IDItem _item) {
        IDStyle jscrib_style = null;
        IDFont jscrib_font = null;
        IDItem item = _item;
        while (item != null) {
            jscrib_style = item.getStyle();
            if (jscrib_style != null && (jscrib_font = jscrib_style.getFont()) != null) {
                return jscrib_font;
            }
            item = item.getParent();
        }
        return null;
    }

    public static class SColor {
        private Color color_;
        private boolean do_dispose_;

        public SColor(Color color, boolean do_dispose) {
            this.color_ = color;
            this.do_dispose_ = do_dispose;
        }

        public SColor() {
            this.do_dispose_ = false;
        }

        public Color getColor() {
            return this.color_;
        }

        public boolean isDisposable() {
            return this.do_dispose_;
        }

        public boolean isDisposed() {
            return this.color_ == null;
        }

        public void dispose() {
            if (this.color_ != null && this.do_dispose_) {
                this.color_.dispose();
            }
            this.color_ = null;
            this.do_dispose_ = false;
        }

        public void setColor(Color color, boolean do_dispose) {
            this.color_ = color;
            this.do_dispose_ = do_dispose;
        }
    }

    public static class SFont {
        private Font font_;
        private boolean do_dispose_;
        private static HashMap _defaultFont = new HashMap();

        public SFont(Font font, boolean do_dispose) {
            this.font_ = font;
            this.do_dispose_ = do_dispose;
        }

        public SFont() {
            this.do_dispose_ = false;
        }

        public Font getFont() {
            return this.font_;
        }

        public boolean isDisposable() {
            return this.do_dispose_;
        }

        public boolean isDisposed() {
            return this.font_ == null;
        }

        public void dispose() {
            if (this.font_ != null && this.do_dispose_) {
                this.font_.dispose();
            }
            this.font_ = null;
            this.do_dispose_ = false;
        }

        public void setFont(Font font, boolean do_dispose) {
            this.font_ = font;
            this.do_dispose_ = do_dispose;
        }
    }
}

