/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drivers.html;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.tptp.platform.report.drivers.internal.ConfSemanticException;
import org.eclipse.tptp.platform.report.drivers.internal.ConvertText;
import org.eclipse.tptp.platform.report.drivers.internal.HtmlFile;
import org.eclipse.tptp.platform.report.drivers.internal.HtmlValuators;
import org.eclipse.tptp.platform.report.drivers.internal.HtmlVariable;
import org.eclipse.tptp.platform.report.drivers.internal.Item;
import org.eclipse.xsd.util.XSDParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ConfParser {
    private boolean parsed;
    private HashMap tt_fonts = new HashMap();
    private HtmlFile html_file;
    private HtmlValuators variables = new HtmlValuators();
    private HashMap items = new HashMap();
    private ConvertText convert_text;
    private ConfParser parent;
    private boolean is_root_parser;
    private String conf_file_name;

    public ConfParser() {
        this.conf_file_name = "dhtml.xml";
        this.is_root_parser = true;
        this.initRootVariables();
    }

    public ConfParser(String file_name, ConfParser parent) {
        this.conf_file_name = file_name;
        this.is_root_parser = parent == null;
        this.parent = parent;
        if (this.is_root_parser) {
            this.initRootVariables();
        }
    }

    public void setParentConfParser(ConfParser p) {
        this.parent = p;
    }

    public ConfParser getParentConfParser() {
        return this.parent;
    }

    private InputSource getConfInputSource() {
        InputSource result;
        Class<ConfParser> clazz = ConfParser.class;
        try {
            result = new InputSource(clazz.getResourceAsStream(this.conf_file_name));
        }
        catch (Throwable throwable) {
            String error = "Cannot load " + this.conf_file_name + " file";
            throw new RuntimeException(error);
        }
        return result;
    }

    public boolean parse() {
        this.parsed = false;
        XSDParser parser = new XSDParser();
        try {
            parser.parse(this.getConfInputSource());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Document document = parser.getDocument();
        try {
            if (document == null) {
                throw new ConfSemanticException("no document read");
            }
            Element root = document.getDocumentElement();
            if (root == null || !"dhtml".equals(root.getNodeName())) {
                throw new ConfSemanticException("no 'dhtml' element in document");
            }
            this.checkTTFonts(root);
            if (this.is_root_parser) {
                this.html_file = this.checkFile(root);
            }
            this.checkItems(root);
            this.convert_text = this.checkConvertText(root);
        }
        catch (ConfSemanticException e) {
            System.err.println("[" + this.getConfInputSource() + "] " + e.getMsg());
            parser = null;
            return false;
        }
        this.parsed = true;
        return true;
    }

    private void checkTTFonts(Element root) throws ConfSemanticException {
        NodeList list = root.getElementsByTagName("tt_font");
        int i = 0;
        while (i < list.getLength()) {
            this.checkTTFont(list.item(i));
            ++i;
        }
    }

    private void checkTTFont(Node tt_font) throws ConfSemanticException {
        NamedNodeMap attrs = tt_font.getAttributes();
        if (attrs == null || attrs.getLength() != 2) {
            throw new ConfSemanticException("'old' and 'new' attributes allowed and mandatory for 'tt_font' tag");
        }
        Node old = attrs.getNamedItem("old");
        if (old == null) {
            throw new ConfSemanticException("no 'old' attribute declared for 'tt_font' tag");
        }
        Node new_ = attrs.getNamedItem("new");
        if (new_ == null) {
            throw new ConfSemanticException("no 'new' attribute declared for 'tt_font' tag");
        }
        this.tt_fonts.put(old.getNodeValue(), new_.getNodeValue());
    }

    public boolean isTTFont(String name) {
        if (this.tt_fonts.get(name) != null) {
            return true;
        }
        return this.parent != null && this.parent.isTTFont(name);
    }

    public boolean isDefinedVariable(String name) {
        if (this.variables.isDefinedVariable(name)) {
            return true;
        }
        return this.parent != null && this.parent.isDefinedVariable(name);
    }

    public String getVariableValue(String name) {
        if (this.variables.isDefinedVariable(name)) {
            return this.variables.getVariableValue(name);
        }
        if (this.parent != null) {
            return this.parent.getVariableValue(name);
        }
        return null;
    }

    public void setVariableValue(String name, String value, Object owner) {
        if (this.variables.isDefinedVariable(name)) {
            this.variables.setVariableValue(name, value, owner);
            return;
        }
        if (this.parent != null) {
            this.parent.setVariableValue(name, value, owner);
        }
    }

    public void unsetVariables(Object owner) {
        this.variables.unsetVariables(owner);
        if (this.parent != null) {
            this.parent.unsetVariables(owner);
        }
    }

    public void initVariable(String name) {
        this.variables.initVariable(name);
    }

    private HtmlVariable checkVar(Element var) throws ConfSemanticException {
        NamedNodeMap attrs = var.getAttributes();
        if (attrs == null || attrs.getLength() != 1) {
            throw new ConfSemanticException("only 'name' attribute allowed for 'var' tag");
        }
        Node name = attrs.getNamedItem("name");
        if (name == null) {
            throw new ConfSemanticException("no 'name' attribute declared for 'var' tag");
        }
        if (this.getVariableValue(name.getNodeValue()) == null) {
            throw new ConfSemanticException("unknown value " + name.getNodeValue() + " for 'name' attribute in 'var' tag\n" + this.getListOfVariables());
        }
        return new HtmlVariable(name.getNodeValue());
    }

    private String getListOfVariables() {
        String s = this.variables.getListOfVariables();
        if (this.parent != null) {
            s = String.valueOf(s) + this.parent.getListOfVariables();
        }
        return s;
    }

    private List checkHtmlFragment(Element parent, String tag_name, boolean mandatory) throws ConfSemanticException {
        NodeList tag = parent.getElementsByTagName(tag_name);
        if (tag == null || tag.getLength() == 0) {
            if (mandatory) {
                throw new ConfSemanticException("missing element '" + tag_name + "'");
            }
            return null;
        }
        if (tag.getLength() != 1) {
            throw new ConfSemanticException("only one '" + tag_name + "' element is allowed");
        }
        NodeList childs = tag.item(0).getChildNodes();
        LinkedList<Object> result = new LinkedList<Object>();
        StringBuffer buf = new StringBuffer(1024);
        int k = 0;
        while (k < childs.getLength()) {
            Node n = childs.item(k);
            if (n != null) {
                if (n.getNodeType() == 3 || n.getNodeType() == 4) {
                    buf.append(n.getNodeValue());
                } else if (n.getNodeType() == 1) {
                    if (!"var".equals(childs.item(k).getNodeName())) {
                        throw new ConfSemanticException("only 'var' tag is allowed in '" + tag_name + "' tag; found '" + childs.item(k).getNodeName() + "' tag");
                    }
                    if (buf.length() > 0) {
                        result.add(buf.toString());
                        buf = new StringBuffer(1024);
                    }
                    result.add(this.checkVar((Element)n));
                } else if (n.getNodeType() != 8) {
                    throw new ConfSemanticException("only 'var' tag is allowed in '" + tag_name + "' tag");
                }
            }
            ++k;
        }
        if (buf.length() > 0) {
            result.add(buf.toString());
        }
        return result;
    }

    private HtmlFile checkFile(Element root) throws ConfSemanticException {
        NodeList file = root.getElementsByTagName("file");
        if (file == null || file.getLength() == 0) {
            throw new ConfSemanticException("missgin element 'file'");
        }
        if (file.getLength() != 1) {
            throw new ConfSemanticException("only one 'file' tag allowed");
        }
        NamedNodeMap attrs = file.item(0).getAttributes();
        if (attrs == null || attrs.getLength() > 2) {
            throw new ConfSemanticException("'extension' and 'max_title_level' attributes needed and authorized for 'file' tag");
        }
        Node extension = attrs.getNamedItem("extension");
        if (extension == null) {
            throw new ConfSemanticException("no 'extension' attribute declared for 'file' tag");
        }
        Node max_title_level = attrs.getNamedItem("max_title_level");
        if (max_title_level == null) {
            throw new ConfSemanticException("no 'max_title_level' attribute declared for 'file' tag");
        }
        return new HtmlFile(extension.getNodeValue(), Integer.decode(max_title_level.getNodeValue()).shortValue(), this.checkHtmlFragment((Element)file.item(0), "begin", true), this.checkHtmlFragment((Element)file.item(0), "end", true));
    }

    public Item getItem(Class class_) {
        Item item = (Item)this.items.get(class_);
        if (item != null) {
            return item;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getItem(class_);
    }

    private void checkItem(Element elt) throws ConfSemanticException {
        Node class_;
        NamedNodeMap attrs = elt.getAttributes();
        Node node = class_ = attrs == null ? null : attrs.getNamedItem("class");
        if (class_ == null) {
            throw new ConfSemanticException("nmissing 'class' attribute in 'item' element");
        }
        Item item = new Item(class_.getNodeValue(), this.checkHtmlFragment(elt, "begin", true), this.checkHtmlFragment(elt, "end", true), this.checkHtmlFragment(elt, "begin_child", false), this.checkHtmlFragment(elt, "end_child", false));
        if (this.items.get(item.getItemClass()) != null) {
            throw new ConfSemanticException("item already defined for " + item.getItemClass() + " in 'item' tag");
        }
        this.items.put(item.getItemClass(), item);
        Node n = elt.getFirstChild();
        while (n != null) {
            Element e;
            if (n.getNodeType() != 1 || !"begin".equals((e = (Element)n).getNodeName()) && !"begin".equals(e.getNodeName()) && !"begin_child".equals(e.getNodeName()) && !"end_child".equals(e.getNodeName())) {
                this.checkItemChild(item, n);
            }
            n = n.getNextSibling();
        }
    }

    protected void checkItemChild(Item item, Node n) throws ConfSemanticException {
    }

    private void checkItems(Element root) throws ConfSemanticException {
        NodeList list = root.getElementsByTagName("item");
        if (list != null) {
            int i = 0;
            while (i < list.getLength()) {
                this.checkItem((Element)list.item(i));
                ++i;
            }
        }
    }

    private void checkReplace(ConvertText ct, Element elt) throws ConfSemanticException {
        NamedNodeMap attrs = elt.getAttributes();
        if (attrs == null || attrs.getLength() != 2) {
            throw new ConfSemanticException("'char' and 'string' attributes needed and authorized for 'replace' tag");
        }
        Node _char = attrs.getNamedItem("char");
        if (_char == null) {
            throw new ConfSemanticException("no 'char' attribute declared for 'replace' tag");
        }
        if (_char == null || _char.getNodeValue().length() != 1) {
            throw new ConfSemanticException("size of 'char' attribute declared for 'replace' tag must be 1, found \"" + _char.getNodeValue() + "\"");
        }
        Character c_char = new Character(_char.getNodeValue().charAt(0));
        Node string = attrs.getNamedItem("string");
        if (string == null) {
            throw new ConfSemanticException("no 'string' attribute declared for 'replace' tag");
        }
        ct.putReplace(c_char, string.getNodeValue());
    }

    private void checkReplaces(ConvertText ct, Element elt) throws ConfSemanticException {
        NodeList list = elt.getElementsByTagName("replace");
        if (list != null) {
            int i = 0;
            while (i < list.getLength()) {
                this.checkReplace(ct, (Element)list.item(i));
                ++i;
            }
        }
    }

    private ConvertText checkConvertText(Element root) throws ConfSemanticException {
        NodeList ct = root.getElementsByTagName("convert_text");
        if (ct == null || ct.getLength() == 0) {
            return null;
        }
        if (ct.getLength() != 1) {
            throw new ConfSemanticException("only one 'convert_text' tag allowed");
        }
        NamedNodeMap attrs = ct.item(0).getAttributes();
        if (attrs == null || attrs.getLength() > 2) {
            throw new ConfSemanticException("'first_space' and 'extra_space' attributes needed and authorized for 'convert_text' tag");
        }
        Node first_space = attrs.getNamedItem("first_space");
        if (first_space == null) {
            throw new ConfSemanticException("no 'first_space' attribute declared for 'convert_text' tag");
        }
        Node extra_space = attrs.getNamedItem("extra_space");
        if (extra_space == null) {
            throw new ConfSemanticException("no 'extra_space' attribute declared for 'convert_text' tag");
        }
        ConvertText result = new ConvertText(first_space.getNodeValue(), extra_space.getNodeValue());
        this.checkReplaces(result, (Element)ct.item(0));
        return result;
    }

    public static void dump(String indent, String name, String value) {
        System.out.println(String.valueOf(indent) + name + "=\"" + value + "\"");
    }

    public static void dump(String indent, String name, int value) {
        System.out.println(String.valueOf(indent) + name + "=" + value);
    }

    public static void dump(String indent, String name, List list) {
        System.out.println(String.valueOf(indent) + name + "=" + list);
    }

    public HtmlFile getHtmlFile() {
        return this.parent == null ? this.html_file : this.parent.getHtmlFile();
    }

    public ConvertText getConvertText() {
        return this.convert_text;
    }

    public void dump() {
        if (!this.parsed) {
            System.err.println("<no parser: error detected during analysis or parse() not called yet>");
            return;
        }
        this.getHtmlFile().dump();
        Set entries = this.items.entrySet();
        Object[] entries_tables = entries.toArray();
        int i = 0;
        while (i < entries.size()) {
            Map.Entry entry = (Map.Entry)entries_tables[i];
            Item item = (Item)entry.getValue();
            item.dump();
            ++i;
        }
        this.convert_text.dump();
    }

    private void initRootVariables() {
        this.variables.initVariable("CONSTANT");
        this.variables.initVariable("DOCUMENT_TAG");
        this.variables.initVariable("DOCUMENT_TITLE");
        this.variables.initVariable("SECTION_TAG");
        this.variables.initVariable("PARAGRAPH_ALIGN");
        this.variables.initVariable("TITLE_TAG");
        this.variables.initVariable("TITLE_LEVEL");
        this.variables.initVariable("TITLE_NUMBER");
        this.variables.initVariable("TITLE_FULL_NUMBER");
        this.variables.initVariable("IMAGE_NAME");
        this.variables.initVariable("LIST_TYPE");
        this.variables.initVariable("LINK_TARGET");
        this.variables.initVariable("LINK_ACTION");
        this.variables.initVariable("LINK_TARGET_DOCUMENT");
        this.variables.initVariable("LINK_TARGET_SECTION");
        this.variables.initVariable("LINK_TARGET_TAG");
        this.variables.initVariable("POPUP_LINK_METHOD");
        this.variables.initVariable("TAG_NAME");
        this.variables.initVariable("TABLE_WIDTH");
        this.variables.initVariable("TABLE_BORDER");
        this.variables.initVariable("TABLE_COLUMNS");
        this.variables.initVariable("TABLE_ROWS");
        this.variables.initVariable("ROW_CELLS");
        this.variables.initVariable("CELL_COLSPAN");
        this.variables.initVariable("CELL_ROWSPAN");
        this.variables.initVariable("CELL_COL");
        this.variables.initVariable("CELL_ROW");
        this.variables.initVariable("CELL_WIDTH");
        this.variables.initVariable("CELL_ALIGN");
        this.variables.initVariable("CELL_VALIGN");
        this.variables.initVariable("POPUP_TAG");
        this.variables.initVariable("INDEX_OF");
        this.variables.initVariable("INDEX_TYPE");
        this.variables.initVariable("INDEX_ENTRY_TYPE");
        this.variables.initVariable("INDEX_ENTRY_NUMBER");
        this.variables.initVariable("SUMMARY_ENTRY_TEXT");
        this.variables.initVariable("GRAPHIC_TITLE");
        this.variables.initVariable("GRAPHIC_WIDTH");
        this.variables.initVariable("GRAPHIC_HEIGHT");
        this.variables.initVariable("HTML_FILE_NAME");
        this.variables.initVariable("HTML_TITLE_LEVEL");
        this.variables.initVariable("HTML_LIST_TYPE");
        this.variables.initVariable("HTML_LINK");
        this.variables.initVariable("HTML_LINE_SIZE");
        this.variables.initVariable("HTML_TABLE_WIDTH");
        this.variables.initVariable("HTML_CELL_COLSPAN");
        this.variables.initVariable("HTML_CELL_ROWSPAN");
        this.variables.initVariable("HTML_CELL_WIDTH");
        this.variables.initVariable("HTML_BACK_COLOR");
        this.variables.initVariable("HTML_FORE_COLOR");
        this.variables.initVariable("HTML_BGCOLOR");
        this.variables.initVariable("HTML_COLOR");
        this.variables.initVariable("HTML_GRAPHIC_WIDTH");
        this.variables.initVariable("HTML_GRAPHIC_HEIGHT");
        this.variables.initVariable("HTML_GRAPHIC_FILE_NAME");
        this.variables.initVariable("HTML_GRAPHIC_APPLET_JAR_PREFIX");
        this.variables.initVariable("HTML_PNG_FILE_NAME");
        this.variables.initVariable("HTML_FONT_ATTRS_BEGIN");
        this.variables.initVariable("HTML_FONT_ATTRS_END");
    }
}

