/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drivers.html;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.tptp.platform.report.chart.internal.ChartEncoderOutputStream;
import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRenderData;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DI18N;
import org.eclipse.tptp.platform.report.drivers.html.ConfParser;
import org.eclipse.tptp.platform.report.drivers.html.DHtmlWriter;
import org.eclipse.tptp.platform.report.drivers.html.DHtmlWriterException;
import org.eclipse.tptp.platform.report.drivers.internal.ConfSemanticException;
import org.eclipse.tptp.platform.report.drivers.internal.Item;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlWriter;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DHtmlGraphicApplet {
    private static final String jarfilename = "jsgraphicapplet.jar";
    private static final int F_DIRECT = 0;
    private static final int F_BEST = 1;
    private static final int F_ZIP = 2;
    private static final int C_NEVER = 0;
    private static final int C_AUTO = 1;
    private static final int C_ALWAYS = 2;
    private DHtmlWriter driver;
    private ConfParser confparser;
    private int format_ = 1;
    private int copy_jar_file_ = 1;
    private int encode_ = 1;
    private static byte[] escape_double_quote_ = new byte[]{38, 35, 51, 52, 59};
    private static byte[] escape_ampersand_ = new byte[]{38, 35, 51, 56, 59};
    private boolean initialized;

    private void graphicDump(Item item, DGraphic graphic, int w, int h, float scale) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(16384);
        DXmlWriter jsml = new DXmlWriter();
        try {
            jsml.write((OutputStream)bos, graphic);
            String nozip = null;
            if (this.format_ != 2) {
                byte[] data = bos.toByteArray();
                int quote = 0;
                int len = data.length;
                int i = 0;
                while (i < len) {
                    if (data[i] == 34 || data[i] == 38) {
                        ++quote;
                    }
                    ++i;
                }
                if (quote == 0) {
                    nozip = new String(data);
                } else {
                    byte[] cnv = new byte[len - quote + quote * 5];
                    int k = 0;
                    int i2 = 0;
                    while (i2 < len) {
                        if (data[i2] == 34) {
                            cnv[k++] = 38;
                            cnv[k++] = 35;
                            cnv[k++] = 51;
                            cnv[k++] = 52;
                            cnv[k++] = 59;
                        } else if (data[i2] == 38) {
                            cnv[k++] = 38;
                            cnv[k++] = 35;
                            cnv[k++] = 51;
                            cnv[k++] = 56;
                            cnv[k++] = 59;
                        } else {
                            cnv[k++] = data[i2];
                        }
                        ++i2;
                    }
                    nozip = new String(cnv);
                }
            }
            String zip = null;
            if (this.format_ != 0) {
                ByteArrayOutputStream zbos = new ByteArrayOutputStream(2048);
                ZipOutputStream zos = new ZipOutputStream(zbos);
                zos.putNextEntry(new ZipEntry("jsml"));
                zos.write(bos.toByteArray());
                zos.closeEntry();
                zos.close();
                ByteArrayOutputStream cbos = new ByteArrayOutputStream(zbos.size());
                ChartEncoderOutputStream cos = new ChartEncoderOutputStream(cbos, this.encode_);
                cos.write(zbos.toByteArray());
                zip = cbos.toString("UTF-8");
            }
            switch (this.format_) {
                case 1: {
                    if (nozip.length() <= zip.length()) {
                        this.confparser.setVariableValue("HTML_APPLET_PARAM_NAME", "jsml", item);
                        this.confparser.setVariableValue("HTML_APPLET_PARAM_VALUE", nozip, item);
                        break;
                    }
                    this.confparser.setVariableValue("HTML_APPLET_PARAM_NAME", "jsml-zip", item);
                    this.confparser.setVariableValue("HTML_APPLET_PARAM_VALUE", zip, item);
                    break;
                }
                case 2: {
                    this.confparser.setVariableValue("HTML_APPLET_PARAM_NAME", "jsml-zip", item);
                    this.confparser.setVariableValue("HTML_APPLET_PARAM_VALUE", zip, item);
                    break;
                }
                case 0: {
                    this.confparser.setVariableValue("HTML_APPLET_PARAM_NAME", "jsml", item);
                    this.confparser.setVariableValue("HTML_APPLET_PARAM_VALUE", nozip, item);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ConfParser getConfParser() {
        return this.confparser;
    }

    private void initConfParser(ConfParser parent) {
        if (this.initialized) {
            this.confparser.setParentConfParser(parent);
            return;
        }
        this.confparser = new ConfParser("dhtmlgraphicapplet.xml", parent){

            protected void checkItemChild(Item item, Node n) throws ConfSemanticException {
                if (n.getNodeType() == 1 && "property".equals(n.getNodeName())) {
                    Element e = (Element)n;
                    String name = e.getAttribute("name");
                    String value = e.getAttribute("value");
                    if (name == null) {
                        throw new ConfSemanticException("missing 'name' attribute in 'property' element");
                    }
                    if ("data".equals(name)) {
                        this.checkPropertyData(value);
                    } else if ("copyjarfile".equals(name)) {
                        this.checkPropertyCopyJarFile(value);
                    } else if ("encode".equals(name)) {
                        this.checkPropertyEncode(value);
                    }
                }
            }

            private void checkPropertyData(String value) throws ConfSemanticException {
                if (value == null || "best".equals(value)) {
                    DHtmlGraphicApplet.this.format_ = 1;
                } else if ("zip".equals(value)) {
                    DHtmlGraphicApplet.this.format_ = 2;
                } else if ("direct".equals(value)) {
                    DHtmlGraphicApplet.this.format_ = 0;
                } else {
                    throw new ConfSemanticException("Unknown '" + value + "' value for 'data' property");
                }
            }

            private void checkPropertyCopyJarFile(String value) throws ConfSemanticException {
                if (value == null || "auto".equals(value)) {
                    DHtmlGraphicApplet.this.copy_jar_file_ = 1;
                } else if ("always".equals(value)) {
                    DHtmlGraphicApplet.this.copy_jar_file_ = 2;
                } else if ("never".equals(value)) {
                    DHtmlGraphicApplet.this.copy_jar_file_ = 0;
                } else {
                    throw new ConfSemanticException("Unknown '" + value + "' value for 'copyjarfile' property");
                }
            }

            private void checkPropertyEncode(String value) throws ConfSemanticException {
                if (value == null || "default".equals(value)) {
                    DHtmlGraphicApplet.this.encode_ = 0;
                } else if ("forjavascript".equals(value)) {
                    DHtmlGraphicApplet.this.encode_ = 1;
                } else if ("all".equals(value)) {
                    DHtmlGraphicApplet.this.encode_ = 3;
                } else {
                    throw new ConfSemanticException("Unknown '" + value + "' value for 'encode' property");
                }
            }
        };
        this.confparser.initVariable("HTML_APPLET_PARAM_NAME");
        this.confparser.initVariable("HTML_APPLET_PARAM_VALUE");
        if (!this.confparser.parse()) {
            System.err.println("Graphic Applet Html Configuration parsing failed");
            this.confparser = null;
            this.initialized = false;
            return;
        }
        this.initialized = true;
    }

    public void doMethod(DGraphic item, DExtensible ext, Object arg) throws DHtmlWriterException {
        this.driver = (DHtmlWriter)ext;
        ConfParser parent_parser = this.driver.getConfparser();
        this.initConfParser(parent_parser);
        if (this.confparser == null) {
            return;
        }
        this.driver.setConfparser(this.confparser);
        Item hitem = this.driver.getItem(item);
        this.driver.updateStyleVariables(item);
        int width = (int)(500.0f * item.getWidthScale());
        int height = (int)(500.0f * item.getHeightScale());
        String title = DefaultChartRenderData.getResourceString(item.getTitle(), (DI18N)item.getChildOfClass(DI18N.class));
        this.confparser.setVariableValue("GRAPHIC_TITLE", title, item);
        this.confparser.setVariableValue("GRAPHIC_WIDTH", Float.toString(item.getWidthScale()), item);
        this.confparser.setVariableValue("GRAPHIC_HEIGHT", Float.toString(item.getHeightScale()), item);
        this.confparser.setVariableValue("HTML_GRAPHIC_WIDTH", Integer.toString(width), item);
        this.confparser.setVariableValue("HTML_GRAPHIC_HEIGHT", Integer.toString(height), item);
        try {
            this.graphicDump(hitem, item, width, height, 1.0f);
            this.driver.htmlDump(hitem.getBegin());
            this.driver.htmlDump(hitem.getEnd());
            this.confparser.unsetVariables(item);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.confparser.setParentConfParser(null);
        this.driver.setConfparser(parent_parser);
        if (this.driver.getGenerationPolicy() == null) {
            return;
        }
        this.checkForAppletJarFile(this.driver.getGenerationPolicy().getBaseDirectoryPath());
    }

    private void checkForAppletJarFile(String dirname) {
        FileOutputStream fos;
        if (dirname == null) {
            return;
        }
        if (this.copy_jar_file_ == 0) {
            return;
        }
        String destname = String.valueOf(dirname) + File.separator + jarfilename;
        URL url = this.getClass().getResource(jarfilename);
        if (url == null) {
            System.err.println("Warning: JScrib graphic applet jar file missed: jsgraphicapplet.jar, can't copy jar file to HTML output directory.");
            return;
        }
        if (this.copy_jar_file_ == 1) {
            File src = new File(url.getFile());
            File dest = new File(destname);
            if (dest.exists() && src.length() == dest.length() && src.lastModified() <= dest.lastModified()) {
                return;
            }
        }
        int SIZE = 10000;
        InputStream is = this.getClass().getResourceAsStream(jarfilename);
        if (is == null) {
            System.err.println("Internal Error: JScrib graphic applet jar file missed: jsgraphicapplet.jar");
            return;
        }
        BufferedInputStream bis = new BufferedInputStream(is, SIZE);
        try {
            fos = new FileOutputStream(destname);
        }
        catch (FileNotFoundException e) {
            System.err.println("Can't write file:" + destname);
            System.err.println("Reason: " + e.getMessage());
            return;
        }
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        byte[] buf = new byte[SIZE];
        try {
            int len;
            while ((len = bis.read(buf)) >= 0) {
                bos.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            System.err.println("Error: can't copy graphic applet jar file to " + dirname);
            System.err.println("Reason: " + e.getMessage());
            File f = new File(destname);
            if (!f.delete()) {
                System.err.println("Can't remove file: " + destname);
            }
            return;
        }
    }
}

