/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drivers.xml.internal;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.tptp.platform.report.ReportCorePlugin;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DCategory;
import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DColorRegistry;
import org.eclipse.tptp.platform.report.core.internal.DCoord;
import org.eclipse.tptp.platform.report.core.internal.DCoordObject;
import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DDocument;
import org.eclipse.tptp.platform.report.core.internal.DFontRegistry;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DMarkerLine;
import org.eclipse.tptp.platform.report.core.internal.DMarkerRegion;
import org.eclipse.tptp.platform.report.core.internal.DPalettes;
import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.DStyle;
import org.eclipse.tptp.platform.report.core.internal.DStyleRegistry;
import org.eclipse.tptp.platform.report.core.internal.IDColor;
import org.eclipse.tptp.platform.report.core.internal.IDCoord;
import org.eclipse.tptp.platform.report.core.internal.IDFont;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDObject;
import org.eclipse.tptp.platform.report.core.internal.IDStringSerializable;
import org.eclipse.tptp.platform.report.core.internal.IDStyle;
import org.eclipse.tptp.platform.report.core.internal.IDocumentReader;
import org.eclipse.tptp.platform.report.drivers.internal.IReader;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlError;
import org.eclipse.tptp.platform.report.drivers.xml.internal.IDXmlSerializable;
import org.eclipse.tptp.platform.report.drivers.xml.internal.IXmlParser;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;
import org.eclipse.tptp.platform.report.extension.internal.DExtensionRegistry;
import org.eclipse.tptp.platform.report.extension.internal.IDExtension;
import org.eclipse.tptp.platform.report.tools.internal.CalendarField;
import org.eclipse.tptp.platform.report.tools.internal.DAlignmentPair;
import org.eclipse.tptp.platform.report.tools.internal.DParser;
import org.eclipse.xsd.XSDDiagnostic;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DXmlDocumentReader
extends DParser
implements IReader,
IDocumentReader {
    private DStyleRegistry styles;
    private DColorRegistry colors;
    private DFontRegistry fonts;
    private IDObject[] roots;
    private HashMap fontsId;
    private HashMap colorsId;
    private HashMap stylesId;
    private HashMap axis;
    private IXmlParser parser_;
    private static String[] filter_for_DGraphic = new String[]{"legend", "chartTitle", "plotArea"};
    private static String[] filter_for_plotArea = new String[]{"axes", "datasets"};
    private static String[] filter_for_DAxis = new String[]{"categories", "majorUnit", "minorUnit", "labelFormat"};
    private HashMap folder_model_read_ = new HashMap();

    public DXmlDocumentReader(IXmlParser parser) {
        this.parser_ = parser;
        this.fontsId = new HashMap();
        this.colorsId = new HashMap();
        this.stylesId = new HashMap();
        this.axis = new HashMap();
        DExtensionRegistry.sgn_addExtension.connect(this, "updateExtension(org.eclipse.tptp.platform.report.extension.internal.IDExtension, Class)");
        DExtensionRegistry.sgn_removeExtension.connect(this, "updateExtension(org.eclipse.tptp.platform.report.extension.internal.IDExtension, Class)");
    }

    private IDColor getColor(String val, String nodeName) {
        DColor color = null;
        if (val.charAt(0) != '#' && val.length() < 7) {
            throw new DXmlError("Bad syntax color (" + val + ") while parsing '" + nodeName + "' tag");
        }
        color = (DColor)this.colorsId.get(val);
        if (color == null) {
            color = new DColor();
            color.serializeFromString(val);
            if (this.colors == null) {
                this.colors = new DColorRegistry();
            }
            this.colors.putColor(color);
            this.colorsId.put(val, color);
        }
        return color;
    }

    private Object getCoordValue(String text, Class c, Node node) {
        if (c == null) {
            try {
                return new Double(text);
            }
            catch (NumberFormatException numberFormatException) {
                return text;
            }
        }
        if (c == Date.class) {
            try {
                return SimpleDateFormat.getInstance().parse(text);
            }
            catch (ParseException parseException) {
                throw new DXmlError("Bad formatted Date expected value in the node '" + node.getNodeName() + "'");
            }
        }
        if (c == Double.class) {
            try {
                return new Double(text);
            }
            catch (NumberFormatException numberFormatException) {
                throw new DXmlError("Bad formatted Double expected value in the node '" + node.getNodeName() + "'");
            }
        }
        if (c == String.class) {
            return text;
        }
        throw new DXmlError("Bad formatted coodinate value for the node '" + node.getNodeName() + "'");
    }

    private Object getRangeValue(String text, Class c, Node node) {
        if (c == null) {
            try {
                return new Double(text);
            }
            catch (NumberFormatException numberFormatException) {
                return text;
            }
        }
        if (c == Date.class) {
            CalendarField cf = new CalendarField();
            cf.serializeFromString(text);
            return cf;
        }
        if (c == Double.class) {
            try {
                return new Double(text);
            }
            catch (NumberFormatException numberFormatException) {
                throw new DXmlError("Bad formatted Double expected value in the node '" + node.getNodeName() + "'");
            }
        }
        if (c == String.class) {
            return text;
        }
        throw new DXmlError("Bad formatted coodinate value for the node '" + node.getNodeName() + "'");
    }

    public DColorRegistry getColorRegistry() {
        return this.colors;
    }

    public DFontRegistry getFontRegistry() {
        return this.fonts;
    }

    public DStyleRegistry getStyleRegistry() {
        return this.styles;
    }

    public void setColorRegistry(DColorRegistry r) {
        this.colors = r;
    }

    public void setFontRegistry(DFontRegistry r) {
        this.fonts = r;
    }

    public void setStyleRegistry(DStyleRegistry r) {
        this.styles = r;
    }

    public void clear() {
        this.fontsId.clear();
        this.colorsId.clear();
        this.stylesId.clear();
        this.axis.clear();
        this.folder_model_read_ = null;
    }

    public IDObject[] read(InputStream in) {
        return this.read(new InputSource(in));
    }

    public Document readDOM(InputStream in) {
        return this.readDOM(new InputSource(in));
    }

    public Document readDOM(InputSource is) {
        this.clear();
        this.parser_.parse(is);
        Document dom_doc = this.parser_.getDocument();
        Collection diagnostics = this.parser_.getDiagnostics();
        if (diagnostics.size() > 0) {
            Iterator iter = diagnostics.iterator();
            StringBuffer sb = new StringBuffer("Validation Error:\n");
            while (iter.hasNext()) {
                XSDDiagnostic diagnostic = (XSDDiagnostic)iter.next();
                sb.append(String.valueOf(diagnostic.getMessage()) + "\n");
            }
            throw new DXmlError(sb.toString());
        }
        if (dom_doc == null) {
            throw new DXmlError(ReportCorePlugin.translate("BAD_XML_FORMAT"));
        }
        return dom_doc;
    }

    public IDObject[] read(InputSource is) {
        this.clear();
        this.parser_.parse(is);
        Document dom_doc = this.parser_.getDocument();
        Collection diagnostics = this.parser_.getDiagnostics();
        if (diagnostics.size() > 0) {
            Iterator iter = diagnostics.iterator();
            StringBuffer sb = new StringBuffer("Validation Error:\n");
            while (iter.hasNext()) {
                XSDDiagnostic diagnostic = (XSDDiagnostic)iter.next();
                sb.append(String.valueOf(diagnostic.getMessage()) + "\n");
            }
            throw new DXmlError(sb.toString());
        }
        if (dom_doc == null) {
            throw new DXmlError(ReportCorePlugin.translate("BAD_XML_FORMAT"));
        }
        return this.read(dom_doc);
    }

    public IDObject[] read(Document in) {
        Element root = in.getDocumentElement();
        ArrayList<DDocument> docs = new ArrayList<DDocument>();
        root.getChildNodes();
        Arg arg = new Arg(null, null);
        if (!"chart".equals(root.getNodeName())) {
            throw new DXmlError("'chart' element is expected as root element");
        }
        DDocument doc = new DDocument();
        DGraphic gph = new DGraphic();
        doc.addChild(gph);
        arg.node = root;
        this.invokeDoMethod(gph, this, arg);
        docs.add(doc);
        if (docs.size() == 0) {
            return null;
        }
        this.roots = new IDObject[docs.size()];
        int i = 0;
        while (i < docs.size()) {
            this.roots[i] = (IDObject)docs.get(i);
            ++i;
        }
        return this.roots;
    }

    public static String decode(String s) {
        if (s == null) {
            return s;
        }
        s = s.replaceAll("&apos;", "'");
        s = s.replaceAll("&lt;", "<");
        s = s.replaceAll("&gt;", ">");
        s = s.replaceAll("&quot;", "\"");
        s = s.replaceAll("&amp;", "&");
        return s;
    }

    protected Node getRequiredAttribut(NamedNodeMap attr, String attr_tag, String elt_tag) {
        Node n = attr.getNamedItem(attr_tag);
        if (n == null) {
            throw new DXmlError("The required '" + attr_tag + "' attribute is not defined in the " + elt_tag + " element");
        }
        return n;
    }

    public static String getNodeText(Node node) {
        String s = "";
        Node child = node.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 3) {
                String sc = child.getNodeValue();
                s = String.valueOf(s) + DXmlDocumentReader.decode(sc);
            }
            child = child.getNextSibling();
        }
        return s;
    }

    protected IDItem createIDItemForNode(Node node) {
        String name = node.getNodeName();
        if (name == null) {
            return null;
        }
        switch (name.length()) {
            case 4: {
                if (!"axis".equals(name)) break;
                return new DAxis("unnamed");
            }
            case 5: {
                if ("coord".equals(name)) {
                    String CoordNodeName;
                    NamedNodeMap attr = node.getAttributes();
                    Node n = this.getRequiredAttribut(attr, "value", CoordNodeName = node.getNodeName());
                    Object c = this.getCoordValue(n.getNodeValue(), null, n);
                    if (c instanceof Double) {
                        return new DCoord(null, (Double)c);
                    }
                    return new DCoordObject(null, c);
                }
                if ("point".equals(name)) {
                    return new DPoint();
                }
                if (!"chart".equals(name)) break;
                return new DGraphic();
            }
            case 7: {
                if (!"dataset".equals(name)) break;
                return new DCurve();
            }
            case 8: {
                if ("category".equals(name)) {
                    return new DCategory();
                }
                if (!"palettes".equals(name)) break;
                return new DPalettes();
            }
            case 10: {
                if (!"markerLine".equals(name)) break;
                return new DMarkerLine();
            }
            default: {
                if (!"markerRegion".equals(name)) break;
                return new DMarkerRegion();
            }
        }
        throw new DXmlError(String.valueOf(name) + " is unknown node.");
    }

    protected IDItem createFromClass(String class_name) {
        try {
            Class<?> clazz = Class.forName(class_name);
            Object inst = clazz.newInstance();
            return (IDItem)inst;
        }
        catch (Exception e) {
            if (e instanceof InstantiationException) {
                System.out.println("Can't instanciate class '" + class_name + "',  haven't a public empty constructor ?");
                return null;
            }
            if (e instanceof ClassNotFoundException) {
                System.out.println("Can't found class = " + class_name);
            }
            return null;
        }
    }

    public void doChildrenItem(IDItem parent, DExtensible ext, Object a_arg) {
        Arg arg = (Arg)a_arg;
        Node n = arg.node;
        if (!n.hasChildNodes()) {
            return;
        }
        Node e = null;
        if (n.getNodeType() == 3) {
            return;
        }
        if (n.getNodeType() == 1) {
            e = (Element)n;
        }
        NodeList list = e.getChildNodes();
        IDItem previous = null;
        int i = 0;
        while (i < list.getLength()) {
            IDItem child = null;
            Node node = list.item(i);
            if (node.getNodeType() == 1 && !arg.filterChildren(node.getNodeName()) && (child = this.createIDItemForNode(node)) != null) {
                this.invokeDoMethod(child, this, new Arg(node, parent));
                if (parent == child) {
                    throw new DXmlError("Parent = " + parent.getClass());
                }
                if (parent != null) {
                    parent.insertChild(child, previous);
                    previous = child;
                }
            }
            ++i;
        }
    }

    public void doMethod(DGraphic graph, DExtensible ext, Object the_arg) {
        Arg arg = (Arg)the_arg;
        NamedNodeMap attr = arg.node.getAttributes();
        Node n = attr.getNamedItem("backgroundColor");
        if (n != null) {
            DStyle s = new DStyle();
            DColor c = new DColor();
            c.serializeFromString(n.getNodeValue());
            s.setBackColor(c);
            graph.setStyle(s);
        }
        if ((n = attr.getNamedItem("width")) != null) {
            graph.getProperties().store("P_MAX_WIDTH.DGraphic.core.jscrib", Float.parseFloat(n.getNodeValue()));
        }
        if ((n = attr.getNamedItem("minWidth")) != null) {
            graph.getProperties().store("P_MIN_WIDTH.DGraphic.core.jscrib", Float.parseFloat(n.getNodeValue()));
        }
        if ((n = attr.getNamedItem("height")) != null) {
            graph.getProperties().store("P_MAX_HEIGHT.DGraphic.core.jscrib", Float.parseFloat(n.getNodeValue()));
        }
        if ((n = attr.getNamedItem("minHeight")) != null) {
            graph.getProperties().store("P_MIN_HEIGHT.DGraphic.core.jscrib", Float.parseFloat(n.getNodeValue()));
        }
        if ((n = attr.getNamedItem("backgroundColor")) != null) {
            graph.getProperties().store("P_BACKCOLOR.DGraphic.core.jscrib", this.getColor(n.getNodeValue(), "chart"));
        }
        this.axis.clear();
        Node c = arg.node.getFirstChild();
        while (c != null) {
            if ("legend".equals(c.getNodeName())) {
                this.parseLegend(graph, ext, new Arg(c, graph));
            } else if ("chartTitle".equals(c.getNodeName())) {
                this.parseChartTitle(graph, ext, new Arg(c, graph));
            } else if ("plotArea".equals(c.getNodeName())) {
                this.parsePlotArea(graph, ext, new Arg(c, graph));
            }
            c = c.getNextSibling();
        }
        String[] save = arg.filter_children;
        arg.filter_children = filter_for_DGraphic;
        this.doChildrenItem(graph, ext, arg);
        arg.filter_children = save;
        this.axis.clear();
    }

    protected void parseLegend(DGraphic g, DExtensible ext, Object the_arg) {
        Arg arg = (Arg)the_arg;
        NamedNodeMap attr = arg.node.getAttributes();
        Node n = attr.getNamedItem("sizingFactor");
        if (n != null) {
            g.getProperties().store("P_LEGEND_LIMIT.DGraphic.core.jscrib", Integer.valueOf(n.getNodeValue()));
        }
        if ((n = attr.getNamedItem("show")) != null) {
            g.getProperties().store("P_SHOW_LEGEND.DGraphic.core.jscrib", Boolean.valueOf(n.getNodeValue()));
        }
        DAlignmentPair p = new DAlignmentPair();
        n = attr.getNamedItem("alignment");
        if (n != null) {
            Node old = arg.node;
            arg.node = n;
            this.invokeDoMethod(p, ext, arg);
            if (p.getAlignment() == 8 || p.getAlignment() == 16) {
                p.setSecondaryAlignment(2);
            } else {
                p.setSecondaryAlignment(8);
            }
            arg.node = old;
        } else {
            p.setAlignment(2);
            p.setSecondaryAlignment(8);
        }
        g.getProperties().store("P_LEGEND_LAYOUT.DGraphic.core.jscrib", p);
    }

    public void doMethod(DCategory cat, DExtensible ext, Object arg) {
        NamedNodeMap attr = ((Arg)arg).node.getAttributes();
        Node n = this.getRequiredAttribut(attr, "id", "category");
        if (n != null) {
            cat.setId(n.getNodeValue());
        }
        if ((n = attr.getNamedItem("label")) != null) {
            cat.setLabel(n.getNodeValue());
        }
        this.doChildrenItem(cat, ext, arg);
    }

    protected void parseChartTitle(DGraphic g, DExtensible ext, Object the_arg) {
        Arg arg = (Arg)the_arg;
        NamedNodeMap attr = arg.node.getAttributes();
        Node n = attr.getNamedItem("show");
        if (n != null) {
            g.getProperties().store("P_SHOW_TITLED.DGraphic.core.jscrib", Boolean.valueOf(n.getNodeValue()));
        }
        g.setTitle(this.getRequiredAttribut(attr, "label", "chartTitle").getNodeValue());
        DAlignmentPair p = new DAlignmentPair();
        p.setAlignment(8);
        p.setSecondaryAlignment(1);
        g.getProperties().store("P_TITLE_LAYOUT.DGraphic.core.jscrib", p);
    }

    protected void parsePlotArea(DGraphic g, DExtensible ext, Object the_arg) {
        Arg arg = (Arg)the_arg;
        NamedNodeMap attr = arg.node.getAttributes();
        String ctype = this.getRequiredAttribut(attr, "type", "plotArea").getNodeValue();
        g.setGraphicType(ctype);
        Node n = attr.getNamedItem("backgroundColor");
        if (n != null) {
            g.getProperties().store("P_PLOTAREA_BACKCOLOR.DGraphic.core.jscrib", this.getColor(n.getNodeValue(), "plotArea"));
        }
        if ((n = attr.getNamedItem("showPercentage")) != null) {
            g.getProperties().store("P_SHOW_PERCENTAGE.DGraphic.core.jscrib", Boolean.valueOf(n.getNodeValue()));
        }
        if ((n = attr.getNamedItem("showValues")) != null) {
            g.getProperties().store("P_SHOW_VALUES.DGraphic.core.jscrib", Boolean.valueOf(n.getNodeValue()));
        }
        if ((n = attr.getNamedItem("margin")) != null) {
            g.getProperties().store("P_MARGIN.DGraphic.core.jscrib", Integer.parseInt(n.getNodeValue()));
        }
        Node c = arg.node.getFirstChild();
        while (c != null) {
            if ("axes".equals(c.getNodeName())) {
                this.parseAxes(g, ext, new Arg(c, g));
            }
            c = c.getNextSibling();
        }
        c = arg.node.getFirstChild();
        while (c != null) {
            if ("datasets".equals(c.getNodeName())) {
                this.parseCurves(g, ext, new Arg(c, g));
            }
            c = c.getNextSibling();
        }
        String[] save = arg.filter_children;
        arg.filter_children = filter_for_plotArea;
        this.doChildrenItem(g, ext, arg);
        arg.filter_children = save;
    }

    protected void parseCurves(DGraphic graph, DExtensible ext, Object the_arg) {
        this.doChildrenItem(graph, ext, the_arg);
    }

    protected void parseAxes(DGraphic graph, DExtensible ext, Object the_arg) {
        this.doChildrenItem(graph, ext, the_arg);
    }

    public void doMethod(DPalettes pal, DExtensible ext, Object the_arg) {
        Arg arg = (Arg)the_arg;
        NamedNodeMap attr = arg.node.getAttributes();
        Node n = attr.getNamedItem("location");
        if (n != null) {
            pal.setLocation(n.getNodeValue());
        }
        if ((n = attr.getNamedItem("paletteSetId")) != null) {
            pal.setPaletteSetId(n.getNodeValue());
        }
        if ((n = attr.getNamedItem("paletteId")) != null) {
            pal.setPaletteId(n.getNodeValue());
        }
    }

    public void doMethod(DAxis ax, DExtensible ext, Object the_arg) {
        Arg arg = (Arg)the_arg;
        NamedNodeMap attr = arg.node.getAttributes();
        arg.node.getNodeName();
        Node n = this.getRequiredAttribut(attr, "id", "axis");
        if (n != null) {
            ax.setName(n.getNodeValue());
        }
        if ((n = attr.getNamedItem("title")) != null) {
            ax.setTitle(n.getNodeValue());
        }
        if ((n = attr.getNamedItem("scale")) != null) {
            if ("log".equals(n.getNodeValue())) {
                ax.setScaleType("S_LOG.DAxis.core.jscrib");
            } else {
                ax.setScaleType("S_LIN.DAxis.core.jscrib");
            }
        }
        if ((n = attr.getNamedItem("showTitle")) != null) {
            ax.getProperties().store("P_SHOW_TITLE.DAxis.core.jscrib", Boolean.valueOf(n.getNodeValue()));
        }
        if ((n = attr.getNamedItem("rotateLabel")) != null) {
            double degrees = Double.parseDouble(n.getNodeValue());
            String degreeId = "zeroDegree";
            degreeId = degrees >= 45.0 ? "plusNinetyDegrees" : (degrees < 45.0 && degrees > 0.0 ? "zeroDegree" : (degrees <= -45.0 ? "minusNinetyDegrees" : (degrees > -45.0 && degrees < 0.0 ? "zeroDegree" : "zeroDegree")));
            ax.getProperties().store("P_LABEL_ROTATION.DAxis.core.jscrib", degreeId);
        }
        String type = "number";
        n = attr.getNamedItem("dataFormatType");
        if (n != null) {
            type = n.getNodeValue();
            if ("date".equals(type)) {
                ax.getProperties().store("P_DATA_CLASS.DAxis.core.jscrib", Date.class);
            } else if ("number".equals(type)) {
                ax.getProperties().store("P_DATA_CLASS.DAxis.core.jscrib", Double.class);
            } else if ("string".equals(type)) {
                ax.getProperties().store("P_DATA_CLASS.DAxis.core.jscrib", String.class);
            } else {
                throw new DXmlError("Unkown type '" + type + "' in the dataFormatType definition");
            }
        }
        Class pdclass = (Class)ax.getProperties().get("P_DATA_CLASS.DAxis.core.jscrib");
        n = attr.getNamedItem("min");
        if (n != null) {
            ax.getProperties().store("P_MIN.DAxis.core.jscrib", this.getCoordValue(n.getNodeValue(), pdclass, n));
        }
        if ((n = attr.getNamedItem("max")) != null) {
            ax.getProperties().store("P_MAX.DAxis.core.jscrib", this.getCoordValue(n.getNodeValue(), pdclass, n));
        }
        this.axis.put(ax.getName(), ax);
        Node c = arg.node.getFirstChild();
        while (c != null) {
            if ("labelFormat".equals(c.getNodeName())) {
                this.parseLabelFormat(ax, ext, new Arg(c, ax));
            } else if ("categories".equals(c.getNodeName())) {
                this.parseCategories(ax, ext, new Arg(c, ax));
            } else if ("majorUnit".equals(c.getNodeName())) {
                this.parseMajorUnit(ax, ext, new Arg(c, ax));
            } else if ("minorUnit".equals(c.getNodeName())) {
                this.parseMinorUnit(ax, ext, new Arg(c, ax));
            }
            c = c.getNextSibling();
        }
        String[] save = arg.filter_children;
        arg.filter_children = filter_for_DAxis;
        this.doChildrenItem(ax, ext, arg);
        arg.filter_children = save;
    }

    public void doMethod(DMarkerLine ml, DExtensible ext, Object the_arg) {
        Arg arg = (Arg)the_arg;
        NamedNodeMap attr = arg.node.getAttributes();
        Node n = attr.getNamedItem("id");
        if (n != null) {
            ml.setId(n.getNodeValue());
        }
        if ((n = attr.getNamedItem("value")) != null) {
            Class f = (Class)((DAxis)arg.parent).getProperties().get("P_DATA_CLASS.DAxis.core.jscrib");
            ml.setValue(this.getCoordValue(n.getNodeValue(), f, n));
        }
        if ((n = attr.getNamedItem("label")) != null) {
            ml.setLabel(n.getNodeValue());
        }
        if ((n = attr.getNamedItem("color")) != null) {
            ml.setColor(this.getColor(n.getNodeValue(), "markerLine"));
        }
        if ((n = attr.getNamedItem("thickness")) != null) {
            ml.setThickness(Double.parseDouble(n.getNodeValue()));
        }
    }

    public void doMethod(DMarkerRegion mr, DExtensible ext, Object the_arg) {
        Arg arg = (Arg)the_arg;
        NamedNodeMap attr = arg.node.getAttributes();
        Node n = attr.getNamedItem("id");
        if (n != null) {
            mr.setId(n.getNodeValue());
        }
        if ((n = attr.getNamedItem("label")) != null) {
            mr.setLabel(n.getNodeValue());
        }
        if ((n = attr.getNamedItem("color")) != null) {
            mr.setColor(this.getColor(n.getNodeValue(), "markerRegion"));
        }
        Class f = (Class)((DAxis)arg.parent).getProperties().get("P_DATA_CLASS.DAxis.core.jscrib");
        n = attr.getNamedItem("fromValue");
        if (n != null) {
            mr.setFromValue(this.getCoordValue(n.getNodeValue(), f, n));
        }
        if ((n = attr.getNamedItem("toValue")) != null) {
            mr.setFromValue(this.getCoordValue(n.getNodeValue(), f, n));
        }
    }

    protected void parseCategories(DAxis ax, DExtensible ext, Object the_arg) {
        this.doChildrenItem(ax, ext, the_arg);
    }

    protected void parseMajorUnit(DAxis ax, DExtensible ext, Object a_arg) {
        boolean showGrid;
        Arg arg = (Arg)a_arg;
        NamedNodeMap attr = arg.node.getAttributes();
        Node n = attr.getNamedItem("value");
        if (n != null) {
            Class f = (Class)ax.getProperties().get("P_DATA_CLASS.DAxis.core.jscrib");
            ax.getProperties().store("P_MAJUNIT_VALUE.DAxis.core.jscrib", this.getRangeValue(n.getNodeValue(), f, n));
        }
        if ((n = attr.getNamedItem("showTick")) != null) {
            ax.getProperties().store("P_MAJUNIT_SHOW_TICK.DAxis.core.jscrib", Boolean.valueOf(n.getNodeValue()));
        }
        if ((n = attr.getNamedItem("showGridLine")) != null) {
            ax.getProperties().store("P_MAJUNIT_SHOWGRID.DAxis.core.jscrib", Boolean.valueOf(n.getNodeValue()));
        }
        boolean showTick = ax.getProperties().get("P_MAJUNIT_SHOW_TICK.DAxis.core.jscrib", true);
        Object value = ax.getProperties().get("P_MAJUNIT_VALUE.DAxis.core.jscrib");
        if (showTick && value != null) {
            ax.getProperties().store("P_STEP_UNIT.DAxis.core.jscrib", value);
        }
        if ((showGrid = ax.getProperties().get("P_MAJUNIT_SHOWGRID.DAxis.core.jscrib", true)) && value != null) {
            ax.getProperties().store("P_STEP_LINE.DAxis.core.jscrib", value);
        }
    }

    protected void parseMinorUnit(DAxis ax, DExtensible ext, Object a_arg) {
        Arg arg = (Arg)a_arg;
        NamedNodeMap attr = arg.node.getAttributes();
        Node n = attr.getNamedItem("value");
        if (n != null) {
            Class f = (Class)ax.getProperties().get("P_DATA_CLASS.DAxis.core.jscrib");
            ax.getProperties().store("P_MINUNIT_VALUE.DAxis.core.jscrib", this.getRangeValue(n.getNodeValue(), f, n));
        }
        if ((n = attr.getNamedItem("showTick")) != null) {
            ax.getProperties().store("P_MINUNIT_SHOW_TICK.DAxis.core.jscrib", Boolean.valueOf(n.getNodeValue()));
        }
        if ((n = attr.getNamedItem("showGridLine")) != null) {
            ax.getProperties().store("P_MINUNIT_SHOWGRID.DAxis.core.jscrib", Boolean.valueOf(n.getNodeValue()));
        }
        boolean showTick = ax.getProperties().get("P_MINUNIT_SHOW_TICK.DAxis.core.jscrib", true);
        Object value = ax.getProperties().get("P_MINUNIT_VALUE.DAxis.core.jscrib");
        if (showTick && value != null) {
            ax.getProperties().store("P_STEP_DOT.DAxis.core.jscrib", value);
        }
    }

    protected void parseLabelFormat(DAxis ax, DExtensible ext, Object a_arg) {
        Arg arg = (Arg)a_arg;
        NamedNodeMap attr = arg.node.getAttributes();
        String type = "number";
        String pattern = null;
        Node n = attr.getNamedItem("type");
        if (n != null) {
            type = n.getNodeValue();
            ax.getProperties().store("P_LABEL_FORMATTYPE.DAxis.core.jscrib", type);
        }
        if ((n = attr.getNamedItem("pattern")) != null) {
            pattern = n.getNodeValue();
            ax.getProperties().store("P_LABEL_FORMAT.DAxis.core.jscrib", pattern);
        }
    }

    public void doMethod(DCurve curv, DExtensible ext, Object a_arg) {
        Arg arg = (Arg)a_arg;
        NamedNodeMap attr = arg.node.getAttributes();
        Node n = attr.getNamedItem("label");
        if (n != null) {
            curv.setName(n.getNodeValue());
        }
        if ((n = attr.getNamedItem("symbol")) != null) {
            curv.getProperties().store("SYMBOL.DCurve.core.jscrib", n.getNodeValue());
        }
        if ((n = attr.getNamedItem("color")) != null) {
            curv.getProperties().store("P_COLOR.DCurve.core.jscrib", this.getColor(n.getNodeValue(), "dataset"));
        }
        this.doChildrenItem(curv, ext, arg);
    }

    public void doMethod(DPoint pnt, DExtensible ext, Object arg) {
        this.doChildrenItem(pnt, ext, arg);
    }

    public void doMethod(IDCoord coord, DExtensible ext, Object a_arg) {
        String CoordNodeName;
        Arg arg = (Arg)a_arg;
        NamedNodeMap attr = arg.node.getAttributes();
        String axisId = this.getRequiredAttribut(attr, "axis", CoordNodeName = arg.node.getNodeName()).getNodeValue();
        DAxis ax = (DAxis)this.axis.get(axisId);
        if (ax == null) {
            throw new DXmlError("Unknown axis id = '" + axisId + "' in coord definition");
        }
        coord.setAxis(ax);
    }

    public void doMethod(Date date, DExtensible ext, Object t_arg) {
        Arg arg = (Arg)t_arg;
        try {
            arg.return_value = SimpleDateFormat.getInstance().parse(DXmlDocumentReader.getNodeText(arg.node));
        }
        catch (ParseException e) {
            throw new DXmlError(e.getMessage());
        }
    }

    public void doMethod(String date, DExtensible ext, Object t_arg) {
        Arg arg = (Arg)t_arg;
        arg.return_value = DXmlDocumentReader.getNodeText(arg.node);
    }

    public void doMethod(DAlignmentPair align, DExtensible ext, Object t_arg) {
        Arg arg = (Arg)t_arg;
        Node n = arg.node;
        if ("top".equals(n.getNodeValue())) {
            align.setAlignment(8);
        } else if ("bottom".equals(n.getNodeValue())) {
            align.setAlignment(16);
        } else if ("right".equals(n.getNodeValue())) {
            align.setAlignment(2);
        } else if ("left".equals(n.getNodeValue())) {
            align.setAlignment(1);
        }
        align.setSecondaryAlignment(1);
    }

    protected Object createObjectForClassName(String class_name, Node node) {
        block28: {
            Class<?> c;
            block27: {
                block26: {
                    c = Class.forName(class_name);
                    if (c == String.class) {
                        return DXmlDocumentReader.getNodeText(node);
                    }
                    if (c == Byte.class) {
                        return Byte.decode(DXmlDocumentReader.getNodeText(node));
                    }
                    if (c == Short.class) {
                        return Short.decode(DXmlDocumentReader.getNodeText(node));
                    }
                    if (c == Integer.class) {
                        return Integer.decode(DXmlDocumentReader.getNodeText(node));
                    }
                    if (c == Long.class) {
                        return Long.decode(DXmlDocumentReader.getNodeText(node));
                    }
                    if (c == Float.class) {
                        return Float.valueOf(DXmlDocumentReader.getNodeText(node));
                    }
                    if (c == Double.class) {
                        return Double.valueOf(DXmlDocumentReader.getNodeText(node));
                    }
                    if (c == Boolean.class) {
                        return Boolean.valueOf(DXmlDocumentReader.getNodeText(node));
                    }
                    if (IDColor.class.isAssignableFrom(c)) {
                        return this.getColor(DXmlDocumentReader.getNodeText(node), node.getNodeName());
                    }
                    if (IDFont.class.isAssignableFrom(c)) {
                        return this.fontsId.get(DXmlDocumentReader.getNodeText(node));
                    }
                    if (IDFont.class.isAssignableFrom(c)) {
                        return this.stylesId.get(DXmlDocumentReader.getNodeText(node));
                    }
                    if (!IDStringSerializable.class.isAssignableFrom(c)) break block26;
                    try {
                        IDStringSerializable v = (IDStringSerializable)c.newInstance();
                        Arg arg = new Arg(node, null);
                        this.invokeDoMethod(v, this, arg);
                        return v;
                    }
                    catch (Exception e) {
                        if (!(e instanceof InstantiationException)) break block26;
                        System.out.println("IDStringSerializable class should have an empty public constructor");
                        return null;
                    }
                }
                if (!IDXmlSerializable.class.isAssignableFrom(c)) break block27;
                try {
                    IDXmlSerializable v = (IDXmlSerializable)c.newInstance();
                    Arg arg = new Arg(node, null);
                    this.invokeDoMethod(v, this, arg);
                    return v;
                }
                catch (Exception e) {
                    if (e instanceof InstantiationException) {
                        System.out.println("IDXmlSerializable class should have an empty public constructor");
                        return null;
                    }
                }
            }
            try {
                if (c == Class.class) {
                    return Class.forName(DXmlDocumentReader.getNodeText(node));
                }
                if (c == DecimalFormat.class) {
                    return new DecimalFormat(DXmlDocumentReader.getNodeText(node));
                }
                if (c == SimpleDateFormat.class) {
                    return new SimpleDateFormat(DXmlDocumentReader.getNodeText(node));
                }
                if (c == Date.class) {
                    try {
                        return SimpleDateFormat.getInstance().parse(DXmlDocumentReader.getNodeText(node));
                    }
                    catch (ParseException parseException) {
                        throw new DXmlError("Failed to parse Date");
                    }
                }
                System.err.println("(W) don't know how to handle property class '" + c.getName() + "' for the element '" + node.getNodeName() + "'");
            }
            catch (Exception e) {
                if (!(e instanceof ClassNotFoundException)) break block28;
                System.err.println("(W) Unable to instanciate class '" + class_name + "'");
            }
        }
        return null;
    }

    public void doMethod(IDXmlSerializable v, DExtensible ext, Object arg) {
        v.readXml(((Arg)arg).node);
    }

    public void doMethod(IDStringSerializable v, DExtensible ext, Object arg) {
        Node node = ((Arg)arg).node;
        v.serializeFromString(DXmlDocumentReader.getNodeText(node));
    }

    public void updateExtension(IDExtension ext, Class for_extension) {
        if (this.getClass().equals(for_extension)) {
            DExtensionRegistry.updateExtensible(this);
        }
    }

    public static IDColor DecodeColor(String s) {
        try {
            int rgb = Integer.parseInt(s, 16);
            return new DColor(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private int parseInt(String s, int _default) {
        try {
            int v = Integer.parseInt(s);
            return v;
        }
        catch (Throwable throwable) {
            return _default;
        }
    }

    public IDObject[] getDocuments() {
        int nbdoc = 0;
        int i = 0;
        while (i < this.roots.length) {
            if (this.roots[i] instanceof DDocument) {
                ++nbdoc;
            }
            ++i;
        }
        IDObject[] docs = new IDObject[nbdoc];
        int i2 = 0;
        while (i2 < this.roots.length) {
            if (this.roots[i2] instanceof DDocument) {
                docs[i2] = this.roots[i2];
            }
            ++i2;
        }
        return docs;
    }

    public IDObject[] getStyles() {
        Iterator it = this.styles.iterator();
        int nbsts = 0;
        while (it.hasNext()) {
            IDStyle cfr_ignored_0 = (IDStyle)it.next();
            ++nbsts;
        }
        IDObject[] sts = new IDObject[nbsts];
        it = this.styles.iterator();
        int i = 0;
        while (it.hasNext()) {
            IDStyle s = (IDStyle)it.next();
            sts[i++] = s;
        }
        return sts;
    }

    public static class Arg {
        public Node node;
        public String[] filter_children;
        public String ret_id;
        public Object return_value;
        public IDItem parent;

        public Arg(Node n, IDItem parent) {
            this.node = n;
            this.ret_id = null;
            this.parent = parent;
        }

        public boolean filterChildren(String node_name) {
            if (this.filter_children == null) {
                return false;
            }
            int i = 0;
            while (i < this.filter_children.length) {
                String s = this.filter_children[i];
                if (s != null && s.equals(node_name)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

