/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drivers.xml.internal;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DCategory;
import org.eclipse.tptp.platform.report.core.internal.DCoord;
import org.eclipse.tptp.platform.report.core.internal.DCoordObject;
import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DDocument;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DMarkerLine;
import org.eclipse.tptp.platform.report.core.internal.DMarkerRegion;
import org.eclipse.tptp.platform.report.core.internal.DPalettes;
import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.DPropertyStore;
import org.eclipse.tptp.platform.report.core.internal.DShapes;
import org.eclipse.tptp.platform.report.core.internal.IDColor;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDObject;
import org.eclipse.tptp.platform.report.core.internal.IDStringSerializable;
import org.eclipse.tptp.platform.report.drivers.internal.IWriter;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlError;
import org.eclipse.tptp.platform.report.drivers.xml.internal.IDXmlSerializable;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;
import org.eclipse.tptp.platform.report.tools.internal.DAlignmentPair;
import org.eclipse.tptp.platform.report.tools.internal.DParser;

public class DXmlDocumentWriter
extends DParser
implements IWriter {
    private OutputStream out;
    private boolean write_complete_document = true;
    private Element curr_element;
    private int curr_indent;
    private boolean auto_indent = false;
    protected ArrayList folder_model_written_;

    public OutputStream getOutputStream() {
        return this.out;
    }

    public boolean isAutoIndentMode() {
        return this.auto_indent;
    }

    public void setAutoIndentMode(boolean b) {
        this.auto_indent = b;
    }

    public boolean isWriteCompleteDocument() {
        return this.write_complete_document;
    }

    public void setWriteCompleteDocument(boolean b) {
        this.write_complete_document = b;
    }

    public String getRootElementName() {
        return "chart";
    }

    public void write(OutputStream output, IDObject[] objects) throws Exception {
        this.out = output;
        this.folder_model_written_ = null;
        this.getRootElementName();
        if (this.write_complete_document) {
            this.out.write("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n".getBytes("UTF-8"));
            this.curr_element = null;
            this.curr_indent = 0;
        }
        int i = 0;
        while (i < objects.length) {
            IDObject obj = objects[i];
            if (obj != null) {
                this.invokeDoMethod(obj, this, null);
            }
            ++i;
        }
        this.curr_element = null;
    }

    public void write(OutputStream output, IDObject object) throws Exception {
        this.write(output, new IDObject[]{object});
    }

    public void clear() {
        super.clear();
        this.curr_element = null;
        this.curr_indent = 0;
    }

    protected void outIndent(int idt) throws IOException {
        if (!this.auto_indent) {
            return;
        }
        this.out.write(10);
        int i = 0;
        while (i < idt) {
            this.out.write(32);
            this.out.write(32);
            ++i;
        }
    }

    private void closeStartElement() throws IOException {
        if (this.curr_element != null && !this.curr_element.start_part_closed) {
            if (this.curr_element.empty) {
                this.out.write(62);
                this.out.write(10);
            }
            this.curr_element.empty = false;
            if (this.curr_element.can_indent) {
                this.outIndent(this.curr_element.indent);
            }
            this.curr_element.start_part_closed = true;
        }
    }

    public void startElement(String name) {
        try {
            this.closeStartElement();
            this.out.write(60);
            this.out.write(name.getBytes("UTF-8"));
            this.curr_element = new Element(name, this.curr_element);
            this.curr_element.indent = this.curr_indent++;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void endElement() {
        if (this.curr_element == null) {
            return;
        }
        try {
            if (this.curr_element.empty) {
                this.out.write(47);
                this.out.write(62);
                this.out.write(10);
            } else {
                if (this.curr_element.can_indent) {
                    this.outIndent(this.curr_element.indent);
                }
                this.out.write(60);
                this.out.write(47);
                this.out.write(this.curr_element.name.getBytes("UTF-8"));
                this.out.write(62);
                this.out.write(10);
            }
            --this.curr_indent;
            this.curr_element = this.curr_element.up;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void outCData(String data) {
        if (data == null) {
            return;
        }
        try {
            if (this.curr_element != null) {
                this.curr_element.can_indent = false;
                this.curr_element.empty = false;
                this.out.write(62);
            }
            this.out.write(DXmlDocumentWriter.encode(data).getBytes("UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void outAttribute(String attr_name, String attr_value, boolean required) {
        if (attr_value == null) {
            if (required) {
                throw new DXmlError("Required attribute '" + attr_name + "' can't have null value, correct the document.");
            }
            return;
        }
        try {
            this.out.write(32);
            this.out.write(attr_name.getBytes("UTF-8"));
            this.out.write(61);
            this.out.write(34);
            this.out.write(DXmlDocumentWriter.encode(attr_value).getBytes("UTF-8"));
            this.out.write(34);
            this.curr_element.have_attr = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void outAttribute(String attr_name, String attr_value, String default_value) {
        if (attr_value == null) {
            return;
        }
        if (attr_value == default_value || attr_value.equals(default_value)) {
            return;
        }
        this.outAttribute(attr_name, attr_value, false);
    }

    public final void outAttribute(String attr_name, int attr_value) {
        this.outAttribute(attr_name, Integer.toString(attr_value), true);
    }

    public final void outAttribute(String attr_name, int attr_value, int default_value) {
        if (attr_value == default_value) {
            return;
        }
        this.outAttribute(attr_name, Integer.toString(attr_value), false);
    }

    public final void outAttribute(String attr_name, boolean attr_value) {
        this.outAttribute(attr_name, Boolean.toString(attr_value), true);
    }

    public final void outAttribute(String attr_name, boolean attr_value, boolean default_value) {
        if (attr_value == default_value) {
            return;
        }
        this.outAttribute(attr_name, Boolean.toString(attr_value), false);
    }

    public final void outAttribute(String attr_name, float attr_value) {
        this.outAttribute(attr_name, Float.toString(attr_value), true);
    }

    public final void outAttribute(String attr_name, float attr_value, float default_value) {
        if (attr_value == default_value) {
            return;
        }
        this.outAttribute(attr_name, Float.toString(attr_value), false);
    }

    public final void outAttribute(String attr_name, double attr_value) {
        this.outAttribute(attr_name, Double.toString(attr_value), true);
    }

    public final void outAttribute(String attr_name, double attr_value, double default_value) {
        if (attr_value == default_value) {
            return;
        }
        this.outAttribute(attr_name, Double.toString(attr_value), false);
    }

    public final void outPropertyAttr(String attr_name, DPropertyStore ps, String key, boolean default_value) {
        if (ps.hasKey(key)) {
            this.outAttribute(attr_name, ps.get(key, default_value));
        }
    }

    public final void outPropertyAttr(String attr_name, DPropertyStore ps, String key, String default_value) {
        if (ps.hasKey(key)) {
            this.outAttribute(attr_name, ps.get(key, default_value), false);
        }
    }

    public final void outPropertyAttr(String attr_name, DPropertyStore ps, String key, double default_value) {
        if (ps.hasKey(key)) {
            this.outAttribute(attr_name, ps.get(key, default_value), default_value);
        }
    }

    public final void outPropertyAttr(String attr_name, DPropertyStore ps, String key, float default_value) {
        if (ps.hasKey(key)) {
            this.outAttribute(attr_name, ps.get(key, default_value), default_value);
        }
    }

    public final void outPropertyAttr(String attr_name, DPropertyStore ps, String key, int default_value) {
        if (ps.hasKey(key)) {
            this.outAttribute(attr_name, ps.get(key, default_value), default_value);
        }
    }

    public final void outPropertyAttr(String attr_name, DPropertyStore ps, String key) {
        if (ps.hasKey(key)) {
            Object o = ps.get(key);
            try {
                this.out.write(32);
                this.out.write(attr_name.getBytes("UTF-8"));
                this.out.write(61);
                this.out.write(34);
                Element olde = this.curr_element;
                this.curr_element = null;
                if (o instanceof IDStringSerializable) {
                    this.out.write(DXmlDocumentWriter.encode(((IDStringSerializable)o).serializeToString()).getBytes("UTF-8"));
                } else {
                    this.invokeDoMethod(o, this, null);
                }
                this.out.write(34);
                this.curr_element = olde;
                this.curr_element.have_attr = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void startElement(String name, IDItem item) {
        this.startElement(name);
    }

    public static String encode(String s) {
        if (s == null) {
            return "";
        }
        s = s.replaceAll("&", "&amp;");
        s = s.replaceAll("'", "&apos;");
        s = s.replaceAll("<", "&lt;");
        s = s.replaceAll(">", "&gt;");
        s = s.replaceAll("\"", "&quot;");
        return s;
    }

    public void doMethod(DDocument d, DExtensible p, Object arg) {
        this.doChildrenItem(d, p, arg);
    }

    public void doMethod(DGraphic g, DExtensible p, Object arg) {
        this.startElement("chart", g);
        this.outPropertyAttr("width", g.getProperties(), "P_MAX_WIDTH.DGraphic.core.jscrib");
        this.outPropertyAttr("minWidth", g.getProperties(), "P_MIN_WIDTH.DGraphic.core.jscrib");
        this.outPropertyAttr("height", g.getProperties(), "P_MAX_HEIGHT.DGraphic.core.jscrib");
        this.outPropertyAttr("minHeight", g.getProperties(), "P_MIN_HEIGHT.DGraphic.core.jscrib");
        this.outPropertyAttr("backgroundColor", g.getProperties(), "P_BACKCOLOR.DGraphic.core.jscrib");
        this.writeLegend(g, p, arg);
        this.writeChartTitle(g, p, arg);
        this.writePlotArea(g, p, arg);
        IDItem c = g.getFirstChild();
        while (c != null) {
            if (!(c instanceof DGraphic || c instanceof DAxis || c instanceof DCurve || c instanceof DShapes || c instanceof DPalettes)) {
                this.invokeDoMethod(c, p, arg);
            }
            c = c.getNext();
        }
        this.endElement();
    }

    public void doMethod(DCategory event, DExtensible ext, Object arg) {
        this.startElement("category");
        this.outAttribute("id", event.getId(), null);
        this.outAttribute("label", event.getLabel(), null);
        this.doChildrenItem(event, ext, arg);
        this.endElement();
    }

    protected void writeLegend(DGraphic g, DExtensible p, Object arg) {
        this.startElement("legend");
        this.outPropertyAttr("width", g.getProperties(), "P_LEGEND_WIDTH.DGraphic.core.jscrib", 100);
        this.outPropertyAttr("height", g.getProperties(), "P_LEGEND_HEIGHT.DGraphic.core.jscrib", 100);
        this.outPropertyAttr("sizingFactor", g.getProperties(), "P_LEGEND_LIMIT.DGraphic.core.jscrib", 4);
        this.outPropertyAttr("show", g.getProperties(), "P_SHOW_LEGEND.DGraphic.core.jscrib", true);
        DAlignmentPair align = (DAlignmentPair)g.getProperties().get("P_LEGEND_LAYOUT.DGraphic.core.jscrib");
        if (align != null) {
            try {
                Element oldelem = this.curr_element;
                this.curr_element = null;
                this.out.write(" alignment=\"".getBytes("UTF-8"));
                this.invokeDoMethod(align, p, arg);
                this.out.write(34);
                this.curr_element = oldelem;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.endElement();
    }

    protected void writeChartTitle(DGraphic g, DExtensible p, Object arg) {
        this.startElement("chartTitle");
        this.outAttribute("label", g.getTitle() == null ? "" : g.getTitle(), true);
        this.outPropertyAttr("show", g.getProperties(), "P_SHOW_TITLED.DGraphic.core.jscrib", true);
        this.endElement();
    }

    public void doMethod(DAlignmentPair align, DExtensible p, Object arg) {
        String val = null;
        switch (align.getAlignment()) {
            case 16: {
                val = "bottom";
                break;
            }
            case 8: {
                val = "top";
                break;
            }
            case 1: {
                val = "left";
                break;
            }
            case 2: {
                val = "right";
            }
        }
        if (val != null) {
            this.outCData(val);
        }
    }

    private String getType(DGraphic _dgraphic, String type) {
        String returnType = type;
        boolean threeD = _dgraphic.getProperties().get("P_3D.DGraphic.core.jscrib", false);
        if ("T_HBARS.DGraphic.core.jscrib".equals(type)) {
            returnType = threeD ? "horizontalBar3D" : "horizontalBar";
        } else if ("T_HISTOGRAM.DGraphic.core.jscrib".equals(type)) {
            returnType = threeD ? "verticalBar3D" : "verticalBar";
        } else if ("T_STACKBARS.DGraphic.core.jscrib".equals(type)) {
            returnType = threeD ? "verticalStackedBar3D" : "verticalStackedBar";
        } else if ("T_SECTORS3D.DGraphic.core.jscrib".equals(type)) {
            returnType = "pie3D";
        } else if ("T_SECTORS.DGraphic.core.jscrib".equals(type)) {
            returnType = "pie";
        } else if ("T_METER.DGraphic.core.jscrib".equals(type)) {
            returnType = "meter";
        } else if ("T_XY.DGraphic.core.jscrib".equals(type)) {
            returnType = "line";
        }
        return returnType;
    }

    protected void writePlotArea(DGraphic g, DExtensible p, Object arg) {
        DPalettes pal;
        this.startElement("plotArea");
        this.outAttribute("type", this.getType(g, g.getRenderableId()), true);
        this.outPropertyAttr("backgroundColor", g.getProperties(), "P_PLOTAREA_BACKCOLOR.DGraphic.core.jscrib");
        this.outPropertyAttr("showPercentage", g.getProperties(), "P_SHOW_PERCENTAGE.DGraphic.core.jscrib", true);
        this.outPropertyAttr("showValues", g.getProperties(), "P_SHOW_VALUES.DGraphic.core.jscrib", true);
        this.outPropertyAttr("margin", g.getProperties(), "P_MARGIN.DGraphic.core.jscrib", 10);
        DShapes s = (DShapes)g.getChildOfClass(DShapes.class);
        if (s != null) {
            this.invokeDoMethod(s, p, arg);
        }
        if ((pal = (DPalettes)g.getChildOfClass(DPalettes.class)) != null) {
            this.invokeDoMethod(pal, p, arg);
        }
        this.writeAxes(g, p, arg);
        this.writeCurves(g, p, arg);
        this.endElement();
    }

    public void doMethod(DPalettes pal, DExtensible p, Object arg) {
        this.startElement("palettes");
        this.outAttribute("location", pal.getLocation(), false);
        this.outAttribute("paletteSetId", pal.getPaletteSetId(), false);
        this.outAttribute("paletteId", pal.getPaletteId(), false);
        this.endElement();
    }

    protected void writeAxes(DGraphic g, DExtensible p, Object arg) {
        this.startElement("axes");
        IDItem c = g.getFirstChild();
        while (c != null) {
            if (c instanceof DAxis) {
                this.invokeDoMethod(c, p, arg);
            }
            c = c.getNext();
        }
        this.endElement();
    }

    protected void writeCurves(DGraphic g, DExtensible p, Object arg) {
        this.startElement("datasets");
        IDItem c = g.getFirstChild();
        while (c != null) {
            if (c instanceof DCurve) {
                this.invokeDoMethod(c, p, arg);
            }
            c = c.getNext();
        }
        this.endElement();
    }

    public void doMethod(DAxis a, DExtensible p, Object arg) {
        this.startElement("axis", a);
        this.outAttribute("id", a.getName(), true);
        this.outAttribute("title", a.getTitle(), false);
        if (a.getScaleType() == "S_LIN.DAxis.core.jscrib") {
            this.outAttribute("scale", "linear", "linear");
        } else {
            this.outAttribute("scale", "log", "linear");
        }
        this.outPropertyAttr("min", a.getProperties(), "P_MIN.DAxis.core.jscrib", 0.0);
        this.outPropertyAttr("max", a.getProperties(), "P_MAX.DAxis.core.jscrib", 0.0);
        String degreeId = a.getProperties().get("P_LABEL_ROTATION.DAxis.core.jscrib", "zeroDegree");
        double degree = 0.0;
        if (degreeId.equals("minusNinetyDegrees")) {
            degree = -90.0;
        } else if (degreeId.equals("plusNinetyDegrees")) {
            degree = 90.0;
        }
        this.outPropertyAttr("rotateLabel", a.getProperties(), "P_LABEL_ROTATION.DAxis.core.jscrib", degree);
        this.outPropertyAttr("showTitle", a.getProperties(), "P_SHOW_TITLE.DAxis.core.jscrib", true);
        this.writeLabelFormat(a, p, arg);
        this.invokeDoMethod(a.getProperties(), p, arg);
        this.writeCategories(a, p, arg);
        this.writeMinorUnit(a, p, arg);
        this.writeMajorUnit(a, p, arg);
        IDItem c = a.getFirstChild();
        while (c != null) {
            if (!(c instanceof DCategory)) {
                this.invokeDoMethod(c, p, arg);
            }
            c = c.getNext();
        }
        this.endElement();
    }

    protected void writeLabelFormat(DAxis a, DExtensible p, Object arg) {
        String labelFormatType = null;
        Object o = a.getProperties().get("P_UNIT_FORMAT.DAxis.core.jscrib");
        if (o == null) {
            o = a.getProperties().get("P_LABEL_FORMAT.DAxis.core.jscrib");
            labelFormatType = (String)a.getProperties().get("P_LABEL_FORMATTYPE.DAxis.core.jscrib");
        }
        if (o == null) {
            return;
        }
        this.startElement("labelFormat");
        if (o instanceof SimpleDateFormat) {
            this.outAttribute("type", "date", false);
            this.outAttribute("pattern", ((SimpleDateFormat)o).toPattern(), false);
        } else if (o instanceof DecimalFormat) {
            this.outAttribute("type", "number", false);
            this.outAttribute("pattern", ((DecimalFormat)o).toPattern(), false);
        } else if (o instanceof String) {
            this.outAttribute("type", labelFormatType, false);
            this.outAttribute("pattern", (String)o, false);
        } else {
            this.outAttribute("type", o.getClass().getName(), false);
        }
        this.endElement();
    }

    public void doMethod(DMarkerLine ml, DExtensible p, Object arg) {
        this.startElement("markerLine");
        this.outAttribute("id", ml.getId(), false);
        if (ml.getValue() instanceof Date) {
            this.outAttribute("value", SimpleDateFormat.getInstance().format(ml.getValue()), null);
        } else if (ml.getValue() != null) {
            this.outAttribute("value", Double.toString((Double)ml.getValue()), false);
        }
        this.outAttribute("label", ml.getLabel(), false);
        if (ml.getColor() != null) {
            this.outAttribute("color", ml.getColor().serializeToString(), false);
        }
        this.outAttribute("thickness", ml.getThickness(), 0.0);
        this.endElement();
    }

    public void doMethod(DMarkerRegion ml, DExtensible p, Object arg) {
        this.startElement("markerRegion");
        this.outAttribute("id", ml.getId(), false);
        if (ml.getFromValue() != null) {
            if (ml.getFromValue() instanceof Date) {
                this.outAttribute("fromValue", SimpleDateFormat.getInstance().format(ml.getFromValue()), null);
            } else {
                this.outAttribute("fromValue", (Double)ml.getFromValue(), 0.0);
            }
        }
        if (ml.getToValue() != null) {
            if (ml.getToValue() instanceof Date) {
                this.outAttribute("toValue", SimpleDateFormat.getInstance().format(ml.getToValue()), null);
            } else {
                this.outAttribute("toValue", (Double)ml.getToValue(), 0.0);
            }
        }
        this.outAttribute("label", ml.getLabel(), false);
        if (ml.getColor() != null) {
            this.outAttribute("color", ml.getColor().serializeToString(), false);
        }
        this.endElement();
    }

    protected void writeCategories(DAxis a, DExtensible p, Object arg) {
        boolean categoryExist = false;
        IDItem c = a.getFirstChild();
        while (c != null) {
            if (c instanceof DCategory) {
                categoryExist = true;
                break;
            }
            c = c.getNext();
        }
        if (!categoryExist) {
            return;
        }
        this.startElement("categories");
        c = a.getFirstChild();
        while (c != null) {
            if (c instanceof DCategory) {
                this.invokeDoMethod(c, p, arg);
            }
            c = c.getNext();
        }
        this.endElement();
    }

    protected void writeMajorUnit(DAxis a, DExtensible p, Object arg) {
        if (a.getProperties().get("P_MAJUNIT_VALUE.DAxis.core.jscrib") != null || a.getProperties().get("P_MAJUNIT_SHOW_TICK.DAxis.core.jscrib") != null || a.getProperties().get("P_MAJUNIT_SHOWGRID.DAxis.core.jscrib") != null) {
            this.startElement("majorUnit");
            this.outPropertyAttr("value", a.getProperties(), "P_MAJUNIT_VALUE.DAxis.core.jscrib", 0.0);
            this.outPropertyAttr("showTick", a.getProperties(), "P_MAJUNIT_SHOW_TICK.DAxis.core.jscrib", false);
            this.outPropertyAttr("showGridLine", a.getProperties(), "P_MAJUNIT_SHOWGRID.DAxis.core.jscrib", false);
            this.endElement();
        }
    }

    protected void writeMinorUnit(DAxis a, DExtensible p, Object arg) {
        if (a.getProperties().get("P_MINUNIT_VALUE.DAxis.core.jscrib") != null || a.getProperties().get("P_MINUNIT_SHOW_TICK.DAxis.core.jscrib") != null || a.getProperties().get("P_MINUNIT_SHOWGRID.DAxis.core.jscrib") != null) {
            this.startElement("minorUnit");
            this.outPropertyAttr("value", a.getProperties(), "P_MINUNIT_VALUE.DAxis.core.jscrib", 0.0);
            this.outPropertyAttr("showTick", a.getProperties(), "P_MINUNIT_SHOW_TICK.DAxis.core.jscrib", false);
            this.outPropertyAttr("showGridLine", a.getProperties(), "P_MINUNIT_SHOWGRID.DAxis.core.jscrib", false);
            this.endElement();
        }
    }

    public void doMethod(DCurve c, DExtensible p, Object arg) {
        this.startElement("dataset", c);
        this.outAttribute("label", c.getName(), false);
        this.outPropertyAttr("symbol", c.getProperties(), "SYMBOL.DCurve.core.jscrib", null);
        this.outPropertyAttr("color", c.getProperties(), "P_COLOR.DCurve.core.jscrib");
        this.doChildrenItem(c, p, arg);
        this.endElement();
    }

    public void doMethod(DPoint p, DExtensible prs, Object arg) {
        this.startElement("point", p);
        this.doChildrenItem(p, prs, arg);
        this.endElement();
    }

    public void doMethod(DCoord c, DExtensible p, Object arg) {
        this.startElement("coord");
        this.outAttribute("axis", c.getAxis().getName(), true);
        this.outAttribute("value", c.getValue());
        this.endElement();
    }

    public void doMethod(DCoordObject c, DExtensible p, Object arg) {
        this.startElement("coord");
        this.outAttribute("axis", c.getAxis().getName(), true);
        try {
            Element oldelem = this.curr_element;
            this.curr_element = null;
            this.out.write(" value=\"".getBytes("UTF-8"));
            this.invokeDoMethod(c.getValue(null), p, arg);
            this.out.write(34);
            this.curr_element = oldelem;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.endElement();
    }

    public static String EncodeColor(IDColor c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int rgb = r << 16 | g << 8 | b;
        String s = Integer.toString(rgb, 16);
        StringBuffer buf = new StringBuffer(6);
        int i = s.length();
        while (i < 6) {
            buf.append('0');
            ++i;
        }
        buf.append(s);
        return buf.toString();
    }

    public void doMethod(IDXmlSerializable i, DExtensible ext, Object arg) {
        this.outCData(i.writeXml());
    }

    public void doMethod(IDStringSerializable i, DExtensible ext, Object arg) {
        this.outCData(i.serializeToString());
    }

    public void doMethod(String str, DExtensible ext, Object arg) {
        this.outCData(DXmlDocumentWriter.encode(str));
    }

    public void doMethod(Byte v, DExtensible ext, Object arg) {
        this.outCData(v.toString());
    }

    public void doMethod(Short v, DExtensible ext, Object arg) {
        this.outCData(v.toString());
    }

    public void doMethod(Integer v, DExtensible ext, Object arg) {
        this.outCData(v.toString());
    }

    public void doMethod(Long v, DExtensible ext, Object arg) {
        this.outCData(v.toString());
    }

    public void doMethod(Float v, DExtensible ext, Object arg) {
        this.outCData(v.toString());
    }

    public void doMethod(Double v, DExtensible ext, Object arg) {
        this.outCData(v.toString());
    }

    public void doMethod(Boolean v, DExtensible ext, Object arg) {
        this.outCData(v.toString());
    }

    public void doMethod(Class c, DExtensible ext, Object arg) {
        this.outCData(c.getName());
    }

    public void doMethod(Date date, DExtensible ext, Object arg) {
        this.outCData(SimpleDateFormat.getInstance().format(date));
    }

    public void doMethod(DecimalFormat df, DExtensible ext, Object arg) {
        this.outCData(df.toPattern());
    }

    public void doMethod(SimpleDateFormat df, DExtensible ext, Object arg) {
        this.outCData(df.toPattern());
    }

    private String getInternalID(Object o) {
        return Integer.toString(o.hashCode(), 16);
    }

    private static class Element {
        public String name;
        public int indent;
        public boolean can_indent;
        public boolean have_attr;
        public boolean empty;
        public Element up;
        public boolean start_part_closed;

        public Element(String n, Element u) {
            this.name = n;
            this.up = u;
            this.indent = 0;
            this.can_indent = true;
            this.have_attr = false;
            this.empty = true;
            this.start_part_closed = false;
        }
    }
}

