/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drivers.xml.internal;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DBorder;
import org.eclipse.tptp.platform.report.core.internal.DCell;
import org.eclipse.tptp.platform.report.core.internal.DCellText;
import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DColorRegistry;
import org.eclipse.tptp.platform.report.core.internal.DCoord;
import org.eclipse.tptp.platform.report.core.internal.DCoordObject;
import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DCurveLink;
import org.eclipse.tptp.platform.report.core.internal.DData;
import org.eclipse.tptp.platform.report.core.internal.DDocument;
import org.eclipse.tptp.platform.report.core.internal.DFolder;
import org.eclipse.tptp.platform.report.core.internal.DFolderModel;
import org.eclipse.tptp.platform.report.core.internal.DFont;
import org.eclipse.tptp.platform.report.core.internal.DFontRegistry;
import org.eclipse.tptp.platform.report.core.internal.DFooter;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DHeader;
import org.eclipse.tptp.platform.report.core.internal.DImage;
import org.eclipse.tptp.platform.report.core.internal.DIndex;
import org.eclipse.tptp.platform.report.core.internal.DIndexEntry;
import org.eclipse.tptp.platform.report.core.internal.DLine;
import org.eclipse.tptp.platform.report.core.internal.DLink;
import org.eclipse.tptp.platform.report.core.internal.DList;
import org.eclipse.tptp.platform.report.core.internal.DPageBreak;
import org.eclipse.tptp.platform.report.core.internal.DPageCounter;
import org.eclipse.tptp.platform.report.core.internal.DParagraph;
import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.DPointLink;
import org.eclipse.tptp.platform.report.core.internal.DPopup;
import org.eclipse.tptp.platform.report.core.internal.DPropertyStore;
import org.eclipse.tptp.platform.report.core.internal.DRow;
import org.eclipse.tptp.platform.report.core.internal.DSection;
import org.eclipse.tptp.platform.report.core.internal.DStyle;
import org.eclipse.tptp.platform.report.core.internal.DStyleRegistry;
import org.eclipse.tptp.platform.report.core.internal.DSummary;
import org.eclipse.tptp.platform.report.core.internal.DTable;
import org.eclipse.tptp.platform.report.core.internal.DTag;
import org.eclipse.tptp.platform.report.core.internal.DText;
import org.eclipse.tptp.platform.report.core.internal.DTitle;
import org.eclipse.tptp.platform.report.core.internal.IDColor;
import org.eclipse.tptp.platform.report.core.internal.IDFont;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDObject;
import org.eclipse.tptp.platform.report.core.internal.IDStringSerializable;
import org.eclipse.tptp.platform.report.core.internal.IDStyle;
import org.eclipse.tptp.platform.report.drawutil.internal.ISymbol;
import org.eclipse.tptp.platform.report.drivers.internal.IWriter;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlError;
import org.eclipse.tptp.platform.report.drivers.xml.internal.IDXmlSerializable;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;
import org.eclipse.tptp.platform.report.tools.internal.DAlignment;
import org.eclipse.tptp.platform.report.tools.internal.DParser;

public class DXmlWriter
extends DParser
implements IWriter {
    private OutputStream out;
    private boolean write_complete_document = true;
    private DStyleRegistry styles = new DStyleRegistry();
    private DColorRegistry colors = new DColorRegistry();
    private DFontRegistry fonts = new DFontRegistry();
    private Element curr_element;
    private int curr_indent;
    private boolean auto_indent = false;
    protected ArrayList folder_model_written_;
    protected HashMap extensions;

    public OutputStream getOutputStream() {
        return this.out;
    }

    public boolean isAutoIndentMode() {
        return this.auto_indent;
    }

    public void setAutoIndentMode(boolean b) {
        this.auto_indent = b;
    }

    public boolean isWriteCompleteDocument() {
        return this.write_complete_document;
    }

    public void setWriteCompleteDocument(boolean b) {
        this.write_complete_document = b;
    }

    public String getRootElementName() {
        return "JSCRIB";
    }

    public void write(OutputStream output, IDObject[] objects) throws Exception {
        this.out = output;
        this.extensions = null;
        this.folder_model_written_ = null;
        String root_name = this.getRootElementName();
        if (this.write_complete_document) {
            this.out.write("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n".getBytes("UTF-8"));
            this.curr_element = null;
            this.curr_indent = 0;
            this.startElement(root_name);
        }
        int i = 0;
        while (i < objects.length) {
            IDObject obj = objects[i];
            if (obj != null) {
                if (this.write_complete_document) {
                    Iterator it;
                    if (obj instanceof DColorRegistry) {
                        it = ((DColorRegistry)obj).iterator();
                        while (it.hasNext()) {
                            this.colors.putColor((IDColor)it.next());
                        }
                    } else if (obj instanceof DFontRegistry) {
                        it = ((DFontRegistry)obj).iterator();
                        while (it.hasNext()) {
                            this.fonts.putFont((IDFont)it.next());
                        }
                    } else if (obj instanceof DStyleRegistry) {
                        it = ((DStyleRegistry)obj).iterator();
                        while (it.hasNext()) {
                            IDStyle sty = (IDStyle)it.next();
                            this.styles.putStyle(sty);
                            if (sty.getBackColor() != null) {
                                this.colors.putColor(sty.getBackColor());
                            }
                            if (sty.getForeColor() != null) {
                                this.colors.putColor(sty.getForeColor());
                            }
                            if (sty.getFont() == null) continue;
                            this.fonts.putFont(sty.getFont());
                        }
                    } else {
                        this.invokeDoMethod(obj, this, null);
                    }
                } else {
                    this.invokeDoMethod(obj, this, null);
                }
            }
            ++i;
        }
        if (this.write_complete_document) {
            this.invokeDoMethod(this.fonts, this, null);
            this.invokeDoMethod(this.colors, this, null);
            this.invokeDoMethod(this.styles, this, null);
            this.endElement();
        }
        this.curr_element = null;
        this.extensions = null;
    }

    public void write(OutputStream output, IDObject object) throws Exception {
        this.write(output, new IDObject[]{object});
    }

    public void clear() {
        this.fonts.clear();
        this.colors.clear();
        this.styles.clear();
        super.clear();
        this.curr_element = null;
        this.curr_indent = 0;
    }

    protected void outIndent(int idt) throws IOException {
        if (!this.auto_indent) {
            return;
        }
        this.out.write(10);
        int i = 0;
        while (i < idt) {
            this.out.write(32);
            this.out.write(32);
            ++i;
        }
    }

    private void closeStartElement() throws IOException {
        if (this.curr_element != null && !this.curr_element.start_part_closed) {
            if (this.curr_element.empty) {
                this.out.write(62);
            }
            this.curr_element.empty = false;
            if (this.curr_element.can_indent) {
                this.outIndent(this.curr_element.indent);
            }
            this.curr_element.start_part_closed = true;
        }
    }

    public void startElement(String name) {
        try {
            this.closeStartElement();
            this.out.write(60);
            this.out.write(name.getBytes("UTF-8"));
            this.curr_element = new Element(name, this.curr_element);
            this.curr_element.indent = this.curr_indent++;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void endElement() {
        if (this.curr_element == null) {
            return;
        }
        try {
            if (this.curr_element.empty) {
                this.out.write(47);
                this.out.write(62);
            } else {
                if (this.curr_element.can_indent) {
                    this.outIndent(this.curr_element.indent);
                }
                this.out.write(60);
                this.out.write(47);
                this.out.write(this.curr_element.name.getBytes("UTF-8"));
                this.out.write(62);
            }
            --this.curr_indent;
            this.curr_element = this.curr_element.up;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void outCData(String data) {
        try {
            if (this.curr_element != null) {
                this.curr_element.can_indent = false;
                this.curr_element.empty = false;
                this.out.write(62);
            }
            this.out.write(DXmlWriter.encode(data).getBytes("UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void outAttribute(String attr_name, String attr_value, boolean required) {
        if (attr_value == null) {
            if (required) {
                throw new DXmlError("Required attribute '" + attr_name + "' can't have null value, correct the document.");
            }
            return;
        }
        try {
            this.out.write(32);
            this.out.write(attr_name.getBytes("UTF-8"));
            this.out.write(61);
            this.out.write(34);
            this.out.write(DXmlWriter.encode(attr_value).getBytes("UTF-8"));
            this.out.write(34);
            this.curr_element.have_attr = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void outAttribute(String attr_name, String attr_value, String default_value) {
        if (attr_value == null) {
            return;
        }
        if (attr_value == default_value || attr_value.equals(default_value)) {
            return;
        }
        this.outAttribute(attr_name, attr_value, false);
    }

    public final void outAttribute(String attr_name, int attr_value) {
        this.outAttribute(attr_name, Integer.toString(attr_value), true);
    }

    public final void outAttribute(String attr_name, int attr_value, int default_value) {
        if (attr_value == default_value) {
            return;
        }
        this.outAttribute(attr_name, Integer.toString(attr_value), false);
    }

    public final void outAttribute(String attr_name, boolean attr_value) {
        this.outAttribute(attr_name, Boolean.toString(attr_value), true);
    }

    public final void outAttribute(String attr_name, boolean attr_value, boolean default_value) {
        if (attr_value == default_value) {
            return;
        }
        this.outAttribute(attr_name, Boolean.toString(attr_value), false);
    }

    public final void outAttribute(String attr_name, float attr_value) {
        this.outAttribute(attr_name, Float.toString(attr_value), true);
    }

    public final void outAttribute(String attr_name, float attr_value, float default_value) {
        if (attr_value == default_value) {
            return;
        }
        this.outAttribute(attr_name, Float.toString(attr_value), false);
    }

    public final void outAttribute(String attr_name, double attr_value) {
        this.outAttribute(attr_name, Double.toString(attr_value), true);
    }

    public final void outAttribute(String attr_name, double attr_value, double default_value) {
        if (attr_value == default_value) {
            return;
        }
        this.outAttribute(attr_name, Double.toString(attr_value), false);
    }

    public void startElement(String name, IDItem item) {
        this.startElement(name);
        IDStyle sty = item.getStyle();
        if (sty != null) {
            this.outAttribute("STYLE", sty.getID(), true);
            this.styles.putStyle(sty);
            if (sty.getBackColor() != null) {
                this.colors.putColor(sty.getBackColor());
            }
            if (sty.getForeColor() != null) {
                this.colors.putColor(sty.getForeColor());
            }
            if (sty.getFont() != null) {
                this.fonts.putFont(sty.getFont());
            }
        }
    }

    public static String encode(String s) {
        if (s == null) {
            return s;
        }
        s = s.replaceAll("&", "&amp;");
        s = s.replaceAll("'", "&apos;");
        s = s.replaceAll("<", "&lt;");
        s = s.replaceAll(">", "&gt;");
        s = s.replaceAll("\"", "&quot;");
        return s;
    }

    public void doMethod(DDocument d, DExtensible p, Object arg) {
        this.startElement("DOCUMENT", d.getDocument());
        this.outAttribute("TITLE", d.getTitle(), false);
        this.outAttribute("TAG", d.getTag(), true);
        this.doChildrenItem(d, p, arg);
        this.endElement();
    }

    public void doMethod(DSection s, DExtensible p, Object arg) throws DParser.ParserException {
        this.startElement("SECTION", s);
        this.outAttribute("TAG", s.getTag(), true);
        super.doMethod(s, p, arg);
        this.endElement();
    }

    public void doMethod(DFooter f, DExtensible p, Object arg) {
        this.startElement("FOOTER", f);
        this.doChildrenItem(f, p, arg);
        this.endElement();
    }

    public void doMethod(DHeader h, DExtensible p, Object arg) {
        this.startElement("HEADER", h);
        this.doChildrenItem(h, p, arg);
        this.endElement();
    }

    public void doMethod(DParagraph p, DExtensible pr, Object arg) {
        this.startElement("PARAGRAPH", p);
        if (p.getAlignment() != 9) {
            this.outAttribute("ALIGNMENT", DAlignment.AlignmentToString(p.getAlignment()), false);
        }
        this.doChildrenItem(p, pr, arg);
        this.endElement();
    }

    public void doMethod(DData ip, DExtensible p, Object arg) {
        this.startElement("DATA", ip);
        this.outAttribute("CLASS", ip.getClass().getName(), true);
        this.invokeDoMethod(ip.getData(), p, arg);
        this.endElement();
    }

    public void doMethod(IDItem i, DExtensible p, Object arg) {
        boolean have_elm;
        this.startElement("IDITEM", i);
        this.outAttribute("CLASS", i.getClass().getName(), true);
        boolean bl = have_elm = i.getFirstChild() != null;
        if (have_elm) {
            this.doChildrenItem(i, p, arg);
        }
        this.endElement();
    }

    public void doMethod(DText t, DExtensible p, Object arg) {
        this.startElement("TEXT", t);
        this.outCData(t.getText());
        this.endElement();
    }

    public void doMethod(DImage i, DExtensible p, Object arg) {
        this.startElement("IMAGE", i);
        this.outAttribute("NAME", i.getName(), true);
        this.outAttribute("SCALEW", i.getWidthScale(), 1.0f);
        this.outAttribute("SCALEH", i.getHeightScale(), 1.0f);
        this.endElement();
    }

    public void doMethod(DColor c, DExtensible p, Object arg) {
        this.startElement("COLOR");
        this.outAttribute("ID", c.getID(), true);
        this.outAttribute("R", c.getRed());
        this.outAttribute("G", c.getGreen());
        this.outAttribute("B", c.getBlue());
        this.endElement();
    }

    public void doMethod(DStyle s, DExtensible p, Object arg) {
        IDColor color;
        IDFont font;
        this.startElement("STYLE");
        this.outAttribute("ID", s.getID(), true);
        String n = s.getName();
        if (n != null) {
            this.outAttribute("NAME", n, false);
        }
        if ((font = s.getFont()) != null) {
            this.outAttribute("FONT", font.getID(), true);
        }
        if ((color = s.getForeColor()) != null) {
            this.outAttribute("FORECOLOR", color.getID(), true);
        }
        if ((color = s.getBackColor()) != null) {
            this.outAttribute("BACKCOLOR", color.getID(), true);
        }
        if (s.getWallpaper() != null) {
            this.outAttribute("WALLPAPER", s.getWallpaper().serializeToString(), false);
        }
        this.endElement();
    }

    public void doMethod(DFont f, DExtensible p, Object arg) {
        this.startElement("FONT");
        this.outAttribute("ID", f.getID(), true);
        this.outAttribute("SIZE", f.getSize());
        this.outAttribute("FAMILY", f.getFamily(), "");
        this.outAttribute("SCRIPT", f.getScript(), false);
        this.outAttribute("STYLE", f.getStringStyle(), "");
        this.endElement();
    }

    public void doMethod(DList l, DExtensible p, Object arg) {
        this.startElement("LIST", l);
        this.outAttribute("TYPE", l.getFormat());
        this.doChildrenItem(l, p, arg);
        this.endElement();
    }

    public void doMethod(DTable t, DExtensible p, Object arg) {
        this.startElement("TABLE", t);
        this.outAttribute("BORDER", t.getBorder());
        this.outAttribute("SCALEW", t.getWidthScale(), 1.0f);
        this.outAttribute("SCALEH", t.getHeightScale(), 1.0f);
        String s = null;
        float[] col_width = t.getColumnWidth();
        if (col_width != null) {
            s = "";
            int i = 0;
            while (i < col_width.length) {
                s = String.valueOf(s) + col_width[i];
                if (i < col_width.length - 1) {
                    s = String.valueOf(s) + "/";
                }
                ++i;
            }
        }
        this.outAttribute("WIDTH", s, false);
        this.doChildrenItem(t, p, arg);
        this.endElement();
    }

    public void doMethod(DRow r, DExtensible p, Object arg) {
        this.startElement("ROW", r);
        this.doChildrenItem(r, p, arg);
        this.endElement();
    }

    public void doMethod(DCell c, DExtensible p, Object arg) {
        this.startElement("CELL", c);
        this.outAttribute("COLSPAN", c.getColSpan(), 0);
        this.outAttribute("ROWSPAN", c.getRowSpan(), 0);
        if (c.getAlignment() != 9) {
            this.outAttribute("ALIGNMENT", DAlignment.AlignmentToString(c.getAlignment()), false);
        }
        this.doChildrenItem(c, p, arg);
        this.endElement();
    }

    public void doMethod(DCellText c, DExtensible p, Object arg) {
        this.startElement("CELL_TEXT", c);
        this.outAttribute("COLSPAN", c.getColSpan(), 0);
        this.outAttribute("ROWSPAN", c.getRowSpan(), 0);
        if (c.getAlignment() != 9) {
            this.outAttribute("ALIGNMENT", DAlignment.AlignmentToString(c.getAlignment()), false);
        }
        this.outCData(c.getText());
        this.endElement();
    }

    public void doMethod(DLink l, DExtensible p, Object arg) {
        this.startElement("LINK", l);
        this.outAttribute("TARGET", l.getTarget(), true);
        this.doChildrenItem(l, p, arg);
        this.endElement();
    }

    public void doMethod(DTag t, DExtensible p, Object arg) {
        this.startElement("TAG", t);
        this.outAttribute("NAME", t.getTag(), true);
        this.endElement();
    }

    public void doMethod(DLine l, DExtensible p, Object arg) {
        this.startElement("LINE", l);
        this.outAttribute("SIZE", l.getSize(), 1);
        this.outAttribute("TYPE", l.getType(), "SOLID.DLine.jscrib");
        this.endElement();
    }

    public void doMethod(DPageBreak pb, DExtensible p, Object arg) {
        this.startElement("PAGE_BREAK", pb);
        this.endElement();
    }

    public void doMethod(DPageCounter pc, DExtensible p, Object arg) {
        this.startElement("PAGE_COUNTER", pc);
        this.endElement();
    }

    public void doMethod(DPopup p, DExtensible prs, Object arg) {
        this.startElement("POPUP", p);
        this.outAttribute("TAG", p.getTag(), true);
        this.doChildrenItem(p, prs, arg);
        this.endElement();
    }

    public void doMethod(DSummary s, DExtensible p, Object arg) {
        this.startElement("SUMMARY", s);
        this.outAttribute("LEVEL", s.getTitleLevel());
        this.outAttribute("TAG", s.getTag(), false);
        this.endElement();
    }

    public void doMethod(DTitle t, DExtensible p, Object arg) {
        this.startElement("TITLE", t);
        this.outAttribute("LEVEL", t.getLevel());
        this.outAttribute("TAG", t.getTag(), false);
        this.doChildrenItem(t, p, arg);
        this.endElement();
    }

    public void doMethod(DIndex i, DExtensible p, Object arg) {
        this.startElement("INDEX", i);
        if (i.getProperty() != null) {
            this.outAttribute("PROPERTY", i.getProperty(), false);
            Object value = i.getValue();
            if (value != null) {
                this.outAttribute("CLASS", value.getClass().getName(), false);
                this.invokeDoMethod(value, p, arg);
            }
            this.outAttribute(i.getProperty(), (String)i.getValue(), false);
        }
        this.endElement();
    }

    public void doMethod(DIndexEntry i, DExtensible p, Object arg) {
        this.startElement("INDEX_ENTRY", i);
        this.invokeDoMethod(i.getProperties(), p, arg);
        this.doChildrenItem(i, p, arg);
        this.endElement();
    }

    public void doMethod(DGraphic g, DExtensible p, Object arg) {
        this.startElement("GRAPHIC", g);
        this.outAttribute("TYPE", g.getRenderableId(), true);
        this.outAttribute("TITLE", g.getTitle(), false);
        this.invokeDoMethod(g.getProperties(), p, arg);
        this.doChildrenItem(g, p, arg);
        this.endElement();
    }

    public void doMethod(DAxis a, DExtensible p, Object arg) {
        this.startElement("AXIS", a);
        this.outAttribute("NAME", a.getName(), true);
        this.outAttribute("TITLE", a.getTitle(), false);
        this.outAttribute("UNIT", a.getUnit(), false);
        this.outAttribute("TYPE", a.getScaleType(), "S_LIN.DAxis.core.jscrib");
        this.invokeDoMethod(a.getProperties(), p, arg);
        this.endElement();
    }

    public void doMethod(DCurve c, DExtensible p, Object arg) {
        this.startElement("CURVE", c);
        this.outAttribute("TYPE", c.getType(), false);
        this.outAttribute("NAME", c.getName(), false);
        this.invokeDoMethod(c.getProperties(), p, arg);
        this.doChildrenItem(c, p, arg);
        this.endElement();
    }

    public void doMethod(DCurveLink c, DExtensible p, Object arg) {
        this.startElement("CURVE_LINK", c);
        this.outAttribute("TYPE", c.getType(), false);
        this.outAttribute("NAME", c.getName(), false);
        this.outAttribute("TARGET", c.getTarget(), true);
        this.invokeDoMethod(c.getProperties(), p, arg);
        this.doChildrenItem(c, p, arg);
        this.endElement();
    }

    public void doMethod(DPoint p, DExtensible prs, Object arg) {
        this.startElement("POINT", p);
        this.doChildrenItem(p, prs, arg);
        this.endElement();
    }

    public void doMethod(DPointLink p, DExtensible prs, Object arg) {
        this.startElement("POINT_LINK", p);
        this.outAttribute("TARGET", p.getTarget(), true);
        this.doChildrenItem(p, prs, arg);
        this.endElement();
    }

    public void doMethod(DCoord c, DExtensible p, Object arg) {
        this.startElement("COORD");
        this.outAttribute("AXIS", c.getAxis().getName(), true);
        this.outAttribute("VALUE", c.getValue());
        this.endElement();
    }

    public void doMethod(DCoordObject c, DExtensible p, Object arg) {
        this.startElement("COORD_OBJ");
        this.outAttribute("AXIS", c.getAxis().getName(), true);
        Object val = c.getValue(null);
        this.outAttribute("CLASS", val == null ? Object.class.getName() : val.getClass().getName(), true);
        this.invokeDoMethod(val, p, arg);
        this.endElement();
    }

    public static String EncodeColor(IDColor c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int rgb = r << 16 | g << 8 | b;
        String s = Integer.toString(rgb, 16);
        StringBuffer buf = new StringBuffer(6);
        int i = s.length();
        while (i < 6) {
            buf.append('0');
            ++i;
        }
        buf.append(s);
        return buf.toString();
    }

    public void doMethod(DFolder folder, DExtensible ext, Object arg) {
        boolean is_default_model;
        DXmlWriter w = (DXmlWriter)ext;
        DFolderModel model = folder.getFolderModel();
        boolean bl = is_default_model = model == null || model == DFolderModel.GetDefault();
        if (!is_default_model && this.folder_model_written_ == null) {
            this.folder_model_written_ = new ArrayList();
        }
        w.startElement("FOLDER", folder);
        w.outAttribute("OPEN", folder.isOpen());
        if (!is_default_model) {
            int id = model.hashCode();
            if (!this.folder_model_written_.contains(model)) {
                this.folder_model_written_.add(model);
                w.outAttribute("MODELDEF", Integer.toString(id, 16), true);
                w.outAttribute("INDENTED", model.isIndented());
                ISymbol l2r = model.getOpenedSymbol(true);
                ISymbol r2l = model.getOpenedSymbol(false);
                if (l2r != null && r2l != null && l2r == r2l) {
                    w.outAttribute("OPENED", l2r.getId(), true);
                } else {
                    if (l2r != null) {
                        w.outAttribute("OPENEDL2R", l2r.getId(), true);
                    }
                    if (r2l != null) {
                        w.outAttribute("OPENEDR2L", r2l.getId(), true);
                    }
                }
                l2r = model.getClosedSymbol(true);
                r2l = model.getClosedSymbol(false);
                if (l2r != null && r2l != null && l2r == r2l) {
                    w.outAttribute("CLOSED", l2r.getId(), true);
                } else {
                    if (l2r != null) {
                        w.outAttribute("CLOSEDL2R", l2r.getId(), true);
                    }
                    if (r2l != null) {
                        w.outAttribute("CLOSEDR2L", r2l.getId(), true);
                    }
                }
                IDColor c = model.getOpenedForeColor();
                if (c != null) {
                    w.outAttribute("OPENEDFORE", DXmlWriter.EncodeColor(c), true);
                }
                if ((c = model.getOpenedBackColor()) != null) {
                    w.outAttribute("OPENEDBACK", DXmlWriter.EncodeColor(c), true);
                }
                if ((c = model.getClosedForeColor()) != null) {
                    w.outAttribute("CLOSEDFORE", DXmlWriter.EncodeColor(c), true);
                }
                if ((c = model.getClosedBackColor()) != null) {
                    w.outAttribute("CLOSEDBACK", DXmlWriter.EncodeColor(c), true);
                }
            } else {
                w.outAttribute("MODEL", Integer.toString(id, 16), true);
            }
        }
        w.doChildrenItem(folder, ext, arg);
        w.endElement();
    }

    public void doMethod(DColorRegistry cr, DExtensible p, Object arg) {
        this.startElement("COLORS");
        Iterator i = cr.iterator();
        while (i.hasNext()) {
            this.invokeDoMethod(i.next(), p, arg);
        }
        this.endElement();
    }

    public void doMethod(DStyleRegistry sr, DExtensible p, Object arg) {
        this.startElement("STYLES");
        Iterator i = sr.iterator();
        while (i.hasNext()) {
            this.invokeDoMethod(i.next(), p, arg);
        }
        this.endElement();
    }

    public void doMethod(DFontRegistry fr, DExtensible p, Object arg) {
        this.startElement("FONTS");
        Iterator i = fr.iterator();
        while (i.hasNext()) {
            this.invokeDoMethod(i.next(), p, arg);
        }
        this.endElement();
    }

    public void doMethod(IDXmlSerializable i, DExtensible ext, Object arg) {
        this.outCData(i.writeXml());
    }

    public void doMethod(IDStringSerializable i, DExtensible ext, Object arg) {
        this.outCData(i.serializeToString());
    }

    public void doMethod(String str, DExtensible ext, Object arg) {
        this.outCData(DXmlWriter.encode(str));
    }

    public void doMethod(Byte v, DExtensible ext, Object arg) {
        this.outCData(v.toString());
    }

    public void doMethod(Short v, DExtensible ext, Object arg) {
        this.outCData(v.toString());
    }

    public void doMethod(Integer v, DExtensible ext, Object arg) {
        this.outCData(v.toString());
    }

    public void doMethod(Long v, DExtensible ext, Object arg) {
        this.outCData(v.toString());
    }

    public void doMethod(Float v, DExtensible ext, Object arg) {
        this.outCData(v.toString());
    }

    public void doMethod(Double v, DExtensible ext, Object arg) {
        this.outCData(v.toString());
    }

    public void doMethod(Boolean v, DExtensible ext, Object arg) {
        this.outCData(v.toString());
    }

    public void doMethod(Class c, DExtensible ext, Object arg) {
        this.outCData(c.getName());
    }

    public void doMethod(Date date, DExtensible ext, Object arg) {
        this.outCData(Long.toString(date.getTime()));
    }

    public void doMethod(DecimalFormat df, DExtensible ext, Object arg) {
        this.outCData(df.toPattern());
    }

    public void doMethod(SimpleDateFormat df, DExtensible ext, Object arg) {
        this.outCData(df.toPattern());
    }

    public void doMethod(DPropertyStore ps, DExtensible p, Object arg) {
        Map m = ps.elements();
        if (m == null) {
            return;
        }
        Set s = m.keySet();
        if (s == null) {
            return;
        }
        this.startElement("PROPERTIES");
        for (String key : s) {
            Object value = m.get(key);
            this.startElement("PROPERTY");
            if (key != null) {
                this.outAttribute("NAME", key, true);
                Class<?> clazz = value.getClass();
                this.outAttribute("CLASS", clazz.getName(), true);
                if (IDColor.class.isAssignableFrom(clazz)) {
                    IDColor color = (IDColor)value;
                    this.colors.putColor(color);
                    this.outCData(color.getID());
                } else if (IDFont.class.isAssignableFrom(clazz)) {
                    IDFont font = (IDFont)value;
                    this.fonts.putFont(font);
                    this.outCData(font.getID());
                } else if (IDStyle.class.isAssignableFrom(clazz)) {
                    IDStyle style = (IDStyle)value;
                    this.styles.putStyle(style);
                    this.outCData(style.getID());
                } else {
                    this.invokeDoMethod(value, p, arg);
                }
            }
            this.endElement();
        }
        this.endElement();
    }

    public void writeExtension(Class extension) {
        if (extension == null) {
            return;
        }
        if (this.extensions == null) {
            this.extensions = new HashMap();
        } else if (this.extensions.containsKey(extension.getClass())) {
            return;
        }
        try {
            this.closeStartElement();
            this.out.write("<JSML_EXTENSION CLASS=\"".getBytes());
            this.out.write(extension.getName().getBytes("UTF-8"));
            this.out.write("\" />".getBytes());
            this.extensions.put(extension.getClass(), null);
        }
        catch (IOException e) {
            throw new DXmlError(e.getMessage());
        }
    }

    public final void writeExtension(IDItem extension) {
        this.writeExtension(extension.getClass());
    }

    public void doMethod(DBorder border, DExtensible ext, Object arg) {
        DXmlWriter w = (DXmlWriter)ext;
        w.startElement("BORDER", border);
        w.outAttribute("SHADOW_TYPE", DBorder.StrShadowType(border.getShadowType()), "NONE");
        w.outAttribute("SHADOW_DEPTH", border.getShadowDepth(), 8);
        if (border.getShadowColor() != null) {
            w.outAttribute("SHADOW_COLOR", DXmlWriter.EncodeColor(border.getShadowColor()), true);
        }
        w.outAttribute("LINE_TYPE", DBorder.StrLineType(border.getLineType()), "SIMPLE");
        w.outAttribute("MARGIN", border.getMargin(), 3);
        w.doChildrenItem(border, ext, arg);
        w.endElement();
    }

    public DColorRegistry getColorRegistry() {
        return this.colors;
    }

    public DFontRegistry getFontRegistry() {
        return this.fonts;
    }

    public DStyleRegistry getStyleRegistry() {
        return this.styles;
    }

    public void setColorRegistry(DColorRegistry r) {
        this.colors = r;
    }

    public void setFontRegistry(DFontRegistry r) {
        this.fonts = r;
    }

    public void setStyleRegistry(DStyleRegistry r) {
        this.styles = r;
    }

    private static class Element {
        public String name;
        public int indent;
        public boolean can_indent;
        public boolean have_attr;
        public boolean empty;
        public Element up;
        public boolean start_part_closed;

        public Element(String n, Element u) {
            this.name = n;
            this.up = u;
            this.indent = 0;
            this.can_indent = true;
            this.have_attr = false;
            this.empty = true;
            this.start_part_closed = false;
        }
    }
}

