/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.extension.internal;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import org.eclipse.tptp.platform.report.extension.internal.DExtensionRegistry;

public class DExtensible {
    protected Hashtable mapMethod = null;
    protected Object[] paramTab;
    private boolean debug = false;

    public DExtensible() {
        this.installDoMethods(this);
        DExtensionRegistry.updateExtensible(this);
    }

    public void doMethod(Object i, DExtensible re, Object arg) {
    }

    protected InvokeMethod getDoMethod(Class for_class) {
        if (this.mapMethod == null) {
            throw new Error("mapMethod null at getInvokeMethod() time");
        }
        InvokeMethod fim = (InvokeMethod)this.mapMethod.get(for_class);
        if (fim == null) {
            return null;
        }
        InvokeMethod im = fim;
        while (im != null && im.ref_callee_.get() == null) {
            im = im.old_;
        }
        if (fim != im) {
            this.mapMethod.put(for_class, im);
        }
        return im;
    }

    protected InvokeMethod resolveDoMethod(Object arg, Object super_of_this_callee) {
        InvokeMethod im = null;
        if (this.debug && arg != null && arg.getClass() != null) {
            System.out.println("resolveMethodToInvoke(" + arg.getClass().getName() + ") DEBUG:");
        }
        Class<?> c = arg == null ? null : arg.getClass();
        block0: while (c != null) {
            im = this.getDoMethod(c);
            if (this.debug) {
                System.out.println(" ? class=" + c.getName() + " im=" + im);
            }
            if (im != null) break;
            Class<?>[] itf = c.getInterfaces();
            if (itf != null) {
                int j = 0;
                while (j < itf.length) {
                    im = this.getDoMethod(itf[j]);
                    if (this.debug) {
                        System.out.println(" ? interface=" + itf[j].getName() + " im=" + im);
                    }
                    if (im != null) break block0;
                    ++j;
                }
            }
            c = c.getSuperclass();
        }
        if (super_of_this_callee != null) {
            while (im != null) {
                if (im.ref_callee_.get() == super_of_this_callee) {
                    im = im.old_;
                    break;
                }
                im = im.old_;
            }
        }
        if (this.debug) {
            if (im == null) {
                System.out.println("resolveInvokeMethod(class=" + arg.getClass().getName() + ") => NOT FOUND");
            } else {
                System.out.println("resolveInvokeMethod(class=" + arg.getClass().getName() + ") => m=" + im.method_.getName() + "(" + im.method_.getParameterTypes()[0].getName() + ") in class " + im.ref_callee_.getClass().getName());
            }
        }
        return im;
    }

    public void invokeDoMethod(Object arg, DExtensible ext, Object parser_arg) {
        this.invokeSuperDoMethod(null, arg, ext, parser_arg);
    }

    protected void invokeSuperDoMethod(Object super_of, Object arg, DExtensible ext, Object parser_arg) {
        this.debug = false;
        InvokeMethod m = this.resolveDoMethod(arg, null);
        if (m == null) {
            this.debug = true;
            this.resolveDoMethod(arg, null);
        }
        if (m == null) {
            throw new Error("Undefined invoke method (doMethod?) for class " + arg.getClass().getName());
        }
        try {
            this.paramTab[0] = arg;
            this.paramTab[1] = ext;
            this.paramTab[2] = parser_arg;
            m.method_.invoke(m.ref_callee_.get(), this.paramTab);
        }
        catch (IllegalAccessException e) {
            System.err.println("can't access to " + m.method_.getName() + "(" + arg.getClass() + ",DExtension,Object), or compatible method in " + m.ref_callee_.getClass());
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.getTargetException().printStackTrace();
            throw new Error(e.getTargetException());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public final void installDoMethod(Method m, Object callee) {
        Class<?>[] arg;
        if (this.mapMethod == null) {
            this.mapMethod = new Hashtable();
        }
        if ((arg = m.getParameterTypes()) == null) {
            throw new Error("Method signature must have one parameter");
        }
        if (arg != null && arg.length == 3) {
            Class<?> a0 = arg[0];
            Class<?> a1 = arg[1];
            Class<?> a2 = arg[2];
            if (a1 == DExtensible.class && a2 == Object.class) {
                InvokeMethod old = (InvokeMethod)this.mapMethod.get(a0);
                this.mapMethod.put(arg[0], new InvokeMethod(m, callee, old));
                return;
            }
        }
        throw new Error("Method signature must be public " + m.getName() + "(" + arg[0] + ", DExtensible, Object)");
    }

    public final void installDoMethods(String method_name, Object callee) {
        if (method_name == null) {
            return;
        }
        if (callee == null) {
            return;
        }
        Method[] m = callee.getClass().getMethods();
        int i = 0;
        while (i < m.length) {
            try {
                if (method_name.equals(m[i].getName())) {
                    this.installDoMethod(m[i], callee);
                }
            }
            catch (Error error) {
            }
            catch (Exception exception) {}
            ++i;
        }
        this.paramTab = new Object[3];
    }

    public final void installDoMethods(Object callee) {
        this.installDoMethods("doMethod", callee);
    }

    public final void removeDoMethod(Method m, Object callee) {
        if (this.mapMethod == null) {
            return;
        }
        if (m == null) {
            return;
        }
        try {
            InvokeMethod fim;
            Class<?>[] arg = m.getParameterTypes();
            InvokeMethod im = fim = (InvokeMethod)this.mapMethod.get(arg[0]);
            while (im != null) {
                if (im.ref_callee_.get() == null) {
                    if (fim == im) {
                        fim = im.old_;
                    }
                } else if (im.method_ == m && im.ref_callee_.get() == callee && fim == im) {
                    fim = im.old_;
                }
                im = im.old_;
            }
            if (fim == null) {
                this.mapMethod.remove(arg[0]);
            } else {
                this.mapMethod.put(arg[0], fim);
            }
        }
        catch (Exception exception) {}
    }

    public final void removeDoMethod(String method_name, Class arg_type, Object callee) {
        if (arg_type == null) {
            return;
        }
        if (method_name == null) {
            return;
        }
        Method[] m = callee.getClass().getMethods();
        int i = 0;
        while (i < m.length) {
            if (method_name.equals(m[i].getName())) {
                this.removeDoMethod(m[i], callee);
                break;
            }
            ++i;
        }
    }

    public final void removeDoMethods(String method_name, Object callee) {
        if (method_name == null) {
            return;
        }
        Method[] m = callee.getClass().getMethods();
        int i = 0;
        while (i < m.length) {
            try {
                if (method_name.equals(m[i].getName())) {
                    this.removeDoMethod(m[i], m[i].getParameterTypes()[0]);
                }
            }
            catch (Error error) {
            }
            catch (Exception exception) {}
            ++i;
        }
    }

    public final void removeDoMethods(Object c) {
        this.removeDoMethods("doMethod", c);
    }

    protected static class InvokeMethod {
        public Method method_;
        public WeakReference ref_callee_;
        public InvokeMethod old_;

        public InvokeMethod(Method _m, Object _callee, InvokeMethod _old) {
            this.method_ = _m;
            this.ref_callee_ = new WeakReference<Object>(_callee);
            this.old_ = _old;
        }
    }
}

