/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.alg.internal;

import org.eclipse.tptp.platform.report.igc.alg.internal.LineAlg;
import org.eclipse.tptp.platform.report.igc.alg.internal.ModelMap;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IPoint;
import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.util.internal.Radian;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;

public class EllipseAlg {
    protected static ModelMap models_ = new ModelMap(5, 50, 10);
    protected final int S_NOTSTARTED = 0;
    protected final int S_GENERATING = 1;
    protected final int S_FINISHED = 2;
    protected int xc_;
    protected int yc_;
    protected int istart_;
    protected int iend_;
    protected double start_angle_;
    protected double arc_length_;
    protected Model model_;
    protected int state_;
    protected int x_;
    protected int y_;
    protected int curr_idx_;
    private int count = 0;

    protected static Object GetKey(int rx, int ry, double _angle) {
        int angle_10th_degree = (int)Math.round(1800.0 * _angle / Math.PI);
        return String.valueOf(Integer.toString(rx)) + ":" + Integer.toString(ry) + ":" + Integer.toString(angle_10th_degree);
    }

    protected static Model GetModel(int rx, int ry, double _angle) {
        Object key = EllipseAlg.GetKey(rx, ry, _angle);
        Model model = (Model)models_.getModel(key);
        if (model == null) {
            model = new Model(rx, ry, _angle);
            models_.addModel(model);
        }
        return model;
    }

    public EllipseAlg() {
        this.state_ = 0;
    }

    public EllipseAlg(int xc, int yc, double _rx_angle, int rx, int ry) {
        this.setEllipse(xc, yc, _rx_angle, rx, ry);
    }

    public EllipseAlg(int xc, int yc, double _rx_angle, int rx, int ry, double _start_angle, double _arc_length) {
        this.setArc(xc, yc, _rx_angle, rx, ry, _start_angle, _arc_length);
    }

    public EllipseAlg(EllipseAlg e) {
        this.setEllipse(e);
    }

    public void setEllipse(EllipseAlg e) {
        this.xc_ = e.xc_;
        this.yc_ = e.yc_;
        this.model_ = e.model_;
        this.istart_ = e.istart_;
        this.curr_idx_ = e.curr_idx_;
        this.iend_ = e.iend_;
        this.start_angle_ = e.start_angle_;
        this.arc_length_ = e.arc_length_;
        this.state_ = 0;
    }

    public void setEllipse(int xc, int yc, double _rx_angle, int rx, int ry) {
        this.xc_ = xc;
        this.yc_ = yc;
        this.model_ = EllipseAlg.GetModel(rx, ry, _rx_angle);
        this.curr_idx_ = 0;
        this.istart_ = 0;
        this.iend_ = this.model_.size_ - 1;
        this.start_angle_ = 0.0;
        this.arc_length_ = Math.PI * 2;
        this.state_ = 0;
    }

    public void setArc(int xc, int yc, double _rx_angle, int rx, int ry, double _start_angle, double _arc_length) {
        this.xc_ = xc;
        this.yc_ = yc;
        this.model_ = EllipseAlg.GetModel(rx, ry, _rx_angle);
        this.start_angle_ = _start_angle;
        this.arc_length_ = _arc_length;
        this.istart_ = this.curr_idx_ = this.model_.indexOfAngle(_start_angle);
        this.iend_ = this.model_.indexOfAngle(_start_angle + _arc_length);
        this.state_ = 0;
    }

    public int getX() {
        return this.x_;
    }

    public int getY() {
        return this.y_;
    }

    public void restart() {
        this.state_ = 0;
    }

    public boolean nextPoint(IPoint point) {
        if (this.state_ == 2) {
            return false;
        }
        if (this.state_ == 0) {
            this.count = 0;
            this.curr_idx_ = this.istart_;
            this.state_ = 1;
        } else {
            if (this.curr_idx_ < 0) {
                this.state_ = 2;
                return false;
            }
            if (this.arc_length_ >= 0.0) {
                ++this.curr_idx_;
                if (this.curr_idx_ >= this.model_.size_) {
                    this.curr_idx_ = 0;
                }
            } else {
                --this.curr_idx_;
                if (this.curr_idx_ < 0) {
                    this.curr_idx_ = this.model_.size_ - 1;
                }
            }
        }
        if (this.curr_idx_ >= this.iend_) {
            this.curr_idx_ = -1;
            this.state_ = 2;
            return false;
        }
        ++this.count;
        this.x_ = this.xc_ + this.model_.px_[this.curr_idx_];
        this.y_ = this.yc_ + this.model_.py_[this.curr_idx_];
        if (point != null) {
            point.setPoint(this.x_, this.y_);
        }
        return true;
    }

    public int getFirstX() {
        return this.xc_ + this.model_.px_[this.istart_];
    }

    public int getFirstY() {
        return this.yc_ + this.model_.py_[this.istart_];
    }

    public int getLastX() {
        return this.xc_ + this.model_.px_[this.iend_];
    }

    public int getLastY() {
        return this.yc_ + this.model_.py_[this.iend_];
    }

    public int getCenterX() {
        return this.xc_;
    }

    public int getCenterY() {
        return this.yc_;
    }

    public double getAngle() {
        return this.model_.ellipse_angle_;
    }

    public double getArcStart() {
        return this.start_angle_;
    }

    public double getArcLength() {
        return this.arc_length_;
    }

    public int getRadiusX() {
        return this.model_.rx_;
    }

    public int getRadiusY() {
        return this.model_.ry_;
    }

    public boolean contains(int x, int y) {
        if (Math.abs(this.arc_length_) >= Math.PI * 2) {
            return this.model_.fullEllipseContains(x - this.xc_, y - this.yc_);
        }
        return false;
    }

    public IRect getBounds() {
        if (Math.abs(this.arc_length_) >= Math.PI * 2) {
            int mxn = this.model_.px_[this.model_.index_top_xmin_];
            int mxx = this.model_.px_[this.model_.index_top_xmax_];
            int myn = this.model_.py_[this.model_.index_left_ymin_];
            int myx = this.model_.py_[this.model_.index_left_ymax_];
            return new Rect(this.xc_ + mxn, this.yc_ + myn, mxx - mxn, myx - myn);
        }
        int mxn = Math.min(this.model_.px_[this.istart_], this.model_.px_[this.iend_]);
        if (this.model_.index_top_xmin_ > this.istart_ && this.model_.index_top_xmin_ < this.iend_) {
            mxn = Math.min(mxn, this.model_.px_[this.model_.index_top_xmin_]);
        }
        int mxx = Math.max(this.model_.px_[this.istart_], this.model_.px_[this.iend_]);
        if (this.model_.index_top_xmax_ > this.istart_ && this.model_.index_top_xmax_ < this.iend_) {
            mxn = Math.max(mxn, this.model_.px_[this.model_.index_top_xmax_]);
        }
        int myn = Math.min(this.model_.py_[this.istart_], this.model_.py_[this.iend_]);
        if (this.model_.index_left_ymin_ > this.istart_ && this.model_.index_left_ymin_ < this.iend_) {
            myn = Math.min(myn, this.model_.py_[this.model_.index_left_ymin_]);
        }
        int myx = Math.max(this.model_.py_[this.istart_], this.model_.py_[this.iend_]);
        if (this.model_.index_left_ymax_ > this.istart_ && this.model_.index_left_ymax_ < this.iend_) {
            myn = Math.max(myn, this.model_.py_[this.model_.index_left_ymax_]);
        }
        mxn = Math.min(mxn, 0);
        mxx = Math.max(mxx, 0);
        myn = Math.min(myn, 0);
        myx = Math.max(myx, 0);
        return new Rect(this.xc_ + mxn, this.yc_ + myn, mxx - mxn, myx - myn);
    }

    public void fillEllipse(IGCDirect gc) {
        this.model_.fillEllipse(this.xc_, this.yc_, gc);
    }

    public void fill(IGCDirect gc) {
        this.model_.fillArc(this.xc_, this.yc_, this.start_angle_, this.arc_length_, gc);
    }

    public String toString() {
        return String.valueOf(super.toString()) + "{ctr=" + this.xc_ + "," + this.yc_ + " model=" + this.model_ + " start_angle=" + this.start_angle_ + " arc_len=" + this.arc_length_ + " istart=" + this.istart_ + " iend=" + this.iend_ + "}";
    }

    protected static class Model
    extends ModelMap.AbstractModel {
        protected int rx_;
        protected int ry_;
        protected double ellipse_angle_;
        protected int[] px_;
        protected int[] py_;
        protected int size_;
        private int index_left_ymin_;
        private int index_left_ymax_;
        private int index_top_xmin_;
        private int index_top_xmax_;
        private int index_left_yzero_;

        public Model(int rx, int ry, double _angle) {
            this.rx_ = rx;
            this.ry_ = ry;
            this.ellipse_angle_ = _angle;
            this.computePoints();
            this.computeBoundsIndexes();
        }

        public Object getKey() {
            return EllipseAlg.GetKey(this.rx_, this.ry_, this.ellipse_angle_);
        }

        public String toString() {
            return String.valueOf(super.toString()) + "{radius=" + this.rx_ + "," + this.ry_ + " angle_rx=" + this.ellipse_angle_ + " size=" + this.size_ + "}";
        }

        public int x(int index) {
            return this.px_[index];
        }

        public int y(int index) {
            return this.py_[index];
        }

        public boolean fullEllipseContains(int x, int y) {
            if (x < this.px_[this.index_top_xmin_]) {
                return false;
            }
            if (x > this.px_[this.index_top_xmax_]) {
                return false;
            }
            if (y < this.py_[this.index_left_ymin_]) {
                return false;
            }
            if (y > this.py_[this.index_left_ymax_]) {
                return false;
            }
            int dy_top = this.py_[this.index_left_ymax_] - y;
            int dy_btm = this.py_[this.index_left_ymin_] - y;
            if (dy_top < dy_btm) {
                int left = this.index_left_ymax_;
                while (this.py_[left] > y) {
                    --left;
                }
                while (this.py_[left] == y && this.px_[left] > this.px_[left - 1]) {
                    --left;
                }
                if (this.py_[left] != y) {
                    ++left;
                }
                int right = this.index_left_ymax_;
                while (this.py_[right] > y) {
                    right = (right + 1) % this.size_;
                }
                while (this.py_[right] == y && this.px_[right] < this.px_[(right + 1) % this.size_]) {
                    right = (right + 1) % this.size_;
                }
                if (this.py_[right] != y && --right < 0) {
                    right = this.size_ - 1;
                }
                return this.px_[left] <= x && x <= this.px_[right];
            }
            int left = this.index_left_ymin_;
            while (this.py_[left] < y) {
                ++left;
            }
            while (this.py_[left] == y && this.px_[left - 1] < this.px_[left]) {
                --left;
            }
            if (this.py_[left] != y) {
                ++left;
            }
            int right = this.index_left_ymin_;
            while (this.py_[right] < y) {
                if (--right >= 0) continue;
                right = this.size_ - 1;
            }
            int pr = right - 1;
            if (pr < 0) {
                pr = this.size_ - 1;
            }
            while (this.py_[right] == y && this.px_[right] < this.px_[pr]) {
                right = pr--;
                if (pr >= 0) continue;
                pr = this.size_ - 1;
            }
            if (this.py_[right] != y) {
                right = (right + 1) % this.size_;
            }
            return this.px_[left] <= x && x <= this.px_[right];
        }

        public boolean isModel(int _rx, int _ry, double _angle) {
            return this.rx_ == _rx && this.ry_ == _ry && _angle == this.ellipse_angle_;
        }

        public int indexOfAngle(double angle) {
            while (angle >= 3600.0) {
                angle -= Math.PI * 2;
            }
            while (angle < 0.0) {
                angle += Math.PI * 2;
            }
            if (angle == 0.0) {
                return 0;
            }
            int a = 0;
            int b = this.size_ - 1;
            while (a < b - 1) {
                int m = (a + b) / 2;
                int ldy = this.py_[m];
                int ldx = this.px_[m];
                double la = Math.atan2(ldy, ldx);
                if (la < 0.0) {
                    la += Math.PI * 2;
                }
                if (la == angle) {
                    a = m;
                    break;
                }
                if (la > angle) {
                    b = m;
                    continue;
                }
                a = m;
            }
            return a;
        }

        protected int indexOfLeftYMin() {
            return this.index_left_ymin_;
        }

        protected int indexOfLeftYMax() {
            return this.index_left_ymax_;
        }

        protected int indexOfTopXMin() {
            return this.index_top_xmin_;
        }

        protected int indexOfTopXMax() {
            return this.index_top_xmax_;
        }

        protected int indexOfLeftYZero() {
            return this.index_left_yzero_;
        }

        private void computeBoundsIndexes() {
            this.index_left_ymin_ = 0;
            this.index_left_ymax_ = 0;
            this.index_top_xmin_ = 0;
            this.index_top_xmax_ = 0;
            int i = 1;
            while (i < this.size_) {
                if (this.py_[i] < this.py_[this.index_left_ymin_] || this.py_[i] == this.py_[this.index_left_ymin_] && this.px_[i] < this.px_[this.index_left_ymin_]) {
                    this.index_left_ymin_ = i;
                }
                if (this.py_[i] > this.py_[this.index_left_ymax_] || this.py_[i] == this.py_[this.index_left_ymax_] && this.px_[i] < this.px_[this.index_left_ymax_]) {
                    this.index_left_ymax_ = i;
                }
                if (this.px_[i] < this.px_[this.index_top_xmin_] || this.px_[i] == this.px_[this.index_top_xmin_] && this.py_[i] < this.py_[this.index_top_xmin_]) {
                    this.index_top_xmin_ = i;
                }
                if (this.px_[i] > this.px_[this.index_top_xmin_] || this.px_[i] == this.px_[this.index_top_xmin_] && this.py_[i] < this.py_[this.index_top_xmin_]) {
                    this.index_top_xmax_ = i;
                }
                if (this.px_[i] < 0 && this.py_[i] == 0) {
                    this.index_left_yzero_ = i;
                }
                ++i;
            }
        }

        private void computePoints() {
            int x_ = 0;
            int y_ = 0;
            int xstart = 0;
            int ystart = 0;
            long dx_ = 0L;
            long dy_ = 0L;
            double a = this.ellipse_angle_;
            int xa_ = (int)((double)this.rx_ * Math.cos(a));
            int ya_ = (int)((double)this.rx_ * Math.sin(a));
            int xb_ = (int)((double)this.ry_ * Math.cos(a += 1.5707963267948966));
            int yb_ = (int)((double)this.ry_ * Math.sin(a));
            int xa2 = xa_ * xa_;
            int xb2 = xb_ * xb_;
            int ya2 = ya_ * ya_;
            int yb2 = yb_ * yb_;
            long xyb2 = (xb2 + yb2) * (xb2 + yb2);
            long xya2 = (xa2 + ya2) * (xa2 + ya2);
            long A_ = (long)xa2 * xyb2 + (long)xb2 * xya2;
            long B_ = (long)(xa_ * ya_) * xyb2 + (long)(xb_ * yb_) * xya2;
            long C_ = (long)ya2 * xyb2 + (long)yb2 * xya2;
            long D_ = xya2 * xyb2;
            y_ = 0;
            x_ = (int)Math.sqrt(D_ / A_);
            long s1 = A_ * (long)x_ * (long)x_ - D_;
            if (s1 < 0L) {
                ++x_;
            }
            xstart = x_;
            ystart = y_;
            dx_ = -(B_ * (long)x_ + C_ * (long)y_);
            dy_ = A_ * (long)x_ + B_ * (long)y_;
            int size = 4 * (this.rx_ + this.ry_ + 1);
            this.px_ = new int[size];
            this.py_ = new int[size];
            int idx = 0;
            do {
                int vy;
                int vx;
                block60: {
                    long min;
                    long s3;
                    int selected;
                    int y1;
                    int x1;
                    block65: {
                        block64: {
                            block61: {
                                block63: {
                                    block62: {
                                        block59: {
                                            this.px_[idx] = x_;
                                            this.py_[idx] = y_;
                                            ++idx;
                                            vx = 0;
                                            vy = 0;
                                            if (dy_ != 0L) break block59;
                                            if (dx_ == 0L) break;
                                            vx = dx_ > 0L ? 1 : -1;
                                            break block60;
                                        }
                                        if (dy_ <= 0L) break block61;
                                        if (dx_ != 0L) break block62;
                                        vy = 1;
                                        break block60;
                                    }
                                    if (dx_ <= 0L) break block63;
                                    x1 = x_ + 1;
                                    y1 = 0;
                                    long _2Bx1 = 2L * B_ * (long)x1;
                                    long Cy_ = C_ * (long)y_;
                                    long s12 = A_ * (long)x1 * (long)x1 + _2Bx1 * (long)y_ + Cy_ * (long)y_ - D_;
                                    int selected2 = 0;
                                    if (s12 == 0L) {
                                        selected2 = 1;
                                    } else {
                                        y1 = y_ + 1;
                                        long s2 = A_ * (long)x1 * (long)x1 + 2L * B_ * (long)x1 * (long)y1 + C_ * (long)y1 * (long)y1 - D_;
                                        if (s2 == 0L) {
                                            selected2 = 2;
                                        } else {
                                            long s32 = A_ * (long)x_ * (long)x_ + 2L * B_ * (long)x_ * (long)y1 + C_ * (long)y1 * (long)y1 - D_;
                                            if (s32 == 0L) {
                                                selected2 = 3;
                                            } else {
                                                long min2 = 0L;
                                                if (s12 > 0L) {
                                                    min2 = s12;
                                                    selected2 = 1;
                                                }
                                                if (s2 > 0L && (selected2 == 0 || s2 < min2)) {
                                                    min2 = s2;
                                                    selected2 = 2;
                                                }
                                                if (s32 > 0L && (selected2 == 0 || s32 < min2)) {
                                                    min2 = s32;
                                                    selected2 = 3;
                                                }
                                            }
                                        }
                                    }
                                    switch (selected2) {
                                        case 1: {
                                            vx = 1;
                                            break block60;
                                        }
                                        case 2: {
                                            vy = 1;
                                            vx = 1;
                                            break block60;
                                        }
                                        case 3: {
                                            vy = 1;
                                            break block60;
                                        }
                                        default: {
                                            throw new Error("Failed all possible point are inside [1]");
                                        }
                                    }
                                }
                                x1 = x_ - 1;
                                y1 = 0;
                                long s13 = A_ * (long)x1 * (long)x1 + 2L * B_ * (long)x1 * (long)y_ + C_ * (long)y_ * (long)y_ - D_;
                                selected = 0;
                                if (s13 == 0L) {
                                    selected = 1;
                                } else {
                                    y1 = y_ + 1;
                                    long s2 = A_ * (long)x1 * (long)x1 + 2L * B_ * (long)x1 * (long)y1 + C_ * (long)y1 * (long)y1 - D_;
                                    if (s2 == 0L) {
                                        selected = 2;
                                    } else {
                                        s3 = A_ * (long)x_ * (long)x_ + 2L * B_ * (long)x_ * (long)y1 + C_ * (long)y1 * (long)y1 - D_;
                                        if (s3 == 0L) {
                                            selected = 3;
                                        } else {
                                            min = 0L;
                                            if (s13 > 0L) {
                                                min = s13;
                                                selected = 1;
                                            }
                                            if (s2 > 0L && (selected == 0 || s2 < min)) {
                                                min = s2;
                                                selected = 2;
                                            }
                                            if (s3 > 0L && (selected == 0 || s3 < min)) {
                                                min = s3;
                                                selected = 3;
                                            }
                                        }
                                    }
                                }
                                switch (selected) {
                                    case 1: {
                                        vx = -1;
                                        break block60;
                                    }
                                    case 2: {
                                        vx = -1;
                                        vy = 1;
                                        break block60;
                                    }
                                    case 3: {
                                        vy = 1;
                                        break block60;
                                    }
                                    default: {
                                        throw new Error("Failed all possible point are inside [2]");
                                    }
                                }
                            }
                            if (dx_ != 0L) break block64;
                            vy = -1;
                            break block60;
                        }
                        if (dx_ <= 0L) break block65;
                        x1 = x_ + 1;
                        y1 = 0;
                        long s14 = A_ * (long)x1 * (long)x1 + 2L * B_ * (long)x1 * (long)y_ + C_ * (long)y_ * (long)y_ - D_;
                        selected = 0;
                        if (s14 == 0L) {
                            selected = 1;
                        } else {
                            y1 = y_ - 1;
                            long s2 = A_ * (long)x1 * (long)x1 + 2L * B_ * (long)x1 * (long)y1 + C_ * (long)y1 * (long)y1 - D_;
                            if (s2 == 0L) {
                                selected = 2;
                            } else {
                                s3 = A_ * (long)x_ * (long)x_ + 2L * B_ * (long)x_ * (long)y1 + C_ * (long)y1 * (long)y1 - D_;
                                if (s3 == 0L) {
                                    selected = 3;
                                } else {
                                    min = 0L;
                                    if (s14 > 0L) {
                                        min = s14;
                                        selected = 1;
                                    }
                                    if (s2 > 0L && (selected == 0 || s2 < min)) {
                                        min = s2;
                                        selected = 2;
                                    }
                                    if (s3 > 0L && (selected == 0 || s3 < min)) {
                                        min = s3;
                                        selected = 3;
                                    }
                                }
                            }
                        }
                        switch (selected) {
                            case 1: {
                                vx = 1;
                                break block60;
                            }
                            case 2: {
                                vx = 1;
                                vy = -1;
                                break block60;
                            }
                            case 3: {
                                vy = -1;
                                break block60;
                            }
                            default: {
                                throw new Error("Failed all possible point are inside [3]");
                            }
                        }
                    }
                    x1 = x_ - 1;
                    y1 = 0;
                    long s15 = A_ * (long)x1 * (long)x1 + 2L * B_ * (long)x1 * (long)y_ + C_ * (long)y_ * (long)y_ - D_;
                    selected = 0;
                    if (s15 == 0L) {
                        selected = 1;
                    } else {
                        y1 = y_ - 1;
                        long s2 = A_ * (long)x1 * (long)x1 + 2L * B_ * (long)x1 * (long)y1 + C_ * (long)y1 * (long)y1 - D_;
                        if (s2 == 0L) {
                            selected = 2;
                        } else {
                            s3 = A_ * (long)x_ * (long)x_ + 2L * B_ * (long)x_ * (long)y1 + C_ * (long)y1 * (long)y1 - D_;
                            if (s3 == 0L) {
                                selected = 3;
                            } else {
                                min = 0L;
                                if (s15 > 0L) {
                                    min = s15;
                                    selected = 1;
                                }
                                if (s2 > 0L && (selected == 0 || s2 < min)) {
                                    min = s2;
                                    selected = 2;
                                }
                                if (s3 > 0L && (selected == 0 || s3 < min)) {
                                    min = s3;
                                    selected = 3;
                                }
                            }
                        }
                    }
                    switch (selected) {
                        case 1: {
                            vx = -1;
                            break;
                        }
                        case 2: {
                            vy = -1;
                            vx = -1;
                            break;
                        }
                        case 3: {
                            vy = -1;
                            break;
                        }
                        default: {
                            throw new Error("Failed all possible point are inside [4]");
                        }
                    }
                }
                dx_ = -(B_ * (long)(x_ += vx) + C_ * (long)(y_ += vy));
                dy_ = A_ * (long)x_ + B_ * (long)y_;
            } while (x_ != xstart || y_ != ystart);
            this.size_ = idx;
            if (idx < 3 * size / 4) {
                int[] nx = new int[idx];
                int[] ny = new int[idx];
                System.arraycopy(this.px_, 0, nx, 0, idx);
                System.arraycopy(this.py_, 0, ny, 0, idx);
                this.px_ = nx;
                this.py_ = ny;
            }
        }

        public void fillEllipse(int xc, int yc, IGCDirect gc) {
            int istart;
            int ileft = istart = this.index_left_ymin_;
            int iright = istart;
            int ymax = yc + this.py_[this.index_left_ymax_];
            int size = this.size_;
            int istop = this.index_left_ymax_;
            int y = yc + this.py_[ileft];
            while (y <= ymax && ileft > 0) {
                int xleft = this.px_[ileft];
                while (ileft > 0 && yc + this.py_[ileft] <= y) {
                    if (this.px_[ileft] < xleft) {
                        xleft = this.px_[ileft];
                    }
                    --ileft;
                }
                int xright = this.px_[iright];
                while (yc + this.py_[iright] <= y && (iright >= istart || iright <= istop)) {
                    if (this.px_[iright] > xright) {
                        xright = this.px_[iright];
                    }
                    int n = iright = iright == size - 1 ? 0 : ++iright;
                }
                gc.drawHLineDirect(xc + xleft, xc + xright, y);
                if (ileft == 0) break;
                ++y;
            }
        }

        public void fillArc(int xc, int yc, double start_angle, double arc_length, IGCDirect gc) {
            double sa = Radian.normalize(start_angle);
            double al = arc_length;
            if (al > Math.PI * 2) {
                al = Math.PI * 2;
            }
            if (al < Math.PI * -2) {
                al = Math.PI * -2;
            }
            if (arc_length == 0.0) {
                return;
            }
            if (arc_length == Math.PI * 2 || arc_length == Math.PI * -2) {
                this.fillEllipse(xc, yc, gc);
                return;
            }
            int as = this.indexOfAngle(sa);
            int ae = this.indexOfAngle(sa + arc_length);
            int qa = 0;
            qa = as <= this.index_left_ymax_ ? 0 : (as <= this.index_left_yzero_ ? 1 : (as <= this.index_left_ymin_ ? 2 : 3));
            int qe = 0;
            qe = ae <= this.index_left_ymax_ ? 0 : (ae <= this.index_left_yzero_ ? 1 : (ae <= this.index_left_ymin_ ? 2 : 3));
            boolean direct_arc = arc_length > 0.0;
            block0 : switch (qa) {
                case 0: {
                    switch (qe) {
                        case 0: {
                            this._FillArc0_0(direct_arc, xc, yc, as, ae, gc);
                            break;
                        }
                        case 1: {
                            if (direct_arc) {
                                this._FillArc0_1_D(xc, yc, as, ae, gc);
                                break;
                            }
                            this._FillArc0_1_I(xc, yc, as, ae, gc);
                            break;
                        }
                        case 2: {
                            if (direct_arc) {
                                this._FillArc0_2_D(xc, yc, as, ae, gc);
                                break;
                            }
                            this._FillArc0_2_I(xc, yc, as, ae, gc);
                            break;
                        }
                        case 3: {
                            if (direct_arc) {
                                this._FillArc0_3_D(xc, yc, as, ae, gc);
                                break;
                            }
                            this._FillArc0_3_I(xc, yc, as, ae, gc);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (qe) {
                        case 0: {
                            if (direct_arc) {
                                this._FillArc0_1_I(xc, yc, ae, as, gc);
                                break;
                            }
                            this._FillArc0_1_D(xc, yc, ae, as, gc);
                            break;
                        }
                        case 1: {
                            this._FillArc1_1(direct_arc, xc, yc, as, ae, gc);
                            break;
                        }
                        case 2: {
                            if (direct_arc) {
                                this._FillArc1_2_D(xc, yc, as, ae, gc);
                                break;
                            }
                            this._FillArc1_2_I(xc, yc, as, ae, gc);
                            break;
                        }
                        case 3: {
                            if (direct_arc) {
                                this._FillArc1_3_D(xc, yc, as, ae, gc);
                                break;
                            }
                            this._FillArc1_3_I(xc, yc, as, ae, gc);
                        }
                    }
                    break;
                }
                case 2: {
                    switch (qe) {
                        case 0: {
                            if (direct_arc) {
                                this._FillArc0_2_I(xc, yc, ae, as, gc);
                                break;
                            }
                            this._FillArc0_2_D(xc, yc, ae, as, gc);
                            break;
                        }
                        case 1: {
                            if (direct_arc) {
                                this._FillArc1_2_I(xc, yc, ae, as, gc);
                                break;
                            }
                            this._FillArc1_2_D(xc, yc, ae, as, gc);
                            break;
                        }
                        case 2: {
                            this._FillArc2_2(direct_arc, xc, yc, as, ae, gc);
                            break;
                        }
                        case 3: {
                            if (direct_arc) {
                                this._FillArc2_3_D(xc, yc, as, ae, gc);
                                break;
                            }
                            this._FillArc2_3_I(xc, yc, as, ae, gc);
                        }
                    }
                    break;
                }
                case 3: {
                    switch (qe) {
                        case 0: {
                            if (direct_arc) {
                                this._FillArc0_3_I(xc, yc, ae, as, gc);
                                break block0;
                            }
                            this._FillArc0_3_D(xc, yc, ae, as, gc);
                            break block0;
                        }
                        case 1: {
                            if (direct_arc) {
                                this._FillArc1_3_I(xc, yc, ae, as, gc);
                                break block0;
                            }
                            this._FillArc1_3_D(xc, yc, ae, as, gc);
                            break block0;
                        }
                        case 2: {
                            if (direct_arc) {
                                this._FillArc2_3_I(xc, yc, ae, as, gc);
                                break block0;
                            }
                            this._FillArc2_3_D(xc, yc, ae, as, gc);
                            break block0;
                        }
                        case 3: {
                            this._FillArc3_3(direct_arc, xc, yc, as, ae, gc);
                        }
                    }
                }
            }
        }

        private void _FillArc3_3(boolean direct_arc, int xc, int yc, int as, int ae, IGCDirect gc) {
            boolean tiny_arc;
            int min_i = as;
            int max_i = ae;
            if (yc + this.py_[ae] < yc + this.py_[as]) {
                min_i = ae;
                max_i = as;
            }
            boolean bl = direct_arc ? as < ae : (tiny_arc = ae < as);
            if (tiny_arc) {
                int y = yc + this.py_[min_i];
                int ira = min_i;
                LineAlg ll = new LineAlg(xc + this.px_[min_i], yc + this.py_[min_i], xc, yc);
                ll.nextPoint(null);
                while (y < yc + this.py_[max_i]) {
                    int llx = ll.getX();
                    while (ll.getY() <= y && ll.nextPoint(null)) {
                        if (llx <= ll.getX()) continue;
                        llx = ll.getX();
                    }
                    int rrx = xc + this.px_[ira];
                    while (yc + this.py_[ira] <= y) {
                        if (rrx < xc + this.px_[ira]) {
                            rrx = xc + this.px_[ira];
                        }
                        ++ira;
                    }
                    gc.drawHLineDirect(llx, rrx, y);
                    ++y;
                }
                LineAlg lr = new LineAlg(xc + this.px_[max_i], yc + this.py_[max_i], xc, yc);
                lr.nextPoint(null);
                while (y <= yc) {
                    int llx = ll.getX();
                    while (ll.getY() <= y && ll.nextPoint(null)) {
                        if (llx <= ll.getX()) continue;
                        llx = ll.getX();
                    }
                    int rrx = lr.getX();
                    while (lr.getY() <= y && lr.nextPoint(null)) {
                        if (rrx >= lr.getX()) continue;
                        rrx = lr.getX();
                    }
                    gc.drawHLineDirect(llx, rrx, y);
                    ++y;
                }
            } else {
                int ila = this.index_left_ymin_;
                int ira = this.index_left_ymin_;
                int y = yc + this.py_[this.index_left_ymin_];
                while (y < yc + this.py_[min_i]) {
                    int llx = xc + this.px_[ila];
                    while (yc + this.py_[ila] <= y) {
                        if (llx > xc + this.px_[ila]) {
                            llx = xc + this.px_[ila];
                        }
                        --ila;
                    }
                    int rrx = xc + this.px_[ira];
                    while (yc + this.py_[ira] <= y) {
                        if (rrx < xc + this.px_[ira]) {
                            rrx = xc + this.px_[ira];
                        }
                        ++ira;
                    }
                    gc.drawHLineDirect(llx, rrx, y);
                    ++y;
                }
                LineAlg ll = new LineAlg(xc + this.px_[min_i], yc + this.py_[min_i], xc, yc);
                ll.nextPoint(null);
                int ymaxi = yc + this.py_[max_i];
                while (y < ymaxi) {
                    int llx = xc + this.px_[ila];
                    while (yc + this.py_[ila] <= y) {
                        if (llx > xc + this.px_[ila]) {
                            llx = xc + this.px_[ila];
                        }
                        --ila;
                    }
                    int rrx = ll.getX();
                    while (ll.getY() <= y && ll.nextPoint(null)) {
                        int crrx = ll.getX();
                        if (rrx >= crrx) continue;
                        rrx = crrx;
                    }
                    gc.drawHLineDirect(llx, rrx, y);
                    ++y;
                }
                LineAlg lr = new LineAlg(xc + this.px_[max_i], yc + this.py_[max_i], xc, yc);
                lr.nextPoint(null);
                ira = max_i;
                int imax = this.size_ - 1;
                while (y < yc) {
                    int llx = xc + this.px_[ila];
                    while (yc + this.py_[ila] <= y) {
                        if (llx > xc + this.px_[ila]) {
                            llx = xc + this.px_[ila];
                        }
                        --ila;
                    }
                    int rrx = xc + this.px_[ira];
                    while (yc + this.py_[ira] <= y && ira < imax) {
                        if (rrx < xc + this.px_[ira]) {
                            rrx = xc + this.px_[ira];
                        }
                        ++ira;
                    }
                    int x1 = ll.getX();
                    while (ll.getY() <= y && ll.nextPoint(null)) {
                        if (x1 >= ll.getX()) continue;
                        x1 = ll.getX();
                    }
                    int x2 = lr.getX();
                    while (lr.getY() <= y && lr.nextPoint(null)) {
                        if (x2 <= lr.getX()) continue;
                        x2 = lr.getX();
                    }
                    if (x1 == x2) {
                        gc.drawHLineDirect(llx, rrx, y);
                    } else {
                        gc.drawHLineDirect(llx, x1, y);
                        gc.drawHLineDirect(x2, rrx, y);
                    }
                    ++y;
                }
                ira = 0;
                int ymaxx = yc + this.py_[this.index_left_ymax_];
                while (y <= ymaxx) {
                    int llx = xc + this.px_[ila];
                    while (yc + this.py_[ila] <= y && ila >= this.index_left_ymax_) {
                        if (llx > xc + this.px_[ila]) {
                            llx = xc + this.px_[ila];
                        }
                        --ila;
                    }
                    int rrx = xc + this.px_[ira];
                    while (yc + this.py_[ira] <= y && ira <= this.index_left_ymax_) {
                        if (rrx < xc + this.px_[ira]) {
                            rrx = xc + this.px_[ira];
                        }
                        ++ira;
                    }
                    gc.drawHLineDirect(llx, rrx, y);
                    ++y;
                }
            }
        }

        private void _FillArc2_2(boolean direct_arc, int xc, int yc, int as, int ae, IGCDirect gc) {
            boolean tiny_arc;
            int min_i = as;
            int max_i = ae;
            if (this.py_[ae] < this.py_[as]) {
                min_i = ae;
                max_i = as;
            }
            boolean bl = direct_arc ? ae > as : (tiny_arc = as > ae);
            if (tiny_arc) {
                int c;
                int y = yc + this.py_[min_i];
                int ila = min_i;
                LineAlg lr = new LineAlg(xc + this.px_[min_i], yc + this.py_[min_i], xc, yc);
                lr.nextPoint(null);
                while (y < yc + this.py_[max_i]) {
                    int llx = xc + this.px_[ila];
                    while (yc + this.py_[ila] <= y) {
                        if (llx > xc + this.px_[ila]) {
                            llx = xc + this.px_[ila];
                        }
                        --ila;
                    }
                    int rrx = lr.getX();
                    while (lr.getY() <= y && lr.nextPoint(null)) {
                        c = lr.getX();
                        if (rrx >= c) continue;
                        rrx = c;
                    }
                    gc.drawHLineDirect(llx, rrx, y);
                    ++y;
                }
                LineAlg ll = new LineAlg(xc + this.px_[max_i], yc + this.py_[max_i], xc, yc);
                ll.nextPoint(null);
                while (y <= yc) {
                    int llx = ll.getX();
                    while (ll.getY() <= y && ll.nextPoint(null)) {
                        c = ll.getX();
                        if (llx <= c) continue;
                        llx = c;
                    }
                    int rrx = lr.getX();
                    while (lr.getY() <= y && lr.nextPoint(null)) {
                        int c2 = lr.getX();
                        if (rrx >= c2) continue;
                        rrx = c2;
                    }
                    gc.drawHLineDirect(llx, rrx, y);
                    ++y;
                }
            } else {
                int ila = this.index_left_ymin_;
                int ira = this.index_left_ymin_;
                int y = yc + this.py_[this.index_left_ymin_];
                while (y < yc + this.py_[min_i]) {
                    int llx = xc + this.px_[ila];
                    while (yc + this.py_[ila] <= y) {
                        if (llx > xc + this.px_[ila]) {
                            llx = xc + this.px_[ila];
                        }
                        --ila;
                    }
                    int rrx = xc + this.px_[ira];
                    while (yc + this.py_[ira] <= y) {
                        if (rrx < xc + this.px_[ira]) {
                            rrx = xc + this.px_[ira];
                        }
                        ++ira;
                    }
                    gc.drawHLineDirect(llx, rrx, y);
                    ++y;
                }
                LineAlg lr = new LineAlg(xc + this.px_[min_i], yc + this.py_[min_i], xc, yc);
                lr.nextPoint(null);
                int ymaxi = yc + this.py_[max_i];
                while (y < ymaxi) {
                    int llx = lr.getX();
                    while (lr.getY() <= y && lr.nextPoint(null)) {
                        int c = lr.getX();
                        if (llx <= c) continue;
                        llx = c;
                    }
                    int rrx = xc + this.px_[ira];
                    while (yc + this.py_[ira] <= y) {
                        if (rrx < xc + this.px_[ira]) {
                            rrx = xc + this.px_[ira];
                        }
                        ++ira;
                    }
                    gc.drawHLineDirect(llx, rrx, y);
                    ++y;
                }
                LineAlg ll = new LineAlg(xc + this.px_[max_i], yc + this.py_[max_i], xc, yc);
                ll.nextPoint(null);
                ila = max_i;
                int imax = this.size_ - 1;
                while (y < yc) {
                    int llx = xc + this.px_[ila];
                    while (yc + this.py_[ila] <= y) {
                        if (llx > xc + this.px_[ila]) {
                            llx = xc + this.px_[ila];
                        }
                        --ila;
                    }
                    int rrx = xc + this.px_[ira];
                    while (yc + this.py_[ira] <= y && ira < imax) {
                        if (rrx < xc + this.px_[ira]) {
                            rrx = xc + this.px_[ira];
                        }
                        ++ira;
                    }
                    int x1 = ll.getX();
                    while (ll.getY() <= y && ll.nextPoint(null)) {
                        int c = ll.getX();
                        if (x1 >= c) continue;
                        x1 = c;
                    }
                    int x2 = lr.getX();
                    while (lr.getY() <= y && lr.nextPoint(null)) {
                        int c = lr.getX();
                        if (x2 <= c) continue;
                        x2 = c;
                    }
                    if (x1 == x2) {
                        gc.drawHLineDirect(llx, rrx, y);
                    } else {
                        gc.drawHLineDirect(llx, x1, y);
                        gc.drawHLineDirect(x2, rrx, y);
                    }
                    ++y;
                }
                ira = 0;
                int ymax = yc + this.py_[this.index_left_ymax_];
                while (y <= ymax) {
                    int llx = xc + this.px_[ila];
                    while (yc + this.py_[ila] <= y && ila >= this.index_left_ymax_) {
                        if (llx > xc + this.px_[ila]) {
                            llx = xc + this.px_[ila];
                        }
                        --ila;
                    }
                    int rrx = xc + this.px_[ira];
                    while (yc + this.py_[ira] <= y && ira <= this.index_left_ymax_) {
                        if (rrx < xc + this.px_[ira]) {
                            rrx = xc + this.px_[ira];
                        }
                        ++ira;
                    }
                    gc.drawHLineDirect(llx, rrx, y);
                    ++y;
                }
            }
        }

        private void _FillArc1_1(boolean direct_arc, int xc, int yc, int as, int ae, IGCDirect gc) {
            boolean tiny_arc;
            int min_i = as;
            int max_i = ae;
            if (yc + this.py_[ae] < yc + this.py_[as]) {
                min_i = ae;
                max_i = as;
            }
            boolean bl = direct_arc ? as < ae : (tiny_arc = ae < as);
            if (tiny_arc) {
                LineAlg ll = new LineAlg(xc, yc, xc + this.px_[min_i], yc + this.py_[min_i]);
                LineAlg lr = new LineAlg(xc, yc, xc + this.px_[max_i], yc + this.py_[max_i]);
                ll.nextPoint(null);
                lr.nextPoint(null);
                int y = yc;
                int ymin = yc + this.py_[min_i];
                while (y < ymin) {
                    int llx = ll.getX();
                    while (ll.getY() <= y && ll.nextPoint(null)) {
                        int c = ll.getX();
                        if (llx <= c) continue;
                        llx = c;
                    }
                    int rrx = lr.getX();
                    while (lr.getY() <= y && lr.nextPoint(null)) {
                        int c = lr.getX();
                        if (rrx >= c) continue;
                        rrx = c;
                    }
                    gc.drawHLineDirect(llx, rrx, y);
                    ++y;
                }
                int ila = min_i;
                int ymax = yc + this.py_[max_i];
                while (y <= ymax) {
                    int llx = xc + this.px_[ila];
                    while (yc + this.py_[ila] <= y && ila >= max_i) {
                        if (llx > xc + this.px_[ila]) {
                            llx = xc + this.px_[ila];
                        }
                        --ila;
                    }
                    int rrx = lr.getX();
                    while (lr.getY() <= y && lr.nextPoint(null)) {
                        int c = lr.getX();
                        if (rrx >= c) continue;
                        rrx = c;
                    }
                    gc.drawHLineDirect(llx, rrx, y);
                    ++y;
                }
            } else {
                int y = yc + this.py_[this.index_left_ymin_];
                int ila = this.index_left_ymin_;
                int ira = this.index_left_ymin_;
                int imax = this.size_ - 1;
                while (y < yc) {
                    int llx = xc + this.px_[ila];
                    while (yc + this.py_[ila] <= y) {
                        if (llx > xc + this.px_[ila]) {
                            llx = xc + this.px_[ila];
                        }
                        --ila;
                    }
                    int rrx = xc + this.px_[ira];
                    while (yc + this.py_[ira] <= y && ira < imax) {
                        if (rrx < xc + this.px_[ira]) {
                            rrx = xc + this.px_[ira];
                        }
                        ++ira;
                    }
                    gc.drawHLineDirect(llx, rrx, y);
                    ++y;
                }
                ira = 0;
                LineAlg ll = new LineAlg(xc, yc, xc + this.px_[min_i], yc + this.py_[min_i]);
                LineAlg lr = new LineAlg(xc, yc, xc + this.px_[max_i], yc + this.py_[max_i]);
                ll.nextPoint(null);
                lr.nextPoint(null);
                int ymin = yc + this.py_[min_i];
                while (y < ymin) {
                    int llx = xc + this.px_[ila];
                    while (yc + this.py_[ila] <= y) {
                        if (llx > xc + this.px_[ila]) {
                            llx = xc + this.px_[ila];
                        }
                        --ila;
                    }
                    int rrx = xc + this.px_[ira];
                    while (yc + this.py_[ira] <= y) {
                        if (rrx < xc + this.px_[ira]) {
                            rrx = xc + this.px_[ira];
                        }
                        ++ira;
                    }
                    int x1 = ll.getX();
                    while (ll.getY() <= y && ll.nextPoint(null)) {
                        int c = ll.getX();
                        if (x1 >= c) continue;
                        x1 = c;
                    }
                    int x2 = lr.getX();
                    while (lr.getY() <= y && lr.nextPoint(null)) {
                        int c = lr.getX();
                        if (x2 <= c) continue;
                        x2 = c;
                    }
                    if (x1 == x2) {
                        gc.drawHLineDirect(llx, rrx, y);
                    } else {
                        gc.drawHLineDirect(llx, x1, y);
                        gc.drawHLineDirect(x2, rrx, y);
                    }
                    ++y;
                }
                int ymax = yc + this.py_[max_i];
                while (y < ymax) {
                    int llx = lr.getX();
                    while (lr.getY() <= y && lr.nextPoint(null)) {
                        int c = lr.getX();
                        if (llx <= c) continue;
                        llx = c;
                    }
                    int rrx = xc + this.px_[ira];
                    while (yc + this.py_[ira] <= y && ira <= max_i) {
                        if (rrx < xc + this.px_[ira]) {
                            rrx = xc + this.px_[ira];
                        }
                        ++ira;
                    }
                    gc.drawHLineDirect(llx, rrx, y);
                    ++y;
                }
                ila = max_i;
                int ymaxmax = yc + this.py_[this.index_left_ymax_];
                while (y <= ymaxmax) {
                    int llx = xc + this.px_[ila];
                    while (yc + this.py_[ila] <= y && ila >= this.index_left_ymax_) {
                        if (llx > xc + this.px_[ila]) {
                            llx = xc + this.px_[ila];
                        }
                        --ila;
                    }
                    int rrx = xc + this.px_[ira];
                    while (yc + this.py_[ira] <= y && ira <= this.index_left_ymax_) {
                        if (rrx < xc + this.px_[ira]) {
                            rrx = xc + this.px_[ira];
                        }
                        ++ira;
                    }
                    gc.drawHLineDirect(llx, rrx, y);
                    ++y;
                }
            }
        }

        private void _FillArc0_0(boolean direct_arc, int xc, int yc, int as, int ae, IGCDirect gc) {
            boolean tiny_arc;
            int min_i = as;
            int max_i = ae;
            if (yc + this.py_[ae] < yc + this.py_[as]) {
                min_i = ae;
                max_i = as;
            }
            boolean bl = direct_arc ? ae > as : (tiny_arc = as > ae);
            if (tiny_arc) {
                int y = yc;
                LineAlg ll = new LineAlg(xc, yc, xc + this.px_[max_i], yc + this.py_[max_i]);
                LineAlg lr = new LineAlg(xc, yc, xc + this.px_[min_i], yc + this.py_[min_i]);
                ll.nextPoint(null);
                lr.nextPoint(null);
                int ymini = yc + this.py_[min_i];
                while (y < ymini) {
                    int llx = ll.getX();
                    while (ll.getY() <= y && ll.nextPoint(null)) {
                        int c = ll.getX();
                        if (llx <= c) continue;
                        llx = c;
                    }
                    int rrx = lr.getX();
                    while (lr.getY() <= y && lr.nextPoint(null)) {
                        int c = lr.getX();
                        if (rrx >= c) continue;
                        rrx = c;
                    }
                    gc.drawHLineDirect(llx, rrx, y);
                    ++y;
                }
                int ira = min_i;
                int ymaxi = yc + this.py_[max_i];
                while (y <= ymaxi) {
                    int llx = ll.getX();
                    while (ll.getY() <= y && ll.nextPoint(null)) {
                        int c = ll.getX();
                        if (llx <= c) continue;
                        llx = c;
                    }
                    int rrx = xc + this.px_[ira];
                    while (yc + this.py_[ira] <= y && ira <= max_i) {
                        if (rrx < xc + this.px_[ira]) {
                            rrx = xc + this.px_[ira];
                        }
                        ++ira;
                    }
                    gc.drawHLineDirect(llx, rrx, y);
                    ++y;
                }
            } else {
                int c;
                int ila = this.index_left_ymin_;
                int ira = this.index_left_ymin_;
                int y = yc + this.py_[this.index_left_ymin_];
                while (y < yc) {
                    int llx = xc + this.px_[ila];
                    while (yc + this.py_[ila] <= y) {
                        if (llx > xc + this.px_[ila]) {
                            llx = xc + this.px_[ila];
                        }
                        --ila;
                    }
                    int rrx = xc + this.px_[ira];
                    while (yc + this.py_[ira] <= y && ira < this.size_ - 1) {
                        if (rrx < xc + this.px_[ira]) {
                            rrx = xc + this.px_[ira];
                        }
                        ++ira;
                    }
                    gc.drawHLineDirect(llx, rrx, y);
                    ++y;
                }
                LineAlg ll = new LineAlg(xc, yc, xc + this.px_[max_i], yc + this.py_[max_i]);
                LineAlg lr = new LineAlg(xc, yc, xc + this.px_[min_i], yc + this.py_[min_i]);
                ll.nextPoint(null);
                lr.nextPoint(null);
                ira = 0;
                int ymini = yc + this.py_[min_i];
                while (y < ymini) {
                    int llx = xc + this.px_[ila];
                    while (yc + this.py_[ila] <= y) {
                        if (llx > xc + this.px_[ila]) {
                            llx = xc + this.px_[ila];
                        }
                        --ila;
                    }
                    int rrx = xc + this.px_[ira];
                    while (yc + this.py_[ira] <= y) {
                        if (rrx < xc + this.px_[ira]) {
                            rrx = xc + this.px_[ira];
                        }
                        ++ira;
                    }
                    int x1 = ll.getX();
                    while (ll.getY() <= y && ll.nextPoint(null)) {
                        c = ll.getX();
                        if (x1 >= c) continue;
                        x1 = c;
                    }
                    int x2 = lr.getX();
                    while (lr.getY() <= y && lr.nextPoint(null)) {
                        int c2 = lr.getX();
                        if (x2 <= c2) continue;
                        x2 = c2;
                    }
                    if (x1 == x2) {
                        gc.drawHLineDirect(llx, rrx, y);
                    } else {
                        gc.drawHLineDirect(llx, x1, y);
                        gc.drawHLineDirect(x2, rrx, y);
                    }
                    ++y;
                }
                int ymaxi = yc + this.py_[max_i];
                while (y < ymaxi) {
                    int llx = xc + this.px_[ila];
                    while (yc + this.py_[ila] <= y) {
                        if (llx > xc + this.px_[ila]) {
                            llx = xc + this.px_[ila];
                        }
                        --ila;
                    }
                    int rrx = ll.getX();
                    while (ll.getY() <= y && ll.nextPoint(null)) {
                        c = ll.getX();
                        if (rrx >= c) continue;
                        rrx = c;
                    }
                    gc.drawHLineDirect(llx, rrx, y);
                    ++y;
                }
                ira = max_i;
                int ymaxx = yc + this.py_[this.index_left_ymax_];
                while (y <= ymaxx) {
                    int llx = xc + this.px_[ila];
                    while (yc + this.py_[ila] <= y && ila >= this.index_left_ymax_) {
                        if (llx > xc + this.px_[ila]) {
                            llx = xc + this.px_[ila];
                        }
                        --ila;
                    }
                    int rrx = xc + this.px_[ira];
                    while (yc + this.py_[ira] <= y && ira <= this.index_left_ymax_) {
                        if (rrx < xc + this.px_[ira]) {
                            rrx = xc + this.px_[ira];
                        }
                        ++ira;
                    }
                    gc.drawHLineDirect(llx, rrx, y);
                    ++y;
                }
            }
        }

        private void _FillArc2_3_I(int xc, int yc, int as, int ae, IGCDirect gc) {
            int rrx;
            int llx;
            int ymaxi;
            int min_i = as;
            int max_i = ae;
            boolean min_is_as = true;
            if (yc + this.py_[ae] < yc + this.py_[as]) {
                min_i = ae;
                max_i = as;
                min_is_as = false;
            }
            LineAlg ll = new LineAlg(xc + this.px_[as], yc + this.py_[as], xc, yc);
            LineAlg lr = new LineAlg(xc + this.px_[ae], yc + this.py_[ae], xc, yc);
            ll.nextPoint(null);
            lr.nextPoint(null);
            int ila = as;
            int ira = ae;
            int y = yc + this.py_[min_i];
            if (min_is_as) {
                ymaxi = yc + this.py_[max_i];
                while (y < ymaxi) {
                    llx = xc + this.px_[ila];
                    while (yc + this.py_[ila] <= y) {
                        if (llx > xc + this.px_[ila]) {
                            llx = xc + this.px_[ila];
                        }
                        --ila;
                    }
                    rrx = ll.getX();
                    while (ll.getY() <= y && ll.nextPoint(null)) {
                        int c = ll.getX();
                        if (rrx >= c) continue;
                        rrx = c;
                    }
                    gc.drawHLineDirect(llx, rrx, y);
                    ++y;
                }
            } else {
                ymaxi = yc + this.py_[max_i];
                while (y < ymaxi) {
                    llx = lr.getX();
                    while (lr.getY() <= y && lr.nextPoint(null)) {
                        int c = lr.getX();
                        if (llx <= c) continue;
                        llx = c;
                    }
                    rrx = xc + this.px_[ira];
                    while (yc + this.py_[ira] <= y) {
                        if (llx > xc + this.px_[ira]) {
                            llx = xc + this.px_[ira];
                        }
                        ++ira;
                    }
                    gc.drawHLineDirect(llx, rrx, y);
                    ++y;
                }
            }
            int imax = this.size_ - 1;
            while (y < yc) {
                llx = xc + this.px_[ila];
                while (yc + this.py_[ila] <= y) {
                    if (llx > xc + this.px_[ila]) {
                        llx = xc + this.px_[ila];
                    }
                    --ila;
                }
                rrx = xc + this.px_[ira];
                while (yc + this.py_[ira] <= y && ira < imax) {
                    if (rrx < xc + this.px_[ira]) {
                        rrx = xc + this.px_[ira];
                    }
                    ++ira;
                }
                int x1 = ll.getX();
                while (ll.getY() <= y && ll.nextPoint(null)) {
                    int c = ll.getX();
                    if (x1 >= c) continue;
                    x1 = c;
                }
                int x2 = lr.getX();
                while (lr.getY() <= y && lr.nextPoint(null)) {
                    int c = lr.getX();
                    if (x2 <= c) continue;
                    x2 = c;
                }
                if (x1 == x2) {
                    gc.drawHLineDirect(llx, rrx, y);
                } else {
                    gc.drawHLineDirect(llx, x1, y);
                    gc.drawHLineDirect(x2, rrx, y);
                }
                ++y;
            }
            ira = 0;
            int ymaxx = yc + this.py_[this.index_left_ymax_];
            while (y <= ymaxx) {
                int llx2 = xc + this.px_[ila];
                while (yc + this.py_[ila] <= y && ila >= this.index_left_ymax_) {
                    if (llx2 > xc + this.px_[ila]) {
                        llx2 = xc + this.px_[ila];
                    }
                    --ila;
                }
                int rrx2 = xc + this.px_[ira];
                while (yc + this.py_[ira] <= y && ira <= this.index_left_ymax_) {
                    if (rrx2 < xc + this.px_[ira]) {
                        rrx2 = xc + this.px_[ira];
                    }
                    ++ira;
                }
                gc.drawHLineDirect(llx2, rrx2, y);
                ++y;
            }
        }

        private void _FillArc2_3_D(int xc, int yc, int as, int ae, IGCDirect gc) {
            int rrx;
            int c;
            int llx;
            int min_i = as;
            boolean min_is_as = true;
            if (yc + this.py_[as] > yc + this.py_[ae]) {
                min_i = ae;
                min_is_as = false;
            }
            int y = yc + this.py_[this.index_left_ymin_];
            int ila = this.index_left_ymin_;
            int ira = this.index_left_ymin_;
            int ymini = yc + this.py_[min_i];
            while (y < ymini) {
                int llx2 = xc + this.px_[ila];
                while (yc + this.py_[ila] <= y) {
                    if (llx2 > xc + this.px_[ila]) {
                        llx2 = xc + this.px_[ila];
                    }
                    --ila;
                }
                int rrx2 = xc + this.px_[ira];
                while (yc + this.py_[ira] <= y) {
                    if (rrx2 < xc + this.px_[ira]) {
                        rrx2 = xc + this.px_[ira];
                    }
                    ++ira;
                }
                gc.drawHLineDirect(llx2, rrx2, y);
                ++y;
            }
            LineAlg ll = new LineAlg(xc + this.px_[as], yc + this.py_[as], xc, yc);
            LineAlg lr = new LineAlg(xc + this.px_[ae], yc + this.py_[ae], xc, yc);
            ll.nextPoint(null);
            lr.nextPoint(null);
            if (min_is_as) {
                int yae = yc + this.py_[ae];
                while (y < yae) {
                    llx = ll.getX();
                    while (ll.getY() <= y && ll.nextPoint(null)) {
                        c = ll.getX();
                        if (llx <= c) continue;
                        llx = c;
                    }
                    rrx = xc + this.px_[ira];
                    while (yc + this.py_[ira] <= y) {
                        if (rrx < xc + this.px_[ira]) {
                            rrx = xc + this.px_[ira];
                        }
                        ++ira;
                    }
                    gc.drawHLineDirect(llx, rrx, y);
                    ++y;
                }
            } else {
                int yas = yc + this.py_[as];
                while (y < yas) {
                    llx = xc + this.px_[ila];
                    while (yc + this.py_[ila] <= y) {
                        if (llx > xc + this.px_[ila]) {
                            llx = xc + this.px_[ila];
                        }
                        --ila;
                    }
                    rrx = lr.getX();
                    while (lr.getY() <= y && lr.nextPoint(null)) {
                        int c2 = lr.getX();
                        if (rrx >= c2) continue;
                        rrx = c2;
                    }
                    gc.drawHLineDirect(llx, rrx, y);
                    ++y;
                }
            }
            while (y <= yc) {
                int llx3 = ll.getX();
                while (ll.getY() <= y && ll.nextPoint(null)) {
                    int c3 = ll.getX();
                    if (llx3 <= c3) continue;
                    llx3 = c3;
                }
                int rrx3 = lr.getX();
                while (lr.getY() <= y && lr.nextPoint(null)) {
                    c = lr.getX();
                    if (rrx3 >= c) continue;
                    rrx3 = c;
                }
                gc.drawHLineDirect(llx3, rrx3, y);
                ++y;
            }
        }

        private void _FillArc1_3_I(int xc, int yc, int as, int ae, IGCDirect gc) {
            int rrx;
            int llx;
            int y = yc + this.py_[ae];
            int imax = this.size_ - 1;
            int ira = ae;
            LineAlg la = new LineAlg(xc + this.px_[ae], yc + this.py_[ae], xc, yc);
            la.nextPoint(null);
            while (y < yc) {
                int llx2 = la.getX();
                while (la.getY() <= y && la.nextPoint(null)) {
                    int c = la.getX();
                    if (llx2 <= c) continue;
                    llx2 = c;
                }
                int rrx2 = xc + this.px_[ira];
                while (yc + this.py_[ira] <= y && ira < imax) {
                    if (rrx2 < xc + this.px_[ira]) {
                        rrx2 = xc + this.px_[ira];
                    }
                    ++ira;
                }
                gc.drawHLineDirect(llx2, rrx2, y);
                ++y;
            }
            la = new LineAlg(xc, yc, xc + this.px_[as], yc + this.py_[as]);
            la.nextPoint(null);
            ira = 0;
            int yas = yc + this.py_[as];
            while (y < yas) {
                llx = la.getX();
                while (la.getY() <= y && la.nextPoint(null)) {
                    int c = la.getX();
                    if (llx <= c) continue;
                    llx = c;
                }
                rrx = xc + this.px_[ira];
                while (yc + this.py_[ira] <= y) {
                    if (rrx < xc + this.px_[ira]) {
                        rrx = xc + this.px_[ira];
                    }
                    ++ira;
                }
                gc.drawHLineDirect(llx, rrx, y);
                ++y;
            }
            int ila = as;
            int ymaxx = yc + this.py_[this.index_left_ymax_];
            while (y <= ymaxx) {
                llx = xc + this.px_[ila];
                while (yc + this.py_[ila] <= y && ila >= this.index_left_ymax_) {
                    if (llx > xc + this.px_[ila]) {
                        llx = xc + this.px_[ila];
                    }
                    --ila;
                }
                rrx = xc + this.px_[ira];
                while (yc + this.py_[ira] <= y && ira <= this.index_left_ymax_) {
                    if (rrx < xc + this.px_[ira]) {
                        rrx = xc + this.px_[ira];
                    }
                    ++ira;
                }
                gc.drawHLineDirect(llx, rrx, y);
                ++y;
            }
        }

        private void _FillArc1_3_D(int xc, int yc, int as, int ae, IGCDirect gc) {
            int rrx;
            int llx;
            int y = yc + this.py_[this.index_left_ymin_];
            int ila = this.index_left_ymin_;
            int ira = this.index_left_ymin_;
            int yae = yc + this.py_[ae];
            while (y < yae) {
                llx = xc + this.px_[ila];
                while (yc + this.py_[ila] <= y) {
                    if (llx > xc + this.px_[ila]) {
                        llx = xc + this.px_[ila];
                    }
                    --ila;
                }
                rrx = xc + this.px_[ira];
                while (yc + this.py_[ira] <= y && ira < this.size_) {
                    if (rrx < xc + this.px_[ira]) {
                        rrx = xc + this.px_[ira];
                    }
                    ++ira;
                }
                gc.drawHLineDirect(llx, rrx, y);
                ++y;
            }
            LineAlg la = new LineAlg(xc + this.px_[ae], yc + this.py_[ae], xc, yc);
            la.nextPoint(null);
            while (y < yc) {
                int llx2 = xc + this.px_[ila];
                while (yc + this.py_[ila] <= y) {
                    if (llx2 > xc + this.px_[ila]) {
                        llx2 = xc + this.px_[ila];
                    }
                    --ila;
                }
                int rrx2 = la.getX();
                while (la.getY() <= y && la.nextPoint(null)) {
                    int c = la.getX();
                    if (rrx2 >= c) continue;
                    rrx2 = c;
                }
                gc.drawHLineDirect(llx2, rrx2, y);
                ++y;
            }
            la = new LineAlg(xc, yc, xc + this.px_[as], yc + this.py_[as]);
            la.nextPoint(null);
            int yas = yc + this.py_[as];
            while (y <= yas) {
                llx = xc + this.px_[ila];
                while (yc + this.py_[ila] <= y && ila >= as) {
                    if (llx > xc + this.px_[ila]) {
                        llx = xc + this.px_[ila];
                    }
                    --ila;
                }
                rrx = la.getX();
                while (la.getY() <= y && la.nextPoint(null)) {
                    int c = la.getX();
                    if (rrx >= c) continue;
                    rrx = c;
                }
                gc.drawHLineDirect(llx, rrx, y);
                ++y;
            }
        }

        private void _FillArc1_2_I(int xc, int yc, int as, int ae, IGCDirect gc) {
            int rrx;
            int c;
            int llx;
            int y = yc + this.py_[this.index_left_ymin_];
            int ira = this.index_left_ymin_;
            int ila = this.index_left_ymin_;
            while (y < yc + this.py_[ae]) {
                int llx2 = xc + this.px_[ila];
                while (yc + this.py_[ila] <= y) {
                    if (llx2 > xc + this.px_[ila]) {
                        llx2 = xc + this.px_[ila];
                    }
                    --ila;
                }
                int rrx2 = xc + this.px_[ira];
                while (yc + this.py_[ira] <= y) {
                    if (rrx2 < xc + this.px_[ira]) {
                        rrx2 = xc + this.px_[ira];
                    }
                    ++ira;
                }
                gc.drawHLineDirect(llx2, rrx2, y);
                ++y;
            }
            int imax = this.size_ - 1;
            LineAlg la = new LineAlg(xc + this.px_[ae], yc + this.py_[ae], xc, yc);
            la.nextPoint(null);
            while (y < yc) {
                llx = la.getX();
                while (la.getY() <= y && la.nextPoint(null)) {
                    c = la.getX();
                    if (llx <= c) continue;
                    llx = c;
                }
                rrx = xc + this.px_[ira];
                while (yc + this.py_[ira] <= y && ira < imax) {
                    if (rrx < xc + this.px_[ira]) {
                        rrx = xc + this.px_[ira];
                    }
                    ++ira;
                }
                gc.drawHLineDirect(llx, rrx, y);
                ++y;
            }
            la = new LineAlg(xc, yc, xc + this.px_[as], yc + this.py_[as]);
            la.nextPoint(null);
            ira = 0;
            while (y < yc + this.py_[as]) {
                llx = la.getX();
                while (la.getY() <= y && la.nextPoint(null)) {
                    c = la.getX();
                    if (llx <= c) continue;
                    llx = c;
                }
                rrx = xc + this.px_[ira];
                while (yc + this.py_[ira] <= y) {
                    if (rrx < xc + this.px_[ira]) {
                        rrx = xc + this.px_[ira];
                    }
                    ++ira;
                }
                gc.drawHLineDirect(llx, rrx, y);
                ++y;
            }
            int ila2 = as;
            while (y <= yc + this.py_[this.index_left_ymax_]) {
                llx = xc + this.px_[ila2];
                while (yc + this.py_[ila2] <= y && ila2 >= this.index_left_ymax_) {
                    if (llx > xc + this.px_[ila2]) {
                        llx = xc + this.px_[ila2];
                    }
                    --ila2;
                }
                rrx = xc + this.px_[ira];
                while (yc + this.py_[ira] <= y && ira <= this.index_left_ymax_) {
                    if (rrx < xc + this.px_[ira]) {
                        rrx = xc + this.px_[ira];
                    }
                    ++ira;
                }
                gc.drawHLineDirect(llx, rrx, y);
                ++y;
            }
        }

        private void _FillArc1_2_D(int xc, int yc, int as, int ae, IGCDirect gc) {
            int c;
            int rrx;
            int llx;
            int y = yc + this.py_[ae];
            int ila = ae;
            LineAlg la = new LineAlg(xc + this.px_[ae], yc + this.py_[ae], xc, yc);
            la.nextPoint(null);
            while (y < yc) {
                llx = xc + this.px_[ila];
                while (yc + this.py_[ila] <= y) {
                    if (llx > xc + this.px_[ila]) {
                        llx = xc + this.px_[ila];
                    }
                    --ila;
                }
                rrx = la.getX();
                while (la.getY() <= y && la.nextPoint(null)) {
                    c = la.getX();
                    if (rrx >= c) continue;
                    rrx = c;
                }
                gc.drawHLineDirect(llx, rrx, y);
                ++y;
            }
            la = new LineAlg(xc, yc, xc + this.px_[as], yc + this.py_[as]);
            la.nextPoint(null);
            while (y <= yc + this.py_[as]) {
                llx = xc + this.px_[ila];
                while (yc + this.py_[ila] <= y && ila >= as) {
                    if (llx > xc + this.px_[ila]) {
                        llx = xc + this.px_[ila];
                    }
                    --ila;
                }
                rrx = la.getX();
                while (la.getY() <= y && la.nextPoint(null)) {
                    c = la.getX();
                    if (rrx >= c) continue;
                    rrx = c;
                }
                gc.drawHLineDirect(llx, rrx, y);
                ++y;
            }
        }

        private void _FillArc0_3_I(int xc, int yc, int as, int ae, IGCDirect gc) {
            int rrx;
            int c;
            int llx;
            int y = yc + this.py_[ae];
            int imax = this.size_ - 1;
            int ira = ae;
            LineAlg la = new LineAlg(xc + this.px_[ae], yc + this.py_[ae], xc, yc);
            la.nextPoint(null);
            while (y < yc) {
                llx = la.getX();
                while (la.getY() <= y && la.nextPoint(null)) {
                    c = la.getX();
                    if (llx <= c) continue;
                    llx = c;
                }
                rrx = xc + this.px_[ira];
                while (yc + this.py_[ira] <= y && ira < imax) {
                    if (rrx < xc + this.px_[ira]) {
                        rrx = xc + this.px_[ira];
                    }
                    ++ira;
                }
                gc.drawHLineDirect(llx, rrx, y);
                ++y;
            }
            la = new LineAlg(xc, yc, xc + this.px_[as], yc + this.py_[as]);
            la.nextPoint(null);
            ira = 0;
            while (y <= yc + this.py_[as]) {
                llx = la.getX();
                while (la.getY() <= y && la.nextPoint(null)) {
                    c = la.getX();
                    if (llx <= c) continue;
                    llx = c;
                }
                rrx = xc + this.px_[ira];
                while (yc + this.py_[ira] <= y && ira < as) {
                    if (rrx < xc + this.px_[ira]) {
                        rrx = xc + this.px_[ira];
                    }
                    ++ira;
                }
                gc.drawHLineDirect(llx, rrx, y);
                ++y;
            }
        }

        private void _FillArc0_3_D(int xc, int yc, int as, int ae, IGCDirect render) {
            int c;
            int rrx;
            int llx;
            int y = yc + this.py_[this.index_left_ymin_];
            int ila = this.index_left_ymin_;
            int ira = this.index_left_ymin_;
            while (y < yc + this.py_[ae]) {
                llx = xc + this.px_[ila];
                while (yc + this.py_[ila] <= y) {
                    if (llx > xc + this.px_[ila]) {
                        llx = xc + this.px_[ila];
                    }
                    --ila;
                }
                rrx = xc + this.px_[ira];
                while (yc + this.py_[ira] <= y) {
                    if (rrx < xc + this.px_[ira]) {
                        rrx = xc + this.px_[ira];
                    }
                    ++ira;
                }
                render.drawHLineDirect(llx, rrx, y);
                ++y;
            }
            LineAlg la = new LineAlg(xc + this.px_[ae], yc + this.py_[ae], xc, yc);
            la.nextPoint(null);
            while (y < yc) {
                llx = xc + this.px_[ila];
                while (yc + this.py_[ila] <= y) {
                    if (llx > xc + this.px_[ila]) {
                        llx = xc + this.px_[ila];
                    }
                    --ila;
                }
                rrx = la.getX();
                while (la.getY() <= y && la.nextPoint(null)) {
                    c = la.getX();
                    if (rrx >= c) continue;
                    rrx = c;
                }
                render.drawHLineDirect(llx, rrx, y);
                ++y;
            }
            la = new LineAlg(xc, yc, xc + this.px_[as], yc + this.py_[as]);
            la.nextPoint(null);
            while (y < yc + this.py_[as]) {
                llx = xc + this.px_[ila];
                while (yc + this.py_[ila] <= y) {
                    if (llx > xc + this.px_[ila]) {
                        llx = xc + this.px_[ila];
                    }
                    --ila;
                }
                rrx = la.getX();
                while (la.getY() <= y && la.nextPoint(null)) {
                    c = la.getX();
                    if (rrx >= c) continue;
                    rrx = c;
                }
                render.drawHLineDirect(llx, rrx, y);
                ++y;
            }
            ira = as;
            while (y <= yc + this.py_[this.index_left_ymax_]) {
                llx = xc + this.px_[ila];
                while (yc + this.py_[ila] <= y && ila >= this.index_left_ymax_) {
                    if (llx > xc + this.px_[ila]) {
                        llx = xc + this.px_[ila];
                    }
                    --ila;
                }
                rrx = xc + this.px_[ira];
                while (yc + this.py_[ira] <= y && ira <= this.index_left_ymax_) {
                    if (rrx < xc + this.px_[ira]) {
                        rrx = xc + this.px_[ira];
                    }
                    ++ira;
                }
                render.drawHLineDirect(llx, rrx, y);
                ++y;
            }
        }

        private void _FillArc0_2_I(int xc, int yc, int as, int ae, IGCDirect gc) {
            int rrx;
            int llx;
            int y = yc + this.py_[this.index_left_ymin_];
            int ilb = this.index_left_ymin_;
            int ila = this.index_left_ymin_;
            int yae = yc + this.py_[ae];
            while (y < yae) {
                llx = xc + this.px_[ila];
                while (yc + this.py_[ila] <= y) {
                    if (llx > xc + this.px_[ila]) {
                        llx = xc + this.px_[ila];
                    }
                    --ila;
                }
                rrx = xc + this.px_[ilb];
                while (yc + this.py_[ilb] <= y) {
                    if (rrx < xc + this.px_[ilb]) {
                        rrx = xc + this.px_[ilb];
                    }
                    ++ilb;
                }
                gc.drawHLineDirect(llx, rrx, y);
                ++y;
            }
            int imax = this.size_ - 1;
            LineAlg la = new LineAlg(xc + this.px_[ae], yc + this.py_[ae], xc, yc);
            la.nextPoint(null);
            while (y < yc) {
                llx = la.getX();
                while (la.getY() <= y && la.nextPoint(null)) {
                    int c = la.getX();
                    if (llx <= c) continue;
                    llx = c;
                }
                rrx = xc + this.px_[ilb];
                while (yc + this.py_[ilb] <= y && ilb < imax) {
                    if (rrx < xc + this.px_[ilb]) {
                        rrx = xc + this.px_[ilb];
                    }
                    ++ilb;
                }
                gc.drawHLineDirect(llx, rrx, y);
                ++y;
            }
            la = new LineAlg(xc, yc, xc + this.px_[as], yc + this.py_[as]);
            la.nextPoint(null);
            ilb = 0;
            int yas = yc + this.py_[as];
            while (y <= yas) {
                int llx2 = la.getX();
                while (la.getY() <= y && la.nextPoint(null)) {
                    int c = la.getX();
                    if (llx2 <= c) continue;
                    llx2 = c;
                }
                int rrx2 = xc + this.px_[ilb];
                while (yc + this.py_[ilb] <= y && ilb < imax) {
                    if (rrx2 < xc + this.px_[ilb]) {
                        rrx2 = xc + this.px_[ilb];
                    }
                    ++ilb;
                }
                gc.drawHLineDirect(llx2, rrx2, y);
                ++y;
            }
        }

        private void _FillArc0_1_D(int xc, int yc, int as, int ae, IGCDirect gc) {
            int rrx;
            int llx;
            int ymaxi;
            int c;
            LineAlg ll = new LineAlg(xc, yc, xc + this.px_[ae], yc + this.py_[ae]);
            LineAlg lr = new LineAlg(xc, yc, xc + this.px_[as], yc + this.py_[as]);
            int ila = ae;
            int ira = as;
            ll.nextPoint(null);
            lr.nextPoint(null);
            int y = yc;
            int min_i = as;
            int max_i = ae;
            if (yc + this.py_[ae] < yc + this.py_[as]) {
                min_i = ae;
                max_i = as;
            }
            int ymini = yc + this.py_[min_i];
            while (y < ymini) {
                int llx2 = ll.getX();
                while (ll.getY() <= y && ll.nextPoint(null)) {
                    int c2 = ll.getX();
                    if (llx2 <= c2) continue;
                    llx2 = c2;
                }
                int rrx2 = lr.getX();
                while (lr.getY() <= y && lr.nextPoint(null)) {
                    c = lr.getX();
                    if (rrx2 >= c) continue;
                    rrx2 = c;
                }
                gc.drawHLineDirect(llx2, rrx2, y);
                ++y;
            }
            if (min_i == as) {
                ymaxi = yc + this.py_[max_i];
                while (y < ymaxi) {
                    llx = ll.getX();
                    while (ll.getY() <= y && ll.nextPoint(null)) {
                        c = ll.getX();
                        if (llx <= c) continue;
                        llx = c;
                    }
                    rrx = xc + this.px_[ira];
                    while (yc + this.py_[ira] <= y) {
                        if (rrx < xc + this.px_[ira]) {
                            rrx = xc + this.px_[ira];
                        }
                        ++ira;
                    }
                    gc.drawHLineDirect(llx, rrx, y);
                    ++y;
                }
            } else {
                ymaxi = yc + this.py_[max_i];
                while (y < ymaxi) {
                    llx = xc + this.px_[ila];
                    while (yc + this.py_[ila] <= y) {
                        if (llx > xc + this.px_[ila]) {
                            llx = xc + this.px_[ila];
                        }
                        --ila;
                    }
                    rrx = lr.getX();
                    while (lr.getY() <= y && lr.nextPoint(null)) {
                        int c3 = lr.getX();
                        if (rrx >= c3) continue;
                        rrx = c3;
                    }
                    gc.drawHLineDirect(llx, rrx, y);
                    ++y;
                }
            }
            int ymaxx = yc + this.py_[this.index_left_ymax_];
            while (y <= ymaxx) {
                llx = xc + this.px_[ila];
                while (yc + this.py_[ila] <= y && ila >= this.index_left_ymax_) {
                    if (llx > xc + this.px_[ila]) {
                        llx = xc + this.px_[ila];
                    }
                    --ila;
                }
                rrx = xc + this.px_[ira];
                while (yc + this.py_[ira] <= y && ira <= this.index_left_ymax_) {
                    if (rrx < xc + this.px_[ira]) {
                        rrx = xc + this.px_[ira];
                    }
                    ++ira;
                }
                gc.drawHLineDirect(llx, rrx, y);
                ++y;
            }
        }

        private void _FillArc0_1_I(int xc, int yc, int as, int ae, IGCDirect gc) {
            int rrx;
            int llx;
            int c;
            int ila = this.index_left_ymin_;
            int ira = this.index_left_ymin_;
            int y = yc + this.py_[this.index_left_ymin_];
            int imax_ = this.size_ - 1;
            while (y < yc) {
                int llx2 = xc + this.px_[ila];
                while (yc + this.py_[ila] <= y) {
                    if (llx2 > xc + this.px_[ila]) {
                        llx2 = xc + this.px_[ila];
                    }
                    --ila;
                }
                int rrx2 = xc + this.px_[ira];
                while (yc + this.py_[ira] <= y && ira < imax_) {
                    if (rrx2 < xc + this.px_[ira]) {
                        rrx2 = xc + this.px_[ira];
                    }
                    ++ira;
                }
                gc.drawHLineDirect(llx2, rrx2, y);
                ++y;
            }
            ira = 0;
            int min_i = as;
            int max_i = ae;
            if (yc + this.py_[ae] < yc + this.py_[as]) {
                min_i = ae;
                max_i = as;
            }
            LineAlg ll = new LineAlg(xc, yc, xc + this.px_[ae], yc + this.py_[ae]);
            LineAlg lr = new LineAlg(xc, yc, xc + this.px_[as], yc + this.py_[as]);
            ll.nextPoint(null);
            lr.nextPoint(null);
            int ymini = yc + this.py_[min_i];
            while (y < ymini) {
                int llx3 = xc + this.px_[ila];
                while (yc + this.py_[ila] <= y) {
                    if (llx3 > xc + this.px_[ila]) {
                        llx3 = xc + this.px_[ila];
                    }
                    --ila;
                }
                int rrx3 = xc + this.px_[ira];
                while (yc + this.py_[ira] <= y) {
                    if (rrx3 < xc + this.px_[ira]) {
                        rrx3 = xc + this.px_[ira];
                    }
                    ++ira;
                }
                int x1 = ll.getX();
                while (ll.getY() <= y && ll.nextPoint(null)) {
                    c = ll.getX();
                    if (x1 >= c) continue;
                    x1 = c;
                }
                int x2 = lr.getX();
                while (lr.getY() <= y && lr.nextPoint(null)) {
                    int c2 = lr.getX();
                    if (x2 <= c2) continue;
                    x2 = c2;
                }
                if (x1 == x2) {
                    gc.drawHLineDirect(llx3, rrx3, y);
                } else {
                    gc.drawHLineDirect(llx3, x1, y);
                    gc.drawHLineDirect(x2, rrx3, y);
                }
                ++y;
            }
            if (max_i == as) {
                int yas = yc + this.py_[as];
                while (y <= yas) {
                    llx = lr.getX();
                    while (lr.getY() <= y && lr.nextPoint(null)) {
                        int c3 = lr.getX();
                        if (llx >= c3) continue;
                        llx = c3;
                    }
                    rrx = xc + this.px_[ira];
                    while (yc + this.py_[ira] <= y && ira <= as) {
                        if (rrx < xc + this.px_[ira]) {
                            rrx = xc + this.px_[ira];
                        }
                        ++ira;
                    }
                    gc.drawHLineDirect(llx, rrx, y);
                    ++y;
                }
            } else {
                int yae = yc + this.py_[ae];
                while (y <= yae) {
                    llx = xc + this.px_[ila];
                    while (yc + this.py_[ila] <= y && ila >= ae) {
                        if (llx > xc + this.px_[ila]) {
                            llx = xc + this.px_[ila];
                        }
                        --ila;
                    }
                    rrx = ll.getX();
                    while (ll.getY() <= y && ll.nextPoint(null)) {
                        c = ll.getX();
                        if (rrx <= c) continue;
                        rrx = c;
                    }
                    gc.drawHLineDirect(llx, rrx, y);
                    ++y;
                }
            }
        }

        private void _FillArc0_2_D(int xc, int yc, int as, int ae, IGCDirect gc) {
            int rrx;
            int llx;
            int y = yc + this.py_[ae];
            int ila = ae;
            if (yc + this.py_[ae] < yc) {
                LineAlg le = new LineAlg(xc + this.px_[ae], yc + this.py_[ae], xc, yc);
                le.nextPoint(null);
                while (y < yc) {
                    int llx2 = xc + this.px_[ila];
                    while (yc + this.py_[ila] <= y) {
                        if (xc + this.px_[ila] < llx2) {
                            llx2 = xc + this.px_[ila];
                        }
                        --ila;
                    }
                    int rrx2 = le.getX();
                    while (le.getY() <= y && le.nextPoint(null)) {
                        int c = le.getX();
                        if (rrx2 >= c) continue;
                        rrx2 = c;
                    }
                    gc.drawHLineDirect(llx2, rrx2, y);
                    ++y;
                }
            }
            LineAlg la = new LineAlg(xc, yc, xc + this.px_[as], yc + this.py_[as]);
            la.nextPoint(null);
            int yas = yc + this.py_[as];
            while (y < yas) {
                llx = xc + this.px_[ila];
                while (yc + this.py_[ila] <= y) {
                    if (xc + this.px_[ila] < llx) {
                        llx = xc + this.px_[ila];
                    }
                    --ila;
                }
                rrx = la.getX();
                while (la.getY() <= y && la.nextPoint(null)) {
                    int c = la.getX();
                    if (rrx >= c) continue;
                    rrx = c;
                }
                gc.drawHLineDirect(llx, rrx, y);
                ++y;
            }
            int ilb = as;
            int ymaxx = yc + this.py_[this.index_left_ymax_];
            while (y <= ymaxx) {
                llx = xc + this.px_[ila];
                while (yc + this.py_[ila] <= y && ila >= this.index_left_ymax_) {
                    if (xc + this.px_[ila] < llx) {
                        llx = xc + this.px_[ila];
                    }
                    --ila;
                }
                rrx = xc + this.px_[ilb];
                while (yc + this.py_[ilb] <= y && ila >= this.index_left_ymax_) {
                    if (xc + this.px_[ilb] > rrx) {
                        rrx = xc + this.px_[ilb];
                    }
                    ++ilb;
                }
                gc.drawHLineDirect(llx, rrx, y);
                ++y;
            }
        }
    }
}

